<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


	<?php require_once(APPPATH . "views/admin/header.php"); ?>
    <style>
        .discussion{
            max-height: 40vh;
            min-height: 40vh;
            overflow-y: scroll;
        }
        .media-custom{
            display: flex;
            align-items: center;
           
        }
        .media-body-custom{
            display: flex;
           
            flex-direction: column;
        }
        .bg-d-light{
            background-color: #e9f8ff;
        }
        .bg-d-dark{
            background-color: #fff8f8;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->

	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Refferal Details <?php echo $_id > 0 ? 'Update' : '' ?></strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<section class="content">

			<!--buttons-->

			<div class="row">
				<div class="col-12">
					<div class="box box-solid">
						<div class="box-body">
						     <?php if($referral->status==0){ ?>
                        <div class="form-group">
                            <label for="add-doctor">Add Another Doctor to Discussion:</label>
                            <select id="add-doctor" class="form-control" name="doctor_id">
                            <option value="">--Select Doctor --</option>
                        <?php  foreach($doctors as $item) { ?>
                            <option value="<?= $item->user_id ?>" id=""><?= $item->full_name ?></option>
                            <?php } ?>
                            </select>
                            <button id="add-doctor-btn" class="btn btn-dark mt-2">Add Doctor</button>
                        </div>
                        <?php } ?>
							<div class="row">
                                <div class="col-md-12">
                                <div class="card mb-4">
                                        <div class="card-header bg-dark text-white">
                                            Referral Information
                                        </div>
                                        <div class="card-body d-flex justify-content-around">
                                            <p><strong>Patient:</strong> <?php echo $referral->patient_name; ?></p>
                                            <p><strong>Referred By:</strong> <?php echo $referral->cname; ?></p>
                                            <p><strong>Referred To:</strong> <?php echo $referral->toname; ?></p>
                                            <p><strong>Date:</strong> <?php echo date('d-m-Y', strtotime($referral->created_at)); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-dark text-white">
                                    Referral Discussion
                                    <?php if($referral->status==0){ ?>
                                    <a  class="btn btn-light text-dark   btn-sm float-right mark_as_complete" data-id=" <?php echo $referral->id; ?>">  <i class="fa fa-check-circle mr-1"></i>Mark As Completed</a>
                                    <?php } else{ ?>
                                        <a  class="btn btn-light text-dark   btn-sm float-right disabled">  <i class="fa fa-check-circle mr-1"></i>Completed</a>
                                        <?php } ?>
                                    <a href="<?php echo base_url('admin/Patients/PatientsController/medical_book/').encrypt_and_url_encode($referral->patient_id,$this) ?>" class="btn btn-light btn-sm float-right mr-1"> <i class="fa fa-user mr-1"></i>Medical Book</a>
                                </div>
                                <div class="card-body">
                                    <!-- Discussion Messages -->
                                    <?php if (!empty($discussion)): ?>
                                        <div class="discussion">
                                        <?php foreach ($discussion as $comment): ?>
                                            <?php if($comment->type=='0'){ ?>

                                            
                                            <?php 
                                                // Check if the current user is the author of the comment
                                                $isCurrentUser = ($comment->user_id == $this->session->userdata('user_Id')); 
                                                $alignmentClass = $isCurrentUser ? 'justify-content-end' : ''; // Align right if the current user
                                                $bgclass = $isCurrentUser ? 'bg-d-light' : 'bg-d-dark'; // Float image accordingly
                                                ?>
                                            <div class="media-custom <?= $alignmentClass?>  p-2 mb-1 ">
                                                <img src="<?php echo base_url('Images/doctor.png') ?>" style="with:50px" class="mr-3 rounded-circle" alt="Doctor Image">
                                                <div class="media-body-custom <?= $bgclass ?> p-2 rounded">
                                                    <h5 class="mt-0"><?php echo $comment->user_name; ?> <small class="text-muted"><?php echo date_formate_days($comment->created_at,$this); ?></small></h5>

                                                    <?php if($comment->comment !=''){ echo $comment->comment;} ?>
                                                    <?php if($comment->atttachment != ''){ ?>
                                                        
                                                        <a class=" btn-link" target="_blank" href="<?= base_url('uploads/discussion/').$comment->atttachment ?>"><p> <i class="fa fa-paperclip"></i>Open Attacment</p></a>
                                                        <?php } ?>
                                                </div>
                                            </div>
                                            <?php } else{?>
                                            
                                            <small class="text-muted text-center d-block"> <?php echo $comment->user_name; ?> Added New Doctor at <?php echo date_formate_days($comment->created_at,$this); ?></small>
                                            <?php } ?>
                                        <?php endforeach; ?>
                                        
                                        </div>
                                    <?php else: ?>
                                        <p>No discussion comments yet.</p>
                                    <?php endif; ?>

                                   

                                    <!-- Add New Comment -->
                                      <?php if($referral->status==0){ ?>
                                    <div class="media">
                                        <img src="https://via.placeholder.com/50" class="mr-3 rounded-circle" alt="Doctor Image">
                                        <div class="media-body">
                                        <form action="<?php echo base_url('admin/Patients/PatientsController/add_comment'); ?>" method="POST" enctype="multipart/form-data">
                                        
                                            <textarea class="form-control" name="comment" placeholder="Write a comment..." rows="3"></textarea>
                                            <input type="hidden" name="reffer_item_id" value="<?= $referral->id ?>" />
                                            <label for="file-upload" class="btn btn-outline-secondary btn-sm mr-2">
                                                <i class="fa fa-paperclip"></i> Attach File
                                            </label>
                                            <input type="file" id="file-upload" name="attachment" style="display: none;" />
                                            <!-- Display selected file name and reset button -->
                                            <span id="file-name" class="text-muted mr-2"></span>
                                            <button type="button" id="reset-file" class="btn btn-outline-secondary btn-sm" onclick="resetFile()" style="display: none;">&times;</button>


                                            <button type="submit" class="btn btn-dark mt-2 float-right">Post Comment</button>
                                            </form>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    
                                </div>
                            </div>
                                                        
		
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

		</section>
		<input type="hidden" id="_id" name="_id" value="<?php echo $_id; ?>">
								
		</form>
	
	</div>

	<!-- ./wrapper -->


	<?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>

<script>
    
    // Function to display the selected file name
    document.getElementById('file-upload').addEventListener('change', function() {
        var input = document.getElementById('file-upload');
        var fileName = input.files.length > 0 ? input.files[0].name : '';
        var fileNameElement = document.getElementById('file-name');
        var resetButton = document.getElementById('reset-file');

        if (fileName) {
            fileNameElement.textContent = fileName;
            resetButton.style.display = 'inline-block';
        } else {
            fileNameElement.textContent = '';
            resetButton.style.display = 'none';
        }
    });

    // Function to reset the file input
    document.getElementById('reset-file').addEventListener('click', function() {
        var input = document.getElementById('file-upload');
        var fileNameElement = document.getElementById('file-name');
        var resetButton = document.getElementById('reset-file');

        input.value = ''; // Reset file input
        fileNameElement.textContent = ''; // Clear file name display
        resetButton.style.display = 'none'; // Hide reset button
    });


    $(document).ready(function() {
        $('.mark_as_complete').on('click', function() {
            var referralId = $(this).data('id'); // Get the referral ID from the data-id attribute

            $.ajax({
                url: '<?php echo base_url('admin/Modules/Refferal/RefferalController/mark_as_complete'); ?>',
                type: 'POST',
                data: { id: referralId },
                success: function(response) {
                    // Handle success - e.g., update UI to reflect completion
                   successNotification('Discussion Completed')
                    // Optionally, update the button or UI to indicate the task is completed
                },
                error: function(xhr, status, error) {
                    // Handle error
                    console.error('An error occurred:', error);
                    alert('Failed to mark as completed.');
                }
            });
        });
    });


    $('#add-doctor-btn').on('click', function() {
        console.log('ss');
            var doctorId = $('#add-doctor').val();
            var referredItemId = '<?= $referral->id ?>'; // Replace with the appropriate variable

            $.ajax({
                url: '<?= base_url('admin/Modules/Refferal/RefferalController/add_doctor_to_discussion'); ?>',
                type: 'POST',
                data: {
                    doctor_id: doctorId,
                    referred_item_id: referredItemId
                },
                success: function(response) {
                    successNotification('Doctor added to discussion.');
                    window.location.reload();
                    // Optionally, update the UI or reload the page
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    alert('Failed to add doctor.');
                }
            });
        });


    
   
</script>

<script src="https://js.pusher.com/beams/1.0/push-notifications-cdn.js"></script>
<script>
  const beamsClient = new PusherPushNotifications.Client({
    instanceId: 'a4f41ea3-8913-4742-8f40-73eb9e44bb7d',
  });

  beamsClient
  .start()
  .then((beamsClient) => beamsClient.getDeviceId())
  .then((deviceId) =>
    console.log("Successfully registered with Beams. Device ID:", deviceId)
  )
  .then(() => beamsClient.addDeviceInterest("hello"))
  .then(() => beamsClient.getDeviceInterests())
  .then((interests) => console.log("Current interests:", interests))
  .catch(console.error);



    

</script>
