<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


	<?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Patient <?php echo $_id > 0 ? 'Update' : 'New' ?></strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<form id="submitForm" name="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Patients/PatientsController/save') ?>" method="post" enctype="multipart/form-data">
			<section class="content">

				<!--buttons-->

				<div class="row">
					<div class="col-12">
						<div class="box box-solid">
							<div class="box-body">
								<div class="row"> <!-- Form Buttons   -->

									<div class="col-md-1">
										<a href="<?php echo base_url('index.php/admin/Patients/PatientsController') ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go back </a>
									</div>
									<div class="col-md-9">
										<?php if (validation_errors()) { ?>
											<div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
												<div>
													<p><i class="icon fa fa-warning"></i>Please provide all the required data.</p>
												</div>
											</div>
										<?php } ?>
									</div>
									<div class="col-md-2 text-right">

										<!-- <a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class="btn btn-dark btn-sm">
											<i class="fa fa-check-circle" aria-hidden="true"></i>
											<?php //echo $_id > 0 ? 'Update' : 'Save' 
											?>
										</a> -->
										<!-- <button type="submit" class="btn btn-success "> <?php //echo $_id > 0 ? 'Update' : 'Save' 
																								?></button> -->

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!--//buttons-->

				<!--form-->
				<div class="row">
					<div class="col-12">
						<div class="box box-info" style="margin-bottom: 5px;">
							<div class="box-header with-border">
								<h2 class="box-title">Patient details</h2>
								<!-- <div class="pull-right box-tools">
									<div class="btn-group">
										<button class="btn btn-info btn-sm" data-widget="collapse"><i class="fa fa-minus"></i></button>
									</div>
								</div> -->
							</div>
							<div class="box-body">
							<hr data-content="PERSONAL DETAILS" class="hr-text">
								<div class="row">
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("first_name") ? "has-error" : "" ?>">
											<label for="first_name">First Name<span class="text-danger">*</span></label>
											<input id="first_name" name="first_name" value="<?php echo $first_name; ?>" type="text" class="form-control" placeholder="Enter First Name Here..." required />
											<label><small><?php echo form_error("first_name"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("middle_name") ? "has-error" : "" ?>">
											<label for="middle_name">Middle Name</label>
											<input id="middle_name" name="middle_name" value="<?php echo $middle_name; ?>" type="text" class="form-control" placeholder="Enter Middle Name Here..." />
											<label><small><?php echo form_error("middle_name"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("last_name") ? "has-error" : "" ?>">
											<label for="last_name">Last Name<span class="text-danger">*</span></label>
											<input id="last_name" name="last_name" value="<?php echo $last_name; ?>" type="text" class="form-control" placeholder="Enter Patient Name Here..." required />
											<label><small><?php echo form_error("last_name"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("qatar_id") ? "has-error" : "" ?>">
											<label for="qatar_id">Qatar ID / Passport<span class="text-danger">*</span></label>
											<input id="qatar_id" name="qatar_id" value="<?php echo $qatar_id; ?>" type="text" class="form-control" placeholder="Enter Qatar ID Here..." required maxlength="25"/>
											<label><small><?php echo form_error("qatar_id"); ?></small></label>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("guardian_id") ? "has-error" : "" ?>">
											<label for="guardian_id">Guardian's ID</label>
											<input id="guardian_id" name="guardian_id" value="<?php echo $guardian_id; ?>" type="text" class="form-control" placeholder="Enter Guardian's ID Here..." />
											<label><small><?php echo form_error("guardian_id"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("country") ? "has-error" : "" ?>">
											<label for="country">Country of Residence<span class="text-danger">*</span></label>
											<!-- <input id="country" name="country" value="<?php echo $country; ?>" type="text" class="form-control" placeholder="Enter Country Here..." /> -->
											<select class=" txtBx_mdl selectpicker" data-live-search="true" id="country" name="country" required>
												<option value="">Select Country</option>
												<?php foreach ($countries as $value) : ?>
													<option <?= ($country == $value['country_id']) || (empty($country) && $value['country_name'] == 'Qatar') ? 'selected' : '' ?> value="<?= $value['country_id'] ?>">
														<?= $value['country_code'] . ' - ' . $value['country_name'] ?>
													</option>
												<?php endforeach; ?>
											</select>
											<label><small><?php echo form_error("country"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("dob") ? "has-error" : "" ?>">
											<label for="dob">Date of Birth<span class="text-danger">*</span></label>
											<input id="dob" name="dob" value="<?php echo $dob != '' ? date('d/m/Y', strtotime($dob)) : ''; ?>"
 type="text" class="form-control select_dob" placeholder="DD/MM/YYYY" required />
											<label><small><?php echo form_error("dob"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("nationality") ? "has-error" : "" ?>">
											<label for="nationality">Nationality<span class="text-danger">*</span></label>
											<select class="txtBx_mdl selectpicker" data-live-search="true" id="nationality" name="nationality" required>
												<option value="">Select Nationality</option>
												<?php foreach ($countries as $value) : ?>
													<option <?= ($nationality == $value['country_id']) || (empty($nationality) && $value['country_name'] == 'Qatar') ? 'selected' : '' ?> value="<?= $value['country_id'] ?>">
														<?= $value['country_code'] . ' - ' . $value['country_name'] ?>
													</option>
												<?php endforeach; ?>
											</select>
											<label><small><?php echo form_error("nationality"); ?></small></label>
										</div>
									</div>
									<div class="col-md-3 col-sm-3">
										<div class="form-group <?php echo form_error("sex") ? "has-error" : "" ?>">
											<label for="sex">Gender<span class="text-danger">*</span></label><br>
											<input type="radio" name="sex" id="sex" value="Male" <?php echo trim($sex) == 'Male' ? "checked" : ""; ?>>&nbsp;Male&nbsp;
											<input type="radio" name="sex" id="sex" value="Female" <?php echo trim($sex) == 'Female' ? "checked" : ""; ?>>&nbsp;Female
											<label><small><?php echo form_error("sex"); ?></small></label>
										</div>
									</div>
									<div class="col-md-3 col-sm-3">
										<div class="form-group <?php echo form_error("marital") ? "has-error" : "" ?>">
											<label for="marital">Marital Status</label><br>
											<input type="radio" name="marital" id="marital" value="Married" <?php echo trim($marital) == "Married" ? "checked" : ""; ?>>&nbsp;Married&nbsp;
											<input type="radio" name="marital" id="marital" value="Single" <?php echo trim($marital) == "Single" ? "checked" : ""; ?>>&nbsp;Single&nbsp;
											<label><small><?php echo form_error("marital"); ?></small></label>
										</div>
									</div>
								</div>
								<hr data-content="CONTACT DETAILS" class="hr-text">
								<div class="row">
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("mobile") ? "has-error" : "" ?>">
											<label for="mobile">Mobile Number<span class="text-danger">*</span></label>
											<input id="guardian_id" name="mobile" value="<?php echo $mobile; ?>" type="text" class="form-control" placeholder="Enter Mobile Number Here..." required maxlength="8"/>
											<label><small><?php echo form_error("mobile"); ?></small></label>
										</div>
									</div>
									
									<div class="col-md-3 col-sm-6">
									<div class="form-group">
										<label for="app_mobile">Whasapp Number <small class="text-muted">(Optional)</small></label>
										<div class="d-flex">
										<select class="txtBx_mdl form-control flex-shrink:0" data-live-search="true" id="country" name="wa_code" required>
																			<option value="">Select Code</option>
																			<?php foreach ($countries as $value) : ?>
																				<option <?= ($value['country_code'] == $wa_code) ? 'selected' : '' ?> value="<?= $value['country_code'] ?>">
																					+<?= $value['country_code'] . ' - ' . $value['country_name'] ?>
																				</option>
																			<?php endforeach; ?>
																		</select>
										<input type="text" class="form-control flex-grow-1" name="wa_mobile" id="wa_mobile" value="<?php echo $wa_mobile; ?>" maxlength="8" placeholder="Enter Whatsapp Mobile Number">
										</div>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("emergency_mobile") ? "has-error" : "" ?>">
											<label for="emergency_mobile">Emergency Contact Number</label>
											<input id="emergency_mobile" name="emergency_mobile" value="<?php echo $emergency_mobile; ?>" type="text" class="form-control" placeholder="Enter Emergency Contact Number Here..." required />
											<label><small><?php echo form_error("emergency_mobile"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("email") ? "has-error" : "" ?>">
											<label for="email">Email</label>
											<input id="email" name="email" value="<?php echo $email; ?>" type="text" class="form-control" placeholder="Enter Email Here..." />
											<label><small><?php echo form_error("patient_name"); ?></small></label>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-1 col-sm-2">
										<div class="form-group <?php echo form_error("zone") ? "has-error" : "" ?>">
											<label for="zone">Zone</label>
											<input id="zone" name="zone" value="<?php echo $zone; ?>" type="text" class="form-control" placeholder="Enter Zone Number Here..." />
											<label><small><?php echo form_error("zone"); ?></small></label>
										</div>
									</div>

									<div class="col-md-1 col-sm-2">
										<div class="form-group <?php echo form_error("street") ? "has-error" : "" ?>">
											<label for="street">Street</label>
											<input id="street" name="street" value="<?php echo $street; ?>" type="text" class="form-control" placeholder="Enter Street Here..." />
											<label><small><?php echo form_error("street"); ?></small></label>
										</div>
									</div>

									<div class="col-md-1 col-sm-2">
										<div class="form-group <?php echo form_error("building") ? "has-error" : "" ?>">
											<label for="building">Building</label>
											<input id="building" name="building" value="<?php echo $building; ?>" type="text" class="form-control" placeholder="Enter Building Number Here..." />
											<label><small><?php echo form_error("building"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("passport_number") ? "has-error" : "" ?>">
											<label for="passport_number">Passport/Alternative Number</label>
											<input id="passport_number" name="passport_number" value="<?php echo $passport_number; ?>" type="text" class="form-control" placeholder="Enter Passport Number Here..." />
											<label><small><?php echo form_error("passport_number"); ?></small></label>
										</div>
									</div>
								</div>
								<hr data-content="Employment & Insurance Information" class="hr-text">
								<div class="row">

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("company") ? "has-error" : "" ?>">
											<label for="company">Company<span class="text-danger">*</span></label>
											<select class="txtBx_mdl selectpicker" data-live-search="true" id="company" name="company" required>
												<option value="0">Select Company</option>
												<?php foreach ($companies as $value) : ?>
													<option <?= ($company_id == $value['company_id']) ? 'selected' : '' ?> value="<?= $value['company_id'] ?>">
														<?= $value['company_name'] ?>
													</option>
												<?php endforeach; ?>
											</select>
											<label><small><?php echo form_error("company"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("insurance_type") ? "has-error" : "" ?>">
											<label for="insurance_type">Insurance Type<span class="text-danger">*</span></label>
											<select class="txtBx_mdl selectpicker" data-live-search="true" id="insurance_type" name="insurance_type" required>
												<option value="">Select Insurance Type</option>
												<?php foreach ($insurances as $value) : ?>
													<option <?= ($insurance_type == $value['insurance_type_id']) ? 'selected' : '' ?> value="<?= $value['insurance_type_id'] ?>">
														<?= $value['insurance_name'] ?>
													</option>
												<?php endforeach; ?>
											</select>
											<label><small><?php echo form_error("insurance_type"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("category") ? "has-error" : "" ?>">
											<label for="category">Category</label>
											<!-- <input id="category" name="category" value="<?php //echo $category; 
																								?>" type="text" class="form-control" placeholder="Enter Category Here..." /> -->

											<select class="form-control txtBx_mdl selectpicker" data-live-search="true" id="module" name="category" required>
												<option value="">Select Department</option>
												<?php foreach ($modules as $value) : if ($value['department_id'] > 0) { ?>
														<option <?= ($module == $value['module_id']) ? 'selected' : '' ?> value="<?= $value['module_id'] ?>">
															<?= $value['module_name'] ?>
														</option>
												<?php }
												endforeach; ?>
											</select>
											<label><small><?php echo form_error("category"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("category") ? "has-error" : "" ?>">
											<label for="category">Discount Category</label>
											<!-- <input id="category" name="category" value="<?php //echo $category; 
																								?>" type="text" class="form-control" placeholder="Enter Category Here..." /> -->

											<select class="form-control txtBx_mdl selectpicker" data-live-search="true" id="module" name="discount_category" required>
												<option value="">Select Discount Category</option>
												<?php foreach ($discount_categories as $value):  ?>
														<option  <?= ($discount_category == $value['id']) ? 'selected' : '' ?> value="<?= $value['id'] ?>">
															<?= $value['category'] .'('.$value['discount'].'%)' ?>
														</option>
												<?php
												endforeach; ?>
											</select>
											<label><small><?php echo form_error("category"); ?></small></label>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-3 col-sm-3">
										<div class="form-group <?php echo form_error("note") ? "has-error" : "" ?>">
											<label for="note">Note</label>
											<input id="note" name="note" value="<?php echo $note; ?>" type="text" class="form-control" placeholder="Enter Note Here..." />
											<label><small><?php echo form_error("note"); ?></small></label>
										</div>
									</div>
								
									<div class="col-md-2 col-sm-4">
											<div class="form-group <?php echo form_error("black") || form_error("vip") ? "has-error" : "" ?> mt-3">

												<!-- Black List Checkbox -->
												<div class="form-check">
													<input class="form-check-input" type="checkbox" name="black" id="black" value="1" <?php echo $black == 1 ? "checked" : ""; ?>>
													<label class="form-check-label" for="black">
														Blacklist
													</label>
												</div>
												<small class="text-danger"><?php echo form_error("black"); ?></small>

												<!-- Spacer between checkboxes -->
												<div class="mt-1"></div>

												<!-- VIP Checkbox -->
												<div class="form-check">
													<input class="form-check-input" type="checkbox" name="vip" id="vip" value="1" <?php echo $vip == 1 ? "checked" : ""; ?>>
													<label class="form-check-label" for="vip">
														VIP
													</label>
												</div>
												<small class="text-danger"><?php echo form_error("vip"); ?></small>

											</div>
										</div>
									<div class="col-md-2 col-sm-1">
										
									</div>
								</div>
								<div class="row">
									<div class="col-md-3">
										<img id="uploadPreview" style="display:none;" class="img-thumbnail" />
									</div>
									<div class="col-md-3">
										<img id="uploadPreviewID" style="display:none;" class="img-thumbnail" />
									</div>
								</div>
								<div class="row">
									<div class="col-md-4">
										<div class="box-body">
											<div class="form-group <?php echo form_error("image_path") || form_error("image_path") ? "has-error" : "" ?>" >
												<label for="image_path">Qatar ID Image <span class="text-danger">*</span></label>
												<input type="file" style="display:block!important"  required id="image_path" name="image_path" size="60">
												<input type="hidden" style="display:block!important"  id="uploadImageval" name="image_path_val" value="<?= $profile_img?>" size="60">
												<small class="text-danger"><?php echo form_error("image_path"); ?></small>
											</div>
										</div>
									</div>
									<!-- <div class="col-md-4">
										<div class="box-body">
											<div class="form-group">
												<label>Qatar ID</label>
												<input type="file" style="display:block!important"  id="uploadImageID" name="qid_front_image" size="60" >
												<input type="hidden" style="display:block!important"  id="uploadImageIDval" name="qid_front_image_val" size="60" >
											</div>
										</div>
									</div> -->

									<!-- <div class="col-md-4">
										<div class="box-body">
											<div class="form-group">
												<label>Profile Image</label>
												<label class="file-control">
													<input type="file" id="fileUploader" name="fileUploader" size="60">
													<div class="dv-image">
														<img class="result-image" id="result" name="result" src="
															<?php echo ($user_id_val > 0 ? $image_path_val : base_url('dist/img/user.jpg')) ?>">
														<div class="dv-hover center">
															<i class="fa fa-image"></i>
														</div>
													</div>
												</label>
											</div>
										</div>
									</div>
									<div class="col-md-4">
										<div class="box-body">
											<div class="form-group">
												<label>Qatar ID</label>
												<label class="file-control">
													<input type="file" id="fileUploader" name="fileUploader" size="60">
													<div class="dv-image">
														<img class="result-image" id="result" name="result" src="
															<?php echo ($user_id_val > 0 ? $image_path_val : base_url('dist/img/user.jpg')) ?>">
														<div class="dv-hover center">
															<i class="fa fa-image"></i>
														</div>
													</div>
												</label>
											</div>
										</div>
									</div> -->
								</div>
								<div class="row">
									<div class="col-md-12">
										<div class="d-flex justify-content-end w-100">
											<a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class="btn btn-light btn-sm">
												<i class="fa fa-check-circle" aria-hidden="true"></i>
												<?php echo $_id > 0 ? 'Update' : 'Save' ?>
											</a>
											<button class="btn btn-sm btn-light mr-2" type="reset">
												<i class="fa fa-refresh" aria-hidden="true"></i>
												Reset
											</button>
											
										</div>
									</div>
								</div>


							</div>
						</div>
					</div>
				</div>

				<!--tables-->


			</section>
			<input type="hidden" id="_id" name="_id" value="<?php echo $_id; ?>">
			<input type="hidden" id="app_id" name="app_id" value="<?php echo $app_id; ?>">
			<input type="hidden" id="app_patient_id" name="app_patient_id" value="<?php echo $app_patient_id; ?>">

		</form>

	</div>

	<!-- ./wrapper -->


	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
	<script src="<?php echo base_url('/js/imgareaselect.js');?>"></script>
    <script src="<?php echo base_url('/js/script.js');?>"></script>

</body>

</html>

<script>


$(".select_dob").datepicker({
			autoclose: true,
			todayHighlight: true,
			format: 'dd/mm/yyyy'
}).datepicker();


$(".select_dob").mask("99/99/9999",{placeholder:"DD/MM/YYYY"});

document.addEventListener('DOMContentLoaded', function() {
        const blackCheckbox = document.getElementById('black');
        const vipCheckbox = document.getElementById('vip');

        blackCheckbox.addEventListener('change', function() {
            if (this.checked) {
                vipCheckbox.checked = false;
            }
        });

        vipCheckbox.addEventListener('change', function() {
            if (this.checked) {
                blackCheckbox.checked = false;
            }
        });
    });
	$("[data-control=image_uploader]").change(function() {
		readURL(this);
	});

	function readURL(input) {
		if (input.files && input.files[0]) {
			var reader = new FileReader();
			reader.onload = function(e) {

				$('#croppie_modal').on('shown.bs.modal', function() {
					document.getElementById('croppie_footer').innerHTML = "<div class='form-group' style='min-height:0px;'><a id='use' class='image-select btn-primary '><i class='fa fa-crop' style='margin-right: 8px;'></i> CROP</a></div>";

					document.getElementById('croppie_image').innerHTML = "<div class='form-group center'><img id='upload_image' src='#' /></div>";

					$('#upload_image').css({
						width: '100%',
						objectFit: 'contain'
					});


					$('#upload_image').attr('src', e.target.result);
					// var resize = new Croppie($('#upload_image')[0], {
					// 	viewport: {
					// 		width: 700,
					// 		height: 900
					// 	},
					// 	boundary: {
					// 		width: 700,
					// 		height: 900
					// 	},
					// 	showZoomer: true,
					// 	enableResize: true,
					// 	enableOrientation: true
					// });



					$('#use').fadeIn();


					$('#use').on('click', function() {
						var dataImg = e.target.result;

						$('#result').attr('src', dataImg);

						$('#image_path').val(dataImg);

						$('#is_new_image').val('true');


						$("#croppie_modal").modal("hide");


					});


				});

				$("#croppie_modal").modal("show");

			}
			reader.readAsDataURL(input.files[0]);
		}
	}
</script>

<script>
	var settings = {};
	new TomSelect('#country', settings);
	new TomSelect('#nationality', settings);
	new TomSelect('#insurance_type', settings);
	new TomSelect('#company', settings);


	var dataTableTreatment = $('#treatement_list').DataTable({
		'ajax': {
			'url': '<?= site_url('admin/Patients/PatientsController/get_patients_list'); ?>',
			'type': 'GET',
			'data': function(d) {
				d.patient_id = '<?php echo encrypt_and_url_encode($patient_id, $this); ?>',
					d.module_id = $('#modules_dropdown').val();
			}
		},
		'columns': [{
				'data': 'treatement_payment_id',
				'title': 'File No'
			},
			{
				'data': 'name',
				'title': 'Patient Name'
			},
			{
				'data': 'procedure_ids',
				'title': 'Type'
			},
			{
				'data': 'teeth_number',
				'title': 'Qatar ID'
			},
			{
				'data': 'full_name',
				'title': 'Nationality'
			},
			{
				'data': 'discount',
				'title': 'Gender'
			},
			{
				'data': 'total',
				'title': 'Mobile Number'
			},
			{
				'data': 'total',
				'title': 'Last Visit'
			},
			{
				'data': 'total',
				'title': 'Action'
			},
			{
				'data': null,
				'title': 'Actions',
				'render': function(data, type, row) {
					var actions = '<button class="btn btn-xs btn-primary" onclick="yourButtonClickFunction(' + row.id + ')">Edit</button>';
					actions += '<button class="btn btn-xs btn-danger m-1" onclick="yourButtonClickFunction(' + row.id + ')">Delete</button>';

					return actions
				}
			}
		],
		'serverSide': true,
		'pageLength': 10,
		'lengthMenu': [10, 25, 50, 100],
		'pagingType': 'full_numbers'
	});
	$("#fileUploader").change(function() {
		readURL(this);
	});
</script>