<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


	<?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				Patient
				<small><?php echo $_id > 0 ? 'Update' : 'New' ?></small>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<form id="submitForm" name="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Patients/PatientsController/save') ?>" method="post">
			<section class="content">

				<!--buttons-->

				<div class="row">
					<div class="col-xs-12">
						<div class="box box-solid">
							<div class="box-body">
								<div class="row"> <!-- Form Buttons   -->

									<div class="col-md-1">
										<a href="<?php echo base_url('index.php/admin/Patients/PatientsController') ?>" class="btn btn-info"><i class="fa fa-angle-left"></i> Go back </a>
									</div>
									<div class="col-md-9">
										<?php if (validation_errors()) { ?>
											<div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
												<div>
													<p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
												</div>
											</div>
										<?php } ?>
									</div>
									<div class="col-md-2 text-right">

										<a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class=" btn btn-success "> <?php echo $_id > 0 ? 'Update' : 'Save' ?></a>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!--//buttons-->

				<!--form-->
				<div class="row">
					<div class="col-xs-12">
						<div class="box box-info" style="margin-bottom: 5px;">
							<div class="box-header with-border">
								<h2 class="box-title">Patient details</h2>
								<div class="pull-right box-tools">
									<div class="btn-group">
										<button class="btn btn-info btn-sm" data-widget="collapse"><i class="fa fa-minus"></i></button>
									</div>
								</div>
							</div>
							<div class="box-body">
								<div class="row">
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("first_name") ? "has-error" : "" ?>">
											<label for="first_name">First Name</label>
											<input id="first_name" name="first_name" value="<?php echo $first_name; ?>" type="text" class="form-control" placeholder="Enter First Name Here..." />
											<label><small><?php echo form_error("first_name"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("middle_name") ? "has-error" : "" ?>">
											<label for="middle_name">Middle Name</label>
											<input id="middle_name" name="middle_name" value="<?php echo $middle_name; ?>" type="text" class="form-control" placeholder="Enter Middle Name Here..." />
											<label><small><?php echo form_error("middle_name"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("last_name") ? "has-error" : "" ?>">
											<label for="last_name">Last Name</label>
											<input id="last_name" name="last_name" value="<?php echo $last_name; ?>" type="text" class="form-control" placeholder="Enter Patient Name Here..." />
											<label><small><?php echo form_error("last_name"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("qatar_id") ? "has-error" : "" ?>">
											<label for="qatar_id">Qatar ID</label>
											<input id="qatar_id" name="qatar_id" value="<?php echo $qatar_id; ?>" type="text" class="form-control" placeholder="Enter Qatar ID Here..." />
											<label><small><?php echo form_error("qatar_id"); ?></small></label>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("guardian_id") ? "has-error" : "" ?>">
											<label for="guardian_id">Guardian's ID</label>
											<input id="guardian_id" name="guardian_id" value="<?php echo $guardian_id; ?>" type="text" class="form-control" placeholder="Enter Guardian's ID Here..." />
											<label><small><?php echo form_error("guardian_id"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("country") ? "has-error" : "" ?>">
											<label for="country">Country of Residence</label>
											<!-- <input id="country" name="country" value="<?php echo $country; ?>" type="text" class="form-control" placeholder="Enter Country Here..." /> -->
											<select class="form-control txtBx_mdl selectpicker"  data-live-search="true"  id="country" name="country">
                                                    <option value="0">Select Country</option>
                                                    <?php foreach ($countries as $value) { ?>
                                                        <?php if ($country == $value['country_id']) { ?>
															<option selected value="<?php echo $value['country_id'] ?>"><?php echo $value['country_code'].' - '.$value['country_name'] ?></option>   
                                                        <?php } else { ?>
                                                            <option value="<?php echo $value['country_id']?>"><?php echo $value['country_code'].' - '.$value['country_name'] ?></option>   
                                                        <?php } ?>

                                                    <?php } ?>
                                            </select>
											<label><small><?php echo form_error("country"); ?></small></label>
										</div>
									</div>		

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("dob") ? "has-error" : "" ?>">
											<label for="dob">Date of Birth</label>
											<input id="dob" name="dob" value="<?php echo $dob; ?>" type="text" class="form-control" placeholder="Enter Date of Birth Here..." />
											<label><small><?php echo form_error("dob"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("nationality") ? "has-error" : "" ?>">
											<label for="nationality">Nationality</label>
											<select class="form-control txtBx_mdl selectpicker"  data-live-search="true"  id="nationality" name="nationality">
                                                    <option value="0">Select Nationality</option>
                                                    <?php foreach ($countries as $value) { ?>
                                                        <?php if ($nationality == $value['country_id']) { ?>
                                                            <option selected value="<?php echo $value['country_id'] ?>"><?php echo $value['country_code'].' - '.$value['country_name'] ?></option>   
                                                        <?php } else { ?>
                                                            <option value="<?php echo $value['country_id']?>"><?php echo $value['country_code'].' - '.$value['country_name'] ?></option>   
                                                        <?php } ?>

                                                    <?php } ?>
                                            </select>
											<label><small><?php echo form_error("nationality"); ?></small></label>
										</div>
									</div>	
								</div>
								<div class="row">
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("mobile") ? "has-error" : "" ?>">
											<label for="mobile">Mobile Number</label>
											<input id="guardian_id" name="mobile" value="<?php echo $mobile; ?>" type="text" class="form-control" placeholder="Enter Mobile Number Here..." />
											<label><small><?php echo form_error("guardian_id"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("second_mobile") ? "has-error" : "" ?>">
											<label for="second_mobile">Second Mobile Number</label>
											<input id="second_mobile" name="second_mobile" value="<?php echo $second_mobile; ?>" type="text" class="form-control" placeholder="Enter Passport Number Here..." />
											<label><small><?php echo form_error("second_mobile"); ?></small></label>
										</div>
									</div>

									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("emergency_mobile") ? "has-error" : "" ?>">
											<label for="emergency_mobile">Emergency Contact Number</label>
											<input id="emergency_mobile" name="emergency_mobile" value="<?php echo $emergency_mobile; ?>" type="text" class="form-control" placeholder="Enter Emergency Contact Number Here..." />
											<label><small><?php echo form_error("emergency_mobile"); ?></small></label>
										</div>
									</div>
									
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("email") ? "has-error" : "" ?>">
											<label for="email">Email</label>
											<input id="email" name="email" value="<?php echo $email; ?>" type="text" class="form-control" placeholder="Enter Email Here..." />
											<label><small><?php echo form_error("patient_name"); ?></small></label>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-1 col-sm-2">
										<div class="form-group <?php echo form_error("zone") ? "has-error" : "" ?>">
											<label for="zone">Zone</label>
											<input id="zone" name="zone" value="<?php echo $zone; ?>" type="text" class="form-control" placeholder="Enter Zone Number Here..." />
											<label><small><?php echo form_error("zone"); ?></small></label>
										</div>
									</div>

									<div class="col-md-1 col-sm-2">
										<div class="form-group <?php echo form_error("street") ? "has-error" : "" ?>">
											<label for="street">Street</label>
											<input id="street" name="street" value="<?php echo $street; ?>" type="text" class="form-control" placeholder="Enter Street Here..." />
											<label><small><?php echo form_error("street"); ?></small></label>
										</div>
									</div>

									<div class="col-md-1 col-sm-2">
										<div class="form-group <?php echo form_error("building") ? "has-error" : "" ?>">
											<label for="building">Building</label>
											<input id="building" name="building" value="<?php echo $building; ?>" type="text" class="form-control" placeholder="Enter Building Number Here..." />
											<label><small><?php echo form_error("building"); ?></small></label>
										</div>
									</div>
									
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("passport_number") ? "has-error" : "" ?>">
											<label for="passport_number">Passport/Alternative Number</label>
											<input id="passport_number" name="passport_number" value="<?php echo $passport_number; ?>" type="text" class="form-control" placeholder="Enter Passport Number Here..." />
											<label><small><?php echo form_error("passport_number"); ?></small></label>
										</div>
									</div>
									
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("insurance_type") ? "has-error" : "" ?>">
											<label for="insurance_type">Insurance Type</label>
											<select class="form-control txtBx_mdl selectpicker"  data-live-search="true"  id="insurance_type" name="insurance_type">
                                                    <option value="0">Select Country</option>
                                                    <?php foreach ($insurances as $value) { ?>
                                                        <?php if ($insurance_type == $value['insurance_type_id']) { ?>
															<option selected value="<?php echo $value['insurance_type_id'] ?>"><?php echo $value['insurance_name'] ?></option>   
                                                        <?php } else { ?>
                                                            <option value="<?php echo $value['insurance_type_id'] ?>"><?php echo $value['insurance_name'] ?></option>   
                                                        <?php } ?>

                                                    <?php } ?>
                                            </select>
											<label><small><?php echo form_error("insurance_type"); ?></small></label>
										</div>
									</div>
									
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("category") ? "has-error" : "" ?>">
											<label for="category">Category</label>
											<input id="category" name="category" value="<?php echo $category; ?>" type="text" class="form-control" placeholder="Enter Category Here..." />
											<label><small><?php echo form_error("category"); ?></small></label>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-md-3 col-sm-6">
										<div class="form-group <?php echo form_error("note") ? "has-error" : "" ?>">
											<label for="note">Note</label>
											<input id="note" name="note" value="<?php echo $note; ?>" type="text" class="form-control" placeholder="Enter Note Here..." />
											<label><small><?php echo form_error("note"); ?></small></label>
										</div>
									</div>
									<div class="col-md-1 col-sm-3">
										<div class="form-group <?php echo form_error("sex") ? "has-error" : "" ?>">
											<label for="sex">Sex</label><br>
											<input type="radio" name="sex" id="sex" value="Male" <?php echo trim($sex) == 'Male' ? "checked":""; ?>>&nbsp;Male
											<input type="radio" name="sex" id="sex" value="Female" <?php echo trim($sex) == 'Female' ? "checked":""; ?>>&nbsp;Female
											<label><small><?php echo form_error("sex"); ?></small></label>
										</div>
									</div>
									<div class="col-md-2 col-sm-3">
										<div class="form-group <?php echo form_error("marital") ? "has-error" : "" ?>">
											<label for="marital">Marital Status</label><br>
											<input type="radio" name="marital" id="marital" value="Married" <?php echo trim($marital) == "Married" ? "checked":""; ?>>&nbsp;Married&nbsp;
											<input type="radio" name="marital" id="marital" value="Single" <?php echo trim($marital) == "Single" ? "checked":""; ?>>&nbsp;Single&nbsp;
											<label><small><?php echo form_error("marital"); ?></small></label>
										</div>
									</div>
									<div class="col-md-2 col-sm-3">
										<div class="form-group <?php echo form_error("black") ? "has-error" : "" ?>">
											<label for="black">Black list</label>&nbsp;
											<input type="checkbox" name="black" id="black" value="1" <?php echo $black == 1 ? "checked":""; ?>>
											<label><small><?php echo form_error("black"); ?></small></label>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<!--tables-->


			</section>
			<input type="hidden" id="_id" name="_id" value="<?php echo $_id; ?>">

		</form>

	</div>

	<!-- ./wrapper -->


	<?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>

<script>
	$("[data-control=image_uploader]").change(function() {
		readURL(this);
	});

	function readURL(input) {
		if (input.files && input.files[0]) {
			var reader = new FileReader();
			reader.onload = function(e) {

				$('#croppie_modal').on('shown.bs.modal', function() {

					document.getElementById('croppie_image').innerHTML = "<div class='form-group center'><img id='upload_image' src='#' /></div>";

					document.getElementById('croppie_footer').innerHTML = "<div class='form-group' style='min-height:0px;'><a id='use' class='image-select btn-primary'><i class='fa fa-crop' style='margin-right: 8px;'></i> CROP</a></div>";


					$('#upload_image').attr('src', e.target.result);
					var resize = new Croppie($('#upload_image')[0], {
						viewport: {
							width: 350,
							height: 450
						},
						boundary: {
							width: 400,
							height: 515
						},
						showZoomer: false,
						enableResize: false,
						enableOrientation: true
					});



					$('#use').fadeIn();


					$('#use').on('click', function() {
						resize.result('base64').then(function(dataImg) {
							var data = [{
								image: dataImg
							}, {
								name: 'myimgage.jpg'
							}];

							$('#result').attr('src', dataImg);

							$('#item_image').val(dataImg);
							$('#is_new_image').val('true');


							$("#croppie_modal").modal("hide");

						});
					});


				});

				$("#croppie_modal").modal("show");

			}
			reader.readAsDataURL(input.files[0]);
		}
	}
</script>