<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Patients List </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


  <?php
  if (!$this->input->is_ajax_request()) {
  require_once(APPPATH . "views/admin/header-simple.php"); 
  }
  ?>

  <style>
    .uploadIcon {
      font-size: 5em !important;
      color: #084a6a;
    }

    .uploadLable {
      cursor: pointer;
      padding: 10px;
      cursor: pointer;
      animation: blink 1s infinite;
    }

    @keyframes blink {
      0% {
        opacity: 0.5;
      }

      50% {
        opacity: 1;
      }

      100% {
        opacity: 0.5;
      }
    }
  </style>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php
  
   require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <div class="modal fade" id="patient_import_modal" tabindex="-1" role="dialog" aria-labelledby="import_patients" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="import_patients">Import Patients</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?= base_url('index.php/admin/Patients/PatientsController/import'); ?>" method="post" enctype="multipart/form-data">
          <div class="modal-body text-center">

            <div class="form-group">
              <i class="fa fa-cloud-upload uploadIcon" aria-hidden="true"></i><br>
              <label class="uploadLable d-block" style="font-size:20px" for="csv_file">CHOOSE A FILE</label>
              <small class="text-danger" style="font-size:17px">"Support is available exclusively for CSV files."</small>
              <input type="file" name="csv_file" id="csv_file" class="form-control" placeholder="Choose CSV File" onchange="handleFileSelect()">
            </div>

            <div id="csv_table_container" class="overflow-auto"></div>

          </div>
          <div class="modal-footer">
            <a href="<?php echo base_url('template_formats/patient_import.csv') ?>" class="btn btn-dark btn-sm" download target="_blank">
              <i class="fa fa-download" aria-hidden="true"></i>
              Download CSV Template
            </a>
            <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
              <i class="fa fa-times-circle" aria-hidden="true"></i>
              Close
            </button>
            <button type="submit" class="btn btn-light btn-sm">
              <i class="fa fa-check-circle" aria-hidden="true"></i>
              Submit
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <strong>Patients List</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->
    <form id="submitForm" name="submitForm" role="submitForm" action="<?php echo base_url('index.php/admin/Patients/PatientsController/search') ?>" method="post">

      <section class="content">
        <!--buttons-->
        <div class="row">
          <div class="col-12">
            <div class="box box-solid" style="margin-bottom: 5px;">
              <div class="box-body">
                <!-- <?php
                $errors = $this->session->flashdata('errors');
                if ($errors) { ?>
                  <div class="row mb-1">
                    <div class="col-md-12">
                      <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                        <div>
                          <span><i class="icon fa fa-warning"></i><?= $errors; ?></span>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php } ?> -->

                <!-- <?php
                $success = $this->session->flashdata('success');
                if ($success) { ?>
                  <div class="row mb-1">
                    <div class="col-md-12">
                      <div class="callout <?php echo $this->config->item('msg_success'); ?> error-msg">
                        <div>
                          <span><i class="icon fa fa-check"></i><?= $success; ?></span>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php } ?> -->
                <div class="row">
                  <div class="col-md-4"></div>
                  <div class="col-md-4 text-right"></div>
                  <div class="col-md-4 text-right">
                    <button type="button" class="btn btn-dark btn-sm" data-toggle="modal" data-target="#patient_import_modal">
                      <i class="fa fa-upload" aria-hidden="true"></i>
                      Import Patients
                    </button>
                    <a href="<?php echo base_url('index.php/admin/Patients/PatientsController/createNew') ?>" class="btn btn-dark btn-sm">
                      <i class="fa fa-plus-circle" aria-hidden="true"></i>
                      Create new
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>


        <!--//buttons-->

        <!--table-->

        <div class="box box-info">
             <div class="row justify-content-end box-body">
                <div class="form-group col-md-3">
                    <label for="">Patient Name</label>
                    <input type="text" class="form-control" name="patient_name" id="patient_name" placeholder="Search By Name">
                </div>
                <div class="form-group col-md-3">
                    <label for="">Patient QID</label>
                    <input type="number" class="form-control" name="patient_qid" id="patient_qid" placeholder="Search By QID">
                </div>
                 <?php if(!check_right('hide_mobile',$this)) { ?>
          <div class="form-group col-md-3">
              
                    <label for="">Patient Mobile</label>
                    <input type="number" class="form-control" name="patient_mobile" id="patient_mobile" placeholder="Search By Mobile">
                  </div>
                  
                  <?php } ?>
                  <div class="form-group col-md-3">
                    <label for="">Patient File No</label>
                    <input type="number" class="form-control" name="patient_mobile" id="patient_file" placeholder="Search By Patient File">
                  </div>
          </div>
          <div class="box-body  table-responsive">

            <!--table format-->
            <table class="table table-bordered table-striped" id="patient_list">
            </table>
            <?php /*?> <?php require_once(APPPATH . "views/admin/pagination.php"); ?><?php */ ?>
          </div>
          <!-- /.box-body -->
        </div>

        <!--//table-->
        <input type="hidden" id="selected_id" name="selected_id">
        <input type="hidden" id="formSubmit" name="formSubmit" value="submitForm">
        <input type="hidden" id="form" name="form" value="Patients">


      </section>


    </form>

  </div>

  <!-- ./wrapper -->


  <?php require_once(APPPATH . "views/admin/footer-simple.php"); ?>
<?php 
$loged_user =getLoginUser($this);

?>

</body>
<script>
  $(document).on('click', '[data-control=medical_click]', function(e) {

    var selected_id = e.target.id;
    var form = $('#formSubmit').val();
    var url_ = $('#form').val();

    $('#selected_id').val(selected_id);

    var URL = url_ + 'Controller/medical_book/' + selected_id;

    window.location.href = URL;

  });

var usergroup = "<?php echo check_right('print_patients', $this) ?>";
console.log(usergroup + 'sd');
var buttonsConfig = [];
// Add Print button if the user has permission
if (usergroup != "") {
    buttonsConfig.push({
        extend: 'print',
        autoPrint: true,
        title: `Patient List`,
        exportOptions: {
            columns: ':not(:last-child)'
        },
        customize: function(win) {
            $(win.document.body).prepend(`<?php print_header($this); ?>`);
        }
    });
}else{
    
}

  var dataTable = $('#patient_list').DataTable({
    dom: 'lBfrtip',
     buttons: buttonsConfig,
    'ajax': {
      'url': '<?= site_url('admin/Patients/PatientsController/get_patients_list'); ?>',
      'type': 'GET',
      'data': function(d) {
        d.patient_mobile=$("#patient_mobile").val()
        d.patient_file=$("#patient_file").val()
        d.patient_qid=$("#patient_qid").val()
        d.patient_name=$("#patient_name").val()
      }
    },
    'columns': [
      {
        'data': 'file_no',
        'title': 'File No',
      },
      {
        'data': 'patient_name',
        'title': 'Patient Name',
        'render': function (data, type, row, meta) {
          if(row.vip == 1){
            return parseInt(row.vip) ? `<span class="badge badge-danger">VIP</span> ${row.patient_name} ` : row.patient_name;
          }else if(row.black==1){
            return parseInt(row.black) ? `<span class="badge badge-dark">Black Listed</span> ${row.patient_name} ` : row.patient_name;
          }else{
            return  row.patient_name ;
          }
          
        }
      },
      {
        'data': 'insurance_name',
        'title': 'Insurance Type'
      },
      {
        'data': 'qatar_id',
        'title': 'Qatar ID'
      },
     
      {
        'data': 'sex',
        'title': 'Gender'
      },
      {
          'data': '',
          'title': 'DOB',
          'render': function(data, type, row) {
            const dob = new Date(row.dob);
            const diff = Date.now() - dob.getTime();
            const ageDate = new Date(diff);
            const age = Math.abs(ageDate.getUTCFullYear() - 1970);
            return row.dob+' ('+age+'y)';
          }
        },
        <?php if(check_right('hide_mobile',$this)) { ?>
        <?php } else { ?>
      {
        'data': '',
        'title': 'Mobile Number',
        'render': function(data, type, row) {
            return row.mobile;
        }
      },<?php } ?>
      
      {
        'data': 'note',
        'title': 'Note'
      },
      {
        'data': null,
        'title': 'Actions',
        'render': function(data, type, row, meta) {
          var htmlContent = ''
          return htmlContent = `<div class="d-flex justify-content-center w-100">
          <?php if(check_right('view_medical',$this)) { ?>
    <a data-control="" title="Patient Medical Book" id="${row.patient_id}" href="<?= base_url('index.php/admin/Patients/PatientsController/medical_book/'); ?>${row.patient_id}" class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i id="${row.patient_id}" class="fa fa-book"></i>
    </a>
    <?php } if(check_right('view_patients',$this)) { ?>
    <a data-control="" title="Patient Details" id="${row.patient_id}" href="<?= base_url('index.php/admin/Patients/PatientsController/view/'); ?>${row.patient_id}" class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i id="${row.patient_id}" class="fa fa-search"></i>
    </a>
    <?php } if(check_right('edit_patients',$this)) { ?>
    <a data-control="" title="Edit Patient" id="${row.patient_id}" href="<?= base_url('index.php/admin/Patients/PatientsController/edit/'); ?>${row.patient_id}" class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i id="${row.patient_id}" class="fa fa-edit"></i>
    </a>
    <?php } if(check_right('view_statement',$this)) { ?>
    <a title="Patient Statement" href="<?= base_url('index.php/admin/Patients/PatientsController/patientStatement/'); ?>${row.patient_id}" class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i class="fa fa-file-text" aria-hidden="true"></i>
    </a>
    <a data-control="" title="Visit Form" id="${row.patient_id}" href="<?= base_url('index.php/admin/Patients/PatientsController/visit_form/'); ?>${row.patient_id}"  class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i id="${row.patient_id}" class="fa fa-id-badge"></i>
    </a>
    <?php } if(check_right('delete_patients',$this)) { ?>
    <a data-control="" title="Delete Patient" id="${row.patient_id}" href="#" onclick="confirmDelete('<?= base_url('index.php/admin/Patients/PatientsController/delete/'); ?>${row.patient_id}')" class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i id="${row.patient_id}" class="fa fa-trash"></i>
    </a>
    <?php } ?>
     <a data-control="" title="Visit Form" id="${row.patient_id}" href="<?= base_url('index.php/admin/Patients/PatientsController/print_details/'); ?>${row.patient_id}"  class="btn btn-light float-right btn-sm" style="margin-right: 5px;">
        <i id="${row.patient_id}" class="fa fa-print"></i>
    </a>
</div>`;
        }
      }
    ],
    'order': [[0, 'desc']],
    'searching': false,
    'serverSide': true,
    'pageLength': 10,
    aLengthMenu: [
      [25, 50, 100, 200, -1],
      [25, 50, 100, 200, "All"]
    ],
    'pagingType': 'full_numbers',
    'columnDefs': [{
      'targets': -1, // Target the last column (Actions column)
      'className': 'dt-center'
    }]
  });
   $("#patient_mobile, #patient_qid, #patient_name").keyup(function(){
    dataTable.ajax.reload();
  })
  $("#patient_file").keyup(function(){
    dataTable.ajax.reload();
  })
</script>

<script>
  function handleFileSelect() {
    const fileInput = document.getElementById('csv_file');
    const file = fileInput.files[0];

    if (file) {
      const reader = new FileReader();

      reader.onload = function(e) {
        const contents = e.target.result;
        displayCSVContents(contents);
      };

      reader.readAsText(file);
    }
  }

  function displayCSVContents(contents) {
    const csvTableContainer = document.getElementById('csv_table_container');
    const lines = contents.split('\n');
    const table = document.createElement('table');
    table.setAttribute('class', 'table table-bordered');

    // Create thead
    const thead = document.createElement('thead');
    thead.setAttribute('class', 'thead-dark');
    const headerRow = lines[0].split(',').map(header => {
      return header.trim().replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase());
    });

    const headerRowElement = document.createElement('tr');
    headerRow.forEach(header => {
      const th = document.createElement('th');
      th.textContent = header;
      headerRowElement.appendChild(th);
    });

    thead.appendChild(headerRowElement);
    table.appendChild(thead);

    // Create tbody
    const tbody = document.createElement('tbody');
    lines.slice(1).forEach(line => {
      const row = tbody.insertRow();
      const cells = line.split(',');

      cells.forEach(cell => {
        const cellElement = document.createElement('td');
        cellElement.textContent = cell.trim();
        row.appendChild(cellElement);
      });
    });

    table.appendChild(tbody);

    csvTableContainer.innerHTML = ''; // Clear previous content
    csvTableContainer.appendChild(table);
  }

  // Delete confirmation
  function confirmDelete(url) {
    Swal.fire({
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Yes, delete it!"
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = url;
      }
    });
  }
</script>


</html>