<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<!--image crop-->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


	<?php require_once(APPPATH . "views/admin/header.php"); ?>
	<style>
		.text-bolder{
			font-size: 18px;
			font-weight: bold;
		}
		.text-bold{
			font-weight: 700;
		}
	</style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->

	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Payment <?php echo $_id > 0 ? 'Update' : '' ?></strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<section class="content">

			<!--buttons-->

			<div class="row">
			<div class="col-md-12">
									<?php if (validation_errors()) { ?>
										<div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
											<div>
												<p><i class="icon fa fa-warning"></i>Please provide all the required data.</p>
											</div>
										</div>
									<?php } 
									if($company->discount != '0' && $paid_amount == 0){?>
									<!-- <div class="callout callout-success error-msg">
											<div>
												<p><i class="icon fa fa-warning"></i><?php //  echo $company->company_name." discount applied ".$company->discount."%" ?></p>
											</div>
										</div> -->
									<?php } ?>
								</div>
				<div class="col-12">
					<div class="box box-solid">
						<div class="box-body">
							<div class="row"> <!-- Form Buttons   -->

								<div class="col-md-4 d-flex">
									<a href="<?php echo base_url('index.php/admin/Payments/PaymentsController') ?>" class="btn btn-dark btn-sm">
										<i class="fa fa-chevron-circle-left"></i> Go back
									</a>
									<a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/'.encrypt_and_url_encode($patient_id,$this) )?>" target="_blank" class=" ml-1 btn btn-light btn-sm">
										<i class="fa fa-plus-square"></i> Medical File
									</a>
									<a href="<?php echo base_url('index.php/admin/Payments/PaymentsController/loyalty_points/'.$patient_id) ?>" class=" ml-1 btn btn-light btn-sm">
										<i class="fa fa-file-text"></i> Loyalty Points Transactions
									</a>
								</div>
								
								<div class="col-md-8 text-right d-flex justify-content-end">
									<h5 class="d-block mb-0 mr-1">
										<strong>
											Open Balance: <label class="text-red"><?php echo $total_advance; ?></label>
										</strong>
										|
									</h5>
									<h5 class="d-block mb-0">
										<strong>
											Loyalty Points: <label class="text-success"><?php echo get_loyalty_points($patient_id,$this) ?></label>
										</strong>
									</h5>
									<!-- <a href="#" onclick="document.getElementById('submitForm').submit(); return false;" class=" btn btn-success "> <?php echo $_id > 0 ? 'Update' : 'Save' ?></a> -->
									<!-- <button type="submit" class="btn btn-success "> <?php //echo $_id > 0 ? 'Update' : 'Save' 
																							?></button> -->

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!--//buttons-->
			<?php
			$paid_amount = 0;
			$cashier_discount = 0;
			$company_discount_qar=0;
			$category_discount_qar=0;
			$coupon_discount = 0;
			$points_discount = 0;
			foreach ($recipts as $val) {
				$paid_amount +=  $val->cash + $val->card + $val->insurance_amount;
				$cashier_discount += $val->discount;
				$company_discount_qar += $val->company_discount;
				$category_discount_qar += $val->category_discount;
				$coupon_discount += $val->coupon_discount;
				$points_discount += $val->points_discount;
			}

			
		
			
			$balance = round( $treatments->total - $treatments->discount - $paid_amount - $cashier_discount - $company_discount_qar - $category_discount_qar - $coupon_discount -$points_discount);
			$netTotal= round( $treatments->total - $treatments->discount  - $cashier_discount - $company_discount_qar - $category_discount_qar - $coupon_discount - $points_discount ) ;
			
			
			?>
			<!--form-->
			<div class="row">
				<input type="hidden" name="total_temp" id="total_temp" value="<?php echo $netTotal; ?>">
				<input type="hidden" name="balance_temp" id="balance_temp" value="<?php echo $balance; ?>">
				<div class="col-6">
					<div class="box box-info" style="margin-bottom: 5px;">
						<div class="box-header with-border">
							<h2 class="box-title font-weight-bold">Payment details </h2>
								
							<?php  if ($balance > 0 || $payment_id != '') : ?>
								<?php if($skipcash_details){ ?>
								<a href="" data-toggle="modal" data-target="#PaymentLinkModal" class="btn btn-light float-right"><i class="fa fa-send mr-2"></i>Send Payment Link (SkipCash)</a>
								<?php } ?>
								<div class="box-body">
									<ul class="nav nav-tabs" id="form_recipt" role="tablist">
										<li class="nav-item" id="non_insurance">
											<a class="nav-link font-weight-bold active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Non Insurance</a>
										</li>
										<?php if ($treatments->insurance_type > 1) : ?>
											<li class="nav-item" id="insurance">
												<a class="nav-link font-weight-bold" id="insurace-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Insurance</a>
											</li>
										<?php endif; ?>
									</ul>
									<div class="tab-content" id="form_recipt_content">
										<div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
											<?php require_once(APPPATH . "views/admin/Payments/Tabs/NonInsurance.php"); ?>
										</div>
										<div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="insurace-tab">
											<?php require_once(APPPATH . "views/admin/Payments/Tabs/Insurance.php"); ?>
										</div>
										<div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab"></div>
									</div>
								</div>
							<?php else : ?>
								<div class="box-body">
									
									<div class="btn btn-light d-flex align-items-center justify-content-center">
										<p class="mb-0">Payment Completed!</p>
									</div>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="col-6">
					<div class="box box-info" style="margin-bottom: 5px;">
						<div class="box-header with-border">
							<h2 class="box-title font-weight-bold">Invoice details - #<?= decrypt_and_url_decode($treatment_id,$this) ; ?></h2>
							<div class="box-body">
								<div class="form-group">
									<div class="box-body">
										<div class="row">

											<div class="col-6">
												<h5>Patient : <strong><?= $patient_id . ' - ' . $patient_name ?></strong></h5>
											</div>
											<div class="col-6">
												<h5>Insurance Type : <strong>

														<?php echo  $treatments->insurance_name ?>
													</strong></h5>
											</div>
											<div class="col-md-12">
												<table class="table table-bordered">
												<tr class="bg-light">
													<td class="text-bold"><h4><strong>Total</strong></h4></td>
													<td class="text-bolder text-right"><?php echo number_format($treatments->total)  ?> QAR</td>
												</tr>
												<tr>
												<td class="text-bold">Total Discount</td>
												<td class="text-bolder text-right"><?php echo round($treatments->discount + $cashier_discount + $company_discount_qar + $category_discount_qar +$coupon_discount + $points_discount) ?> QAR 
												<a class="btn " id="show-discounts-btn"><i class="fa fa-angle-down"></i></a>
												</td>
											</tr>
											
																						<tbody id="discount-details" style="display: none;">
															<tr>
																<td class="text-bold">Doctor Discount</td>
																<td class="text-bolder text-right"><?php echo number_format($treatments->discount) ?></td>
															</tr>
															<tr>
																<td class="text-bold">Cashier Discount</td>
																<td class="text-bolder text-right"><?php echo number_format($cashier_discount, 2) ?></td>
															</tr>

															<?php if ($coupon_discount > 0) { ?>
																<tr>
																	<td class="text-bold">Coupon</td>
																	<td class="text-bolder text-right"><?php echo  number_format($coupon_discount, 0)  ?></td>
																</tr>
															<?php } ?>

															<?php if ($treatments->company_discount != '') { ?>
																<tr>
																	<td class="text-bold">Company Discount</td>
																	<td class="text-bolder text-right"><?php echo number_format($company_discount_qar, 2) . '(' . number_format($treatments->company_discount_p, 0) . '%)' ?></td>
																</tr>
															<?php } ?>

															<?php if ($treatments->category_discount != '') { ?>
																<tr>
																	<td class="text-bold">Category Discount</td>
																	<td class="text-bolder text-right"><?php echo number_format($category_discount_qar, 2) . '(' . $treatments->category_discount_p . '%)' ?></td>
																</tr>
															<?php } ?>
															<?php if ($points_discount > 0) { ?>
																<tr>
																	<td class="text-bold">Loyalty Points</td>
																	<td class="text-bolder text-right"><?php echo  number_format($points_discount, 0)  ?></td>
																</tr>
															<?php } ?>
													</tbody>
													<tr>
													<td class="text-bold">Net Total</td>
													<td class="text-bolder text-right" id="net_total"><?php echo $netTotal  ?></td>
												</tr>
												<tr>
													<td class="text-bold">Total Paid</td>
													<td class="text-bolder text-right"><?php echo round($paid_amount)  ?></td>
												</tr>
												
												<tr class="bg-light">
													<td class="text-bolder"><h4><strong>Balance</strong></h4></td>
													<td class="text-bolder text-right" id="balance"><?php echo $balance  ?></td>
												</tr>
												</table>
											</div>
			

										</div>
									</div>
								</div>
							</div>
							<div class="box-body">
								<ul class="nav nav-tabs" id="reciptTable" role="tablist">
									<li class="nav-item">
										<a class="nav-link font-weight-bold active" id="recipts-tab" data-toggle="tab" href="#recipts" role="tab" aria-controls="recipts" aria-selected="true">Receipts</a>
									</li>
									<?php if ($treatments->insurance_type > 1) : ?>
										<li class="nav-item">
											<a class="nav-link font-weight-bold" id="insurances-tab" data-toggle="tab" href="#insurances" role="tab" aria-controls="insurances" aria-selected="false">Insurance</a>
										</li>
									<?php endif; ?>
								</ul>
								<div class="tab-content" id="myTabContent">
									<div class="tab-pane fade show active" id="recipts" role="tabpanel" aria-labelledby="recipts-tab">
										<?php require_once(APPPATH . "views/admin/Payments/Tabs/Receipts.php"); ?>
									</div>
									<?php if ($treatments->insurance_type > 1) : ?>
										<div class="tab-pane fade" id="insurances" role="tabpanel" aria-labelledby="insurances-tab">
											<?php require_once(APPPATH . "views/admin/Payments/Tabs/InsuranceRecipts.php"); ?>
										</div>
									<?php endif; ?>
									<div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!--tables-->

		</section>
		<input type="hidden" id="_id" name="_id" value="<?php echo $_id; ?>">
								
		</form>
		<div class="modal fade" id="PaymentLinkModal" tabindex="-1" role="dialog" aria-labelledby="subscribeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="subscribeModalLabel">Send Payment Link</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="subscribeForm" method="POST" >
        <div class="modal-body">
          <div class="form-group">
            <label for="messagesCount">Amount</label>
            <input type="number" class="form-control" id="amount" name="amount" placeholder="Enter Amount In QAR" required>
            <input type="hidden" id="payment_id" name="payment_id" value="<?= $treatments->treatement_payment_id ?>">
			<input type="hidden" id="patient_id" value="<?= $treatments->patient_id ?>">
          
         
          </div>
		  <div class="form-group form-check">
			<label class="form-check-label d-block">
			<input class="form-check-input" type="checkbox" name="remember" >Send Whatsapp
			
			</label>
		
		<label class="form-check-label">
			<input class="form-check-input" type="checkbox" name="remember" checked>Send SMS
			
			</label>
		
		</div>
		
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-dismiss="modal"><i class="fa fa-close mr-1"></i>Close</button>
          <button type="submit" class="btn btn-light"><i class="fa fa-send mr-1"></i> Send Link</button>
        </div>
      </form>
    </div>
  </div>
</div>
	</div>

	<!-- ./wrapper -->


	<?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>

<script>

</script>

<script>
$(document).ready(function () {
    $('#show-discounts-btn').on('click', function () {
        var discountDetails = $('#discount-details');

        // Toggle visibility of discount details
        if (discountDetails.is(':visible')) {
            discountDetails.fadeOut();
            $(this).html('<i class="fa fa-angle-down"></i>'); // Update button text
        } else {
            discountDetails.fadeIn();
            $(this).html('<i class="fa fa-angle-up"></i>'); // Update button text
        }
    });
});

$('#subscribeForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        var form = $(this);
        var amount = $('#amount').val();
        var payment_id = $('#payment_id').val();
        var patient_id = $('#patient_id').val();
        

        // Construct the payment gateway URL
        var paymentUrl = "<?php echo base_url('admin/SkipCash/PaymentController/send_payment_link') ?>";
        var formData = {
            amount: amount,
            payment_id: payment_id,
            patient_id: patient_id,
     
        };

        // Open the payment gateway URL in a new window
        $.ajax({
            url: paymentUrl,
            type: 'POST',
            data: formData,
			dataType: 'json', 
            success: function(response) {
                // Handle the response from the server
				
                console.log(response.status);
				$('#PaymentLinkModal').modal('hide')
                // Optionally, redirect to a different page or show a success message
				if(response.status==true){
					successNotification('Payment link sent successfully.');
					form[0].reset();
				}else{
					errorNotification('An error occurred while sending the payment link.');
				}
              
            },
            error: function(xhr, status, error) {
                // Handle any errors
                console.error(error);
                errorNotification('An error occurred while sending the payment link.');
            }
        });
  
    });



	function calculateTotal() {
		var baseTotal = parseFloat($('#net_total').html()) || 0;
		var discount = parseFloat($('#discount_ins').val()) || 0;
		var discountPer = parseFloat($('#discount_per_ins').val()) || 0;
		var coPayment = parseFloat($('#co_payment_ins').val()) || 0;
		var coPaymentPer = parseFloat($('#co_payment_per_ins').val()) || 0;
		var excess = parseFloat($('#excess_ins').val()) || 0;

		var discount_val = discount;
		var coPayment_val = coPayment;

		var total = baseTotal - discount_val - coPayment_val - excess;

		$('#total_ins').val(total.toFixed(2));
	}


	function updateDiscountAmount() {
		var baseTotal = parseFloat($('#net_total').html()) || 0;
		var discountPer = parseFloat(document.getElementById('discount_per_ins').value) || 0;

		var discount = (discountPer / 100) * baseTotal;

		document.getElementById('discount_ins').value = discount.toFixed(2);

		// calculateTotal();
	}

	function updateDiscountPercentage() {
		var baseTotal = parseFloat($('#net_total').html()) || 0;
		var discount = parseFloat(document.getElementById('discount_ins').value) || 0;

		var discountPer = (discount / baseTotal) * 100;

		document.getElementById('discount_per_ins').value = discountPer.toFixed(2);

		// calculateTotal();
	}

	function updateCopaymentAmount() {
		var baseTotal = parseFloat($('#net_total').html()) || 0;
		var co_payment_per_ins = parseFloat(document.getElementById('co_payment_per_ins').value) || 0;

		var co_payment_per = (co_payment_per_ins / 100) * baseTotal;

		document.getElementById('co_payment_ins').value = co_payment_per.toFixed(2);

		// calculateTotal();
	}

	function updateCopaymentPercentage() {

		var baseTotal = parseFloat($('#net_total').html()) || 0;
		var co_payment_ins = parseFloat(document.getElementById('co_payment_ins').value) || 0;

		var co_payment_per = (co_payment_ins / baseTotal) * 100;

		document.getElementById('co_payment_per_ins').value = co_payment_per.toFixed(2);

		// calculateTotal();
	}

	$('#discount_per_ins').on('input', updateDiscountAmount);
	$('#discount_ins').on('input', updateDiscountPercentage);
	$('#co_payment_per_ins').on('input', updateCopaymentAmount);
	$('#co_payment_ins').on('input', updateCopaymentPercentage);
	$('#discount_ins, #co_payment_ins, #discount_per_ins, #co_payment_per_ins, #excess_ins').on('input', calculateTotal);


	$('#payment_type').on('change', function(e) {
		visible_card();
	});

	$('.submit_btn').on('click', function(e) {
	     e.preventDefault();

    var $btn = $(this);
		var baseTotal = parseFloat($('#balance').text().replace(/,/g, '')) || 0;
		var payment_amount = parseFloat($('#payment_amount').val().replace(/,/g, '')) || 0;
		// var discount = parseFloat($('#discount').val().replace(/,/g, '')) || 0;
		// var total = payment_amount + discount;
		
		if (payment_amount > baseTotal) {
			errorNotification('Amount should be less than total balance');
			return;
		}else{
		      if ($btn.prop('disabled')) return;
    $btn.prop('disabled', true).text('Processing...');
			var form = $(this).closest('form');
		form.submit();
		}
		
	});

	$('.submit_btn_insurance').on('click', function(e) {
		var baseTotal = parseFloat($('#net_total').html().replace(/,/g, '')) || 0;
		var total_ins = parseFloat($('#total_ins').val().replace(/,/g, '')) || 0;
		var total = payment_amount + total_ins;
		//
		if (baseTotal < total) {
			// errorNotification('Net Amount should be less than total balance');
			// return;
		}
		var form = $(this).closest('form');
		form.submit();
	});

	function visible_card() {
		var type = $('#payment_type').val();
		//
		if (type == '3') {
			$('#card_amount').removeClass('hide')
			$('#discount_for_content').removeClass('hide')

		} else {
			$('#card_amount').addClass('hide')
			$('#discount_for_content').addClass('hide')
		}
	}

	
</script>