<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">Transaction Report</h4>
                </div>
                <form  method="post" id="transaction_report">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Select Pyment Type</label>
                          <select class="form-control" id="request">
                          <option value="2">All</option>
                            <?php if(isset($payment_methods) AND $payment_methods != NULL){ foreach($payment_methods as $val){ ?>
                                <option value="<?php echo $val['type_id']; ?>"><?php echo $val['type_name']; ?></option>
                            <?php }} ?>
                          </select>
                        </div>
						</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
							</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
						</div>
                     
                    </div>
                    
                    <button type="reset" class="btn btn-dark  hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="p_report" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>

<script>

     $(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#p_report').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Transaction Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Transaction Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/get_transaction_list'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.request = $('#request').val();
					d.from = $('#from').val();
					d.to = $('#to').val();
				}
			},
			'columns': [{
					'data': 'sell_bill_id',
					'title': 'Ref #'
				},
				{
					'data': 'full_name',
					'title': 'Cashier'
				},
				{
					'data': 'sell_date',
					'title': 'Date.'
				},
				{
					'data': 'amount',
					'title': 'Amount.'
				},
				{
					'data': 'type',
					'title': 'Payment Method'
				},
				
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#request, #from,#to ').on('change', function() {
			dataTable.ajax.reload();
		});
        $('#clear').on('click', function() {
            $('#transaction_report').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>