<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>POS</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <!--image crop-->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>


    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/jquery.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/buttons.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">

    <?php require_once(APPPATH . "views/admin/header.php"); ?>
    <style>
        .small-box {
            text-decoration: none;
            color: #444444;
            transition-timing-function: ease-in-out;
            cursor: pointer;
        }

        .small-box:hover {
            text-decoration: none;
            color: #084a6ad9;
        }

        .small-box {
            box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
        }

        .inner {
            height: 120px;
        }

        .dashboard_icon {
            color: #084a6a;
            font-size: 50px;
        }

        .DTED_Lightbox_Content {
            border: none !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Header {
            background-color: #084a6a !important;
            color: white;
            height: 58px !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Footer {
            background-color: none !important;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
            <section class="content-header">
            <h1><a href="<?php echo base_url('index.php/admin/Pharmacy/PharmacyController') ?>" class="btn btn-sm btn-dark"><i class="fa fa-angle-left"></i> Back</a>
                &nbsp;<strong>Pharmacy </strong><small>- POS</small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        
        </section>

        <section class="content">
            <div class="box box-info">

                <div class="box-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel panel-default">
                                <?php echo $msg; ?>
                                <div class="panel-header">
                                    <div class="col-md-12" style="color: black;">

                                        <div class="row">
                                            <div class="col-md-5">
                                        <!-- <br><label>Choose:</label>
                                        <input class="form-control" type="text" id="prescription_choose" placeholder="Enter Patient Name / File Number">
                                    </div>
                                    <div class="col-md-3">
                                        <label>&nbsp;</label><br><br>
                                        <button type="button" class="btn btn-info" id="build_prescription">Build bill from Internal Prescription</button>
                                    </div> -->
                                            <br>
                                            <div class="col-md-5">
                                                <label>&nbsp;</label>
                                                <!-- <button type="button" class="btn btn-primary" id="pres_list">Prescription List</button> -->

                                                <div class="btn-group">
                                                    <form id="add_prescription">
                                                        <button type="button" class="btn btn-dark dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                            Prescription List <span class="caret"></span>
                                                        </button>
                                                        <?php
                                                        $date_today = date('Y-m-d');
                                                        $yesterday = date('Y-m-d', strtotime($date_today . ' -1 day'));
                                                        $query = $this->db->query("SELECT * FROM tbl_prescription_main
                                                LEFT JOIN tbl_patients ON tbl_prescription_main.patient_id=tbl_patients.patient_id
                                                WHERE enter_date BETWEEN '$yesterday' AND '$date_today' AND status=1 ORDER BY prescription_main_id DESC");
                                                        $result = $query->result_array(); ?>
                                                        <?php if (count($result) > 0) { ?>
                                                            <ul class="dropdown-menu">
                                                                <?php foreach ($result as $value) {
                                                                    echo "<li class='dropdown-item text-wrap' onclick='build_pres(" . '"' . $value['patient_name'] . '"' . "," . $value['prescription_main_id'] . "," . $value['patient_id'] . ")'><a href='#'>" . $value['patient_id'] . " - " . $value['patient_name'] . " - " . $value['enter_date'] . "</a></li>";
                                                                } ?>
                                                            </ul>
                                                        <?php } ?>

                                                    </form>
                                                </div>
                                                <br>
                                                <br>
                                                <p>OR</p>
                                                <form id="add_item">
                                                    <label>Choose an item:</label>
                                                    <input class="form-control" name="item" type="text" id="item_choose" placeholder="Enter Code Number or Item Name"><br>
                                                    <button type="submit" class="btn btn-sm btn-dark">
                                                        <i class="ri-add-line"></i>Add</button>
                                                    <br><br>
                                                </form>
                                            </div>
                                            <div class="col-md-6" id='pres_drugs_table'>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="panel-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-bordered table-hover w-100" id="dataTables-employee">
                                            <thead>
                                                <tr>
                                                    <th>No</th>
                                                    <th>Item Name</th>
                                                    <th>Expiry Date</th>
                                                    <th>Quantity</th>
                                                    <th>Original Price</th>
                                                    <th>Discount</th>
                                                    <th>Discount %</th>
                                                    <th>Sell Price</th>
                                                    <th>Total Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody">
                                            </tbody>
                                            <tfoot id="tfoot">
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <form id="receive_form" method="post" action="<?php echo site_url("admin/Pharmacy/PharmacyController/POS"); ?>">
                        <div class="row">
                            <div class="col-md-6">
                            <div class="col-md-6">
                                <label>Patient:</label>
                                <p id="patient">Cash</p>
                            </div>
                            <div class="col-md-6">
                                <label>Doctor:</label><br>
                                <select id="doctor_id" name="doctor_id" class="form-control">
                                    <?php
                                    $query = $this->db->query("SELECT * from tbl_employees LEFT JOIN tbl_users ON tbl_employees.user_id = tbl_users.user_id");
                                    $result =  $query->result_array();
                                    foreach ($result as $value) {
                                        echo "<option value='" . $value['user_Id'] . "'>" . $value['full_name'] . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label>Percentage:</label><br>
                                        <input type="text" name="percentage" id="percentage" class="form-control">
                                    </div>

                                    <div class="col-md-6">
                                        <label>Total Amount:</label><br>
                                        <input type="text" name="total_amount" id="total" readonly class="form-control">
                                    </div>

                              
                           
                            
                                    <div class="col-md-6">
                                        <label>Bill Date:</label><br>
                                        <input type="text" name="bill_date" id="bill_date" class="ex-date form-control" value="<?php echo date('d/m/Y'); ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <label>Payment Method:</label><br>
                                        <select id="payment_select" class="form-control" name="type">
                                            <option value="cash">Cash</option>
                                            <option value="card">Card</option>
                                            <option value="check">Check</option>
                                            <option value="cash_card">Cash & Card</option>
                                            <option value="loan">Loan</option>
                                        </select>
                                    </div>

                          
                            <div class="col-md-6">
                            <label>Received Amount:</label><br>
                                <input type="text" name="paid_amount" id="paid_amount" class="option1 form-control">
                                <input type="hidden" name="pres" id="pres">
                                <div class="option2" style="display: none">
                                    <input type="text" name="paid_cash" id="paid_cash" placeholder="cash" class="form-control">
                                    <input type="text" name="paid_card" id="paid_card" placeholder="card" class="form-control">
                                </div>
                               
                            </div>
                            <div class="col-md-12 pe-3 mb-3">
                                <input type="hidden" name="print" value="0" id="print_input">
                            <button type="button" class="btn btn-dark mt-3 float-right" id="received_payment">Receive Payment</button> &nbsp;
                            <button type="button" class="btn btn-warning mt-3 mr-2 float-right" id="received_payment_print">Receive Payment & print</button>
                            </div>

                            </div>
                            </div>

                           

                            <!-- </form> -->
                        </div>
                </div>
                <!-- /.box-body -->
            </div>

        </section>


        </form>

    </div>

    <!-- ./wrapper -->


    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
    <script src="<?php echo base_url('js/Services/Pharmacy/posBill.js') ?>" type="text/javascript"></script>


</body>
<script>
    <?php
    function category_list()
    {
        $CI = &get_instance();
        $query = $CI->db->query("SELECT category_id as value,category_name as label FROM sh_category");
        $result =  $query->result_array();

        return json_encode($result);
    }

    function location_list()
    {
        $CI = &get_instance();
        $query = $CI->db->query("SELECT location_id as value,location_name as label FROM sh_locations");
        $result =  $query->result_array();

        return json_encode($result);
    }

    function brand_list()
    {
        $CI = &get_instance();
        $query = $CI->db->query("SELECT brand_id as value, brand_name as label FROM sh_brand");
        $result =  $query->result_array();

        return json_encode($result);
    }
    ?>

    /*$('#receive_form').one('submit', function() {
            alert('hi');
            $(this).find('input[type="button"]').attr('disabled','disabled');
        });*/

    $(".ex-date").datepicker({
        // minDate: new Date(),
        // dateFormat: "yyyy-mm-dd"
        dateFormat: "dd/mm/yyyy"
    });

    $('#payment_select').change(function() {
        if (this.value == "cash_card") {
            $('.option1').hide();
            $('.option2').show();
        } else {
            $('.option1').show();
            $('.option2').hide();
        }
    });

    $('#received_payment').click(function(event) {
        $("#print_input").val('0');
        if ($('#payment_select').val() == "cash_card") {
            if ($('#paid_cash').val() == "") {
                alert('Input cash amount');
                return false;
            }
            if ($('#paid_card').val() == "") {
                alert('Input card amount');
                return false;
            }
        } else {
            if ($('#paid_amount').val() == "") {
                alert('Input amount');
                return false;
            }
        }

        $('#receive_form').submit();
    });
    $('#received_payment_print').click(function(event) {
        $("#print_input").val('1');
        if ($('#payment_select').val() == "cash_card") {
            if ($('#paid_cash').val() == "") {
                alert('Input cash amount');
                return false;
            }
            if ($('#paid_card').val() == "") {
                alert('Input card amount');
                return false;
            }
        } else {
            if ($('#paid_amount').val() == "") {
                alert('Input amount');
                return false;
            }
        }

        $('#receive_form').submit();
    });

    $('#build_prescription').click(function(event) {
        var temp = $('#prescription_choose').val().split(" ||| ");

        $.ajax({
            url: "<?php $this->load->helper('url');
                    echo site_url('treatment/treatment_process/get_illness'); ?>",
            type: 'post',
            data: {
                patient_id: temp[1],
                pres_id: temp[0]
            },
            success: function(result) {
                var result = $.parseJSON(result);

                if (result.illness != null) {
                    var illness = result.illness.split("-");
                } else {
                    var illness = '';
                }
                var allergy = result.any_allergies;
                var table = result.table;
                var ill = ' ';
                var all = ' ';
                for (x = 0; x < illness.length - 1; x++) {
                    var index = illness[x].charCodeAt() - 97;
                    var arr = ["Phychiatric illness", "Heart Problems", "High or Low Blood Pressure", "Epilepsy / Blackouts", "Diabbetes", "Blood Disorders", "Anemia - sickle cell", "Thyroid Disease", "GI Bleed", "Acid Reflux", "Eye Disease", "Stomach or peptic ulcer", "Kidney Disease", "Asthma", "Allergy", "Lupus, Arthritis", "Tuberculosis", "Hepatitis"];
                    ill += arr[index] + "<br>";
                }
                if (allergy == "Yes") {
                    if (result.antibiotics) {
                        all += result.antibiotics + '<br>';
                    }
                    if (result.anesthetic) {
                        all += result.anesthetic + '<br>';
                    }
                    if (result.latex) {
                        all += result.latex + '<br>';
                    }
                    if (result.dye) {
                        all += result.dye + '<br>';
                    }
                    if (result.other_allergy) {
                        all += result.other_allergy + '<br>';
                    }
                }
                if (ill == ' ') {
                    ill = "None";
                }
                if (all == ' ') {
                    all = "None";
                }
                $('#illness_pharma').html(ill);
                $('#allergy_pharma').html(all);
                $('#pres_pharma').html(table);

                $('#app_poppup_illness_allergy').modal({
                    keyboard: false
                });


            },
        });

        $('#add_prescription').submit();
    });


    $('#pres_list').click(function() {
        $('#pres_poppup').modal();
    });

    $('.app_date').datepicker({
        dateFormat: 'yyyy-mm-dd',
        showTrigger: '#calImg',
        minDate: new Date(2014, 1 - 1, 1),
        maxDate: new Date(2030, 12 - 1, 31),
        yearRange: '2014:2050'
    });

    function select_item(num) {
        var text = $('#' + num + '_text').text();
        var element = $('#item_choose');
        $(element).val(text).autocomplete("search");;
    };

    // $('#search_pres').click(function(){
    // var doc_id = $('#doctor_id_pres').val();
    // var date_from = $('date_from_pres').val();
    // var date_to = $('date_to_pres').val();

    // alert('');
    // });
    function build_pres(patient_name, id, p_id) {
        var temp = id + ' ||| ' + p_id;
        //$('#prescription_choose').val(temp);
        //$('#build_prescription').trigger("click");
        $('#item_choose').val('');

        patient = $("<input>").attr({
            "type": "hidden",
            "name": "patient"
        }).val(p_id);
        pres = $("<input>").attr({
            "type": "hidden",
            "name": "pres"
        }).val(id);

        $("#patient").html(patient_name);
        $('#receive_form').append(patient);
        $('#receive_form').append(pres);

        $.ajax({
            url: "<?php $this->load->helper('url');
                    echo site_url('admin/Pharmacy/PharmacyController/get_prescription'); ?>",
            dataType: "html",
            beforeSend: function() {
                // var img = '<div class="loading"><img class="loading-img" src="<?php echo IMG . "/loading.gif"; ?>"></div>';
                // $('#pres_drugs_table').html(img);
            },
            data: {
                patient_id: p_id,
                pres_id: id
            },
            success: function(data) {
                
                 data = JSON.parse(data);
                console.log(data.length);
                for (var i = 0; i < data.length; i++) {
                    add_prescription_item(data[i]);
                    // $("#choose_form").append("<option value=\"" + data[i] + "\" class=\"removable\">" + data[i] + "</option>");
                }
            }
        });
    }
    function add_prescription_item(item) {
    var item_array = item.split(" ||| "),
            item_id = item_array[0],
            item_name = item_array[1],
            bills_id = item_array[2],
            batch = item_array[3],
            x_date = item_array[4],
            qty = item_array[5],
            price = item_array[6];
    $("#tbody").append("<tr id=\"" + item_id + "-" + batch + "-" + bills_id + "-" + "1" + "-" + item_name + "\">"
            + "<td><form class=\"remove_row\">"
            + "<input type=\"hidden\" name=\"row_id\" value=\"" + item_id + "-" + batch + "\">"
            + "<button type=\"button\" onClick=\"$(this).closest('tr').remove();\" class=\"btn btn-sm btn-danger\"><span class=\"glyphicon glyphicon-minus-sign\"></span></button>"
            + "</form></td>"
            + "<td>" + item_name + "</td>"
            // + "<td>" + batch + "</td>"
            + "<td>" + x_date + "</td>"
            + "<td>"
            + "<input id=\"q" + item_id + "-" + batch + "\" type=\"text\" value=\"" + qty + "\" class=\"quantity\">"
            + "</td>"
            + "<td id=\"p" + item_id + "-" + batch + "\">" + price + "</td>"
            + "<td>"
            + "<input class=\"discount\" type=\"text\">"
            + "</td>"
            + "<td>"
            + "<input class=\"discount_per\" type=\"text\">"
            + "</td>"
            + "<td id=\"s" + item_id + "-" + batch + "\">" + price + "</td>"
            + "<td id=\"t" + item_id + "-" + batch + "\">" + Number(Number(price) * Number(qty)) + "</td>"
            + "</tr>");
    if ($("#total").length) {
        $("#total").html(Number($("#total").html()) + Number(Number(price) * Number(qty)));
        $("#paid_amount").val(Number($("#total").html()) + Number(Number(price) * Number(qty)));
    }
    else {
        $("#tfoot").append("<tr><th colspan=\"7\">Net Total:</th><th id=\"total\">" + Number(Number(price) * Number(qty)) + "</th></tr>");
        $("#paid_amount").val(Number(Number(price) * Number(qty)));

    }
    $("#prescription_choose").val("");
}


    jQuery(function() {
        $("#receive_form").submit(function() {
            // submit more than once return false
            $(this).submit(function() {
                return false;
            });
            // submit once return true
            return true;
        });
    });
</script>

</script>

</html>