<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>POS</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <!--image crop-->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/jquery.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/buttons.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">

    <?php require_once(APPPATH . "views/admin/header.php"); ?>
    <style>
        .small-box {
            text-decoration: none;
            color: #444444;
            transition-timing-function: ease-in-out;
            cursor: pointer;
        }

        .small-box:hover {
            text-decoration: none;
            color: #084a6ad9;
        }

        .small-box {
            box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
        }

        .inner {
            height: 120px;
        }

        .dashboard_icon {
            color: #084a6a;
            font-size: 50px;
        }

        .DTED_Lightbox_Content {
            border: none !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Header {
            background-color: #084a6a !important;
            color: white;
            height: 58px !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Footer {
            background-color: none !important;
        }

        .return_choose {
            width: 100%;
            zoom: 2;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><a href="<?php echo base_url('index.php/admin/Pharmacy/PharmacyController') ?>" class="btn btn-sm btn-dark"><i class="fa fa-angle-left"></i> Back</a>
                &nbsp;<strong>Pharmacy </strong><small>- POS</small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>

        </section>

        <section class="content">
            <div class="box box-info">
                <div class="box-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group form-inline">
                                <input class="form-control" type="text" name="search_drug" id="search_drug" placeholder="Type Drug name or Drug Code" size="60">
                                <button type="button" class="ml-2 btn btn-sm btn-dark" id="search">Search<span class="glyphicon glyphicon-search"></span></button>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <span id="search_drug_name"></span>
                        </div>
                    </div>



                    <form action="<?php  echo site_url('admin/Pharmacy/PharmacyController/insert_return_items'); ?>" method="post" id="item_remove_form" style="display:none" >
                        <div class="row">
                            <div class="col-md-12">
                                <div class="box box-warning">
                                    <div class="box-body">
                                        <div class="box-header with-border">
                                            <h3 class="box-title"><i class="ri-wallet-line"></i>Items to Return</h3>
                                            </div>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered table-hover" id="items_to_return_table">
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th>Item Code</th>
                                                        <th>Item Name</th>
                                                        <th>Batch</th>
                                                        <th>Expiry Date</th>
                                                        <th width="10%">Price</th>
                                                        <th width="10%">Quantity</th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <button type="submit" class="btn btn-dark pull-right">Save</button>
                                </div>
                            </div>
                        </div>
                    </form>

       
            </div>
            <div class="box box-primary">
            <div class="row">
                <div class="col-md-12">
                <div class="panel panel-primary">
                    <div class="panel-heading p-3">
                    <h3 class="panel-title">Purchase Return List</h3>
                    </div>
                    <div class="panel-body">
                    <?php if ($purchase_return != FALSE) { ?>
                        <!-- User table -->
                        <div class="panel-body" style="background-color:#fff;">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Date</th>
                                        <th>Employee</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    foreach($purchase_return as $row){
                                    ?>
                                    <tr>
                                        <td><?=$row['return_stock_id']?></td>
                                        <td><?=$row['return_date']?></td>
                                        <td><?=$row['full_name']?></td>
                                        <td>
                                        <button class="btn btn-light btn-xs" id="view" onclick="window.location.href='<?php $this->load->helper('url');  echo site_url('admin/Pharmacy/PharmacyController/purchase_return/'.$row['return_stock_id']);?>'">
                                            <i class="fa fa-eye"></i>
                                        </button>

                                        <a class="btn btn-danger btn-xs" role="button" onclick="delete_bill(<?php echo $row['return_stock_id'] ?>)"><i class="fa fa-trash-o text-light"></i></a>
                                        </td>
                                    </tr>
                                    <?php 
                                    } 
                                    ?>                          
                                </tbody>
                            </table>                           
                        </div>
                        </div>
                    <?php }else{?>
                        <div class="alert alert-danger" role="alert"> Records is not exist</div>
                    <?php } ?>
                    </div>
                </div>
                </div>
          </div>
        </div>
            </div>
    </div>
    </div>
    </section>


    </form>

    </div>

    <!-- ./wrapper -->


    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>
<script>
    $('#search').on('click', function(e) {
        $.ajax({
            type: "POST",
            url: "search_drug_items",
            data: {
                search_data: $("input[name=search_drug]").val()
            },
            cache: false,
            success: function(result) {

                $("#search_drug_name").html(result);

            }
        });

        $('#search_drug').val('');

    });

    $('body').on('click', ".add_item", function() {
        
        var item = this.value.split("||");

        var content = '<tr>\
                        <td><button type="button" class="btn btn-sm btn-dark remove_row"><i class="ri-delete-bin-line"></i></button></td>\
                        <td>' + item[0] + '</td>\
                        <td>' + item[1] + '</td>\
                        <td>' + item[2] + '</td>\
                        <td>' + item[3] + '</td>\
                        <td>' + item[4] + '</td>\
                        <td><input type="number" min="1" class="form-control" name="drug_qty[]" value="1"><input type="hidden" name="drug_id[]" value="' + item[0] + '"><input type="hidden" name="bill_id[]" value="' + item[5] + '"><input type="hidden" name="batch[]" value="' + item[2] + '"><input type="hidden" name="drug_cost[]" value="' + item[4] + '"></td>\
                      </tr>';

        $('#items_to_return_table tbody').append(content);

        $('#search_drug').val('');
        $('#search_drug_name').html('');
        $("#item_remove_form").fadeIn();

    });

    $('body').on("click", ".remove_row", function(e) { //user click on remove text
        $(this).closest('tr').remove();
        return false;
    })
    
    $('#dataTables-example').dataTable({"order": [[ 0, "desc" ]]});
    function delete_bill(id)
        {
            confirmDelete(function(){
                $.ajax({
                    url : "<?php echo base_url(); ?>index.php/admin/Pharmacy/PharmacyController/delete_purchase_return/" +id,
                    type: "POST",
                    dataType: "JSON",
                    success: function(data)
                    {
                        //if success reload ajax table
                        // $('#modal_form').modal('hide');
                        
                        successNotification('Purchase Statement Deleted');
                        window.location.reload();
                    },
                    error: function (jqXHR, textStatus, errorThrown)
                    {
                        alert('Error deleting data');
                    }
                });
            })
            
                // ajax delete data to database
              

            
        }
</script>

</html>