<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Queue Display</title>
    <!-- Include Socket.io client library -->
    <script src="<?php echo NODE_SERVER_URL ?>/socket.io/socket.io.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/css/bootstrap.min.css" integrity="sha512-jnSuA4Ss2PkkikSOLtYs8BlYIeeIK1h99ty4YfvRPAlzr377vr3CXDb7sb7eEEBYjDtcYj+AjBH3FLv5uSJuXg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo base_url('css/queue.css') ?>" />
    <script src="https://code.responsivevoice.org/responsivevoice.js?key=lgfR4noJ"></script>
</head>
<body>

    <div class="contianer-fluid height ">
        <div class="row bg-p  header p-1">
            <div class="col-md-2 d-flex align-items-center">
               <img src="<?php echo base_url('images/hmate_white.png')  ?>" class="img-fluid" width="90px" alt="">
             
            </div>
            <div class="col-md-8 d-flex align-items-center justify-content-center">
                <h2 class="text-white clinic_name" >Welcome To <?php echo $company->company_name ?></h2>
            </div>
           
            <div class="col-md-2 ">
            <a class="weatherwidget-io" href="https://forecast7.com/en/25d3551d18/qatar/" data-mode="Current" data-days="3" data-theme="pure" data-basecolor="" data-textcolor="#ffffff" data-suncolor="#ffffff" data-mooncolor="#ffffff" data-cloudcolor="#ffffff" >QATAR WEATHER</a>
            <p id="date_time" class="text-center text-white"></p>  
        </div>
          

        </div>
        <div class="row h-90">
        <div class="col-md-7 d-flex justify-content-center flex-column align-items-center">
              <div class="video-box height">
                <video src="<?php echo $config->video ?? ''  ?>" id="video" controls class="img-fluid object-fit-cover height" autoplay="1" loop></video>
              </div>
                
            </div>
            <div class="col-md-5 list-container">
             
                <div class="col-md-12 ">
                <ul id="queueList">
        <!-- Queue numbers will be dynamically added here -->
            </ul>
                </div>
          
            </div>
            
        </div>

    <footer class="footer bg-p">
        
        <marquee  direction="left" class="text-white promotion_text" id="marque"><?php echo $config->promotion ?? ''  ?></marquee>
    </footer>
    </div>
    <audio src="<?php echo base_url(''.UPLOAD_PATH.'bell.mp3') ?>" id="bellSound" ></audio>
    
   
   
    <button onclick="toggleFullScreen()" class="btn-fullscreen"><i class="fa fa-expand icon-fullscreen"></i></button>
    <script>
       
       function updateScrollSpeed() {
    const list = document.querySelector('.scrolling'); // The scrolling container
const items = document.querySelectorAll('.scrolling li'); // The items in the list
  
    const listHeight = list.offsetHeight;
    const itemsHeight = Array.from(items).reduce((sum, item) => sum + item.offsetHeight, 0);
        console.log('list_hiehg' + listHeight + ' | ' + itemsHeight)
    if (itemsHeight < listHeight) {
        const animationDuration = (itemsHeight / 90); // Adjust 50 for desired speed factor
        list.style.animationDuration = `${animationDuration}s`;
    } else {
        list.style.animationDuration = '35s'; // No animation if items fit in the container
    }
}
window.addEventListener('resize', updateScrollSpeed);

            function duplicateItems() {
                const list = document.getElementById('queueList');
                const items = Array.from(list.children);

                items.forEach(item => {
                    const clone = item.cloneNode(true);
                    list.appendChild(clone);
                });
            }

            function checkHeight() {
                const listContainer = document.querySelector('.list-container');
                const list = document.getElementById('queueList');
                const delay = 300; // Delay in milliseconds

                setTimeout(() => {
                    console.log('List scrollHeight:', list.scrollHeight);
                    console.log('Container clientHeight:', listContainer.clientHeight);
                    if (list.scrollHeight > listContainer.clientHeight) {
                        list.classList.add('scrolling');
                        updateScrollSpeed
                    } else {
                        list.classList.remove('scrolling');
                    }
                }, delay);
            }

            // duplicateItems();
            
       
    </script>
    <script>
        // Connect to the Socket.io server
        const socket = io('<?php echo NODE_SERVER_URL ?>');
        var voice_enable = <?php echo $config->voice_enable ?>;
        socket.on('config_updated', (data) => {
            console.log('Config updated', data);
            updateConfigView(data);
        });
        function updateConfigView(config) {
            // const configDiv = document.getElementById('current-config');
            // configDiv.innerHTML = '';
            console.log('updated config');
            if (config.promotion) {
                if(isArabic(config.promotion)){
                    document.getElementById('marque').setAttribute('direction','right')
                    document.getElementById('marque').innerText=config.promotion
                }else{
                    document.getElementById('marque').setAttribute('direction','left')
                    document.getElementById('marque').innerText=config.promotion
                }
              
            }
            if(config.video){
                document.getElementById('video').src=config.video;
            }
            if(config.voice_enable){

               voice_enable=config.voice_enable;
            }
            // if(config.display){
            //     if(config.display == 'd2'){
            //   window.location.reload();
            //     }else{
            //         window.location.reload();
            //     }
            // }
           
        }

        
        socket.emit('queueUpdate');
        // Listen for 'queueUpdate' events from server
        socket.on('queueUpdate', function(data) {
            const queueList = document.getElementById('queueList');
            const newQueueItems = data.queue; // Clear previous list
       
            checkHeight();

            // Add each queue number to the list
            newQueueItems.forEach(item => {
                var status="";
                var class_name="";
                var processing;
                var text_color= 'text-white'
            if(item.status == 11){
                status ="Calling";
                class_name="badge bg-danger";
            }
            if(item.status == 8){
                status ="Processing"
               
                class_name="badge bg-info";
                processing ='bg-processing';
                text_color="text-dark"
            }
            const uniqueClass = 'queueitem-' + item.id;
                const li = document.createElement('li');
                li.classList.add('queueitem-'+item.id);
                li.classList.add(processing);
                
                li.innerHTML = ` <span class="number">${item.number}</span> <span class="doctor_name `+text_color+`"> Dr. ${item.doctor_name}</span> <span class="${class_name}">${status}</span>`;
                queueList.appendChild(li);
              // Remove animation after 500ms
            });

         console.log('dfdf');
           
        });
        socket.on('queueNewNumber', (data) => {
            console.log(data);
            const queueList = document.getElementById('queueList');
            const newQueueItem = data.queue; // Assuming this is the new queue item object
            const bellSound = document.getElementById('bellSound');
            const uniqueClass = 'queueitem-' + newQueueItem.id;
            let existingItem = document.querySelector('.' + uniqueClass);
            // Add new queue item to the list
            const li = document.createElement('li');
            li.classList.add('queueitem-'+newQueueItem.id);
            var status="";
            var processing;
                var text_color= 'text-white'
            if(newQueueItem.status == 11){
                bellSound.play().catch(e => console.log(e));
                if(voice_enable ==1){
                    speak('Patient Number '+newQueueItem.number + '') ;
                }
               
                status ="Calling"
                class_name="badge bg-danger";
            }
            else if(newQueueItem.status == 8){
                status ="Processing"
                class_name="badge bg-info";
                processing ='bg-processing';
                text_color="text-dark"
            }else if(newQueueItem.status == 9){
                existingItem.remove();
                return;
            }
            else if(newQueueItem.status == 6){
                existingItem.remove();
                return;
            }


            if (existingItem) {
        // If the item already exists, play the sound and add animation to the existing item
        existingItem.innerHTML = `<span class="number"> ${newQueueItem.number}</span> <span class="doctor_name `+text_color+` "> Dr. ${newQueueItem.doctor_name} </span><span class="${class_name}">${status}</span>`;
        queueList.classList.remove('scrolling')
        existingItem.classList.add('animated');
        existingItem.classList.add(processing);
       
            setTimeout(() => {
                existingItem.classList.remove('animated');
                queueList.classList.add('scrolling');
    }, 10000);
      
    } else {
        // If the item does not exist, create a new one
        const li = document.createElement('li');
        li.classList.add(uniqueClass);
        li.innerHTML = `<span class="number"> ${newQueueItem.number}</span> <span class="doctor_name `+text_color+`"> Dr. ${newQueueItem.doctor_name}</span> <span class="${class_name}">${status}</span>`;
        queueList.prepend(li);

        li.classList.add('animated');
        queueList.classList.remove('scrolling')
        li.classList.add('animated');
        li.classList.add(processing);
       
            setTimeout(() => {
                li.classList.remove('animated');
                queueList.classList.add('scrolling');
    }, 10000);
       
    }
            
        });

        function toggleFullScreen() {
            const doc = window.document;
            const docEl = doc.documentElement;

            const requestFullScreen = docEl.requestFullscreen || docEl.mozRequestFullScreen || docEl.webkitRequestFullScreen || docEl.msRequestFullscreen;
            const cancelFullScreen = doc.exitFullscreen || doc.mozCancelFullScreen || doc.webkitExitFullscreen || doc.msExitFullscreen;

            if (!doc.fullscreenElement && !doc.mozFullScreenElement && !doc.webkitFullscreenElement && !doc.msFullscreenElement) {
                requestFullScreen.call(docEl);
            } else {
                cancelFullScreen.call(doc);
            }
        }
    </script>
       
     <script>
     
     let isSpeaking = false;

function speak(message) {
    if (!isSpeaking) {
        isSpeaking = true;
        responsiveVoice.speak(message, 'UK English Female', {
            onstart: function() {
                console.log('Speaking: ' + message);
            },
            onend: function() {
                console.log('Finished speaking: ' + message);
                isSpeaking = false;
                // Call next function or process here
            }
        });
    } else {
        // Wait until current speech ends and then speak the next message
        setTimeout(() => speak(message), 500); // Adjust timing as needed
    }
}   
function showCurrentDateTime() {
    // Create a new Date object
    const now = new Date();

    // Extract date components
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0'); // Months are zero-indexed
    const day = String(now.getDate()).padStart(2, '0');

    // Extract time components
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    const seconds = String(now.getSeconds()).padStart(2, '0');

    // Format the date and time as needed (example: yyyy-mm-dd hh:mm:ss)
    const dateTimeString = `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;

    // Display the formatted date and time
    document.getElementById('date_time').innerText= dateTimeString;
}

// Call the function to display current date and time
showCurrentDateTime();
var promotion=document.getElementById('marque').innerText;
    if(isArabic(promotion)){
        document.getElementById('marque').setAttribute('direction','right')
        document.getElementById('marque').innerText=promotion
    }
function isArabic(text) {
    var arabicPattern = /[\u0600-\u06FF\u0750-\u077F\u08A0-\u08FF]/;
    return arabicPattern.test(text);
}

function isEnglish(text) {
    var englishPattern = /^[A-Za-z0-9\s.,!?'"-]+$/;
    return englishPattern.test(text);
}
    </script>
 <script>
!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src='https://weatherwidget.io/js/widget.min.js';fjs.parentNode.insertBefore(js,fjs);}}(document,'script','weatherwidget-io-js');
</script>
</body>
</html>
