<?php
// Calculate other totals
$insurance = 0;
$cash = 0;
$card = 0;
$cashier_discount = 0;
$co_payment = 0;
$excess = 0;
foreach ($receipts as $key => $receipt) {
    $insurance += $receipt->insurance_amount;
    if($receipt->patient_payment_id == $patient_payment_id){
        $cash += $receipt->cash;
        $card += $receipt->card;
        $cashier_discount += $receipt->discount;
        $co_payment += $receipt->co_payment;
        $excess += $receipt->excess;
    }
}
$content = '<div class="zd0">
    <h1>INSURANCE RECEIPT / إيصال</h1>
</div>

<div class="zd0">
    <table class="ztbl0">
        <tbody>
            <tr>
                <td>
                    <strong>Insurance Type / نوع التأمين :</strong>
                    <span>' . $receiptHeader->insurance_name . '</span>
                </td>
                <td>
                    <strong>Date / تاريخ :</strong>
                    <span>' . date("l, Y-m-d") . '</span>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Receipt No. / رقم الإيصال. :</strong>
                    <span>RCP ' . $receiptHeader->patient_payment_id . '</span>
                </td>
                <td>
                    <strong>Patient / مريض :</strong>
                    <span>' . $receiptHeader->patient_name . ' - (' . $receiptHeader->patient_id . ')</span>
                </td>
            </tr>
            <td>
                <strong>Doctor / Nurse / طبيب / ممرضة :</strong>
                <span>' . $receiptHeader->doctor . '</span>
            </td>
            <td>
                <strong>Cashier / أمين الصندوق :</strong>
                <span>' . $receiptHeader->receptionist . '</span>
            </td>
            </tr>
        </tbody>
    </table>
</div>

<div class="zd0">
    <table class="ztbl0">
        <thead>
            <tr>
                <th>#</th>
                <th>Code / شفرة </th>
                <th>Service / خدمة </th>
                <th>Price / سعر </th>
                <th>Discount / تخفيض </th>
                <th>Amount / كمية </th>
            </tr>
        </thead>
        <tbody>';

$insurance_payment = 0;
foreach ($episodePayments as $key => $row) {
    $content .= '<tr>
                    <td class="ztd0">' . ($key + 1) . '</td>
                    <td>' . $row->procedure_id . '</td>
                    <td class="ztd0">' . $row->treatment_name . ' x' . $row->quantity . '</td>
                    <td class="ztd0">' . $row->orig_price . ' QR</td>
                    <td class="ztd0">' . $row->discount_qr . ' QR</td>
                    <td class="ztd0">' . number_format($row->fees, 2) . ' QR</td>
                </tr>';
    $insurance_payment += $row->insurance_amount;
}

$content .=  '
            <tr>
                <td class="ztd1" colspan="4"></td>
                <td class="ztd1 ztd0"><strong>Total / المجموع :</strong></td>
                <td class="ztd0 ztd1"><strong>' . number_format(($invoice->total - $invoice->discount), 2) . ' QR</strong></td>
            </tr>
            <tr>
                <td colspan="4"></td>
                <td class="ztd0"><strong>Discount / تخفيض :</strong></td>
                <td class="ztd0"><strong>' . number_format($cashier_discount, 2) . ' QR</strong></td>
            </tr>
            <tr>
                <td colspan="4"></td>
                <td class="ztd0"><strong>Co Payment / الدفع المشترك
                :</strong></td>
                <td class="ztd0"><strong>' . number_format($co_payment, 2) . ' QR</strong></td>
            </tr>
            <tr>
                <td class="" colspan="4"></td>
                <td class=" ztd0"><strong>Exccess / إفراط :</strong></td>
                <td class="ztd0 "><strong>' . number_format(($excess), 2) . ' QR</strong></td>
            </tr>
            <tr>
                <td class="" colspan="4"></td>
                <td class=" ztd0"><strong>Net Claim / المجموع المدفوع :</strong></td>
                <td class="ztd0 "><strong>' . number_format(($insurance), 2) . ' QR</strong></td>
            </tr>
            
            
        </tbody>
    </table>
</div>';