<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
	<?php require_once(APPPATH . "views/admin/header.php"); ?>
	<style>
		.dataTables_scrollBody{
			overflow: scroll !important;
		}
	</style>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->


	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				<strong>Sales Report</strong>
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>
		<!-- Main content -->
		<section class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
						<div class="box-header with-border">
							<h3 class="box-title font-weight-bold">Sales Income</h3>
						</div>

						<div class="box-body">
							<div class="panel-group" id="accordion">

								<div class="d-block mb-3">
									<div class="row" id="filters">
										<div class="col-12 col-md-2">
											<div class="form-group">
												<label for="payment_type">Payment Type</label>
												<select name="payment_type" id="payment_type">
													<option value="-1">All</option>
													<?php foreach ($payment_types as $index => $type) : ?>
														<option value="<?= $type->type_id; ?>"><?= $type->type_name; ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										</div>
											<div class="col-12 col-md-2">
											<div class="form-group">
												<label for="payment_type">Insurance Type</label>
												<select name="payment_type" id="insurance_type">
													<option value="-1">All</option>
													<?php foreach ($insurance_types as $index => $type) : ?>
														<option value="<?= $type->insurance_type_id; ?>"><?= $type->insurance_name; ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										</div>
											<div class="col-12 col-md-2">
											<div class="form-group">
												<label for="payment_type">Doctors</label>
												<select name="doctor" id="doctor">
												    <?php
													$loged_user =getLoginUser($this);

													if (!check_right('view_all_trans', $this)) : ?>
														<!-- Show only the logged-in doctor's data -->
														<option value="<?= $loged_user->user_Id; ?>"><?= $loged_user->full_name; ?></option>
													<?php else : ?>
													<option value="-1">All</option>
													<?php foreach ($doctors as $index => $type) : ?>
														<option value="<?= $type->user_Id; ?>"><?= $type->full_name; ?></option>
													<?php endforeach; ?>
														<?php endif; ?>
												</select>
											</div>
										</div>
										<div class="col-12 col-md-2">
											<div class="form-group">
												<label for="date_from">Date From</label>
												<input type="date" class="form-control" name="date_from" id="date_from" placeholder="Date From" value="<?php echo date('Y-m-d') ?>">
											</div>
										</div>
										<div class="col-12 col-md-2">
											<div class="form-group">
												<label for="date_to">Date To</label>
												<input type="date" class="form-control" name="date_to" id="date_to" placeholder="Date To" value="<?php echo date('Y-m-d') ?>">
											</div>
										</div>
											<div class="col-12 col-md-2">
											<div class="form-group">
												<label for="payment_type">Balance</label>
												<select name="balance" id="balance" class="form-control">
													<option value="-1">All</option>
														<option value="1">Only Receivables</option>
												</select>
											</div>
										</div>
										
									</div>
								</div>

								<table id="price_list" class="table table-light table-bordered table-striped"></table>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div><!-- /.content-wrapper -->
	<!-- ./wrapper -->
	<?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

</html>

<script type="text/javascript">
	$(document).ready(function() {
	    const base_url = "<?php echo base_url(); ?>";
		// Initialize the DataTable
		var dataTable = $('#price_list').DataTable({
		     columnDefs: [
		          { targets: 0, width: '6%' },
        { targets: 7, className: 'text-center' },   // Align first column to the left
        { targets: 8, className: 'text-center' }, // Align second column to the center
        { targets: 9, className: 'text-center' },
          { targets: 10, className: 'text-center' },// Align third column to the right
           
    ],
			dom: 'Blfrtip',
				fixedHeader: {
        header: true,
        footer: true
    },
     scrollY: '650px',
        scrollCollapse: true,
			buttons: [{
				extend: 'excel',
				title: `Sales Report`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Sales Report`,
				customize: function(win) {
					$(win.document.body).prepend(`<?php echo print_header($this); ?>`);
					var filterData = '<div class="filter-data d-flex ml-3">';

					$('#filters .form-group').each(function() {
						var label = $(this).find('label').text().trim();
						var value;
						var inputElement = $(this).find('select, input');

						if (inputElement.is('select')) {
							value = inputElement.find('option:selected').text();
						} else if (inputElement.is('input[type="date"]')) {
							value = inputElement.val();
						}


						filterData += '<p class="ml-2 mr-2"><strong>' + label + ':</strong> ' + value + '</p>';
					});

					filterData += '</div>';

					$(win.document.body).find('h1').after(filterData);

					$(win.document.body).find('h1').css({
						'font-size': '20px',
						'text-align': 'center',
						"font-weight": "700"
					});

					$(win.document.body).find('table').css({
						'margin-left': '20px',
						'margin-right': '10px',
						"width": "95%",
						"font-size": "12px",
						'table-layout': 'auto'
					});
					$(win.document.body).find('table th').css({
						"font-size": "12px",
					});
				}

			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Reports/ReportsController/SalesList'); ?>',
				'type': 'GET',
				'data': function(d) {
					d.payment_type = $('#payment_type').val();
						d.insurance_type = $('#insurance_type').val();
							d.doctor_id = $('#doctor').val();
								d.balance = $('#balance').val();
					d.date_from = $('#date_from').val();
					d.date_to = $('#date_to').val();
				}
			},
			'columns': [
			    	{
					'data': 'treat_date',
					'title': 'Treatment Date'
				},
			    {
					'data': 'treatement_payment_id',
					'title': 'Invoice No',
					 'render':function(data, type,row){
              return  '<a target="_blank" href="<?php echo base_url('admin/Invoice/InvoiceController/index/') ?>'+row.encInvoice+'" class="patient-file-link btn-link cursor-pointer">' + row.treatement_payment_id ?? 0.00+ '</a>' 
          }
			
				},
				{
					'data': 'insurance_name',
					'title': 'Insurance Type'
				},
				{
                    'data': 'patient_payment_ids',
                    'title': 'Receipts',
                    'render': function(data, type, row) {
        if (!data) return ''; // Handle empty data gracefully

        // Split the comma-separated encrypted IDs into an array
        let ids =row.encReceipt.split(',');
        let showid = data.split(',');
        
        // Map each encrypted ID to a link
       let links = ids.map((id, index) => {
            return `<a target="_blank" href="${base_url}admin/Receipt/ReceiptController/index/${id.trim()}" 
                    class="patient-file-link btn-link cursor-pointer">
                    ${showid[index].trim()}   <!-- Display non-encrypted ID -->
                </a>`;
        });

        // Join all links with line breaks for display
        return links.join('<br>');
    }
				},
					{
					'data': 'payment_type',
					'title': 'Payment Type',
					  'render': function(data, type, row) {
        if (!data) return ''; // Handle empty data gracefully

        // Split the comma-separated encrypted IDs into an array
        let ids =row.payment_type.split(',');
        let showid = data.split(',');
        
        // Map each encrypted ID to a link
       let links = ids.map((id, index) => {
            return showid[index].trim();
        });

        // Join all links with line breaks for display
        return links.join('<br>');
    }
				},
					{
					'data': 'doc_name',
					'title': 'Doctor Name'
				},
				{
					'data': 'patient_id',
					'title': 'File No',
					'render':function(data, type,row){
              return  '<a target="_blank" href="<?php echo base_url('admin/Patients/PatientsController/patientStatement/') ?>'+row.encPatient+'" class="patient-file-link btn-link cursor-pointer">' + row.patient_id ?? 0.00+ '</a>' 
          }
				},
				{
					'data': 'patient_name',
					'title': 'Patient'
				},
				 {
					'data': 'mobile',
					'title': 'Patient Mobile',
					'render':function(data, type,row){
					    if(row.last_row == true){
                  return '';
            }else{
              return  '<b>'+ row.mobile+'</b>'; 
            }
          }
					
				},
				{
					'data': 'procedure_ids',
					'title': 'Treatment Name'
				},
				{
					'data': 'invoice_amount',
					'title': 'Gross Amount',
						'render':function(data, type,row){
              return  '<b>'+formatNumberWithCommas(row.invoice_amount)+'</b>';
          }
				},
				{
					'data': 'all_discount',
					'title': 'Discount',
						'render':function(data, type,row){
              return  formatNumberWithCommas(row.all_discount);
          }
				},
				{
					'data': 'net_total',
					'title': 'Net Total',
						'render':function(data, type,row){
              return  '<b>'+formatNumberWithCommas(row.net_total)+'</b>';
          }
				},
				{
					'data': 'paid_amount',
					'title': 'Paid Amount',
						'render':function(data, type,row){
              return  '<b>'+formatNumberWithCommas(row.paid_amount)+'</b>';
          }
				    
				},
          
          {
    'data': 'due_amount',
    'title': 'Due Amount',
    'render': function(data, type, row) {
            
            if(row.last_row == true){
                  return row.due_amount;
            }else{
                 var dueAmount = parseInt(row.net_total) - parseInt(row.paid_amount);
            var dueAmountfr = formatNumberWithCommas(dueAmount);
            
        
        
        // Check if dueAmount is greater than zero
        var colorClass = dueAmount > 0 ? 'text-danger' : ''; // 'text-danger' class for red color
        
        // Return the formatted HTML
        return '<b class="' + colorClass + '">' + dueAmountfr + '</b>';
        
            }
            
       
    },
          },
            {
					'data': 'note',
					'title': 'Patient Note',
            },
					
	
			
			],
			'searching': false,
			'serverSide': true,
			'paging': false
		});

		$('#insurance_type, #payment_type, #date_from, #date_to,#doctor,#balance').on('keyup change', function() {
			dataTable.ajax.reload();

			// var sumColumn = dataTable.column(1).data().reduce(function(a, b) {
			// 	return a + b;
			// }, 0);

			// dataTable.row.add(['Total: ', sumColumn]).draw();
		});
	});
	
	function formatNumberWithCommas(number) {
    return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
}
</script>
<script>
	var settings = {};
	new TomSelect('#payment_type', settings);
		new TomSelect('#insurance_type', settings);
			new TomSelect('#doctor', settings);
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1-crypto-js.js"></script>
<script>
    function encrypt_and_url_encode(value) {
    if (!value) {
        throw "Cannot encrypt an empty value.";
    }

    // Base64 encode the value
    var base64Encoded = btoa(value);

    // URL encode the base64 encoded string
    return encodeURIComponent(base64Encoded);
}
</script>
