<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Banks
                    <small>-<?php echo ($bank_id_val > 0 ? "Update" : "Create" ) ?> bank</small>
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>


            <!-- Main content -->
            <form id="save_form" name ="save_form" role="form" action="<?php echo base_url('index.php/admin/Setting/Bank/BankController/Save') ?>" method="post" >
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box margin-bottom-5px box-warning">
                                <div class="box-body">
                                    <div class="row">
										<div class="col-md-1">
											<a href="<?php echo base_url('index.php/admin/Setting/Bank/BankController') ?>" class="btn btn-social-icon <?php echo $this->config->item('new_update_back'); ?>" data-toggle="tooltip" data-placement="bottom" title="Back"><i class="fa  fa-long-arrow-left"></i></a>
										</div>
                                        <div class="col-md-9">
                                            <?php if (validation_errors()) { ?>
                                                <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
        												<!--  <i class="icon fa fa-warning"></i>-->
                                                    <div>

                                                        <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="col-md-2">
                                            <a href="#" onclick="document.getElementById('save_form').submit(); return false;" class="btn btn-block btn-social <?php echo $this->config->item('save'); ?>">
                                                <i class="fa fa-save"></i> Save bank
                                            </a>
                                        </div>
                                    </div>	
                                </div><!-- /.box-body -->
                            </div>
                            <div class="box box-info">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-5">
                                        <div class="box-body">
                                            <!-- text input -->
                                            <div class="form-group <?php echo form_error("bank_name") ? "has-error" : "" ?>">
                                                <label>Bank name</label>
                                                <input id="bank_name" name="bank_name" value="<?php echo $bank_name_val; ?>" type="text" class="form-control" placeholder="Enter ..."/>
                                                <label><small><?php echo form_error("bank_name"); ?></small></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="box-body">
                                        	<div class="form-group <?php echo form_error("note") ? "has-error" : "" ?>">
                                                <label>Note</label>
                                                <textarea id="note" name="note" type="text"   class="form-control" rows="3" placeholder="Enter ..."><?php echo $note_val; ?></textarea>
                                                <label><small><?php echo form_error("note"); ?></small></label>
                                            </div>
                                        </div>
                                    </div>
                                    <input  type="hidden" runat="server"  id="bank_id" name="bank_id" value=" <?php echo $bank_id_val; ?> ">

                                </div>
                            </div><!-- /.box --><!-- /.box-body -->
                        </div><!--/.col (right) -->
                    </div>   <!-- /.row -->
                </section><!-- /.content -->
            </form>

        </div><!-- /.content-wrapper -->

        <!-- ./wrapper -->

		

        <?php require_once(APPPATH . "views/admin/footer.php"); ?>



    </body>
</html>


