<div class="tab-pane fade" id="announcements" role="tabpanel" aria-labelledby="invoice-config-tab">
    <div class="row">
        <div class="col-md-4">
        <h4>Create New Announcement</h4>
            <form action="<?= base_url('index.php/admin/Setting/Company/CompanyController/save_announcement'); ?>" method="POST">

                <div class="form-group">
                    <label for="">User Group</label>
                    <select name="user_group" id="user_group" class="form-control">
                        <option value="">Choose Announcement Group</option>
                        <option value="0">All</option>
                        <?php foreach ($user_groups as $group) : ?>
                            <option <?= old($this, 'user_group') == $group->user_group_Id ? 'selected' : null; ?> value="<?= $group->user_group_Id; ?>"><?= $group->user_group_name; ?></option>
                        <?php endforeach ?>
                    </select>
                    <?= _e($this, 'user_group'); ?>
                </div>

                <div class="form-group mb-2">
                    <label for="announcement">Announcement</label>
                    <textarea name="announcement" id="announcement" cols="30" rows="10" class="form-control"><?= old($this, 'announcement'); ?></textarea>
                    <?= _e($this, 'announcement'); ?>
                </div>

                <div class="form-group mb-2">
                    <label for="start_at">Start at</label>
                    <input type="date" name="start_at" class="form-control" id="start_at" value="<?= old($this, 'start_at'); ?>">
                    <?= _e($this, 'start_at'); ?>
                </div>

                <div class="form-group mb-2">
                    <label for="expire_at">Expire at</label>
                    <input type="date" name="expire_at" class="form-control" id="expire_at" value="<?= old($this, 'expire_at'); ?>">
                    <?= _e($this, 'expire_at'); ?>
                </div>

                <input type="hidden" id="announcement_id" name="announcement_id" value="<?= old($this, 'announcement_id'); ?>">

                <button type="submit" class="btn btn-sm btn-light"><i class="fa fa-check-circle" aria-hidden="true"></i> Submit</button>
                <button type="reset" class="btn btn-sm btn-light"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
            </form>

        </div>
        <div class="col-md-8">
        <h4>Announcements</h4>
            <table class="table table-bordered table-striped w-100">
                <thead>
                    <th>#</th>
                    <th>User Group</th>
                    <th>Announcement</th>
                    <th>Start At</th>
                    <th>Expire At</th>
                    <th>Actions</th>
                </thead>
                <tbody id="announcement_list"></tbody>
            </table>
        </div>
    </div>

</div>

<script>
    $(function() {
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Company/CompanyController/LoadAnnouncements'); ?>',
            method: 'POST',
            dataType: 'json',
            data: {
                notification_type: $('#notifications_type').val()
            },
            success: function(response) {


                let _row = '';

                $.each(response, function(index, row) {
                    let data = {};

                    _row += `<tr>
                        <td>${row.id}</td>
                        <td>${row.user_group_name ? row.user_group_name.toUpperCase() : 'ALL'}</td>
                        <td>${row.announcement}</td>
                        <td>${row.start_at.split(' ')[0]}</td>
                        <td>${row.expire_at.split(' ')[0]}</td>
                        <td class='text-center'>
                            <button class='btn btn-sm btn-light' data-tamplate='${JSON.stringify(row)}' onclick="editAnnouncement(this)">
                                <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                            </button>
                            <button class='btn btn-sm btn-light' onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Setting/Company/CompanyController/deleteAnnouncement/') ?>${row.e_id}')">
                                <i class="fa fa-trash" aria-hidden="true"></i>
                            </button>
                        </td>
                    </tr>`;
                    //console.log(row);
                });

                $('#announcement_list').html(_row);
            },
            error: function(xhr, status, error) {

                console.error('Error:', error);
            }
        });
    });

    function editAnnouncement(e) {
        let announcement = JSON.parse($(e).attr('data-tamplate'));
        $('#announcement_id').val(announcement.e_id);
        $('#expire_at').val(announcement.expire_at.split(' ')[0]);
        $('#start_at').val(announcement.start_at.split(' ')[0]);
        $('#announcement').val(announcement.announcement);
        $('#user_group').val(announcement.user_group);
    }
</script>