<div class="tab-pane fade" id="whatsapp_config" role="tabpanel" aria-labelledby="invoice-config-tab">
    <?php 

        $whatsapp_portal = json_decode($whatsapp_portal->service_configuration);
    ?>
    <div class="row">
        <div class="col-md-4">
            
            <form action="<?= base_url('index.php/admin/Setting/Company/CompanyController/save_whatsapp_configurations'); ?>" method="POST" id="whatsapp_config_form">
                <div class="form-group">
                    <label for="api_key">Whatsapp Secret Key</label>
                    <input type="text" value="<?= $whatsapp_portal->secret_key; ?>" required name="secret_key" id="secret_key" class="form-control" placeholder="Secret Key">
                </div>
                <div class="form-group">
                    <label for="api_key"> Auth Token</label>
                    <input type="text" value="<?= $whatsapp_portal->key_id; ?>" name="key_id" id="key_id" class="form-control" placeholder="Key ID">
                </div>
                <div class="form-group">
                    <label for="api_key">Whatsapp Business Number</label>
                    <input type="text" value="<?= $whatsapp_portal->business_number; ?>" name="business_number" id="bussiness_number" class="form-control" placeholder="Whatsapp Number">
                </div>

               

               
                

                <button type="submit" class="btn btn-sm btn-light" ><i class="fa fa-check-circle" aria-hidden="true"></i> Submit <i class="spinner spinner-border spinner-border-sm text-primary otp-send-loader" style="display:none;"></i></button>
                <button type="reset" class="btn btn-sm btn-light"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
            
                <div class="modal" id="otpModal">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">OTP Verification</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>

                    <!-- Modal body -->
                    <div class="modal-body">
                <p><i class="fa fa-info-circle mr-2"></i> OTP is valid only for <span id="">5:00</span> minutes.</p>
                <div class="form-group">
                    <label for="otp">Enter OTP</label>
                    <div id="otp-inputs" class="d-flex justify-content-between">
                        <input type="text" maxlength="1" class="form-control otp-digit" autofocus>
                        <input type="text" maxlength="1" class="form-control otp-digit">
                        <input type="text" maxlength="1" class="form-control otp-digit">
                        <input type="text" maxlength="1" class="form-control otp-digit">
                    </div>
                </div>
                <button type="button" class="btn btn-link btn-sm" id="resend-otp" disabled>Resend OTP (<span id="otp-timer">00:10</span>)</button>
            </div>

                    <!-- Modal footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-sm btn-light" id="verify-otp"><i class="fa fa-check-circle" aria-hidden="true"></i> Verify OTP</button>
                    </div>

                    </div>
                </div>
                </div>
            </form>

        </div>
    </div>

</div>

<script>
       let timer;
    let timeLeft = 60; // 5 minutes in seconds

    function startTimer() {
        timer = setInterval(function() {
            if (timeLeft <= 0) {
                clearInterval(timer);
                $('#otp-timer').text('1:00');
                $('#resend-otp').prop('disabled', false); // Enable the resend button
            } else {
                let minutes = Math.floor(timeLeft / 60);
                let seconds = timeLeft % 60;
                $('#otp-timer').text(`${minutes}:${seconds < 10 ? '0' : ''}${seconds}`);
                timeLeft--;
            }
        }, 1000);
    }

    // Start the timer when the modal is shown
  

    $('.otp-digit').on('keyup', function(e) {
        if (e.key >= '0' && e.key <= '9') {
            $(this).next('.otp-digit').focus();
        } else if (e.key === 'Backspace') {
            $(this).prev('.otp-digit').focus();
        }
    });

    $("#send_otp").click(function(){
        $('.otp-send-loader').show();

        $.ajax({
                    url: '<?= base_url('index.php/admin/Setting/Company/CompanyController/send_otp'); ?>',
                    type: 'POST',
                    success: function(response) {
                        successNotification('OTP has been sent to your registered phone.');
                        $('#otpModal').modal('show');
                        $('.otp-send-loader').hide();
                        timeLeft = 60;
                            $('#resend-otp').prop('disabled', true); // Disable resend button initially
                            startTimer();
                    },
                    error: function() {
                       errorNotification('Failed to send OTP. Please try again.');
                    }
                });
    })
    
    $("#resend-otp").click(function(){
        

        $.ajax({
                    url: '<?= base_url('index.php/admin/Setting/Company/CompanyController/send_otp'); ?>',
                    type: 'POST',
                    success: function(response) {
                        successNotification('OTP has been sent to your registered phone.');
                        $('#otpModal').modal('show');
                        $('.otp-send-loader').hide();
                        timeLeft = 60;
                            $('#resend-otp').prop('disabled', true); // Disable resend button initially
                            startTimer();
                    },
                    error: function() {
                       errorNotification('Failed to send OTP. Please try again.');
                    }
                });
    })


    $('#verify-otp').on('click', function() {
        let otp = '';
        $('.otp-digit').each(function() {
            otp += $(this).val();
        });

        // Perform AJAX request to validate OTP here
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Company/CompanyController/validate_otp'); ?>',
            type: 'POST',
            data: { otp: otp },
            dataType: 'json',
            success: function(data) {
                if (data.valid) {
                    successNotification('OTP verified successfully!');
                    $('#otpModal').modal('hide');
                    $('#whatsapp_config_form').submit();
                    // Proceed with form submission or further actions
                } else {
                    errorNotification(data.message);
                }
            },
            error: function() {
                alert('Error validating OTP. Please try again.');
            }
        });
    });



</script>