<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
    <script src="https://flex.cybersource.com/cybersource/assets/microform/0.11/flex-microform.min.js"></script>
     <script src="https://skipcashtest.azurewebsites.net/js/skipcash-credit-card.js"></script> 
    <!--<script src="<?php echo base_url('js/credit-card.js') ?>"></script>-->
    <style>
        .payment-form {
      background: #fff;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      width: 100%;
      max-width: 450px;
    }
    .payment-form h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #333;
    }
    .input-group-text {
      background-color: #ffff;
      color: #6c757d;
      border: 1px solid #d2d6de;
      border-right: none;

    }
    .form-control{
        border-left: none;
    }
    
    .form-control:focus {
      border-color: #084a6a;
      box-shadow: none;
    }
    .btn-primary {
      background-color: #084a6a;
      border: none;
    }

    .btn-primary:hover {
      background-color: #084a6a;
    }
    .secure {
      text-align: center;
      margin-top: 15px;
      color: #6c757d;
      font-size: 14px;
    }
    .secure i {
      color: green;
    }
    .payment-details-box .card-header {
    border-radius: 10px 10px 0 0;
    background-color: #084a6a;
  }

  .payment-details-box .card {
    border-radius: 10px;
  }

  .payment-details-box .card-body .row {
    align-items: center;
  }

  .payment-details-box .card-body .row div {
    font-size: 16px;
  }

  .payment-details-box .text-muted {
    color: #6c757d !important;
  }

  .payment-details-box .text-success {
    color: #084a6a !important;
  }

  .payment-details-box hr {
    border-top: 1px solid #dee2e6;
  }
    </style>
</head>

<body class="<?= $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->
    <?php if (validation_errors()) { ?>
        <div class="callout <?= $this->config->item('msg_error'); ?> error-msg">
            <div>
                <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
            </div>
        </div>
    <?php } ?>

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
               Payment <small> </small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->

        <section class="content">
            <div class="row">
               <div class="col-md-12">
                    <div class="card">
                       <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                            <div class="payment-method-box ">
                                <h5 class="text-center mb-2">Choose Payment Method</h5>
                                <div class="">
                                    <!-- Credit Card Button -->
                                    <button class="btn btn-light  active">
                                    <img src="https://img.icons8.com/?size=100&id=lWWE908jTJ3m&format=png&color=000000" width="35px" alt="Credit Card Icon" class="mr-2 active" />
                                    Credit Card
                                    </button>

                                    <!-- Debit Card Button -->
                                    <button class="btn btn-light ">
                                    <img src="https://img.icons8.com/?size=100&id=nwhf6sbmRFKH&format=png&color=000000" width="35px" alt="Debit Card Icon" class="mr-2" />
                                    Debit Card
                                    </button>
                                </div>
                                </div>
                            </div>
                            <div class="col-md-8">
                            <div class="payment-details-box my-4">
                            <div class="card shadow-sm">
                                <div class="card-header bg-dark text-white text-center">
                                <h4 class="mb-0">Payment Summary</h4>
                                </div>
                                <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-6 text-muted">Company Name:</div>
                                    <div class="col-6 font-weight-bold text-right"><?= $company->company_name ?></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-6 text-muted">Paying For:</div>
                                    <div class="col-6 font-weight-bold text-right">H-Mate Subscription</div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-6 text-muted">Monthly Price:</div>
                                    <div class="col-6 font-weight-bold text-right">QAR <?= $subscriptions->price ?></div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-6 text-muted">Selected Months:</div>
                                    <div class="col-6 font-weight-bold text-right"><input type="number" id="monthCount" value="<?= $months ?>" class="fo" /> Months</div>
                                    <input type="hidden" name="" id="price" value="<?= $subscriptions->price ?>" />
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-6 text-muted">Total Price:</div>
                                    <div class="col-6 font-weight-bold text-right text-success" id="total_price">QAR 300</div>
                                    <input type="hidden" name="" id="amount" value="">
                                </div>
                                </div>
                            </div>
                            </div>

                            </div>
                            <div class="col-md-4">
                                <div class="payment-form">
                                <h2>Payment Form</h2>
                                <form>
                                <div class="form-group">
                                <label for="cardholderName">Cardholder Name</label>
                                <div class="input-group">
                                <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fa fa-user"></i></span>
                                </div>
                                <input type="text" class="form-control" id="cardholderName" placeholder="Enter Card Holder Name" required>
                                </div>
                                </div>
                                <div class="form-group">
                                <label for="cardNumber">Card Number</label>
                                <small id="card_type" class="text-right float-right"></small>
                                <div class="input-group">
                                <div class="input-group-append">
                                <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                
                                </div>
                                <input type="text" class="form-control" id="card_number" placeholder="1234 5678 9012 3456" maxlength="16" required>
                                <span  class="position-absolute" style="right:8px; top:7px; bottom:0">
                                <i class="spinner spinner-border font-sm card-loader" style="
                                    font-size: 11px;
                                    width: 13px;
                                    height: 13px;
                                    display:none;
                                    position:absolute;right:0;
                                    z-index:9;
                                "></i>
                                <i class="fa fa-check card-success" style="display: none; color:green;z-index:9999;position:absolute;right:0"></i>
                                </span>
                                </div>
                                <span id="card_text" ></span>
                                </div>
                                <div class="form-row">
                                <div class="form-group col-md-6">
                                <label for="expiryDate">Expiry Date</label>
                                <div class="input-group">
                                <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                </div>
                                <input type="text" class="form-control" id="expiryDate" placeholder="MM/YY" maxlength="5" required>
                                </div>
                                </div>
                                <div class="form-group col-md-6">
                                <label for="cvv">CVV</label>
                                <div class="input-group">
                                <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fa fa-lock"></i></span>
                                </div>
                                <input type="text" class="form-control" id="cvv" placeholder="123" maxlength="3" required>
                                </div>
                                </div>
                                </div>
                                <button type="button" class="btn btn-primary btn-block" id="pay-button">Pay Now</button>
                                </form>
                                <p class="secure"><i class="fa fa-lock"></i> Secure Payment</p>
                                </div>
                            </div>
                        </div>
                       
<div
            class="form-control"
            id="number-container"
            style="height: 40px"
          ></div>
           <div
            class="form-control"
            id="securityCode-container"
            style="height: 40px"
          ></div>

                        </div>
               </div>
            </div>
        </section>
 <!-- Device Data collection IFRAME -->
 <iframe
          name="ddc-iframe"
          height="10"
          width="10"
          style="display: none"
        ></iframe>
        <form
          id="ddc-form"
          target="ddc-iframe"
          method="POST"
          action="https://centinelapistag.cardinalcommerce.com/V1/Cruise/Collect"
        >
          <input type="hidden" id="JWT" name="JWT" value="" />
        </form>

        <iframe
          id="step-up-iframe"
          name="step-up-iframe"
          style="width: 100%; height: 100%; border: none"
        ></iframe>
        <form
          id="step-up-form"
          target="step-up-iframe"
          method="POST"
          action="https://centinelapistag.cardinalcommerce.com/V2/Cruise/StepUp"
        >
          <input type="hidden" id="StepJWT" name="JWT" value="" />
        </form>
    </div>

                             
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>

</body>

</html>
<script>
      $('#monthCount').on('keyup change', function () {
        console.log('sd')
        var months= $(this).val();
       
        var price= $('#price').val();
        var total =  parseInt(price)* parseInt(months);
        
        $('#amount').val(total);
        $('#total_price').text('QAR  '+total);
        
        
        
    });
var base_url= "<?php echo base_url('')  ?>"
$(document).ready(function () {
   var months= $('#monthCount').val();
    var price= $('#price').val();
        var total =  parseInt(price)* parseInt(months);
        
        $('#amount').val(total);
        $('#total_price').text('QAR  '+total);
  $('#card_number').on('keyup', function () {
    const cardNumber = $(this).val().trim();

    // Check if the length is at least 6 digits for BIN lookup
    if (cardNumber.length >= 6) {
      const bin = cardNumber.slice(0, 6); // Get the first 6 digits
      $('.card-loader').show();
      // Make the API request
      $.ajax({
        url: base_url+'/admin/CommenController/validate',
        method: 'POST',
      
        data: { bin: bin },
        success: function (response) {
            $('.card-loader').hide();
         $('#card_type').text(response.BIN.brand)
          const cardType = response.BIN.type; // Assuming the API returns a `type` field
          if (cardType === 'CREDIT') {
            $('#card_text').text('');
            $('.card-success').show();
           
          } else if (cardType === 'DEBIT') {
            $('.card-success').hide();
            $('#card_text').text('Please Enter Credit Card Number').css('color', 'red');
          } else {
            $('#card_text').text('Unknown card type').css('color', 'orange');
          }
        },
        error: function () {
            $('.card-success').hide();
          $('#card_text').text('Error: Unable to check card type').css('color', 'red');
        }
      });
    } else {
        $('.card-success').hide();
        $('#card_type').text('')
      
    }
  });
});

</script>
<script>

  
  
    // Store selected tab in localstorage
    $('.company_configuration_tab_list').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('company_configuration_tab', tabIndex);
    });

    // Load tab index from localstorage
    $(document).ready(function() {
        let selectedTab = localStorage.getItem('company_configuration_tab') != null ? localStorage.getItem('company_configuration_tab') : 0;
        $(`.company_configuration_tab_list a:eq(${selectedTab})`).tab('show');
    });
</script>
<script type="text/javascript">
      var cardholderName = document.getElementById("cardholderName");
      var amount = document.getElementById("amount");
      var expMonth = document.getElementById("expiry-month");
      var expYear = document.getElementById("expiry-year");
      var payButton = document.querySelector("#pay-button");
      var flexResponse = document.querySelector("#flexresponse");
      var iframeDiv = document.querySelector("#iframe-div");
      var jwk, transientToken, sessionId, transactionId;
      var keyId = "79b0651b-00e2-4f9c-a0f7-2bffc535c348";
      var clientId = "2582ac48-8b6f-418d-b323-f6d11e104fcc";
     
      // var keyId = "10254d95-97c0d-4f90-8d0f-f4724a388997";
      var BE_URL = "<?php echo base_url('admin/SkipCash/CreditCardController/') ?>";
      var domain ="<?php  echo base_url();?>"

      function cleanUpJWK({ resultObj }) {
        const jwkWithSpecialChar = resultObj.replace(/^"|"$/g, "");
        jwk = JSON.parse(jwkWithSpecialChar.replace(/\\/g, ""));
      }

       console.log(KeyId);
      async function getCaptureContextHash() {
        const response = await fetch(
          `${BE_URL}/generateCaptureContextHash?flexTargetOrgin=${domain}`
        );
        const json = await response.json();
        const { hashInBase64 } = json;
     
        const body = {
          KeyId: keyId,
          FlexTargetOrigin: domain,
          ClientId: clientId,
        };
        const data = await GenerateCaptureContextRequest(body, hashInBase64);
        cleanUpJWK(data);
        createFlexMicroformField();
      }

      getCaptureContextHash();

      payButton.addEventListener("click", async function () {
        transientToken = await createTransientToken(
          expMonth.value,
          expYear.value
        );
        console.log("transientToken", transientToken);
        await handlePayerAuthSetup();
      });

      const handlePayerAuthSetup = async () => {
        transientToken = transientToken.replace(/^"|"$/g, "");
        transientToken = transientToken.replace(/\\/g, "");

        const payload = {
          KeyId: keyId,
          TransientToken: transientToken,
          Amount: `${amount.value}.00`,
          FirstName: "Wasim",
          LastName: "Ibrahim",
          Phone: "97433973295",
          Email: "wasim@asd.com",
          TransactionId: "435324",
          Custom1: "This is Custom1",
          webHookUrl:
            "https://century.event-site.live/api/test/payment/callback",
        };

        const body = { ...payload };
        delete body["TransientToken"];

        console.log("payload ", payload);

        const response = await fetch(`${BE_URL}/payAuthHash`, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            
          },
          body: JSON.stringify({ ...body }),
        });

        const { hashInBase64 } = await response.json();
        console.log("auth hash json ", hashInBase64);

        const { resultObj } = await PayerAuthSetupRequest(
          payload,
          hashInBase64
        );
        console.log("auth setup ", resultObj);
        if (resultObj.accessToken) {
          const ddcForm = document.querySelector("#ddc-form");
          document.getElementById("JWT").value = resultObj.accessToken;
          if (ddcForm) {
            ddcForm.submit();
          }

          window.addEventListener(
            "message",
            (event) => {
              var eventUrl = "https://centinelapistag.cardinalcommerce.com";
              let d = JSON.parse(event.data);
              if (event.origin === eventUrl) {
                console.log("Merchant received a message:", d);
              }
              if (d !== undefined && d.Status) {
                console.log(
                  "Songbird ran DF successfully.. \n",
                  JSON.stringify(d)
                );
                sessionId = resultObj.referenceID;
                handleEnrollmentRequest();
              }
            },
            false
          );
        }
      };

      const handleEnrollmentRequest = async () => {
        const response = await fetch(
          `${BE_URL}/enrollmentHash?referenceId=${sessionId}&returnUrl=https://webhook.site/a6e42216-8b67-4c89-b7ec-189c58f94a90`
        );
        const { hashInBase64 } = await response.json();
        console.log("session id ", sessionId);
        const body = {
          keyId,
          referenceId: sessionId,
          transientToken,
          returnURL: `https://webhook.site/a6e42216-8b67-4c89-b7ec-189c58f94a90`,
        };

        console.log("enrollment hash ", hashInBase64)
        console.log("enrollment body ", JSON.stringify(body))

        const { resultObj } = await PayerAuthEnrollmentRequest(
          body,
          hashInBase64
        );
        console.log("enrollment result ", resultObj);
        if (resultObj.accessToken) {
          var StepUpForm = document.querySelector("#step-up-form");
          document.getElementById("StepJWT").value = resultObj.accessToken;
          if (StepUpForm) {
            StepUpForm.submit();
            handleValidation(
              resultObj.accessToken,
              resultObj.authTransactionId
            );
          }
        }
      };

      const handleValidation = async (accessToken, authTransactionId) => {
        console.log("handleValidation", accessToken, authTransactionId);
        const validationResponse = await fetch(
          `${BE_URL}/validationHash?referenceId=${sessionId}&transactionId=${authTransactionId}`
        );

        const { hashInBase64 } = await validationResponse.json();
        const body = {
          keyId,
          transactionId: authTransactionId,
          transientToken,
          referenceId: sessionId,
        };

        const { resultObj } = await PayerAuthValidationRequest(
          body,
          hashInBase64
        );
        console.log("validation result ", resultObj);

        if (resultObj.isSuccess) {
          alert("Payment Successful -> " + resultObj.subscriptionId);
        }
      };
    </script>