<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?= $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->
    <?php if (validation_errors()) { ?>
        <div class="callout <?= $this->config->item('msg_error'); ?> error-msg">
            <div>
                <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
            </div>
        </div>
    <?php } ?>

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
               Subscription Plan <small> </small>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->

        <section class="content">
            <div class="row">
               <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="car-header">
                                <h1 class="card-title">Plan Details</h1>
                            </div>

                            <table class="table table-striped">
                                <tr>
                                    <th>Plan Name</th>
                                    <th>Starting Date</th>
                                    <th>Expired On</th>
                                    <th>Price</th>
                                    <th>Days Left</th>
                                    <th>Action</th>

                                </tr>
                                <tr>
                                    
                                    <td><?= $subscriptions->plan ?></td>
                                    <?php 
                                            $start_date=date_create($subscriptions->start_date);
                                           $s_date =date_format($start_date,"d-M-Y ");
                                    ?>
                                    <td><?= $s_date ?></td>
                                    <?php 
                                            $expiry_date=date_create($subscriptions->expired_at);
                                           $f_date =date_format($expiry_date,"d-M-Y ");
                                    ?>
                                    <td><?= $f_date;  ?></td>
                                 
                                    
                                    <td><?= $subscriptions->price ?> <span>QR/month</span></td>
                                        <input type="hidden" name="" id="price" value="<?= $subscriptions->price ?>" />
                                    <td>
                                    <?php
                                       $start_date = strtotime(date('Y-m-d')); // Convert start date to timestamp
                                       $end_date = strtotime($f_date); // Convert end date to timestamp
                                       
                                       $datediff = $end_date - $start_date; // Calculate difference in seconds
                                       
                                       $days=round($datediff / (60 * 60 * 24)) . ' Days'; // Convert seconds to days
                                       $badge_class='badge-primary';
                                    if($days < 30 && $days > 20){
                                        $badge_class='badge-warning';
                                    }else{
                                        $badge_class='badge-danger';
                                    }
                                    ?>
                                    
                                    <span class="badge <?= $badge_class?>"><?= $days ?></span>
                                    </td>
                                    <td><a  class="btn btn-light btn-sm" data-toggle="modal" data-target="#subscribeModal" ><i class="fa fa-refresh mr-1"></i> Renew</a></td>
                                </tr>
                            </table>
                        </div>
                    </div>
               </div>
            </div>
        </section>

    </div>

    <div class="modal fade" id="subscribeModal" tabindex="-1" role="dialog" aria-labelledby="subscribeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="subscribeModalLabel">Renew H-Mate Subscription</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="subscribeForm" method="POST" action="<?php echo base_url('admin/WhatsappController/subscribe')  ?>">
        <div class="modal-body">
          <div class="form-group">
            <label for="messagesCount">Number of Months</label>
            <input type="number" class="form-control" min="1" id="monthCount" name="messages_count" placeholder="Number of Months" required>
            <input type="hidden" name="" class="form-control" id="amount" >
             <p class="total-text"></p>                       
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-dismiss="modal"><i class="fa fa-close mr-1"></i>Close</button>
          <button type="submit" class="btn btn-light"> Pay</button>
        </div>
      </form>
    </div>
  </div>
</div>                           
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>

</body>

</html>

<script>

    $('#monthCount').keyup(function(){
        var months= $(this).val();
       
        var price= $('#price').val();
        var total =  parseInt(price)* parseInt(months);
        console.log(total);
        $('#amount').val(total);
        $('.total-text').text('Total Amount Will be: '+total);
        $('.total-text').fadeIn();

    });
    $('#subscribeForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        var form = $(this);
        var amount = $('#amount').val();
        var month_count = $('#monthCount').val();
        var type = 'H-Mate Subscription Renewal';

        // Construct the payment gateway URL
        var paymentUrl = "<?php echo base_url('admin/SkipCash/PaymentController/index') ?>";
        var formData = {
            amount: amount,
           
            month_count: month_count,
            type: type
        };

        // Open the payment gateway URL in a new window
        var form = $('<form>', {
            action: paymentUrl,
            method: 'POST',
            target: '_blank'
        });

        $.each(formData, function(key, value) {
            form.append($('<input>', {
                type: 'hidden',
                name: key,
                value: value
            }));
        });

        $('body').append(form);
        form.submit();
  
    });
    // Store selected tab in localstorage
    $('.company_configuration_tab_list').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('company_configuration_tab', tabIndex);
    });

    // Load tab index from localstorage
    $(document).ready(function() {
        let selectedTab = localStorage.getItem('company_configuration_tab') != null ? localStorage.getItem('company_configuration_tab') : 0;
        $(`.company_configuration_tab_list a:eq(${selectedTab})`).tab('show');
    });
</script>