<div class="tab-pane fade" id="consent_config_tab" role="tabpanel" aria-labelledby="consent-config-tab">


  <?php
  $errors = $this->session->flashdata('errors');
  if ($errors) { ?>
    <div class="row mb-1">
      <div class="col-md-12">
        <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
          <div>
            <span><i class="icon fa fa-warning"></i><?= $errors; ?></span>
          </div>
        </div>
      </div>
    </div>
  <?php } ?>

  <?php
  $success = $this->session->flashdata('success');
  if ($success) { ?>
    <div class="row mb-1">
      <div class="col-md-12">
        <div class="callout <?php echo $this->config->item('msg_success'); ?> error-msg">
          <div>
            <span><i class="icon fa fa-check"></i><?= $success; ?></span>
          </div>
        </div>
      </div>
    </div>
  <?php } ?>

  <div class="panel-body">
    <div class="row">
      <div class="col-md-4">
        <div class="d-flex justify-content-between w-100">
          <button class="btn btn-sm btn-light modal_consent" data-target="#modal_consent" data-toggle="modal" title="Add" style="margin-bottom:10px">
            <i class="fa fa-plus-circle" aria-hidden="true"></i>
            <span>Add</span>
          </button>
        </div>
        <div class="d-block">
          <div class="list-group">
            <table class="table table-bordered">
              <thead class="thead-light">
                <tr>
                  <th scope="col">#</th>
                  <th scope="col">Consent</th>
                  <th scope="col" class="text-center">Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($consents as $key => $consent) : ?>
                  <tr>
                    <td><?= $key + 1; ?></td>
                    <td>
                      <a href="#" class="list-group-item consent_list border-none <?php echo $key == 0 ? 'active' : ''; ?>" id="<?= $consent['consent_id']; ?>"><?= $consent['consent_name']; ?></a>
                    </td>
                    <td>
                      <div class="d-flex justify-content-center w-100">
                        <button class="btn btn-sm btn-light modal_consent mr-2" data-target="#modal_consent" data-toggle="modal" title="Edit" onclick="editConsent(<?= $consent['consent_id']; ?>,'<?= $consent['consent_name']; ?>')" style="margin-bottom:10px">
                          <span class="fa fa-edit" aria-hidden="true"></span>
                        </button>
                        <button class="btn btn-sm btn-light" id="delete_consent" onclick="consentDeleteConfirmation(<?= $consent['consent_id']; ?>)" style="margin-bottom:10px">
                          <span class="fa fa-trash" aria-hidden="true"></span>
                        </button>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>

          </div>
        </div>

      </div>
      <div class="col-md-8">
        <div class="">
          <ul class="nav nav-tabs bg-light tab_list1" role="tablist">
            <li role="presentation" class="nav-item active">
              <a href="#english" aria-controls="home" role="tab" class="nav-link font-weight-bold" data-toggle="tab">English</a>
            </li>
            <li role="presentation" class="nav-item">
              <a href="#arabic" aria-controls="messages" role="tab" class="nav-link font-weight-bold" data-toggle="tab">Arabic</a>
            </li>
          </ul>
        </div>

        <div class="tab-content" id="consent_content">

          <div role="tabpanel container" class="tab-custom active" id="english">
         
            <textarea id="editor_en" name="editor_en" height="700"></textarea>
          </div>
          <div role="tabpanel container" class="tab-custom" style="display:none" id="arabic">
            <textarea id="editor_ar" name="editor_ar" height="700"></textarea>
          </div>

        </div>

        <div class="d-block mt-2 text">
          <button type="button" class="btn btn-md btn-light btn-sm" id="consent_content_save">
            <i class="fa fa-check-circle" aria-hidden="true"></i>
            Save
          </button>
        </div>

        <div class="tab-content hide" id="consent_loading">
          <img class="loading_img" width="100px" style="margin: 0;
          position: absolute;
          top: 50%;
          left: 50%;
          transform: translate(-50%, -50%);
          text-align: center;" src="<?= base_url('Images/loading.gif') ?>">
        </div>
      </div>
      <input type="hidden" class="form-control" name="active_consent_id" id="active_consent_id">
    </div>
  </div>

  <div class="modal fade" id="modal_consent" tabindex="-1" role="dialog" aria-labelledby="modal_consent">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalCenterTitle">Consent Form</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?= base_url('index.php/admin/ConsentForm/ConsentFormController/add_consent_form'); ?>" method="post">

        <div class="modal-body">
        
            <input type="hidden" class="form-control" name="consent_id" id="consent_id" placeholder="Concent ID">

            <div class="form-group">
              <label for="consent_name" id="app_date">Consent Name</label>
              <input type="text" class="form-control" name="consent_name" id="consent_name" placeholder="Consent Name">
            </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-light btn-sm">
            <i class="fa fa-check-circle" aria-hidden="true"></i>
            Save
          </button>
          <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
            <i class="fa fa-times-circle" aria-hidden="true"></i>
            Close
          </button>
        </div>
        </form>
      </div>
    </div>
  </div>

</div>

<script>
var base_url = "<?php echo base_url();  ?>";

$(document).ready(function() {
  // Handle the click event for the English tab
  $('a[href="#english"]').on('click', function(e) {
    e.preventDefault(); // Prevent default behavior
    // Remove the 'active' class from all tabs
    $('.nav-item a').removeClass('active');
    // Add 'active' class to the clicked tab
    $(this).addClass('active');
    // Hide all tab panes
    $('.tab-custom').hide();
    // Show the English tab pane
    $('#english').show();
  });

  // Handle the click event for the Arabic tab
  $('a[href="#arabic"]').on('click', function(e) {
    e.preventDefault(); // Prevent default behavior
    // Remove the 'active' class from all tabs
    $('.nav-item a').removeClass('active');
    // Add 'active' class to the clicked tab
    $(this).addClass('active');
    // Hide all tab panes
    $('.tab-custom').hide();
    // Show the Arabic tab pane
    $('#arabic').show();
  });

  // Initialize: Set English tab as visible and active on page load
  $('#english').show();
  $('#arabic').hide();
  $('a[href="#english"]').addClass('active');
});
$(".consent_list").click(function(e) {
        $(".consent_list").removeClass("active");
        $(this).addClass("active");

        var id = $(this).attr('id');
        $('#active_consent_id').val(id);

        $.ajax({
            type: "POST",
            url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_consent_form'); ?>",
            data: {
                consent_id: id
            },
            dataType: 'JSON',
            beforeSend: function() {
                $('#consent_content').addClass('hide');
                $('#consent_loading').removeClass('hide');

            },
            success: function(data) {
                $('#consent_content').removeClass('hide');
                $('#consent_loading').addClass('hide');
                editor_en.value = data[0].en_content;
                editor_ar.value = data[0].ar_content;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(xhr.status + ' : ' + xhr.responseText);
            }
        });
    });

    $("#consent_content_save").click(function(e) {

        var id = $('#active_consent_id').val(),
            en_content = $('#editor_en').val(),
            ar_content = $('#editor_ar').val();

        $.ajax({
            type: "POST",
            url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/update_consent_template'); ?>",
            data: {
                consent_id: id,
                en_content: en_content,
                ar_content: ar_content
            },
            dataType: 'JSON',
            beforeSend: function() {
                $('#consent_content').addClass('hide');
                $('#consent_loading').removeClass('hide');
            },
            success: function(data) {
                $('#consent_content').removeClass('hide');
                $('#consent_loading').addClass('hide');
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(xhr.status + ' : ' + xhr.responseText);
            }
        });
    });

    // const editor_en = Jodit.make("#editor_en", {
    //     "uploader": {
    //         "insertImageAsBase64URI": true
    //     },
    //     "spellcheck": true,
    //     "toolbarButtonSize": "small",
    //     "enter": "P",
    //     // "defaultMode": "3"
    // });

    // const editor_ar = Jodit.make("#editor_ar", {
    //     "uploader": {
    //         "insertImageAsBase64URI": true
    //     },
    //     "spellcheck": true,
    //     "toolbarButtonSize": "small",
    //     "enter": "P",
    //     // "defaultMode": "3"
    // });

    // $(".modal_consent").click(function(e) {
    //     let type = $(this).attr("title");
    //     if (type == "Edit") {
    //         var consent_ = $(".consent_list").parent().find(".active"),
    //             id = consent_[0].id;
    //         text = consent_[0].text;
    //         $("#consent_id").val(id);
    //         $("#consent_name").val(text);
    //     } else {
    //         $("#consent_id").val("");
    //         $("#consent_name").val("");
    //     }

    //     $("#consent_type").text(type + " ");
    //     $("#modal_consent").modal({
    //         keyboard: false,
    //     });
    // });

    englishExtrabuttons('eng');
    
    englishExtrabuttons('ar');
    
        var editor= $('#editor_en');
        
function englishExtrabuttons(type){
  
          var patientCounter = 1
        var doctorCounter =1;
        var SignCounter =1;
        var RadioCounter =1;
        var TextCounter =1;
       

        
  Jodit.defaultOptions.controls['insertPatientField' + type] = {
    iconURL: base_url+'/uploads/medical_p.png', // Optional: icon for the button
    name: 'Insert Patient Field',
    exec: function (editor) {
    const content = editor.value; // Get current content from editor
    
    // Find the highest existing patient placeholder in the content
    let matches = content.match(/\{PATIENT_(\d+)\}/g); // Match all {PATIENT_X} placeholders
    let highestNumber = 0;

    if (matches) {
      // Extract numbers from the placeholders and find the highest one
      matches.forEach(function(match) {
        let number = parseInt(match.match(/\d+/)[0], 10); // Extract the number part
        if (number > highestNumber) {
          highestNumber = number;
        }
      });
    }

    // Set the counter to the next number after the highest one found
    let patientCounter = highestNumber + 1;

    // Insert the next patient field
    const patientPlaceholder = `{PATIENT_${patientCounter}}`;
    editor.selection.insertHTML(patientPlaceholder);
  },
    tooltip: 'Insert Patient Field'
  };
  Jodit.defaultOptions.controls['insertDoctorField' + type] = {
    iconURL: base_url+'/uploads/doctor.png', // Optional: icon for the button
    name: 'Insert Doctor Field',
    exec: function (editor) {
    const content = editor.value; // Get current content from editor
    
    // Find the highest existing patient placeholder in the content
    let matches = content.match(/\{DOCTOR_(\d+)\}/g); // Match all {PATIENT_X} placeholders
    let highestNumber = 0;

    if (matches) {
      // Extract numbers from the placeholders and find the highest one
      matches.forEach(function(match) {
        let number = parseInt(match.match(/\d+/)[0], 10); // Extract the number part
        if (number > highestNumber) {
          highestNumber = number;
        }
      });
    }

    // Set the counter to the next number after the highest one found
    let doctorCounter = highestNumber + 1;

    // Insert the next patient field
    const doctorPlaceholder = `{DOCTOR_${doctorCounter}}`;
    editor.selection.insertHTML(doctorPlaceholder);
  },
    tooltip: 'Insert Doctor Field'
  };
  Jodit.defaultOptions.controls['insertSignField' + type] = {
    iconURL: base_url+'/uploads/contract.png', // Optional: icon for the button
    name: 'Insert Signature Field',
    exec: function (editor) {
    const content = editor.value; // Get current content from editor
    
    // Find the highest existing patient placeholder in the content
    let matches = content.match(/\{SIGNATURE_(\d+)\}/g); // Match all {PATIENT_X} placeholders
    let highestNumber = 0;

    if (matches) {
      // Extract numbers from the placeholders and find the highest one
      matches.forEach(function(match) {
        let number = parseInt(match.match(/\d+/)[0], 10); // Extract the number part
        if (number > highestNumber) {
          highestNumber = number;
        }
      });
    }

    // Set the counter to the next number after the highest one found
    let SignCounter = highestNumber + 1;

    // Insert the next patient field
    const SignPlaceholder = `{SIGNATURE_${SignCounter}}`;
    editor.selection.insertHTML(SignPlaceholder);
  },
    tooltip: 'Insert Signature Field'
  };

  Jodit.defaultOptions.controls['insertTextField' + type] = {
    iconURL: base_url+'/uploads/input.png', // Optional: icon for the button
    name: 'Insert Text Field',
    exec: function (editor) {
    const content = editor.value; // Get current content from editor
    
    // Find the highest existing patient placeholder in the content
    let matches = content.match(/\{TEXT_(\d+)\}/g); // Match all {PATIENT_X} placeholders
    let highestNumber = 0;

    if (matches) {
      // Extract numbers from the placeholders and find the highest one
      matches.forEach(function(match) {
        let number = parseInt(match.match(/\d+/)[0], 10); // Extract the number part
        if (number > highestNumber) {
          highestNumber = number;
        }
      });
    }

    // Set the counter to the next number after the highest one found
    let TextCounter = highestNumber + 1;

    // Insert the next patient field
    const TextPlaceholder = `{TEXT_${TextCounter}}`;
    editor.selection.insertHTML(TextPlaceholder);
  },
    tooltip: 'Insert Text Field'
  };
  Jodit.defaultOptions.controls['insertOptionField' + type] = {
    iconURL: base_url+'/uploads/check-box.png', // Optional: icon for the button
    name: 'Insert Options',
    exec: function (editor) {
    const content = editor.value; // Get current content from editor
    
    // Find the highest existing patient placeholder in the content
    let matches = content.match(/\{CHECKBOX_(\d+)\}/g); // Match all {PATIENT_X} placeholders
    let highestNumber = 0;

    if (matches) {
      // Extract numbers from the placeholders and find the highest one
      matches.forEach(function(match) {
        let number = parseInt(match.match(/\d+/)[0], 10); // Extract the number part
        if (number > highestNumber) {
          highestNumber = number;
        }
      });
    }

    // Set the counter to the next number after the highest one found
    let RadioCounter = highestNumber + 1;

    // Insert the next patient field
    const RadioPlaceholder = `{CHECKBOX_${RadioCounter}}`;
    editor.selection.insertHTML(RadioPlaceholder);
  },
    tooltip: 'Insert Checkbox Options'
  };
  
   // Initialize a counter to keep track of the number of groups
    let groupCounter = 0;

    // Define the custom button for inserting radio buttons
    Jodit.defaultOptions.controls['insertRadioOptions' + type] = {
        iconURL: base_url + '/uploads/radio-btn.png', // Optional: icon for the button
        name: 'Insert Radio Options',
        exec: function (editor) {
            // Increment the group counter for a new group
            groupCounter++;

            // Show the dialog for user input
            const dialogHTML = `
                <div>
                    <label for="radio-count">Number of Radio Buttons:</label>
                    <input type="number" id="radio-count" min="1" value="1"><br>
                    <button id="submit-radio-options">Insert</button>
                    <button id="cancel-radio-options">Cancel</button>
                </div>
            `;
            
            // Create a temporary dialog
            const dialog = editor.create.fromHTML(dialogHTML);
            editor.s.insertNode(dialog);

            // Handle insert button click
            dialog.querySelector('#submit-radio-options').addEventListener('click', function () {
                const count = parseInt(dialog.querySelector('#radio-count').value);

                // Insert the specified number of radio buttons into the new group
                for (let i = 0; i < count; i++) {
                    const RadioPlaceholder = `{RADIO_${groupCounter}_${i + 1}}`;
                    editor.selection.insertHTML(RadioPlaceholder);
                }

                // Close the dialog
                editor.selection.clear();
                dialog.remove();
            });

            // Handle cancel button click
            dialog.querySelector('#cancel-radio-options').addEventListener('click', function () {
                dialog.remove();
            });
        },
        tooltip: 'Insert Radio Options' // Tooltip for the button
    };
}
    const editor_en = Jodit.make("#editor_en", {
        "saveModeInStorage": true,
        toolbarAdaptive: true,
        extraButtons: ['insertPatientField'+'eng', 'insertDoctorField'+'eng', 'insertSignField'+'eng','insertTextField'+'eng','insertOptionField'+'eng','insertRadioOptions'+'eng'],
    
    });
    editor_en.value = "<p></p>";

    const editor_ar = Jodit.make("#editor_ar", {
        "saveModeInStorage": true,
        toolbarAdaptive: true,
        extraButtons: ['insertPatientField'+'ar', 'insertDoctorField'+'ar', 'insertSignField'+'ar','insertTextField'+'ar','insertOptionField'+'ar','insertRadioOptions'+'ar'],
    });
    editor_ar.value = '<p style="text-align: right;"></p>';


function consentDeleteConfirmation(consent_id) {
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
        }).then((result) => {
            if (result.isConfirmed) {

                $.ajax({
                    type: "POST",
                    url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/deleteConsentForm'); ?>",
                    data: {
                        consent_id: consent_id
                    },
                    dataType: 'JSON',
                    success: function(response) {
                        Swal.fire({
                            title: "Deleted!",
                            text: response.message,
                            icon: "success"
                        });
                        setTimeout(function() {
                            window.location.reload();
                        }, 1000);
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        console.log(xhr.status + ' : ' + xhr.responseText);
                        Swal.fire({
                            title: "Failed!",
                            text: JSON.parse(xhr.responseText).message,
                            icon: "error"
                        });
                    }
                });
            }
        });
    }

    // Conset edit
    function editConsent(consent_id, consent_name) {
        $("#consent_id").val(consent_id);
        $("#consent_name").val(consent_name);
    }
</script>