<div class="panel-group" id="accordion">

<div class="row">

<div class="col-md-6">
<form id="csvUploadForm" enctype="multipart/form-data">
        <div class="justify-content-between d-flex">
        <input type="file" name="csv_file" id="csv_file" accept=".csv" required />
        <button type="submit" class="btn btn-light btn-sm ">Upload CSV</button>
        </div>
       
        <hr>
        
    </form>

<div class="form-group">
    <label for="">Enter Message</label>
    <textarea name="message" class="form-control" id="message" cols="30" rows="10" placeholder="Enter Message"></textarea>
    <small id="smsCreditsInfo" class="form-text text-muted"></small>
</div>
<button type="button" class="btn btn-light mt-5" id="sendMessages">Send Messages</button>
</div>
<div class="col-md-6">


<div id="resultContainer" class="" style="margin-top: 20px; max-height:350px; overflow-y:scroll">
    <p class="text-center text-muted">Please Select CSV file and Upload</p>
</div>

</div>
</div>
<div class="col-md-12 mt-5">
    <div class="alert alert-dark bg-info" role="alert">
        <p><i class="fa fa-info-circle"></i> <strong>Instructions for Sending SMS To Specific Phone Numbers:</strong></p>
        <ul>
            <li>First, <a href="<?php echo base_url('uploads/csv/number_template.csv') ?>" download>download the CSV template</a> to ensure your file is formatted correctly.</li>
            <li>Prepare your CSV file with a single column of phone numbers (one number per row).Without Country Code</li>
            <li>Click the <strong>Upload CSV</strong> button below to select and upload your file.</li>
            <li>Once uploaded, review the list of phone numbers and deselect any numbers you do not wish to include.</li>
            <li>Compose your SMS message in the message box provided and then click <strong>Send Messages</strong> to deliver your message to the selected recipients.</li>
        </ul>

    </div>
</div>
<!-- Confirmation Modal -->


</div>
<script>
    var credits =0;
 $(document).ready(function () {
        // Handle form submission
        $('#csvUploadForm').submit(function (e) {
            e.preventDefault();
            
            // Create FormData object for the uploaded file
            var formData = new FormData(this);

            // AJAX request to upload the file
            $.ajax({
                url: base_url+'admin/SmsPortal/SmsPortalController/upload_csv', // Controller function URL
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    $('#resultContainer').empty();
                    $('#resultContainer').html(response); // Load result into container
                },
                error: function () {
                    alert("Failed to upload CSV file.");
                }
            });
        });



        $('#sendMessages').click(function () {
        // Gather selected phone numbers
        var selectedNumbers = [];
        $('.numberCheckbox:checked').each(function () {
            selectedNumbers.push($(this).val());
        });

        if (selectedNumbers.length === 0) {
            errorNotification('Please select at least one number to send messages to.');
            return;
        }
        var message =$('#message').val();
        if(message == ''){
            errorNotification('Please Enter Message');
            return;
        }
        $('#confirmationMessage').text('You are about to send messages to ' + selectedNumbers.length + ' numbers. Are you sure?');
        $('#total_credits').html('Total Credits = '+credits +' x '+selectedNumbers.length  + ' = <strong>'+credits * selectedNumbers.length  + '</strong>');
    $('#confirmSendModal').modal('show');
    $('#confirmSendMessages').off('click').on('click', function () {
        if (!$('#captchaCheckbox').is(':checked')) {
            errorNotification("Please confirm .");
            return;
        }
        // Send AJAX request with the selected numbers
        $.ajax({
            url: base_url+'admin/SmsPortal/SmsPortalController/send_sms_number', // URL for sending messages
            type: 'POST',
            data: { 
                phoneNumbers: selectedNumbers,
                message:message
             },
            success: function (response) {
                
                successNotification(response); // Display message sending status
                window.location.reload();
            },
            error: function () {
                errorNotification("Failed to send messages.");
            }
        });
    });
});

$('#message').on('input', function () {
        var message = $(this).val();
        credits = calculateSmsCredits(message);
        
        // Display the calculated credits below the textarea
        $('#smsCreditsInfo').text('SMS Credits needed: ' + credits);
    });
    });

</script>