<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .dataTables_info {
            display: none !important;
        }
        #csv_file {
             display: block !important;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
         <?php if (!empty($datajobs) && $datajobs->total_batches > 0): ?>
     <div class="alert alert-warning d-flex justify-content-between align-items-center" role="alert">
            <div>
                <h5 class="mb-1"><i class="fa fa-exclamation-triangle"></i> Pending SMS Batches</h5>
                <p class="mb-0">You have <strong><?php echo $datajobs->total_batches; ?></strong> pending SMS batches.</p>
                <p class="mb-0 text-muted"><small>Last batch created on: <strong><?php echo date('F j, Y, g:i A', strtotime($datajobs->last_batch_date)); ?></strong></small></p>
                <p class="mt-2"><strong>Note:</strong> If you have just sent messages, please wait. If this is old data, click the <strong>Clear Pending Messages</strong> button.</p>
            </div>
            <button class="btn btn-danger btn-sm" id="clearPendingBtn">
                <i class="fas fa-trash-alt"></i> Clear Pending Messages
            </button>
        </div>
    </div>
<?php else: ?>
        <section class="content-header">
            <h1>
                <strong>SMS Portal</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">

                    <div class="box box-info">
                        <div id="smsProgressModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%;
                            background-color: rgba(0,0,0,0.6); z-index: 9999;  align-items: center; justify-content: center;">
                            <div style="background: #fff; padding: 20px 30px; border-radius: 10px; width: 90%; max-width: 500px; box-shadow: 0 0 20px rgba(0,0,0,0.3);">
                                <h5 class="mb-3 text-center">Sending Bulk SMS...</h5>
                                <div class="progress" id="smsProgressWrapper">
                                    <div id="smsProgressBar" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%">0%</div>
                                </div>
                                <small id="smsStatusText" class="form-text text-muted mt-2 text-center"></small>
                            </div>
                </div>
                        <div class="box-header with-border">
                        <a href="javascript:void(0);" class="btn btn-light btn-sm" id="sendSMSPatients">Send SMS Within Patients List</a>
                        <a href="javascript:void(0);" class="btn btn-light btn-sm" id="sendSMSPhoneNumber">Send SMS to Selected Mobile Numbers</a>
                        <!-- <a href="javascript:void(0);" class="btn btn-light btn-sm" id="smsTask">Bulk SMS Tasks</a> -->
                        </div>

                        <div class="box-body" id="viewContainer">
                            
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div class="modal fade" id="confirmSendModal" tabindex="-1" role="dialog" aria-labelledby="confirmSendModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="confirmSendModalLabel">Confirm Message Sending</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p id="confirmationMessage"></p>
                <p id="total_credits">

                </p>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="captchaCheckbox">
                    <label class="form-check-label" for="captchaCheckbox">I'm Sure </label>
                   
                </div>
                 <p><strong>Note:</strong> Duplicated Mobile Numbers has been excluded</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-dark btn-sm" id="confirmSendMessages">Confirm</button>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
    </div><!-- /.content-wrapper -->
    <!-- ./wrapper -->
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>

</html>

<script>
    var base_url= "<?php echo base_url(); ?>"
    $(document).ready(function () {
        // Check if there's a saved tab in localStorage
        var savedTab = localStorage.getItem('activeTab');

        // Load the saved tab or default to the first tab
        if (savedTab) {
            loadTab(savedTab);
        } else {
            loadTab('sendSMSPatients');  // Default tab if none saved
        }

        // Handle clicks for tabs and store the clicked tab in localStorage
        $('#sendSMSPatients').click(function () {
            loadTab('sendSMSPatients');
        });

        $('#sendSMSPhoneNumber').click(function () {
            loadTab('sendSMSPhoneNumber');
        });

        $('#smsTask').click(function () {
            loadTab('smsTask');
        });

        // Function to load the view and store the active tab
        function loadTab(tabId) {
            var view = '';
            switch (tabId) {
                case 'sendSMSPatients':
                    view = 'patient';
                    break;
                case 'sendSMSPhoneNumber':
                    view = 'numbers';
                    break;
                case 'smsTask':
                    view = 'smsTask';
                    break;
                default:
                    view = 'patient';
            }

            // Load the respective view based on the tab
            $('#viewContainer').load(base_url + '/admin/SmsPortal/SmsPortalController/load_view/' + view);
            
            // Store the active tab in localStorage
            localStorage.setItem('activeTab', tabId);
        }
    });

    
    function calculateSmsCredits(message) {
        var isUnicode = /[^\x00-\x7F]/.test(message); // Check if the message contains Unicode characters
        var charCount = message.length; // Count characters

        var firstPartLimit, subsequentPartLimit;

        if (isUnicode) {
            // Unicode SMS calculation
            firstPartLimit = 70;
            subsequentPartLimit = 67;
        } else {
            // English SMS calculation
            firstPartLimit = 160;
            subsequentPartLimit = 153;
        }

        if (charCount <= firstPartLimit) {
            return 1; // Only 1 part is needed
        } else {
            // Calculate additional parts
            var remainingChars = charCount - firstPartLimit;
            var additionalParts = Math.ceil(remainingChars / subsequentPartLimit);
            return 1 + additionalParts; // Total parts = 1 (first part) + additional parts
        }
    }
    
</script>
    
    
    <script>
        document.getElementById('clearPendingBtn').addEventListener('click', function () {
            if (confirm("Are you sure you want to clear all pending messages?")) {
                fetch("<?php echo base_url('admin/SmsPortal/SmsPortalController/clearPending'); ?>", {
                    method: "POST"
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert("All pending messages cleared successfully!");
                        location.reload();
                    } else {
                        alert("Failed to clear messages.");
                    }
                })
                .catch(error => console.error('Error:', error));
            }
        });
    </script>
