<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>User Groups <small>Create/Edit User Groups</small></strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="d-flex justify-content-end">
                                        <a href="<?php echo base_url('index.php/admin/UserGroup/UserGroupController/CreateNew') ?>" class="btn btn-sm btn-dark <?php echo $this->config->item('add_new'); ?>">
                                            <i class="fa fa-plus-circle" aria-hidden="true"></i> New user group
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-body -->
                    </div>
                </div><!-- /.col -->
            </div><!-- /.row -->

            <div class="row">
                <div class="col-12">
                    <div class="box box-info"><!-- /.box-header -->
                    <div class="box-header with-border">
							<h3 class="box-title font-weight-bold">Available User Groups</h3>
						</div>
                        <div class="box-body">
                            <table id="search_grid" class="table table-bordered table-striped">
                                <thead>

                                    <tr class="<?php echo $this->config->item('grid_header'); ?>">
                                        <th class="hide">#</th>
                                        <th>Group name</th>
                                        <th>Description</th>
                                        <th class="text-center">Actions</th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <?php foreach ($user_group->result() as $row) { ?>
                                        <tr>
                                            <td class="hide"><?php echo $row->user_group_Id; ?></td>
                                            <td> <?php echo $row->user_group_name; ?></td>
                                            <td> <?php echo $row->description; ?></td>
                                            <td class="col_10 text-center">
                                                <a class="btn btn-sm btn-light" title="Edit" href="<?php echo site_url('admin/UserGroup/UserGroupController/Load/') . $row->user_group_Id; ?>" title="Edit"><i class="fa  fa-edit"></i></a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>

                            </table>
                        </div><!-- /.box-body -->
                    </div><!-- /.box -->
                </div>
            </div>
        </section>


    </div><!-- /.content-wrapper -->

    <!-- ./wrapper -->

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>



</body>

</html>