<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                <strong>Users <small>Create/Edit Users</small></strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="box header_bar" style="border:none">
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="d-flex justify-content-end">
                                    <?php if(check_right('add_user',$this)) { ?>
                                        <a href="<?= base_url('index.php/admin/Users/UsersController/CreateNew') ?>" class="btn btn-sm btn-dark">
                                            <i class="fa fa-plus-circle" aria-hidden="true"></i>
                                            New User
                                        </a>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                        <div class="col-md-4 mt-3">
                        <div class="form-group">
                        <label for="">Designations</label>
                        <select name="status_filter" class="form-control" id="status_filter">
                            <option value="">All</option>
                           <?php foreach($designations as $item){ ?>
                                <option value="<?= $item['designation_id'] ?>"><?= $item['designation'] ?></option>
                            <?php } ?>
                        </select>
                        </div>
                        </div>
                    <div class="box box-info theme_color_bar content_padding">
                        <div class="box-body">
                            <table id="usersTable" class="table table-bordered table-striped" >
                               
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>



</body>
<script>
    user_list()
    function user_list(){
var base_url ="<?php echo site_url() ?>"
var status= $("#status_filter").val();

var dataTableInvoice = $('#usersTable').DataTable({
  'ajax': {
    'url': '<?= site_url('admin/Users/UsersController/get_users_list'); ?>',
    'type': 'GET',
    'data': function(d) {
      d.is_insurance = 1,
      d.designation=$("#status_filter").val()
    }
  },

  'columns': [{
      'data': null,
      'title': '#',
      'render': function(data, type, row) {
        var htmlCont = '';

        
          htmlCont += '<img style="height: 33px;width: 33px;border-radius: 50%;" src="'+row.image+'">'
        
        return htmlCont;
      }
    },
    {
      'data': 'user_name',
      'title': 'Username',
    },
    {
      'data': 'full_name',
      'title': 'Name'
    },
    {
      'data': '--',
      'title': 'Designation',
      'render': function(data, type, row) {
        var htmlCont = '';

            if(row.designation == 0 ||row.designation == null ){
               htmlCont +='Not Available' 
            }else{
                htmlCont +=row.designation  
            }
          
        
        return htmlCont;
      }
      
    },
    {
      'data': 'user_group_name',
      'title': 'User Group'
    },
    {
      'data': 'phone_no',
      'title': 'Contact'
    },
    {
      'data': null,
      'title': 'Status',
      'render': function(data, type, row) {
        var htmlCont = '';

            if(row.is_inactive == 0){
               htmlCont +='<small class="badge badge-success">Active</small>' 
            }else{
                htmlCont +='<small class="badge badge-danger">Inactive</small>'  
            }
          
        
        return htmlCont;
      }
      
    },
    {
            "data": null, // Assuming `null` as this column data comes from a function, not a direct field
            'title':'Action',
            "render": function(data, type, row) {
                var userId = row.user_Id;
                var buttons = '<div class="text-center">';

                // Check permission for 'reset_user_password'
                if (check_right('reset_user_password')) {
                    buttons += '<a id="user~' + userId + '" data-control="open_change_password_modal" class="btn btn-light btn-sm" style="margin-right: 5px;" title="Change Password">';
                    buttons += '<i class="fa fa-key" aria-hidden="true"></i></a>';
                }

                // Check permission for 'edit_user'
                if (check_right('edit_user')) {
                    buttons += '<a class="btn btn-light btn-sm" title="Edit" href="' + base_url+ '/admin/Users/UsersController/Load/' + userId + '">';
                    buttons += '<i class="fa fa-edit"></i></a>';
                }

                buttons += '</div>';
                return buttons;
            },
            "orderable": false, // Prevent sorting for this column
            "searchable": false // Disable search for this column
        }
    
    
  ],
  'order': [
    [1, 'desc']
  ],
  'serverSide': true,
  "stateSave": true,
  // 'pageLength': 10,
  'lengthMenu': [10, 25, 50, 100, -1],
  'pagingType': 'full_numbers',
  'autoWidth': false,
  'columnDefs': [{
    'targets': -1, // Target the last column (Actions column)
    'className': 'dt-center'
  }],
  stateSaveCallback: function(settings, data) {
    localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
  },
  stateLoadCallback: function(settings) {
    return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
  },
});
$("#status_filter").change(function(){
  dataTableInvoice.ajax.reload();
})
}

function check_right(permission) {
   var data=false;
    if(permission =='reset_user_password'){
        data= "<?php echo check_right('reset_user_password',$this)?>"
    }else if(permission =='edit_user'){
        data= "<?php echo check_right('edit_user',$this)?>"

    }
    console.log(data);
   return data;
}
</script>
</html>