<?php
// Validate that the file parameter is present in the URL
if (!isset($_GET['file'])) {
    header('HTTP/1.1 400 Bad Request');
    echo 'File parameter is missing.';
    exit;
}

// Decode the file path from base64
$encodedFilePath = $_GET['file'];
$decodedFilePath = base64_decode(urldecode($encodedFilePath));

// Validate the decoded file path (e.g., check if it exists and is within allowed directories)
// Replace this validation with your actual validation logic
$allowedDirectories = [UPLOAD_PATH.'patients/']; // Add your allowed directories here
$isValidFilePath = false;

// foreach ($allowedDirectories as $directory) {
//     $absolutePath = realpath($directory);
//     print_r($decodedFilePath);die;
//     if ($absolutePath !== false && strpos($decodedFilePath, $absolutePath) === 0) {
//         $isValidFilePath = true;
//         break;
//     }
// }

// if (!$isValidFilePath) {
//     header('HTTP/1.1 403 Forbidden');
//     echo 'Access to the file is not allowed.';
//     exit;
// }

// Determine the content type based on the file extension
$mimeTypes = [
    'pdf' => 'application/pdf',
    'jpg' => 'image/jpeg',
    'png' => 'image/png',
    // Add more mime types as needed
];


$fileExtension = pathinfo($decodedFilePath, PATHINFO_EXTENSION);
print_r(basename($decodedFilePath));die;
$contentType = $mimeTypes[$fileExtension] ?? 'application/octet-stream'; // Default to binary data if extension not found

// Set the appropriate content type header
header('Content-Type: ' . $contentType);
header('Content-Disposition: inline; filename="' . basename($decodedFilePath) . '"');

// Output the file content
readfile($decodedFilePath);
