// Check if the browser supports notifications
if ("Notification" in window) {
  
    // Ask for permission if it's not already granted
    if (Notification.permission !== "granted") {
      Notification.requestPermission().then(permission => {
        if (permission === "granted") {
          showNotification();
        }
      });
    } else {
      showNotification();
    }
  }
  
  // Function to show the notification
  function showNotification() {
    const options = {
      body: "This is the body of the notification.",
      icon: "icon.png", // Path to an icon image
      // Additional options:
      // tag: "notification-tag", // Tag to avoid showing duplicate notifications
      // actions: [ // You can add actions to the notification
      //   { action: "action1", title: "Action 1" },
      //   { action: "action2", title: "Action 2" }
      // ]
    };
  
    const notification = new Notification("Notification Title", options);
  
    // Optional: Add event listeners to handle notification interactions
    notification.onclick = () => {
      console.log("Notification clicked!");
      window.focus(); // Brings the tab to focus
      notification.close(); // Close the notification
    };
    
    notification.onclose = () => {
      console.log("Notification closed!");
    };
  }