var editor; // use a global for the submit and return data rendering in the examples

$(document).ready(function() {
    editor = new $.fn.dataTable.Editor( {
        "ajax": "Ajax/Staff",
        "table": "#example",
        "fields": [ {
                "label": "Drug ID:",
                "name": "drug_id"
            }, {
                "label": "Availability:",
                "name": "availability"
            }, {
                "label": "Price:",
                "name": "price"
            }, {
                "label": "Drug Type:",
                "name": "drug_type"
            }, {
                "label": "New Old:",
                "name": "new_old"
            }, {
                "label": "Update Time:",
                "name": "update_date",
                "type": "datetime"
            }
        ]
    } );

    $('#example').DataTable( {
        dom: "Bfrtip",
        ajax: {
            url: "Ajax/Staff",
            type: "POST"
        },
        serverSide: true,
        columns: [
            { data: "drug_id" },
            { data: "availability" },
            { data: "price" },
            { data: "drug_type" },
            { data: "new_old" },
            { data: "update_date" }
        ],
        select: true,
        buttons: [
            { extend: "create", editor: editor },
            { extend: "edit",   editor: editor },
            { extend: "remove", editor: editor }
        ]
    } );
} );