<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2017, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (https://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2017, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	https://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Model Class
 *
 * @package		CodeIgniter
 * @subpackage	Libraries
 * @category	Libraries
 * @author		EllisLab Dev Team
 * @link		https://codeigniter.com/user_guide/libraries/config.html
 */
class CI_Model {

	/**
	 * Class constructor
	 *
	 * @return	void
	 */
	public function __construct()
	{
		log_message('info', 'Model Class Initialized');
	}

	// --------------------------------------------------------------------

	/**
	 * __get magic
	 *
	 * Allows models to access CI's loaded classes using the same
	 * syntax as controllers.
	 *
	 * @param	string	$key
	 */
	public function __get($key)
	{
		// Debugging note:
		//	If you're here because you're getting an error message
		//	saying 'Undefined Property: system/core/Model.php', it's
		//	most likely a typo in your model code.
		return get_instance()->$key;
	}

	public function insert_data($table, $data)
	{
		$this->db->insert($table, $data);
		return $this->db->insert_id();
	}

	public function insert_data_multiple($table, $data)
	{
		$this->db->insert_batch($table, $data);
		return $this->db->insert_id();
	}

	public function update_data_where($table, $field, $value, $data)
	{

		$query = $this->db->query("SELECT *FROM $table WHERE $field ='$value'");
			
			if($query->num_rows() >0)
			{
				$this->db->where($field, $value);
				$this->db->update($table, $data); 
				return TRUE;
			} else{
				return FALSE;
			}
	}

	
	public function retrieve_data_unique_like($table, $filed_name, $filed_value)
	{

		if($filed_value!=""){
			$sql = " WHERE $filed_name LIKE '%$filed_value%'";
		}
		

		$query = $this->db->query("SELECT * FROM $table $sql ");
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{
				return FALSE;
			}
	}


	public function retrieve_data_unique($table, $filed_name, $filed_value)
	{

		$query = $this->db->query("SELECT * FROM $table WHERE $filed_name = '$filed_value'");
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{
				return FALSE;
			}
	}

	public function retrieve_data_unique_fields($table, $fields, $filed_name, $filed_value)
	{

		$query = $this->db->query("SELECT $fields FROM $table WHERE $filed_name = '$filed_value'");
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{
				return FALSE;
			}
	}

	public function retrieve_data_unique_fields_order($table, $fields, $filed_name, $filed_value, $order_field, $order)
	{

		$query = $this->db->query("SELECT $fields FROM $table WHERE $filed_name = '$filed_value' ORDER BY $order_field $order");
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{
				return FALSE;
			}
	}


	public function retrieve_data($table)
	{

		$query = $this->db->query("SELECT * FROM $table");
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{
				return FALSE;
			}
	}
	

	public function delete_data_where($table, $filed_name, $filed_value)
	{
		$query = $this->db->query("SELECT * FROM $table WHERE $filed_name ='$filed_value'");

		if ($query->num_rows() > 0) {
			$this->db->where($filed_name, $filed_value);
			$this->db->delete($table);
			return TRUE;
		} else {
			return FALSE;
		}
	}

	

	public function retrieve_data_unique_row($table, $field_name = null, $field_value = null)
	{
		$this->db->select('*');
		$this->db->from($table);

		if ($field_name !== null && $field_value !== null) {
			$this->db->where($field_name, $field_value);
		}

		$query = $this->db->get();

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}

	public function get_data_row($table, $field_name = null, $field_value = null)
	{
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where($field_name, $field_value);

		$query = $this->db->get();

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}


	public function retrieve_data_order($table, $filed_name, $order)
	{

		$query = $this->db->query("SELECT * FROM $table ORDER BY $filed_name $order" );
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{
				return FALSE;
			}
	}

	public function update_data($table, $field, $value, $data)
	{

		$query = $this->db->query("SELECT * FROM $table WHERE $field ='$value'");
			
			if($query->num_rows() >0)
			{
				$this->db->where($field, $value);
				$this->db->update($table, $data); 
				return TRUE;
			} else{
				return FALSE;
			}
	}


}
