<!DOCTYPE html>
<html>

<head>
	<meta charset="UTF-8">
	<title>Patient</title>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

	<?php require_once(APPPATH . "views/admin/header.php"); ?>

	<style>
		.accordion {
			background-color: #eee;
			color: #444;
			cursor: pointer;
			padding: 18px;
			width: 100%;
			border: none;
			text-align: left;
			outline: none;
			font-size: 15px;
			font-weight: bold;
			transition: 0.4s;
			margin-top: 5px;
			margin-bottom: 5px;
			outline: none !important;
			border-radius: 5px;
			display: flex;
			justify-content: space-between;
			align-items: center;

		}

		.accor .active,
		.accordion:hover {
			background-color: #084a6a;
			color: white;
		}

		/* .accordion:after {
			content: '\002B';
			color: #777;
			font-weight: bold;
			float: right;
			margin-left: 5px;
		}

		.accor .active:after {
			content: "\2212";
		} */

		.panels {
			padding: 0 18px;
			background-color: white;
			max-height: 0;
			overflow: hidden;
			transition: max-height 0.2s ease-out;
		}

		.btn-file input[type=file] {
			position: absolute;
			top: 0;
			right: 0;
			min-width: 100%;
			min-height: 100%;
			font-size: 100px;
			text-align: right;
			filter: alpha(opacity=0);
			opacity: 0;
			outline: none;
			background: white;
			cursor: inherit;
			display: block;
			z-index: -999;
		}

		.ui-widget-content {
			display: none;
			top: 2571px;
			left: 255px;
			max-height: 200px;
			overflow-y: auto;
			overflow-x: hidden;
			width: 544px;
		}

		.width {
			width: auto;
		}

		.ui-autocomplete {
			z-index: 2147483647;
		}
	</style>
	<link href="<?= base_url('css/magnific-popup.css'); ?>" rel="stylesheet">

	<link rel="stylesheet" href="<?= base_url('plugins/fancybox/source/jquery.fancybox.css'); ?>" type="text/css" media="screen" />
	<script type="text/javascript" src="<?= base_url('plugins/fancybox/source/jquery.fancybox.pack.js'); ?>"></script>

	<link rel="stylesheet" href="<?= base_url('plugins/fancybox/source/helpers/jquery.fancybox-buttons.css'); ?>" type="text/css" media="screen" />
	<script type="text/javascript" src="<?= base_url('plugins/fancybox/source/helpers/jquery.fancybox-buttons.js'); ?>"></script>
	<script type="text/javascript" src="<?= base_url('plugins/fancybox/source/helpers/jquery.fancybox-media.js'); ?>"></script>

	<link rel="stylesheet" href="<?= base_url('plugins/fancybox/source/helpers/jquery.fancybox-thumbs.css'); ?>" type="text/css" media="screen" />
	<script type="text/javascript" src="<?= base_url('plugins/fancybox/source/helpers/jquery.fancybox-thumbs.js'); ?>"></script>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
	<!-- Site wrapper -->

	<!-- Header Navbar: style can be found in header.less -->
	<?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

	<!-- =============================================== -->

	<!-- Left side column. contains the sidebar -->
	<?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

	<!-- =============================================== -->



	<!-- Right side column. Contains the navbar and content of the page -->
	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
				&nbsp;Edit Dermatology Treatment
			</h1>
			<?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
		</section>

		<!-- Main content -->
		<section class="content print-remove-top-space">

			<?php //print_header($this); 
			?>

			<div class="row mb-2">
				<div class="col-md-12">
					<div class="box margin-bottom-5px" style="border: none;">
						<div class="box-body">
							<div class="d-flex justify-content-start">
								<a href="<?php echo base_url('index.php/admin/Patients/PatientsController') ?>" class="btn btn-dark btn-sm">
									<i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="row">
				<div class="col-12 col-md-12">
					<div class="row">
						<div class="col-12 col-md-12">
							<div class="box box-info" style="margin-bottom: 5px;">
								<div class="box-body">

									<?php
									$success = $this->session->flashdata('success');
									if ($success) { ?>
										<div class="row mb-2">
											<div class="col-md-12">
												<div class="callout <?= $this->config->item('msg_success'); ?> error-msg">
													<div>
														<span><i class="icon fa fa-check"></i><?= $success; ?></span>
													</div>
												</div>
											</div>
										</div>
									<?php } ?>

									<?php
									$error = $this->session->flashdata('error');
									if ($error) { ?>
										<div class="row mb-2">
											<div class="col-md-12">
												<div class="callout <?= $this->config->item('msg_error'); ?> error-msg">
													<div>
														<span><i class="icon fa fa-check"></i><?= $error; ?></span>
													</div>
												</div>
											</div>
										</div>
									<?php } ?>

									<!-- Derma start -->
									<div class="theme-showcase" role="main">
										<div>

											<h4 class="page-header ui-page-header hidden-print"><?= $page_header; ?></h4>
											<div class="row visible-print-block">

												<div class="col-md-12" style="display: flex;flex-wrap: wrap;flex-direction: row;justify-content: space-between;margin-bottom: 20px;">
													<?php print_header($this); ?>
												</div>
											</div>

											<div class="col-md-12 ui-line">

												<div class="text_size">
													<div>
														<div class="row">
															<?php foreach ($profile as $key => $value) : ?>
																<div class="col-md-3 width">
																	<p style="font-size:1.1em"><b>FileNo/Name :</b> <?= $value['patient_id'] . ' - ' . $value['patient_name'] ?></p>
																</div>
																<div class="col-md-3 width">
																	<p style="font-size:1.1em"><b>DOB :</b> <?= $value['dob'] ?></p>
																</div>
																<div class="col-md-3 width">
																	<p style="font-size:1.1em"><b>Sex :</b> <?= $value['sex']; ?></p>
																	<?php
																	$insruance = $value['insurance_name'];
																	$mobile = $value['mobile'];
																	?>
																</div>
																<div class="col-md-3 width">
																	<p style="font-size:1.1em"><b>Qid :</b> <?= $value['qatar_id'] ?></p>
																</div>
															<?php endforeach; ?>
															<?php
															$dob = strtotime($value['dob']);
															$current_time = time();

															$age_years = date('Y', $current_time) - date('Y', $dob);
															$age_months = date('m', $current_time) - date('m', $dob);
															$age_days = date('d', $current_time) - date('d', $dob);

															if ($age_days < 0) {
																$days_in_month = date('t', $current_time);
																$age_months--;
																$age_days = $days_in_month + $age_days;
															}

															if ($age_months < 0) {
																$age_years--;
																$age_months = 12 + $age_months;
															}
															?>
														</div>

														<div class="row">
															<?php foreach ($treatment_list as $value) : ?>
																<div class="col-md-3 width">
																	<p style="font-size:1.1em"><b>Doctor :</b> Dr.<?= $value['employee_name']; ?></p>
																</div>
																<div class="col-md-3 width">
																	<p style="font-size:1.1em"><b>Mobile No. :</b> <?= $mobile; ?></p>
																</div>
																<div class="col-md-3 width">
																	<p style="font-size:1.1em"><b>Treatment :</b> <?= $value['treat_date'] . ' ' . $value['treatment_time']; ?></p>
																</div>
																<div class="col-md-3">
																	<p style="font-size:1.1em"><b>Age :</b> <?= $age_years . ' years and ' . $age_months . ' months and ' . $age_days . ' days old.'; ?></p>
																</div>
															<?php endforeach; ?>
														</div>
													</div>

													<div class="panel mt-2">
														<form role="form" id="update_main" action="<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/update_derma'); ?>" method="post" enctype="multipart/form-data">

															<div class="row">
																<div class="col-md-12">

																	<?php
																	foreach ($treatment_list as $val) {
																		$derma_id = $val['derma_id'];
																	?>

																		<div class="form-group">
																			<div class="row">
																				<div class="col-sm-6 col-md-6">
																					<label class="font-weight-bold" for="poppup_atime">Date</label>
																					<input type="date" class="form-control app_date" name="date_derma" id="date_derma" value="<?= $val['treat_date'] ?>" required>
																				</div>
																				<div class="col-sm-6 col-md-6">
																					<label class="font-weight-bold" for="follow_up_time_internal">Time</label>
																					<div class="input-group clockpicker">
																						<input type="time" class="form-control" name="time_derma" id="time_derma" value="<?= $val['treatment_time'] ?>" required>
																						<span class="input-group-addon">
																							<span class="glyphicon glyphicon-time"></span>
																						</span>
																					</div>
																				</div>
																			</div>
																		</div>

																		<div class="form-group"><br>
																			<label class="font-weight-bold">Chief Complaint</label>
																			<input type="text" class="form-control" name="chief_complaint_derma" id="chief_complaint_derma" value="<?= $val['chief_complaint'] ?>">
																		</div>
																		<input name="derma_id" type="hidden" value="<?= $val['derma_id']; ?>">
																		<br>
																		<div>
																			<label class="font-weight-bold">PROCEDURE</label>
																		</div>

																		<?php
																		$query = $this->db->query("SELECT GROUP_CONCAT(`machine_id` SEPARATOR ',') as machine_id FROM `tbl_treat_derma_machine` WHERE `derma_id` = '$derma_id' GROUP BY `derma_id`");
																		$check_exist = $query->row();
																		if ($check_exist) {
																			$check_array = explode(',', $check_exist->machine_id);
																		} else {
																			$check_array = array();
																		}
																		for ($x = 1; $x < 23; $x++) {
																			$query = $this->db->query("SELECT * FROM tbl_treat_derma_machine LEFT JOIN tbl_treat_derma_sub ON tbl_treat_derma_machine.tbl_treat_derma_machine_id = tbl_treat_derma_sub.treat_derma_machine_id WHERE tbl_treat_derma_machine.derma_id = '$derma_id' AND tbl_treat_derma_machine.machine_id = '$x'");
																			if ($query->num_rows() > 0) {
																				$result[$x] = $query->result_array();
																			} else {
																				$result[$x] = FALSE;
																			}
																		}

																		?>

																		<div class="accor">
																			<button class="accordion <?php if (in_array("1", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_cooltech">Cooltech <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("1", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_cooltech" id="check_cooltech" value="<?php if (in_array("1", $check_array)) {
																																							echo "1";
																																						} else {
																																							echo "0";
																																						} ?>">

																				<table class="table table-bordered" id="cooltech_table" style="width: 100%">
																					<tr>
																						<td>Area</td>
																						<?php if (isset($result[1]) and $result[1] != false) {
																							foreach ($result[1] as $values) {
																								echo '<td><input type="text" name="area_cooltech[]" id="area_derma-1" class="form-control derma_auto" value="' . $values['area'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Sessions</td>
																						<?php if (isset($result[1]) and $result[1] != false) {
																							foreach ($result[1] as $values) {
																								echo '<td><input type="text" name="sessions_cooltech[]" id="sessions_derma-2" class="form-control derma_auto" value="' . $values['sessions'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Measurement (cm)</td>
																						<?php if (isset($result[1]) and $result[1] != false) {
																							foreach ($result[1] as $values) {
																								echo '<td><input type="text" name="measurement_cooltech[]" id="measurement_derma" class="form-control" value="' . $values['measurement'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>No. of pads used</td>
																						<?php if (isset($result[1]) and $result[1] != false) {
																							foreach ($result[1] as $values) {
																								echo '<td>
																											<select name="pads_cooltech[]" class="form-control">
																											<option value="1" ' . (($values['pads'] == 1) ? "selected" : "") . '>1</option>
																											<option value="2" ' . (($values['pads'] == 2) ? "selected" : "") . '>2</option>
																											</select>
																										</td> ';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Duration (mins)</td>
																						<?php if (isset($result[1]) and $result[1] != false) {
																							foreach ($result[1] as $values) {
																								echo '<td><input type="text" name="duration_cooltech[]" id="duration_derma" class="form-control" value="' . $values['duration'] . '"></td>';
																							}
																						} ?>
																					</tr>

																				</table>
																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_derma"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("2", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_etwo">E-two <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("2", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_etwo" id="check_etwo" value="<?php if (in_array("2", $check_array)) {
																																					echo "1";
																																				} else {
																																					echo "0";
																																				} ?>">
																				<!-- E-two -->
																				<div class="form-group">
																					<label class="font-weight-bold">Select Category</label>
																					<?php
																					echo '<select name="sub_category" id="sub_category" class="form-control">
																								<option value="-1" ' . (($result[2][0]['sub_category'] == '-1') ? "selected" : "") . '>Select category</option>
																								<option value="2a" ' . (($result[2][0]['sub_category'] == '2a') ? "selected" : "") . '>Sublative</option>
																								<option value="2b" ' . (($result[2][0]['sub_category'] == '2b') ? "selected" : "") . '>Sublime</option>
																							</select>';
																					?>
																				</div>

																				<!-- 2a -->
																				<table class="table table-bordered hides 2a" id="" style="width: 100%">
																					<tr>
																						<td>Skin Type</td>
																						<td>
																							<?php
																							echo '
																								<select name="skin_type_etwo[]" class="form-control">
																									<option value="TYPE I" ' . (($result[2][0]['skin_type'] == 'TYPE I') ? "selected" : "") . '>TYPE I</option>
																									<option value="TYPE II" ' . (($result[2][0]['skin_type'] == 'TYPE II') ? "selected" : "") . '>TYPE II</option>
																									<option value="TYPE III" ' . (($result[2][0]['skin_type'] == 'TYPE III') ? "selected" : "") . '>TYPE III</option>
																									<option value="TYPE IV" ' . (($result[2][0]['skin_type'] == 'TYPE IV') ? "selected" : "") . '>TYPE IV</option>
																									<option value="TYPE V" ' . (($result[2][0]['skin_type'] == 'TYPE V') ? "selected" : "") . '>TYPE V</option>
																									<option value="TYPE VI" ' . (($result[2][0]['skin_type'] == 'TYPE VI') ? "selected" : "") . '>TYPE VI</option>
																								</select>';
																							?>
																						</td>
																					</tr>
																					<tr>
																						<td>Indication</td>
																						<td>
																							<?php
																							echo '
																								<select name="indication_etwo[]" class="form-control">
																									<option value="scars" ' . (($result[2][0]['indication'] == 'scars') ? "selected" : "") . '>scars</option>
																									<option value="pimple marks" ' . (($result[2][0]['indication'] == 'pimple marks') ? "selected" : "") . '>pimple marks</option>
																									<option value="dark spots" ' . (($result[2][0]['indication'] == 'dark spots') ? "selected" : "") . '>dark spots</option>
																									<option value="fine lines" ' . (($result[2][0]['indication'] == 'fine lines') ? "selected" : "") . '>fine lines</option>
																									<option value="wrinkles" ' . (($result[2][0]['indication'] == 'wrinkles') ? "selected" : "") . '>wrinkles</option>
																								</select>';
																							?>
																						</td>
																					</tr>
																					<tr>
																						<td>Program</td>
																						<?php
																						echo '<td>
																								<select name="program_etwo[]" class="form-control">
																								<option value="A"' . (($result[2][0]['program'] == 'A') ? "selected" : "") . '>A</option>
																								<option value="B"' . (($result[2][0]['program'] == 'B') ? "selected" : "") . '>B</option>
																								<option value="C"' . (($result[2][0]['program'] == 'C') ? "selected" : "") . '>C</option>
																								</select>
																							</td>';
																						?>
																					</tr>
																					<tr>
																						<td>Area</td>
																						<td><input type="text" name="area_etwo[]" id="area_derma-3" class="form-control derma_auto" value="<?= $result[2][0]['area']; ?>"></td>
																					</tr>
																					<tr>
																						<td>Intensity</td>
																						<td><input type="text" name="intensity_etwo[]" id="intensity_derma" class="form-control" value="<?= $result[2][0]['intensity']; ?>"></td>
																					</tr>
																					<tr>
																						<td>Total Pulse</td>
																						<td><input type="text" name="total_pulse_etwo[]" id="total_pulse_derma" class="form-control" value="<?= $result[2][0]['total_pulse']; ?>"></td>
																					</tr>
																				</table>

																				<!-- 2b -->
																				<table class="table table-bordered hides 2b" id="" style="width: 100%">
																					<tr>
																						<td>Skin Type</td>
																						<td>
																							<?php
																							echo '
																								<select name="skin_type_etwo[]" class="form-control">
																									<option value="TYPE I" ' . (($result[2][0]['skin_type'] == 'TYPE I') ? "selected" : "") . '>TYPE I</option>
																									<option value="TYPE II" ' . (($result[2][0]['skin_type'] == 'TYPE II') ? "selected" : "") . '>TYPE II</option>
																									<option value="TYPE III" ' . (($result[2][0]['skin_type'] == 'TYPE III') ? "selected" : "") . '>TYPE III</option>
																									<option value="TYPE IV" ' . (($result[2][0]['skin_type'] == 'TYPE IV') ? "selected" : "") . '>TYPE IV</option>
																									<option value="TYPE V" ' . (($result[2][0]['skin_type'] == 'TYPE V') ? "selected" : "") . '>TYPE V</option>
																									<option value="TYPE VI" ' . (($result[2][0]['skin_type'] == 'TYPE VI') ? "selected" : "") . '>TYPE VI</option>
																								</select>';
																							?>
																						</td>
																					</tr>
																					<tr>
																						<td>Indication</td>
																						<td>
																							<?php
																							echo '
																								<select name="indication_etwo[]" class="form-control">
																									<option value="lifting" ' . (($result[2][0]['indication'] == 'lifting') ? "selected" : "") . '>lifting</option>
																									<option value="fine lines" ' . (($result[2][0]['indication'] == 'fine lines') ? "selected" : "") . '>fine lines</option>
																								</select>';
																							?>
																						</td>
																					</tr>
																					<tr>
																						<td>Program</td>
																						<td><input type="text" name="program_etwo[]" id="program_derma" class="form-control" value="<?= $result[2][0]['program']; ?>"></td>
																					</tr>
																					<tr>
																						<td>Area</td>
																						<td><input type="text" name="area_etwo[]" id="area_derma-3" class="form-control derma_auto" value="<?= $result[2][0]['area']; ?>"></td>
																					</tr>
																					<tr>
																						<td>Intensity</td>
																						<td><input type="text" name="intensity_etwo[]" id="intensity_derma" class="form-control" value="<?= $result[2][0]['intensity']; ?>"></td>
																					</tr>
																					<tr>
																						<td>Total Pulse</td>
																						<td><input type="text" name="total_pulse_etwo[]" id="total_pulse_derma" class="form-control" value="<?= $result[2][0]['total_pulse']; ?>"></td>
																					</tr>
																				</table>
																			</div>

																			<button class="accordion <?php if (in_array("3", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_hifu">HIFU <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("3", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_hifu" id="check_hifu" value="<?php if (in_array("3", $check_array)) {
																																					echo "1";
																																				} else {
																																					echo "0";
																																				} ?>">
																				<div class="form-group">
																					<label class="font-weight-bold">Area</label>
																					<input type="text" name="area_hifu" id="area_main-4" class="form-control derma_auto" value="<?= $result[3][0]['area_main']; ?>">
																				</div>
																				<table class="table table-bordered" id="" style="width: 100%">
																					<tr>
																						<td>Cartridge</td>
																						<?php if (isset($result[3]) and $result[3] != false) {
																							foreach ($result[3] as $values) {
																								echo '<td><input name="cartridge_hifu[]" type="hidden" id="cartridge_derma" class="form-control" value="' . $values['cartridge'] . '">' . $values["cartridge"] . '</td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Energy</td>
																						<?php if (isset($result[3]) and $result[3] != false) {
																							foreach ($result[3] as $values) { ?>
																								<td>
																									<select name="energy_hifu[]" class="form-control">
																										<option value="-1">Select</option>
																										<option value="1" <?= ($values['energy'] == "1") ? "selected" : ""; ?>>1</option>
																										<option value="2" <?= ($values['energy'] == "2") ? "selected" : ""; ?>>2</option>
																										<option value="3" <?= ($values['energy'] == "3") ? "selected" : ""; ?>>3</option>
																										<option value="4" <?= ($values['energy'] == "4") ? "selected" : ""; ?>>4</option>
																										<option value="5" <?= ($values['energy'] == "5") ? "selected" : ""; ?>>5</option>
																										<option value="6" <?= ($values['energy'] == "6") ? "selected" : ""; ?>>6</option>
																										<option value="7" <?= ($values['energy'] == "7") ? "selected" : ""; ?>>7</option>
																										<option value="8" <?= ($values['energy'] == "8") ? "selected" : ""; ?>>8</option>
																										<option value="9" <?= ($values['energy'] == "9") ? "selected" : ""; ?>>9</option>
																										<option value="10" <?= ($values['energy'] == "10") ? "selected" : ""; ?>>10</option>
																									</select>
																								</td>
																						<?php }
																						} ?>
																					</tr>
																					<tr>
																						<td>Length/ Mode Shoot</td>
																						<?php if (isset($result[3]) and $result[3] != false) {
																							foreach ($result[3] as $values) { ?>
																								<td>
																									<select name="length_hifu[]" class="form-control">
																										<option value="-1">Select</option>
																										<option value="half" <?= ($values['length'] == "half") ? "selected" : ""; ?>>half</option>
																										<option value="full" <?= ($values['length'] == "full") ? "selected" : ""; ?>>full</option>
																										<option value="one shot" <?= ($values['length'] == "one shot") ? "selected" : ""; ?>>one shot</option>
																										<option value="autoshot" <?= ($values['length'] == "autoshot") ? "selected" : ""; ?>>autoshot</option>
																									</select>
																								</td>
																						<?php }
																						} ?>
																					</tr>
																					<tr>
																						<td>Spacing/ Speed</td>
																						<?php if (isset($result[3]) and $result[3] != false) {
																							foreach ($result[3] as $values) { ?>
																								<td>
																									<select name="spacing_hifu[]" class="form-control">
																										<option value="-1">Select</option>
																										<option value="1.0" <?= ($values['spacing'] == "1.0") ? "selected" : ""; ?>>1.0</option>
																										<option value="1.5" <?= ($values['spacing'] == "1.5") ? "selected" : ""; ?>>1.5</option>
																										<option value="2.0" <?= ($values['spacing'] == "2.0") ? "selected" : ""; ?>>2.0</option>
																										<option value="3.0" <?= ($values['spacing'] == "3.0") ? "selected" : ""; ?>>3.0</option>
																										<option value="0.1" <?= ($values['spacing'] == "0.1") ? "selected" : ""; ?>>0.1</option>
																										<option value="0.2" <?= ($values['spacing'] == "0.2") ? "selected" : ""; ?>>0.2</option>
																										<option value="0.3" <?= ($values['spacing'] == "0.3") ? "selected" : ""; ?>>0.3</option>
																										<option value="0.4" <?= ($values['spacing'] == "0.4") ? "selected" : ""; ?>>0.4</option>
																										<option value="0.5" <?= ($values['spacing'] == "0.5") ? "selected" : ""; ?>>0.5</option>
																									</select>
																								</td>
																						<?php }
																						} ?>
																					</tr>
																					<tr>
																						<td>Count</td>
																						<?php if (isset($result[3]) and $result[3] != false) {
																							foreach ($result[3] as $values) { ?>
																								<td><input type="text" name="count_hifu[]" class="form-control" value="<?= $values['count'] ?>"></td>
																						<?php }
																						} ?>
																					</tr>
																				</table>
																			</div>

																			<button class="accordion <?php if (in_array("4", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_elite">Elite <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("4", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_elite" id="check_elite" value="<?php if (in_array("4", $check_array)) {
																																					echo "1";
																																				} else {
																																					echo "0";
																																				} ?>">
																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Indication</label>
																							<?php $indication_main_array = explode(',', $result[4][0]['indication_main']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="indication_main_elite[]" id="nose" value="1" <?php if (in_array('1', $indication_main_array)) {
																																												echo "checked";
																																											} ?>> Laser Hair Removal
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="indication_main_elite[]" id="nose" value="2" <?php if (in_array('2', $indication_main_array)) {
																																												echo "checked";
																																											} ?>> Laser for Veins
																							</label>
																						</div>
																					</div>
																				</div>

																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Skin Type</label>
																							<?php $skin_type_main_array = explode(',', $result[4][0]['skin_type_main']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_elite[]" id="skin_type" value="1" <?php if (in_array('1', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type I
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_elite[]" id="skin_type" value="2" <?php if (in_array('2', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type II
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_elite[]" id="skin_type" value="3" <?php if (in_array('3', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type III
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_elite[]" id="skin_type" value="4" <?php if (in_array('4', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type IV
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_elite[]" id="skin_type" value="5" <?php if (in_array('5', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type V
																							</label>
																							<div class="d-flex flex-row align-items-center">
																								<label class="checkbox-inline">
																									<input type="checkbox" name="skin_type_main_elite[]" id="skin_type" value="6" <?php if (in_array('6', $skin_type_main_array)) {
																																														echo "checked";
																																													} ?>> Specify
																								</label>
																								<input type="text" class="form-control ml-1" name="specify_elite" size="15" style="max-width: 150px;" value="<?= $result[4][0]['specify_derma']; ?>">
																							</div>
																						</div>
																					</div>
																				</div>

																				<div class="form-group mt-2">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Skin reaction</label>
																							<?php $skin_reaction_array = explode(',', $result[4][0]['skin_reaction']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_reaction_elite[]" id="nose" value="1" <?php if (in_array('1', $skin_reaction_array)) {
																																											echo "checked";
																																										} ?>> Positive
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_reaction_elite[]" id="nose" value="2" <?php if (in_array('2', $skin_reaction_array)) {
																																											echo "checked";
																																										} ?>> Negative
																							</label>
																						</div>
																					</div>
																				</div>

																				<table class="table table-bordered" id="elite_table" style="width: 100%">
																					<tr>
																						<td>Area</td>
																						<?php if (isset($result[4]) and $result[4] != false) {
																							foreach ($result[4] as $values) {
																								echo '<td><input type="text" name="area_elite[]" id="area_derma-5" class="form-control derma_auto" value="' . $values['area'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Wavelength</td>
																						<?php if (isset($result[4]) and $result[4] != false) {
																							foreach ($result[4] as $values) { ?>
																								<td>
																									<select name="wavelength_elite[]" class="form-control">
																										<option value="755" <?= ($values['wavelength'] == "755") ? "selected" : ""; ?>>755</option>
																										<option value="1064" <?= ($values['wavelength'] == "1064") ? "selected" : ""; ?>>1064</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>

																					</tr>
																					<tr>
																						<td>Spot Size</td>
																						<?php if (isset($result[4]) and $result[4] != false) {
																							foreach ($result[4] as $values) { ?>
																								<td>
																									<select name="spot_size_elite[]" class="form-control">
																										<option value="3" <?= ($values['spot_size'] == "3") ? "selected" : ""; ?>>3</option>
																										<option value="5" <?= ($values['spot_size'] == "5") ? "selected" : ""; ?>>5</option>
																										<option value="7" <?= ($values['spot_size'] == "7") ? "selected" : ""; ?>>7</option>
																										<option value="10" <?= ($values['spot_size'] == "10") ? "selected" : ""; ?>>10</option>
																										<option value="12" <?= ($values['spot_size'] == "12") ? "selected" : ""; ?>>12</option>
																										<option value="15" <?= ($values['spot_size'] == "15") ? "selected" : ""; ?>>15</option>
																										<option value="18" <?= ($values['spot_size'] == "18") ? "selected" : ""; ?>>18</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Fluence</td>
																						<?php if (isset($result[4]) and $result[4] != false) {
																							foreach ($result[4] as $values) {
																								echo '<td><input type="text" name="fluence_elite[]" id="fluence_derma-5" class="form-control" value="' . $values['fluence'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Pulse</td>
																						<?php if (isset($result[4]) and $result[4] != false) {
																							foreach ($result[4] as $values) { ?>
																								<td>
																									<select name="pulse_elite[]" class="form-control">
																										<option value="5" <?= ($values['pulse'] == "5") ? "selected" : ""; ?>>5</option>
																										<option value="10" <?= ($values['pulse'] == "10") ? "selected" : ""; ?>>10</option>
																										<option value="15" <?= ($values['pulse'] == "15") ? "selected" : ""; ?>>15</option>
																										<option value="20" <?= ($values['pulse'] == "20") ? "selected" : ""; ?>>20</option>
																										<option value="25" <?= ($values['pulse'] == "25") ? "selected" : ""; ?>>25</option>
																										<option value="30" <?= ($values['pulse'] == "30") ? "selected" : ""; ?>>30</option>
																										<option value="40" <?= ($values['pulse'] == "40") ? "selected" : ""; ?>>40</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Rep Rate</td>
																						<?php if (isset($result[4]) and $result[4] != false) {
																							foreach ($result[4] as $values) { ?>
																								<td>
																									<select name="rep_rate_elite[]" class="form-control">
																										<option value="SGL" <?= ($values['rep_rate'] == "SGL") ? "selected" : ""; ?>>SGL</option>
																										<option value="1" <?= ($values['rep_rate'] == "1") ? "selected" : ""; ?>>1</option>
																										<option value="1.5" <?= ($values['rep_rate'] == "1.5") ? "selected" : ""; ?>>1.5</option>
																										<option value="2.0" <?= ($values['rep_rate'] == "2.0") ? "selected" : ""; ?>>2.0</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Count</td>
																						<?php if (isset($result[4]) and $result[4] != false) {
																							foreach ($result[4] as $values) {
																								echo '<td><input type="text" name="count_elite[]" id="count_derma-5" class="form-control" value="' . $values['count'] . '"></td>';
																							}
																						} ?>
																					</tr>

																				</table>
																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_elite"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_elite"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button><br><br><br><br>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("13", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_acclaim">Acclaim <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("13", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_acclaim" id="check_acclaim" value="<?php if (in_array("13", $check_array)) {
																																						echo "1";
																																					} else {
																																						echo "0";
																																					} ?>">
																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Indication</label>
																							<?php $indication_main_array = explode(',', $result[13][0]['indication_main']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="indication_main_acclaim[]" id="nose" value="1" <?php if (in_array('1', $indication_main_array)) {
																																												echo "checked";
																																											} ?>> Laser Hair Removal
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="indication_main_acclaim[]" id="nose" value="2" <?php if (in_array('2', $indication_main_array)) {
																																												echo "checked";
																																											} ?>> Laser for Veins
																							</label>
																						</div>
																					</div>
																				</div>

																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Skin Type</label>
																							<?php $skin_type_main_array = explode(',', $result[13][0]['skin_type_main']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_acclaim[]" id="skin_type" value="1" <?php if (in_array('1', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type I
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_acclaim[]" id="skin_type" value="2" <?php if (in_array('2', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type II
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_acclaim[]" id="skin_type" value="3" <?php if (in_array('3', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type III
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_acclaim[]" id="skin_type" value="4" <?php if (in_array('4', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type IV
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_acclaim[]" id="skin_type" value="5" <?php if (in_array('5', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type V
																							</label>
																							<div class="d-flex flex-row align-items-center">
																								<label class="checkbox-inline">
																									<input type="checkbox" name="skin_type_main_acclaim[]" id="skin_type" value="6" <?php if (in_array('6', $skin_type_main_array)) {
																																														echo "checked";
																																													} ?>> Specify
																								</label>
																								<input type="text" name="specify_acclaim" class="form-control ml-1" style="max-width: 150px;" size="15" value="<?= $result[13][0]['specify_derma']; ?>">
																							</div>
																						</div>
																					</div>
																				</div>

																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Skin reaction</label>
																							<?php $skin_reaction_array = explode(',', $result[13][0]['skin_reaction']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_reaction_acclaim[]" id="nose" value="1" <?php if (in_array('1', $skin_reaction_array)) {
																																												echo "checked";
																																											} ?>> Positive
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_reaction_acclaim[]" id="nose" value="2" <?php if (in_array('2', $skin_reaction_array)) {
																																												echo "checked";
																																											} ?>> Negative
																							</label>
																						</div>
																					</div>
																				</div>

																				<table class="table table-bordered" id="acclaim_table" style="width: 100%">
																					<tr>
																						<td>Area</td>
																						<?php if (isset($result[13]) and $result[13] != false) {
																							foreach ($result[13] as $values) {
																								echo '<td><input type="text" name="area_acclaim[]" id="area_derma-5" class="form-control derma_auto" value="' . $values['area'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Wavelength</td>
																						<?php if (isset($result[13]) and $result[13] != false) {
																							foreach ($result[13] as $values) { ?>
																								<td>
																									<select name="wavelength_acclaim[]" class="form-control">
																										<option value="755" <?= ($values['wavelength'] == "755") ? "selected" : ""; ?>>755</option>
																										<option value="1064" <?= ($values['wavelength'] == "1064") ? "selected" : ""; ?>>1064</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>

																					</tr>
																					<tr>
																						<td>Spot Size</td>
																						<?php if (isset($result[13]) and $result[13] != false) {
																							foreach ($result[13] as $values) { ?>
																								<td>
																									<select name="spot_size_acclaim[]" class="form-control">
																										<option value="3" <?= ($values['spot_size'] == "3") ? "selected" : ""; ?>>3</option>
																										<option value="5" <?= ($values['spot_size'] == "5") ? "selected" : ""; ?>>5</option>
																										<option value="7" <?= ($values['spot_size'] == "7") ? "selected" : ""; ?>>7</option>
																										<option value="10" <?= ($values['spot_size'] == "10") ? "selected" : ""; ?>>10</option>
																										<option value="12" <?= ($values['spot_size'] == "12") ? "selected" : ""; ?>>12</option>
																										<option value="15" <?= ($values['spot_size'] == "15") ? "selected" : ""; ?>>15</option>
																										<option value="18" <?= ($values['spot_size'] == "18") ? "selected" : ""; ?>>18</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Fluence</td>
																						<?php if (isset($result[13]) and $result[13] != false) {
																							foreach ($result[13] as $values) {
																								echo '<td><input type="text" name="fluence_acclaim[]" id="fluence_derma-5" class="form-control" value="' . $values['fluence'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Pulse</td>
																						<?php if (isset($result[13]) and $result[13] != false) {
																							foreach ($result[13] as $values) { ?>
																								<td>
																									<select name="pulse_acclaim[]" class="form-control">
																										<option value="5" <?= ($values['pulse'] == "5") ? "selected" : ""; ?>>5</option>
																										<option value="10" <?= ($values['pulse'] == "10") ? "selected" : ""; ?>>10</option>
																										<option value="15" <?= ($values['pulse'] == "15") ? "selected" : ""; ?>>15</option>
																										<option value="20" <?= ($values['pulse'] == "20") ? "selected" : ""; ?>>20</option>
																										<option value="25" <?= ($values['pulse'] == "25") ? "selected" : ""; ?>>25</option>
																										<option value="30" <?= ($values['pulse'] == "30") ? "selected" : ""; ?>>30</option>
																										<option value="40" <?= ($values['pulse'] == "40") ? "selected" : ""; ?>>40</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Rep Rate</td>
																						<?php if (isset($result[13]) and $result[13] != false) {
																							foreach ($result[13] as $values) { ?>
																								<td>
																									<select name="rep_rate_acclaim[]" class="form-control">
																										<option value="SGL" <?= ($values['rep_rate'] == "SGL") ? "selected" : ""; ?>>SGL</option>
																										<option value="1" <?= ($values['rep_rate'] == "1") ? "selected" : ""; ?>>1</option>
																										<option value="1.5" <?= ($values['rep_rate'] == "1.5") ? "selected" : ""; ?>>1.5</option>
																										<option value="2.0" <?= ($values['rep_rate'] == "2.0") ? "selected" : ""; ?>>2.0</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Count</td>
																						<?php if (isset($result[13]) and $result[13] != false) {
																							foreach ($result[13] as $values) {
																								echo '<td><input type="text" name="count_acclaim[]" id="count_derma-5" class="form-control" value="' . $values['count'] . '"></td>';
																							}
																						} ?>
																					</tr>

																				</table>
																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_acclaim"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_acclaim"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button><br><br><br><br>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("14", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_apogee">Apogee <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("14", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_apogee" id="check_apogee" value="<?php if (in_array("14", $check_array)) {
																																						echo "1";
																																					} else {
																																						echo "0";
																																					} ?>">
																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Indication</label>
																							<?php $indication_main_array = explode(',', $result[14][0]['indication_main']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="indication_main_apogee[]" id="nose" value="1" <?php if (in_array('1', $indication_main_array)) {
																																												echo "checked";
																																											} ?>> Laser Hair Removal
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="indication_main_apogee[]" id="nose" value="2" <?php if (in_array('2', $indication_main_array)) {
																																												echo "checked";
																																											} ?>> Laser for Veins
																							</label>
																						</div>
																					</div>
																				</div>

																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Skin Type</label>
																							<?php $skin_type_main_array = explode(',', $result[14][0]['skin_type_main']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_apogee[]" id="skin_type" value="1" <?php if (in_array('1', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type I
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_apogee[]" id="skin_type" value="2" <?php if (in_array('2', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type II
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_apogee[]" id="skin_type" value="3" <?php if (in_array('3', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type III
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_apogee[]" id="skin_type" value="4" <?php if (in_array('4', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type IV
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_type_main_apogee[]" id="skin_type" value="5" <?php if (in_array('5', $skin_type_main_array)) {
																																													echo "checked";
																																												} ?>> Type V
																							</label>
																							<div class="d-flex flex-row align-items-center">
																								<label class="checkbox-inline">
																									<input type="checkbox" name="skin_type_main_apogee[]" id="skin_type" value="6" <?php if (in_array('6', $skin_type_main_array)) {
																																														echo "checked";
																																													} ?>> Specify
																								</label>
																								<input type="text" name="specify_apogee" class="form-control ml-1" style="max-width: 150px;" size="15" value="<?= $result[14][0]['specify_derma']; ?>">
																							</div>
																						</div>
																					</div>
																				</div>

																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Skin reaction</label>
																							<?php $skin_reaction_array = explode(',', $result[14][0]['skin_reaction']); ?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_reaction_apogee[]" id="nose" value="1" <?php if (in_array('1', $skin_reaction_array)) {
																																												echo "checked";
																																											} ?>> Positive
																							</label>
																							<label class="checkbox-inline" style="margin-right: 40px;">
																								<input type="checkbox" name="skin_reaction_apogee[]" id="nose" value="2" <?php if (in_array('2', $skin_reaction_array)) {
																																												echo "checked";
																																											} ?>> Negative
																							</label>
																						</div>
																					</div>
																				</div>

																				<table class="table table-bordered" id="apogee_table" style="width: 100%">
																					<tr>
																						<td>Area</td>
																						<?php if (isset($result[14]) and $result[14] != false) {
																							foreach ($result[14] as $values) {
																								echo '<td><input type="text" name="area_apogee[]" id="area_derma-5" class="form-control derma_auto" value="' . $values['area'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Wavelength</td>
																						<?php if (isset($result[14]) and $result[14] != false) {
																							foreach ($result[14] as $values) { ?>
																								<td>
																									<select name="wavelength_apogee[]" class="form-control">
																										<option value="755" <?= ($values['wavelength'] == "755") ? "selected" : ""; ?>>755</option>
																										<option value="1064" <?= ($values['wavelength'] == "1064") ? "selected" : ""; ?>>1064</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>

																					</tr>
																					<tr>
																						<td>Spot Size</td>
																						<?php if (isset($result[14]) and $result[14] != false) {
																							foreach ($result[14] as $values) { ?>
																								<td>
																									<select name="spot_size_apogee[]" class="form-control">
																										<option value="3" <?= ($values['spot_size'] == "3") ? "selected" : ""; ?>>3</option>
																										<option value="5" <?= ($values['spot_size'] == "5") ? "selected" : ""; ?>>5</option>
																										<option value="7" <?= ($values['spot_size'] == "7") ? "selected" : ""; ?>>7</option>
																										<option value="10" <?= ($values['spot_size'] == "10") ? "selected" : ""; ?>>10</option>
																										<option value="12" <?= ($values['spot_size'] == "12") ? "selected" : ""; ?>>12</option>
																										<option value="15" <?= ($values['spot_size'] == "15") ? "selected" : ""; ?>>15</option>
																										<option value="18" <?= ($values['spot_size'] == "18") ? "selected" : ""; ?>>18</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Fluence</td>
																						<?php if (isset($result[14]) and $result[14] != false) {
																							foreach ($result[14] as $values) {
																								echo '<td><input type="text" name="fluence_apogee[]" id="fluence_derma-5" class="form-control" value="' . $values['fluence'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Pulse</td>
																						<?php if (isset($result[14]) and $result[14] != false) {
																							foreach ($result[14] as $values) { ?>
																								<td>
																									<select name="pulse_apogee[]" class="form-control">
																										<option value="5" <?= ($values['pulse'] == "5") ? "selected" : ""; ?>>5</option>
																										<option value="10" <?= ($values['pulse'] == "10") ? "selected" : ""; ?>>10</option>
																										<option value="15" <?= ($values['pulse'] == "15") ? "selected" : ""; ?>>15</option>
																										<option value="20" <?= ($values['pulse'] == "20") ? "selected" : ""; ?>>20</option>
																										<option value="25" <?= ($values['pulse'] == "25") ? "selected" : ""; ?>>25</option>
																										<option value="30" <?= ($values['pulse'] == "30") ? "selected" : ""; ?>>30</option>
																										<option value="40" <?= ($values['pulse'] == "40") ? "selected" : ""; ?>>40</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Rep Rate</td>
																						<?php if (isset($result[14]) and $result[14] != false) {
																							foreach ($result[14] as $values) { ?>
																								<td>
																									<select name="rep_rate_apogee[]" class="form-control">
																										<option value="SGL" <?= ($values['rep_rate'] == "SGL") ? "selected" : ""; ?>>SGL</option>
																										<option value="1" <?= ($values['rep_rate'] == "1") ? "selected" : ""; ?>>1</option>
																										<option value="1.5" <?= ($values['rep_rate'] == "1.5") ? "selected" : ""; ?>>1.5</option>
																										<option value="2.0" <?= ($values['rep_rate'] == "2.0") ? "selected" : ""; ?>>2.0</option>
																									</select>
																								</td>
																						<?php
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Count</td>
																						<?php if (isset($result[14]) and $result[14] != false) {
																							foreach ($result[14] as $values) {
																								echo '<td><input type="text" name="count_apogee[]" id="count_derma-5" class="form-control" value="' . $values['count'] . '"></td>';
																							}
																						} ?>
																					</tr>

																				</table>
																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_apogee"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_apogee"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button><br><br><br><br>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("5", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_filler">Filler <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("5", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_filler" id="check_filler" value="<?php if (in_array("5", $check_array)) {
																																						echo "1";
																																					} else {
																																						echo "0";
																																					} ?>">
																				<table class="table table-bordered" id="filler_table" style="width: 100%">
																					<tr>
																						<td>Area</td>
																						<?php if (isset($result[5]) and $result[5] != false) {
																							foreach ($result[5] as $values) {
																								echo '<td><input type="text" name="area_filler[]" id="area_derma-7" class="form-control derma_auto" value="' . $values['area'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Name of Filler</td>
																						<?php if (isset($result[5]) and $result[5] != false) {
																							foreach ($result[5] as $values) {
																								echo '<td><input type="text" name="filler_filler[]" id="filler_derma-6" class="form-control derma_auto" value="' . $values['filler'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Quantity</td>
																						<?php if (isset($result[5]) and $result[5] != false) {
																							foreach ($result[5] as $values) {
																								echo '<td><input type="text" name="quantity_filler[]" id="quantity_derma" class="form-control" value="' . $values['quantity'] . '"></td>';
																							}
																						} ?>
																					</tr>

																				</table>


																				<input type="hidden" id="filler_up_image" name="filler_up_image" value="<?php echo $result[5][0]['filler_mark']; ?>">
																				<div class="row">
																					<div class="col-md-12">
																						<div class="row">
																							<div class="col-md-5">
																								<div style="width: 300px; height: 350px; margin: 0 auto;">
																									<canvas id="faces" width="300" height="350" onmousedown="draws(event)"></canvas>
																								</div>
																							</div>
																							<div class="col-md-4 d-flex">
																								<div class="form-group d-flex flex-row justify-content-center align-items-center">
																									<input type="text" class="form-control form-control-sm" style="max-width: 150px;" id="canvas_inputs"></input>
																									<button type="button" class="btn btn-dark btn-sm ml-1" id="canvas_buttons"><i class="fa fa-check-circle-o" aria-hidden="true"></i> Ok</button>
																									<button type="reset" class="btn btn-dark btn-sm ml-1" onclick="draws();"><i class="fa fa-refresh" aria-hidden="true"></i> Clear Dots</button>
																									<input type="hidden" id="x-coors"><input type="hidden" id="y-coors">
																									<input type="hidden" class="form-control" name="imagepathsxf" id="imagepathsxf">
																								</div>
																							</div>
																						</div>
																					</div>
																				</div>

																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_filler"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_filler"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button><br><br>
																				</p>
																			</div>
																			<script>
																				draws();

																				function draws(e) {


																					var el = document.getElementById('faces');
																					var ctx = el.getContext('2d');
																					var img = new Image();
																					var isDrawing;
																					var filler_up_image = $("#filler_up_image").val();

																					img.onload = function() {
																						ctx.drawImage(img, 0, 0, 300, 350);
																						el.onmousedown = function(e) {
																							var pos = getMousePos(el, e);
																							posx = pos.x;
																							posy = pos.y;
																							if (e.which == 1) {
																								ctx.fillStyle = "black";
																								ctx.fillRect(posx, posy, 5, 5);
																								$("#x-coors").val(posx);
																								$("#y-coors").val(posy);
																							}
																							if (e.which == 3) {
																								ctx.clearRect(posx, posy, 10, 10);
																							}
																						};

																						$("#canvas_buttons").click(function() {
																							var canvas_text = $("#canvas_inputs").val();
																							var x_coor = +$("#x-coors").val() - 2;
																							var y_coor = +$("#y-coors").val() - 7;



																							ctx.fillStyle = "blue";
																							ctx.font = "12px Arial";
																							ctx.fillText(canvas_text, x_coor, y_coor);

																							var canvasData = faces.toDataURL("image/png");
																							$('input[name=imagepathsxf').val(canvasData);
																						});

																					};

																					if (filler_up_image == '') {
																						img.src = '<?= base_url('Images/face.jpg') ?>';
																					} else {
																						img.src = '<?= base_url('/'.UPLOAD_PATH.'derma/filler/') ?>' + filler_up_image;
																					}

																				}

																				function getMousePos(el, evt) {
																					var rect = el.getBoundingClientRect();
																					return {
																						x: evt.clientX - rect.left,
																						y: evt.clientY - rect.top
																					};
																				}
																			</script>

																			<button class="accordion <?php if (in_array("6", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_botox">Botox <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("6", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_botox" id="check_botox" value="<?php if (in_array("6", $check_array)) {
																																					echo "1";
																																				} else {
																																					echo "0";
																																				} ?>">
																				<div class="form-group">
																					<div class="row">
																						<div class="col-md-2">
																							<label class="font-weight-bold">Area</label>
																							<?php $botox_array = explode(',', $result[6][0]['botox']);
																							$botox_image = $result[6][0]['botox_mark'];
																							?>
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="1" <?php if (in_array('1', $botox_array)) {
																																											echo "checked";
																																										} ?>> Forehead lines
																							</label>
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="2" <?php if (in_array('2', $botox_array)) {
																																											echo "checked";
																																										} ?>> Frown or Globellar lines
																							</label>
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="3" <?php if (in_array('3', $botox_array)) {
																																											echo "checked";
																																										} ?>> Eyebrow Lift
																							</label>
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="4" <?php if (in_array('4', $botox_array)) {
																																											echo "checked";
																																										} ?>> Crow's Feet
																							</label>
																							<label class="checkbox-inline">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="5" <?php if (in_array('5', $botox_array)) {
																																											echo "checked";
																																										} ?>> Bunny or Nasalis Lines
																							</label>
																						</div>
																					</div>

																					<div class="row">
																						<div class="col-md-2">
																						</div>
																						<div class="col-md-10">
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="6" <?php if (in_array('6', $botox_array)) {
																																											echo "checked";
																																										} ?>> Dimpled Chin
																							</label>
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="7" <?php if (in_array('7', $botox_array)) {
																																											echo "checked";
																																										} ?>> Smile Lift
																							</label>
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="8" <?php if (in_array('8', $botox_array)) {
																																											echo "checked";
																																										} ?>> Neck
																							</label>
																							<label class="checkbox-inline" style="margin-right: 20px;">
																								<input type="checkbox" name="botox_botox[]" id="botox_derma" value="9" <?php if (in_array('9', $botox_array)) {
																																											echo "checked";
																																										} ?>> Underarms
																							</label>
																							<div class="d-flex flex-row align-items-center">
																								<label class="checkbox-inline">
																									<input type="checkbox" name="botox_botox[]" id="botox_derma" value="10" <?php if (in_array('10', $botox_array)) {
																																												echo "checked";
																																											} ?>> Specify
																								</label>
																								<input type="text" name="specify_botox" class="form-control ml-1" style="max-width: 150px;" size="15" value="<?= $result[6][0]['specify_derma'] ?>">
																							</div>
																						</div>
																					</div>
																				</div>

																				<div class="row mt-2">
																					<div class="col-md-2">
																						<label class="font-weight-bold">ML</label>
																					</div>
																					<div class="col-md-10">
																						<input type="text" name="ml_botox" id="ml_derma" class="form-control" style="max-width: 150px;" value="<?= $result[6][0]['ml'] ?>">
																					</div>
																				</div>

																				<input type="hidden" id="botox_up_image" name="botox_up_image" value="<?= $result[6][0]['botox_mark']; ?>">
																				<input type="hidden" class="form-control" name="botox_image" id="botox_image" value=<?php echo $botox_image; ?>>

																				<div class="row">
																					<div class="col-md-12">
																						<div class="row">
																							<div class="col-md-5">
																								<div style="width: 300px; height: 350px;margin:0 auto;">
																									<canvas id="facesb" width="300" height="350" onmousedown="drawsb(event)"></canvas>
																								</div>
																							</div>
																							<div class="col-md-4 d-flex">
																								<div class="form-group d-flex flex-row justify-content-center align-items-center">
																									<input type="text" class="form-control form-control-sm" style="max-width: 150px;" id="canvas_inputsb"></input> 
																									<button type="button" class="btn btn-dark btn-sm ml-1" id="canvas_buttonsb"><i class="fa fa-check-circle-o" aria-hidden="true"></i> Ok</button>
																									<button type="reset" class="btn btn-dark btn-sm ml-1" onclick="drawsb();"><i class="fa fa-refresh" aria-hidden="true"></i> Clear Dots</button>
	
																									<input type="hidden" id="x-coorsb"><input type="hidden" id="y-coorsb">
																									<input type="hidden" class="form-control" name="imagepathsx" id="imagepathsx">
																								</div>
																							</div>
																						</div>
																					</div>
																				</div>
																				
																			</div>

																			<script>
																				drawsb();

																				function drawsb(e) {

																					var el = document.getElementById('facesb');
																					var ctx = el.getContext('2d');

																					var ctx;
																					var img = new Image();
																					var isDrawing;
																					var botox_up_image = $("#botox_up_image").val();

																					img.onload = function() {
																						ctx.drawImage(img, 0, 0, 300, 350);
																						el.onmousedown = function(e) {
																							var pos = getMousePos(el, e);
																							posx = pos.x;
																							posy = pos.y;
																							if (e.which == 1) {
																								ctx.fillStyle = "black";
																								ctx.fillRect(posx, posy, 5, 5);
																								$("#x-coorsb").val(posx);
																								$("#y-coorsb").val(posy);
																							}
																							if (e.which == 3) {
																								ctx.clearRect(posx, posy, 10, 10);
																							}
																						};

																						$("#canvas_buttonsb").click(function() {

																							var canvas_text = $("#canvas_inputsb").val();
																							var x_coor = +$("#x-coorsb").val() - 2;
																							var y_coor = +$("#y-coorsb").val() - 7;

																							ctx.fillStyle = "blue";
																							ctx.font = "12px Arial";
																							ctx.fillText(canvas_text, x_coor, y_coor);

																							var canvasData = facesb.toDataURL("image/png");

																							$('input[name=imagepathsx').val(canvasData);

																						});

																					};

																					if (botox_up_image == '') {
																						img.src = '<?= base_url('/Images/face.jpg') ?>';
																					} else {
																						img.src = '<?= base_url(''.UPLOAD_PATH.'derma/botox/') ?>' + botox_up_image;
																					}


																				}

																				function getMousePos(el, evt) {
																					var rect = el.getBoundingClientRect();
																					return {
																						x: evt.clientX - rect.left,
																						y: evt.clientY - rect.top
																					};
																				}
																			</script>

																			<button class="accordion <?php if (in_array("7", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_hydrafacial">Hydrafacial <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("7", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_hydrafacial" id="check_hydrafacial" value="<?php if (in_array("7", $check_array)) {
																																								echo "1";
																																							} else {
																																								echo "0";
																																							} ?>">
																				<div class="form-group">
																					<?php $hydrafacial_array = explode(',', $result[7][0]['hydrafacial']); ?>
																					<div class="checkbox">
																						<label class="font-weight-bold">
																							<input type="checkbox" value="1" name="hydrafacial_derma[]" <?php if (in_array('1', $hydrafacial_array)) {
																																							echo "checked";
																																						} ?>>
																							With Diamond Peel
																						</label>
																					</div>
																					<div class="checkbox">
																						<label class="font-weight-bold">
																							<input type="checkbox" value="2" name="hydrafacial_derma[]" <?php if (in_array('2', $hydrafacial_array)) {
																																							echo "checked";
																																						} ?>>
																							Without Diamond Peel
																						</label>
																					</div>
																					<div class="checkbox mt-2">
																						<label class="font-weight-bold">
																							<input type="checkbox" value="3" name="hydrafacial_derma[]" <?php if (in_array('3', $hydrafacial_array)) {
																																							echo "checked";
																																						} ?>>
																							Mesotherapy
																						</label>
																						<input type="text" class="form-control" style="max-width:200px" name="mesotherapy_hydrafacial" size="30" value="<?= $result[7][0]['mesotherapy'] ?>">
																					</div>
																					<div class="checkbox mt-2">
																						<label class="font-weight-bold">
																							<input type="checkbox" value="4" name="hydrafacial_derma[]" <?php if (in_array('4', $hydrafacial_array)) {
																																							echo "checked";
																																						} ?>>
																							Mask
																						</label>
																						<input type="text" class="form-control" style="max-width:200px" name="mask_hydrafacial" size="30" value="<?= $result[7][0]['mask'] ?>">
																					</div>
																					<div class="checkbox mt-2">
																						<label class="font-weight-bold">
																							<input type="checkbox" value="5" name="hydrafacial_derma[]" <?php if (in_array('5', $hydrafacial_array)) {
																																							echo "checked";
																																						} ?>>
																							PRP
																						</label>
																						<input type="text" class="form-control" style="max-width:200px" name="prp_hydrafacial" size="30" value="<?= $result[7][0]['prp'] ?>">
																					</div>
																				</div>
																			</div>

																			<button class="accordion <?php if (in_array("8", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_velashape">Velashape <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("8", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_velashape" id="check_velashape" value="<?php if (in_array("8", $check_array)) {
																																							echo "1";
																																						} else {
																																							echo "0";
																																						} ?>">
																				
																				<table class="table table-bordered" id="velashape_table" style="width: 80%">
																					<tr>
																						<td>Area</td>
																						<?php if (isset($result[8]) and $result[8] != false) {
																							foreach ($result[8] as $values) {
																								echo '<td>
																										<select name="area_velashape[]" class="form-control">
																										<option value="chin" ' . (($values['area'] == 'chin') ? "selected" : "") . '>chin</option>
																										<option value="abdomen" ' . (($values['area'] == 'abdomen') ? "selected" : "") . '>abdomen</option>
																										<option value="arms" ' . (($values['area'] == 'arms') ? "selected" : "") . '>arms</option>
																										<option value="thighs" ' . (($values['area'] == 'thighs') ? "selected" : "") . '>thighs</option>
																										<option value="buttocks" ' . (($values['area'] == 'buttocks') ? "selected" : "") . '>buttocks</option>
																										<option value="back" ' . (($values['area'] == 'back') ? "selected" : "") . '>back</option>
																										</select>
																									</td> ';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Measurement (cm)</td>
																						<?php if (isset($result[8]) and $result[8] != false) {
																							foreach ($result[8] as $values) {
																								echo '<td><input type="text" name="measurement_velashape[]" id="measurement_derma" class="form-control" value="' . $values['measurement'] . '"></td>';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Applicator</td>
																						<?php if (isset($result[8]) and $result[8] != false) {
																							foreach ($result[8] as $values) {
																								echo '<td>
																											<select name="applicator_velashape[]" class="form-control">
																											<option value="Vsmooth" ' . (($values['applicator'] == 'Vsmooth') ? "selected" : "") . '>Vsmooth</option>
																											<option value="Vcontour Large" ' . (($values['applicator'] == 'Vcontour Large') ? "selected" : "") . '>Vcontour Large</option>
																											<option value="Vcontour Medium" ' . (($values['applicator'] == 'Vcontour Medium') ? "selected" : "") . '>Vcontour Medium</option>
																											<option value="Vcontour Small" ' . (($values['applicator'] == 'Vcontour Small') ? "selected" : "") . '>Vcontour Small</option>
																											</select>
																										</td> ';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>IR</td>
																						<?php if (isset($result[8]) and $result[8] != false) {
																							foreach ($result[8] as $values) {
																								echo '<td>
																											<select name="ir_velashape[]" class="form-control">
																											<option value="1" ' . (($values['ir'] == '0') ? "selected" : "") . '>0</option>
																											<option value="1" ' . (($values['ir'] == '1') ? "selected" : "") . '>1</option>
																											<option value="2" ' . (($values['ir'] == '2') ? "selected" : "") . '>2</option>
																											<option value="3" ' . (($values['ir'] == '3') ? "selected" : "") . '>3</option>
																											</select>
																										</td> ';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>RF</td>
																						<?php if (isset($result[8]) and $result[8] != false) {
																							foreach ($result[8] as $values) {
																								echo '<td>
																											<select name="rf_velashape[]" class="form-control">
																											<option value="1" ' . (($values['rf'] == '1') ? "selected" : "") . '>1</option>
																											<option value="2" ' . (($values['rf'] == '2') ? "selected" : "") . '>2</option>
																											<option value="3" ' . (($values['rf'] == '3') ? "selected" : "") . '>3</option>
																											</select>
																										</td> ';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>VAC</td>
																						<?php if (isset($result[8]) and $result[8] != false) {
																							foreach ($result[8] as $values) {
																								echo '<td>
																										<select name="vac_velashape[]" class="form-control">
																										<option value="0" ' . (($values['vac'] == '0') ? "selected" : "") . '>0</option>
																										<option value="1" ' . (($values['vac'] == '1') ? "selected" : "") . '>1</option>
																										<option value="2" ' . (($values['vac'] == '2') ? "selected" : "") . '>2</option>
																										<option value="3" ' . (($values['vac'] == '3') ? "selected" : "") . '>3</option>
																										</select>
																									</td> ';
																							}
																						} ?>
																					</tr>
																					<tr>
																						<td>Duration (mins)</td>
																						<?php if (isset($result[8]) and $result[8] != false) {
																							foreach ($result[8] as $values) {
																								echo '<td><input type="text" name="duration_velashape[]" id="duration_derma" class="form-control" value="' . $values['duration'] . '"></td>';
																							}
																						} ?>
																					</tr>

																				</table>

																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_velashape"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_velashape"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button>
																				</p>
																			</div>


																			<button class="accordion <?php if (in_array("9", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_prp">PRP <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("9", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_prp" id="check_prp" value="<?php if (in_array("9", $check_array)) {
																																				echo "1";
																																			} else {
																																				echo "0";
																																			} ?>">
																				<input type="hidden" name="counter" id="counter" value="<?php if ($result[9]) {
																																			echo count($result[9]);
																																		} else {
																																			echo "0";
																																		} ?>">
																				<?php $ctr = 1; ?>
																				<?php if (isset($result[9]) and $result[9] != false) {
																					foreach ($result[9] as $values) { ?>
																						<table class="table table-bordered" id="prp_table" style="width: 100%">
																							<tr>
																								<td>Area</td>
																								<td><input type="text" name="area_prp[]" id="area_prp" class="form-control" value="<?php echo $values['area']; ?>"></td>
																							</tr>
																							<tr>
																								<td>PRP set</td>
																								<td><input type="text" name="prp_set[]" id="prp_set" class="form-control" value="<?php echo $values['prp_set']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Tubes</td>
																								<td><input type="text" name="tubes_prp[]" id="tubes_prp" class="form-control" value="<?php echo $values['tubes']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Vitamins</td>
																								<td>
																									<div class="row">
																										<div class="input_fields_wrap_prp col-md-12">
																											<div class="row">
																												<div class="col-md-8">
																													<div class="form-group">
																														<label class="font-weight-bold">NAME</label>
																														<input type="text" class="form-control" name="vitamin_name" id="vitamin_name">
																													</div>
																												</div>
																												<div class="col-md-4">
																													<div class="form-group">
																														<label class="font-weight-bold">ML</label>
																														<div class="input-group">
																															<input type="text" class="form-control" name="vitamin_ml" id="vitamin_ml">
																															<span class="input-group-addon">
																																<button type="button" class="btn btn-success btn-xs add_field_button_prp" id="add_drug_prp" value="<?= $ctr; ?>">+</button>
																																<button type="button" class="btn btn-warning btn-xs clear_field_prp" id="clear_field_prp">x</button>
																															</span>
																														</div>
																													</div>
																												</div>
																											</div>
																										</div>

																									</div>
																									<?php
																									$derma_sub_id = $values['derma_sub_id'];
																									$query = $this->db->query("SELECT * FROM tbl_treat_derma_vitamins WHERE derma_sub_id = '$derma_sub_id'");
																									$results = $query->result_array();

																									if ($results) {
																										foreach ($results as $val1) {
																									?>
																											<div class="xys">
																												<div class="row">
																													<div class="col-md-8">
																														<div class="form-group">
																															<input type="text" class="form-control" name="vitamin_name[]" value="<?php echo $val1['name']; ?>" id="vitamin_name" disabled>
																															<input type="hidden" class="form-control" name="vitamin_name-<?= $ctr ?>[]" value="<?php echo $val1['name']; ?>" id="vitamin_name">
																														</div>
																													</div>
																													<div class="col-md-4">
																														<div class="form-group">
																															<div class="input-group">
																																<input type="text" class="form-control" name="vitamin_ml[]" value="<?php echo $val1['ml']; ?>" id="vitamin_ml" disabled>
																																<input type="hidden" class="form-control" name="vitamin_ml-<?= $ctr ?>[]" value="<?php echo $val1['ml']; ?>" id="vitamin_ml">
																																<span class="input-group-addon">
																																	<button type="button" class="btn btn-light remove_field_prp" id="remove_drug_derma"><i class="fa fa-trash" aria-hidden="true"></i></button>
																																</span>
																															</div>
																														</div>
																													</div>
																												</div>
																											</div>

																									<?php }
																									} ?>
																								</td>
																							</tr>
																						</table>
																				<?php $ctr++;
																					}
																				} ?>



																				<div id="print_prp"></div>

																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_prp"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_prp"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("10", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_mesotherapy">Mesotherapy <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("10", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_mesotherapy" id="check_mesotherapy" value="<?php if (in_array("10", $check_array)) {
																																								echo "1";
																																							} else {
																																								echo "0";
																																							} ?>">
																				<input type="hidden" name="counter_mesotherapy" id="counter_mesotherapy" value="<?php if (isset($result[10])) {
																																									echo count($result[10]);
																																								} else {
																																									echo "0";
																																								} ?>">
																				<?php $ctr = 1; ?>
																				<?php if (isset($result[10]) and $result[10] != false) {
																					foreach ($result[10] as $values) { ?>
																						<table class="table table-bordered" id="mesotherapy_table" style="width: 100%">
																							<tr>
																								<td>Area</td>
																								<td><input type="text" name="area_mesotherapy[]" id="area_mesotherapy" class="form-control" value="<?php echo $values['area']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Vitamins</td>
																								<td>
																									<div class="row">
																										<div class="input_fields_wrap_mesotherapy col-md-12">
																											<div class="row">
																												<div class="col-md-8">
																													<div class="form-group">
																														<label class="font-weight-bold">NAME</label>
																														<input type="text" class="form-control" name="vitamin_name" id="vitamin_name">
																													</div>
																												</div>
																												<div class="col-md-4">
																													<div class="form-group">
																														<label class="font-weight-bold">ML</label>
																														<div class="input-group">
																															<input type="text" class="form-control" name="vitamin_ml" id="vitamin_ml">
																															<span class="input-group-addon">
																																<button type="button" class="btn btn-success btn-xs add_field_button_mesotherapy" id="add_drug_mesotherapy" value="<?= $ctr; ?>">+</button>
																																<button type="button" class="btn btn-warning btn-xs clear_field_mesotherapy" id="clear_field_mesotherapy">x</button>
																															</span>
																														</div>
																													</div>
																												</div>
																											</div>
																										</div>


																									</div>
																									<?php
																									$derma_sub_id = $values['derma_sub_id'];
																									$query = $this->db->query("SELECT * FROM tbl_treat_derma_vitamins WHERE derma_sub_id = '$derma_sub_id'");
																									$results = $query->result_array();

																									if ($results) {
																										foreach ($results as $val1) {
																									?>
																											<div class="xys">
																												<div class="row">
																													<div class="col-md-8">
																														<div class="form-group">
																															<input type="text" class="form-control" name="vitamin_name[]" value="<?php echo $val1['name']; ?>" id="vitamin_name" disabled>
																															<input type="hidden" class="form-control" name="vitamin_name_mesotherapy-<?= $ctr ?>[]" value="<?php echo $val1['name']; ?>" id="vitamin_name">
																														</div>
																													</div>
																													<div class="col-md-4">
																														<div class="form-group">
																															<div class="input-group">
																																<input type="text" class="form-control" name="vitamin_ml[]" value="<?php echo $val1['ml']; ?>" id="vitamin_ml" disabled>
																																<input type="hidden" class="form-control" name="vitamin_ml_mesotherapy-<?= $ctr ?>[]" value="<?php echo $val1['ml']; ?>" id="vitamin_ml">
																																<span class="input-group-addon ml-1">
																																	<button type="button" class="btn btn-light remove_field_mesotherapy" id="remove_drug_derma"><i class="fa fa-trash" aria-hidden="true"></i></button>
																																</span>
																															</div>
																														</div>
																													</div>
																												</div>
																											</div>
																									<?php }
																									} ?>
																								</td>
																							</tr>
																						</table>
																				<?php $ctr++;
																					}
																				} ?>


																				<div id="print_mesotherapy"></div>

																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_mesotherapy"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_mesotherapy"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("11", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_threading">Threading <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("11", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_threading" id="check_threading" value="<?php if (in_array("11", $check_array)) {
																																							echo "1";
																																						} else {
																																							echo "0";
																																						} ?>">
																				<input type="hidden" name="counter_threading" id="counter_threading" value="<?php if (isset($result[11])) {
																																								echo count($result[11]);
																																							} else {
																																								echo "0";
																																							} ?>">
																				<?php $ctr = 1; ?>
																				<?php if (isset($result[11]) and $result[11] != false) {
																					foreach ($result[11] as $values) { ?>
																						<table class="table table-bordered" id="threading_table" style="width: 100%">
																							<tr>
																								<td>Area</td>
																								<td><input type="text" name="area_threading[]" id="area_threading" class="form-control" value="<?php echo $values['area']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Name of Thread</td>
																								<td><input type="text" name="thread[]" id="thread" class="form-control" value="<?php echo $values['thread']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Size Description</td>
																								<td><input type="text" name="size_threading[]" id="size_threading" class="form-control" value="<?php echo $values['size']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Quantity</td>
																								<td><input type="text" name="quantity_threading[]" id="quantity_threading" class="form-control" value="<?php echo $values['quantity']; ?>"></td>
																							</tr>
																						</table>
																				<?php $ctr++;
																					}
																				} ?>


																				<div id="print_threading"></div>

																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_threading"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_threading"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("12", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_injections">Other Injections <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("12", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_injections" id="check_injections" value="<?php if (in_array("12", $check_array)) {
																																								echo "1";
																																							} else {
																																								echo "0";
																																							} ?>">
																				<input type="hidden" name="counter_injections" id="counter_injections" value="<?php if (isset($result[12])) {
																																									echo count($result[12]);
																																								} else {
																																									echo "0";
																																								} ?>">
																				<?php $ctr = 1; ?>
																				<?php if (isset($result[12]) and $result[12] != false) {
																					foreach ($result[12] as $values) { ?>
																						<table class="table table-bordered" id="injections_table" style="width: 100%">
																							<tr>
																								<td>Area</td>
																								<td><input type="text" name="area_injections[]" id="area_injections" class="form-control" value="<?php echo $values['area']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Name of Injections</td>
																								<td><input type="text" name="injection[]" id="injection" class="form-control" value="<?php echo $values['injection']; ?>"></td>
																							</tr>
																							<tr>
																								<td>Quantity</td>
																								<td><input type="text" name="quantity_injections[]" id="quantity_injections" class="form-control" value="<?php echo $values['quantity']; ?>"></td>
																							</tr>
																						</table>
																				<?php $ctr++;
																					}
																				} ?>

																				<div id="print_injections"></div>

																				<p>
																					<button type="button" class="btn btn-light btn-sm" id="addRow_injections"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																					<button type="button" class="btn btn-light btn-sm" id="delete_last_column_injections"><i class="fa fa-trash" aria-hidden="true"></i> Remove</button>
																				</p>
																			</div>

																			<button class="accordion <?php if (in_array("15", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_plastic">Plastic Surgery <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("15", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_plastic_surg" id="check_plastic_surg" value="<?php if (in_array("15", $check_array)) {
																																									echo "1";
																																								} else {
																																									echo "0";
																																								} ?>">
																				<input type="hidden" name="counter_plsurgery" id="counter_plsurgery" value="<?php if (isset($result[15])) {
																																								echo count($result[15]);
																																							} else {
																																								echo "0";
																																							} ?>">
																				<?php $ctr = 1; ?>
																				<?php if (isset($result[15]) and $result[15] != false) {

																					foreach ($result[15] as $values) {

																				?>
																						<div class="row">
																							<div class="col-md-12">
																								<div class="form-group">
																									<label class="font-weight-bold">Mark Area</label>
																								</div>
																								<input type="hidden" id="plastic_up_image" name="plastic_up_image" value="<?= $values['mark_iname']; ?>">
																								<div class="row">
																									<div class="col-md-8">
																										<div style="width: 580px; height: 522px">
																											<canvas id="face" width="580" height="522" onmousedown="facdraw(event)"></canvas>
																										</div>
																									</div>
																									<div class="col-md-4 d-flex">
																										<div class="form-group d-flex flex-row justify-content-center align-items-center">
																											<input type="text" class="form-control form-control-sm" id="canvas_input"></input>
																											<button type="button" class="btn btn-dark btn-sm" id="canvas_button"><i class="fa fa-check-circle-o" aria-hidden="true"></i> Ok</button>
																											<button type="reset" class="btn btn-dark btn-sm" onclick="facdraw();"><i class="fa fa-refresh" aria-hidden="true"></i> Clear Dots</button>
																											
																											<input type="hidden" id="x-coor"><input type="hidden" id="y-coor">
																										</div>
																									</div>
																								</div>

																								<div class="form-group">
																									<label class="font-weight-bold">Plastic Surgery</label>
																									<textarea class="form-control" name="pl_remark" id="pl_remark" rows="2" value=""><?php echo $values['pl_remark']; ?></textarea>
																									<input type="hidden" class="form-control" name="imagepath" id="imagepath">
																								</div>

																								<div class="col-md-6">
																									<div class="form-group">
																										<label style="color:red; font-weight: bolder;">Before Treatment</label>
																									</div>

																									<div class="form-group">
																										<img class="show_div" src="<?= base_url(''.UPLOAD_PATH.'derma/before/') . $values['before_iname']; ?>" alt="Before treatment - File not uploaded">
																										<input type="hidden" name="pl_before_old" value="<?php echo $values['before_iname']; ?>">
																									</div>
																								</div>
																								<div class="col-md-6">
																									<div class="form-group">
																										<label style="color:red; font-weight: bolder;">After Treatment</label>
																									</div>

																									<div class="form-group">
																										<img class="show_div" src="<?= base_url(''.UPLOAD_PATH.'derma/after/') . $values['after_iname']; ?>" alt="After treatment - File not uploaded">
																										<input type="hidden" name="pl_after_old" value="<?php echo $values['after_iname']; ?>">
																									</div>
																								</div>
																							</div>
																						</div>
																					<?php $ctr++;
																					}
																				} else {
																					?>
																					<div class="row">
																						<div class="col-md-12">
																							<div class="form-group">
																								<label class="font-weight-bold">Mark Area</label>
																							</div>

																							<div class="row">
																								<div class="col-md-8">
																									<div style="width: 580px; height: 522px; margin: 0 auto;">
																										<canvas id="face" width="580" height="522" onmousedown="facdraw(event)"></canvas>
																									</div>
																								</div>
																								<div class="col-md-4 d-flex">
																									<div class="form-group d-flex flex-row justify-content-center align-items-center">
																										<input type="text" id="canvas_input"></input> 
																										<button type="button" class="btn btn-sm btn-dark ml-1" id="canvas_button"><i class="fa fa-check-circle-o" aria-hidden="true"></i> Ok</button>
																										<button type="reset" class="btn btn-sm btn-dark  ml-1" onclick="facdraw();"><i class="fa fa-refresh" aria-hidden="true"></i> Clear Dots</button>
																										
																										<input type="hidden" id="x-coor"><input type="hidden" id="y-coor">
																									</div>
																								</div>
																							</div>


																							<div class="form-group">
																								<label class="font-weight-bold">Plastic Surgery</label>
																								<textarea class="form-control" name="pl_remark" id="pl_remark" rows="2"></textarea>
																								<input type="hidden" class="form-control" name="imagepath" id="imagepath">
																							</div>

																							<div class="row">
																								<div class="col-md-6">
																									<div class="form-group">
																										<label style="color:red; font-weight: bolder;">Before Treatment</label>
																									</div>
																									<div class="form-group">
																										<label for="exampleInputFile">Image Upload</label>
																										<input type="file" name="pl_before" id="pl_before">
																										<p class="help-block">Maximum image size 0.5mp</p>
																									</div>
																								</div>
																								<div class="col-md-6">
																									<div class="form-group">
																										<label style="color:red; font-weight: bolder;">After Treatment</label>
																									</div>
																									<div class="form-group">
																										<label for="exampleInputFile">Image Upload</label>
																										<input type="file" name="pl_after" id="pl_after">
																										<p class="help-block">Maximum image size 0.5mp</p>
																									</div>
																								</div>
																							</div>

																						</div>
																					</div>
																				<?php
																				}
																				?>

																				<div id="print_injections"></div>
																			</div>
																			<button class="accordion <?php if (in_array("16", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_laser">Laser <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("16", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_laser" id="check_laser" value="<?php if (in_array("16", $check_array)) {
																																					echo "1";
																																				} else {
																																					echo "0";
																																				} ?>">
																				<input type="hidden" name="counter_laser" id="counter_laser" value="<?php if (isset($result[16])) {
																																						echo count($result[16]);
																																					} else {
																																						echo "0";
																																					} ?>">


																				<?php $ctr = 1; ?>
																				<?php if (isset($result[16]) and $result[16] != false) {

																					foreach ($result[16] as $values) {
																						$laser_mechine = $values['laser_mechine'];
																						$laser_date = $values['laser_date'];
																						$laser_session = $values['sessions'];
																						$face_neck = $values['face_neck'];
																						$lip_line = $values['lip_line'];
																						$beard_line = $values['beard_line'];
																						$chest = $values['chest'];
																						$abdomen_laser = $values['abdomen_laser'];
																						$un_arms = $values['un_arms'];
																						$lasert_thigts = $values['lasert_thigts'];
																						$laser_legs = $values['laser_legs'];
																						$lasert_bikini = $values['lasert_bikini'];
																						$buttocks = $values['buttocks'];
																						$lasert_ear = $values['lasert_ear'];
																						$lasert_nose = $values['lasert_nose'];
																						$lasert_chin = $values['lasert_chin'];
																						$lasert_nipples = $values['lasert_nipples'];
																						$lasert_hand = $values['lasert_hand'];
																					}
																				} else {
																					$laser_date = '';
																					$laser_session = '';
																					$face_neck = '';
																					$lip_line = '';
																					$beard_line = '';
																					$chest = '';
																					$abdomen_laser = '';
																					$un_arms = '';
																					$lasert_thigts = '';
																					$laser_legs = '';
																					$lasert_bikini = '';
																					$buttocks = '';
																					$nurser_laser = '';
																					$lasert_ear = '';
																					$lasert_nose = '';
																					$lasert_chin = '';
																					$lasert_nipples = '';
																					$lasert_hand = '';
																				}

																				?>
																				<div class="row">
																					<div class="col-md-12">
																						<table class="table table-bordered" id="injections_table">
																							<tr>
																								<td>Machine</td>
																								<td>
																									<select name="laser_mechine" class="form-control">
																										<?php
																										if ($laser_mechine == 'Duetto Evo') {
																										?>
																											<option value="Duetto Evo" selected>Duetto Evo</option>
																											<option value="Candela">Candela</option>
																										<?php
																										} else {
																										?>
																											<option value="Duetto Evo">Duetto Evo</option>
																											<option value="Candela" selected>Candela</option>
																										<?php
																										}

																										?>
																									</select>
																								</td>
																							</tr>
																							<tr>
																								<td>Date</td>

																								<td><input type="text" name="laser_date" id="laser_date" class="form-control" value="<?php echo $laser_date; ?>"></td>
																							</tr>
																							<tr>
																								<td>Session</td>
																								<td><input type="text" name="laser_session" id="laser_session" class="form-control" value="<?php echo $laser_session; ?>"></td>
																							</tr>
																							<tr>
																								<td>Face/neck</td>
																								<td><input type="text" name="face_neck" id="face_neck" class="form-control" value="<?php echo $face_neck; ?>"></td>
																							</tr>
																							<tr>
																								<td>Lip/chin</td>
																								<td><input type="text" name="lip_line" id="lip_line" class="form-control" value="<?php echo $lip_line; ?>"></td>
																							</tr>
																							<tr>
																								<td>Beard Line</td>
																								<td><input type="text" name="beard_line" id="beard_line" class="form-control" value="<?php echo $beard_line; ?>"></td>
																							</tr>
																							<tr>
																								<td>chest</td>
																								<td><input type="text" name="chest" id="chest" class="form-control" value="<?php echo $chest; ?>"></td>
																							</tr>
																							<tr>
																								<td>abdomen</td>
																								<td><input type="text" name="abdomen_laser" id="abdomen_laser" class="form-control" value="<?php echo $abdomen_laser; ?>"></td>
																							</tr>
																							<tr>
																								<td>UN/Arms</td>
																								<td><input type="text" name="un_arms" id="un_arms" class="form-control" value="<?php echo $un_arms; ?>"></td>
																							</tr>
																							<tr>
																								<td>Thights</td>
																								<td><input type="text" name="lasert_thigts" id="lasert_thigts" class="form-control" value="<?php echo $lasert_thigts; ?>"></td>
																							</tr>
																							<tr>
																								<td>Legs</td>
																								<td><input type="text" name="laser_legs" id="laser_legs" class="form-control" value="<?php echo $laser_legs; ?>"></td>
																							</tr>
																							<tr>
																								<td>Buttocks</td>
																								<td><input type="text" name="buttocks" id="buttocks" class="form-control" value="<?php echo $buttocks; ?>"></td>
																							</tr>
																							<tr>
																								<td>Bikini</td>
																								<td><input type="text" name="lasert_bikini" id="lasert_bikini" class="form-control" value="<?php echo $lasert_bikini; ?>"></td>
																							</tr>
																							<tr>
																								<td>Ear</td>
																								<td><input type="text" name="lasert_ear" id="lasert_ear" class="form-control" value="<?php echo $lasert_ear; ?>"></td>
																							</tr>
																							<tr>
																								<td>Nose</td>
																								<td><input type="text" name="lasert_nose" id="lasert_nose" class="form-control" value="<?php echo $lasert_nose; ?>"></td>
																							</tr>
																							<tr>
																								<td>Chin</td>
																								<td><input type="text" name="lasert_chin" id="lasert_chin" class="form-control" value="<?php echo $lasert_chin; ?>"></td>
																							</tr>
																							<tr>
																								<td>Nipples</td>
																								<td><input type="text" name="lasert_nipples" id="lasert_nipples" class="form-control" value="<?php echo $lasert_nipples; ?>"></td>
																							</tr>
																							<tr>
																								<td>Hand</td>
																								<td><input type="text" name="lasert_hand" id="lasert_hand" class="form-control" value="<?php echo $lasert_hand; ?>"></td>
																							</tr>
																						</table>

																					</div>
																				</div>

																			</div>

																			<button class="accordion <?php if (in_array("17", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_secret">Secret RF <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<?php
																			$secret_array = explode(',', $result[17][0]['area']);


																			?>
																			<div class="panels" style="<?php if (in_array("16", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_secret" id="check_secret" value="<?php if (in_array("17", $check_array)) {
																																						echo "1";
																																					} else {
																																						echo "0";
																																					} ?>">
																				<input type="hidden" name="counter_secret" id="counter_secret" value="<?php if (isset($result[17])) {
																																							echo count($result[15]);
																																						} else {
																																							echo "0";
																																						} ?>">
																				<div class="row">
																					<div class="col-md-12">
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="secret_treat[]" id="secret_treat" value="1" <?php if (in_array('1', $secret_array)) {
																																											echo "checked";
																																										} ?>> face
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="secret_treat[]" id="secret_treat" value="2" <?php if (in_array('2', $secret_array)) {
																																											echo "checked";
																																										} ?>> Neck
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="secret_treat[]" id="secret_treat" value="3" <?php if (in_array('3', $secret_array)) {
																																											echo "checked";
																																										} ?>> Hand
																						</label>
																					</div>
																				</div>
																				<div class="row">
																					<div class="col-md-12">
																						<div class="form-group">
																							<label class="font-weight-bold">Note</label>
																							<textarea class="form-control" name="prog_secret_rf" id="prog_secret_rf" rows="4"><?php echo $result[17][0]['short_note']; ?></textarea>
																						</div>
																					</div>
																				</div>
																			</div>

																			<button class="accordion <?php if (in_array("18", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_dermapen">Derma Pen <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("18", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_dermapen" id="check_dermapen" value="<?php if (in_array("18", $check_array)) {
																																							echo "1";
																																						} else {
																																							echo "0";
																																						} ?>">
																				<input type="hidden" name="counter_dermapen" id="counter_dermapen" value="<?php if (isset($result[18])) {
																																								echo count($result[18]);
																																							} else {
																																								echo "0";
																																							} ?>">
																				<?php
																				$dermapen = explode(',', $result[18][0]['area']);
																				?>
																				<div class="row">
																					<div class="col-md-12">
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="derma_pen[]" id="derma_pen" value="1" <?php if (in_array('1', $dermapen)) {
																																									echo "checked";
																																								} ?>> face
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="derma_pen[]" id="derma_pen" value="2" <?php if (in_array('2', $dermapen)) {
																																									echo "checked";
																																								} ?>> Neck
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="derma_pen[]" id="derma_pen" value="3" <?php if (in_array('4', $dermapen)) {
																																									echo "checked";
																																								} ?>> Hand
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="derma_pen[]" id="derma_pen" value="4" <?php if (in_array('5', $dermapen)) {
																																									echo "checked";
																																								} ?>> Body Parts w/Scars
																						</label>
																					</div>
																				</div>
																				<div class="row">
																					<div class="col-md-12">
																						<div class="form-group">
																							<label class="font-weight-bold">Note</label>
																							<textarea class="form-control" name="prog_derma_pen" id="prog_derma_pen" rows="4"><?php echo $result[18][0]['short_note']; ?></textarea>
																						</div>
																					</div>
																				</div>
																			</div>

																			<button class="accordion <?php if (in_array("19", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_tattoo">Tattoo Removal <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<div class="panels" style="<?php if (in_array("19", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_tattoo" id="check_tattoo" value="<?php if (in_array("19", $check_array)) {
																																						echo "1";
																																					} else {
																																						echo "0";
																																					} ?>">
																				<input type="hidden" name="counter_tattoo" id="counter_tattoo" value="<?php if (isset($result[19])) {
																																							echo count($result[19]);
																																						} else {
																																							echo "0";
																																						} ?>">
																				<?php
																				$tattoo = explode(',', $result[19][0]['area']);
																				?>
																				<div class="row">
																					<div class="col-md-12">
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="tattoo_treat[]" id="tattoo_treat" value="1" <?php if (in_array('1', $tattoo)) {
																																											echo "checked";
																																										} ?>> Eyebrow
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="tattoo_treat[]" id="tattoo_treat" value="2" <?php if (in_array('2', $tattoo)) {
																																											echo "checked";
																																										} ?>> Other
																						</label>
																					</div>
																				</div>
																				<div class="row">
																					<div class="col-md-12">
																						<div class="form-group">
																							<label class="font-weight-bold">Note</label>
																							<textarea class="form-control" name="prog_tattoo" id="prog_tattoo" rows="4"><?php echo $result[19][0]['short_note']; ?></textarea>
																						</div>
																					</div>
																				</div>
																			</div>

																			<button class="accordion <?php if (in_array("20", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_carbon">Carbon <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<?php
																			$carbon = explode(',', $result[20][0]['area']);
																			?>
																			<div class="panels" style="<?php if (in_array("20", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_carbon" id="check_carbon" value="<?php if (in_array("20", $check_array)) {
																																						echo "1";
																																					} else {
																																						echo "0";
																																					} ?>">
																				<input type="hidden" name="counter_carbon" id="counter_carbon" value="<?php if (isset($result[20])) {
																																							echo count($result[20]);
																																						} else {
																																							echo "0";
																																						} ?>">
																				<div class="row">
																					<div class="col-md-12">
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="carbon_treat[]" id="carbon_treat" value="1" <?php if (in_array('1', $carbon)) {
																																											echo "checked";
																																										} ?>> face
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="carbon_treat[]" id="carbon_treat" value="2" <?php if (in_array('2', $carbon)) {
																																											echo "checked";
																																										} ?>> Neck
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="carbon_treat[]" id="carbon_treat" value="3" <?php if (in_array('3', $carbon)) {
																																											echo "checked";
																																										} ?>> Hand
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="carbon_treat[]" id="carbon_treat" value="4" <?php if (in_array('4', $carbon)) {
																																											echo "checked";
																																										} ?>> Underarm
																						</label>
																					</div>
																				</div>
																				<div class="row">
																					<div class="col-md-12">
																						<div class="form-group">
																							<label class="font-weight-bold">Note</label>
																							<textarea class="form-control" name="prog_carbon" id="prog_carbon" rows="4"><?php echo $result[20][0]['short_note']; ?></textarea>
																						</div>
																					</div>
																				</div>
																			</div>

																			<button class="accordion <?php if (in_array("21", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_bleaching">Bleaching <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<?php
																			$bleaching = explode(',', $result[21][0]['area']);
																			?>
																			<div class="panels" style="<?php if (in_array("21", $check_array)) {
																											echo "max-height: 2000px";
																										} ?>">
																				<input type="hidden" name="check_bleaching" id="check_bleaching" value="<?php if (in_array("21", $check_array)) {
																																							echo "1";
																																						} else {
																																							echo "0";
																																						} ?>">
																				<input type="hidden" name="counter_bleaching" id="counter_bleaching" value="<?php if (isset($result[21])) {
																																								echo count($result[21]);
																																							} else {
																																								echo "0";
																																							} ?>">
																				<div class="row">
																					<div class="col-md-12">
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="bleaching_treat[]" id="bleaching_treat" value="1" <?php if (in_array('1', $bleaching)) {
																																												echo "checked";
																																											} ?>> face
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="bleaching_treat[]" id="bleaching_treat" value="2" <?php if (in_array('2', $bleaching)) {
																																												echo "checked";
																																											} ?>> Neck
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="bleaching_treat[]" id="bleaching_treat" value="3" <?php if (in_array('3', $bleaching)) {
																																												echo "checked";
																																											} ?>> Hand
																						</label>
																					</div>
																				</div>
																				<div class="row">
																					<div class="col-md-12">
																						<div class="form-group">
																							<label class="font-weight-bold">Note</label>
																							<textarea class="form-control" name="prog_bleaching" id="prog_bleaching" rows="4"><?php echo $result[21][0]['short_note']; ?></textarea>
																						</div>
																					</div>
																				</div>
																			</div>

																			<button class="accordion <?php if (in_array("16", $check_array)) {
																											echo "active";
																										} else {
																											echo "hidden-print";
																										} ?>" type="button" id="div_peeling">Peeling <i class="fa fa-plus-circle" aria-hidden="true"></i></button>
																			<?php
																			$peeling = explode(',', $result[22][0]['area']);
																			?>
																			<div class="panels" style="<?php if (in_array("22", $check_array)) {
																											echo "max-height: 300px";
																										} ?>">
																				<input type="hidden" name="check_peeling" id="check_peeling" value="<?php if (in_array("22", $check_array)) {
																																						echo "1";
																																					} else {
																																						echo "0";
																																					} ?>">
																				<input type="hidden" name="counter_peeling" id="counter_peeling" value="<?php if (isset($result[22])) {
																																							echo count($result[22]);
																																						} else {
																																							echo "0";
																																						} ?>">
																				<div class="row">
																					<div class="col-md-12">
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="1" <?php if (in_array('1', $peeling)) {
																																											echo "checked";
																																										} ?>> face
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="2" <?php if (in_array('2', $peeling)) {
																																											echo "checked";
																																										} ?>> Neck
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="3" <?php if (in_array('3', $peeling)) {
																																											echo "checked";
																																										} ?>> Hands
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="4" <?php if (in_array('4', $peeling)) {
																																											echo "checked";
																																										} ?>> Underarm
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="5" <?php if (in_array('5', $peeling)) {
																																											echo "checked";
																																										} ?>> Lips
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="6" <?php if (in_array('6', $peeling)) {
																																											echo "checked";
																																										} ?>> Arms
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="7" <?php if (in_array('7', $peeling)) {
																																											echo "checked";
																																										} ?>> Bikini
																						</label>
																						<label class="checkbox-inline" style="margin-right: 20px;">
																							<input type="checkbox" name="peeling_treat[]" id="peeling_treat" value="8" <?php if (in_array('8', $peeling)) {
																																											echo "checked";
																																										} ?>> Knee
																						</label>
																					</div>
																				</div>
																				<div class="row">
																					<div class="col-md-12">
																						<div class="form-group">
																							<label class="font-weight-bold">Note</label>
																							<textarea class="form-control" name="prog_secret_rf" id="prog_secret_rf" rows="4"><?php echo $result[22][0]['short_note']; ?></textarea>
																						</div>
																					</div>
																				</div>
																			</div>

																		</div>
																		<script>
																			function facdraw(e) {

																				var el = document.getElementById('face');
																				var ctx = el.getContext('2d');
																				var img = new Image();
																				var isDrawing;
																				var plastic_up_image = $("#plastic_up_image").val();

																				img.onload = function() {
																					ctx.drawImage(img, 0, 0, 580, 522);
																					el.onmousedown = function(e) {
																						var pos = getMousePos(el, e);
																						posx = pos.x;
																						posy = pos.y;
																						if (e.which == 1) {
																							ctx.fillStyle = "red";
																							ctx.fillRect(posx, posy, 7, 7);
																							$("#x-coor").val(posx);
																							$("#y-coor").val(posy);
																						}
																						if (e.which == 3) {
																							ctx.clearRect(posx, posy, 10, 10);
																						}
																					};

																					$('body').on('click', '#canvas_button', function() {
																						var canvas_text = $("#canvas_input").val();
																						var x_coor = +$("#x-coor").val() - 2;
																						var y_coor = +$("#y-coor").val() - 7;

																						ctx.fillStyle = "blue";
																						ctx.font = "12px Arial";
																						ctx.fillText(canvas_text, x_coor, y_coor);

																						var canvasData = face.toDataURL("image/png");
																						$('input[name=imagepath]').val(canvasData);
																					});

																				};

																				/**
																				 * This code from old code base
																				 * 
																				 */
																				// if (plastic_up_image == '' || typeof plastic_up_image == 'undefined') {
																				// 	img.src = '<?= base_url('Images/body_full.jpg'); ?>';
																				// } else {
																				// 	img.src = '<?= base_url(''.UPLOAD_PATH.'derma/marks/') ?>' + plastic_up_image;
																				// }

																				var imgElement = new Image();
																				imgElement.onload = function() {
																					// Image exists, set the src attribute
																					console.log("Image exists");
																					img.src = img.src;
																				};
																				imgElement.onerror = function() {
																					// Image doesn't exist, set a default image
																					console.log("Image does not exist");
																					img.src = '<?= base_url('Images/body_full.jpg'); ?>';
																				};

																				// Set the source of the Image object
																				imgElement.src = '<?= base_url(''.UPLOAD_PATH.'derma/marks/') ?>' + plastic_up_image;

																			}

																			function getMousePos(el, evt) {
																				var rect = el.getBoundingClientRect();
																				return {
																					x: evt.clientX - rect.left,
																					y: evt.clientY - rect.top
																				};
																			}
																		</script>

																		<script>
																			var acc = document.getElementsByClassName("accordion");
																			var i;

																			for (i = 0; i < acc.length; i++) {
																				acc[i].addEventListener("click", function() {
																					this.classList.toggle("active");
																					var panel = this.nextElementSibling;
																					if (panel.style.maxHeight) {
																						panel.style.maxHeight = null;
																					} else {
																						panel.style.maxHeight = "2000px";
																					}
																				});
																			}

																			$('#div_cooltech').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_cooltech').val(1);
																				} else {
																					$('#check_cooltech').val(0);
																				}
																			});

																			$('#div_etwo').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_etwo').val(1);
																				} else {
																					$('#check_etwo').val(0);
																				}
																			});

																			$('#div_hifu').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_hifu').val(1);
																				} else {
																					$('#check_hifu').val(0);
																				}
																			});

																			$('#div_elite').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_elite').val(1);
																				} else {
																					$('#check_elite').val(0);
																				}
																			});

																			$('#div_acclaim').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_acclaim').val(1);
																				} else {
																					$('#check_acclaim').val(0);
																				}
																			});

																			$('#div_apogee').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_apogee').val(1);
																				} else {
																					$('#check_apogee').val(0);
																				}
																			});

																			$('#div_filler').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_filler').val(1);
																				} else {
																					$('#check_filler').val(0);
																				}
																			});

																			$('#div_botox').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_botox').val(1);
																				} else {
																					$('#check_botox').val(0);
																				}
																			});

																			$('#div_hydrafacial').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_hydrafacial').val(1);
																				} else {
																					$('#check_hydrafacial').val(0);
																				}
																			});

																			$('#div_velashape').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_velashape').val(1);
																				} else {
																					$('#check_velashape').val(0);
																				}
																			});

																			$('#div_prp').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_prp').val(1);
																				} else {
																					$('#check_prp').val(0);
																				}
																			});

																			$('#div_mesotherapy').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_mesotherapy').val(1);
																				} else {
																					$('#check_mesotherapy').val(0);
																				}
																			});

																			$('#div_threading').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_threading').val(1);
																				} else {
																					$('#check_threading').val(0);
																				}
																			});

																			$('#div_injections').click(function(event) {

																				if ($(this).hasClass('active')) {
																					$('#check_injections').val(1);
																				} else {
																					$('#check_injections').val(0);
																				}
																			});

																			$('#div_plastic').click(function(event) {

																				if ($(this).hasClass('active')) {
																					$('#check_plastic_surg').val(1);
																				} else {
																					$('#check_plastic_surg').val(0);
																				}
																			});



																			$('#div_laser').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_laser').val(1);
																				} else {
																					$('#check_laser').val(0);
																				}
																			});

																			$('#div_secret').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_secret').val(1);
																				} else {
																					$('#check_secret').val(0);
																				}
																			});

																			$('#div_dermapen').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_dermapen').val(1);
																				} else {
																					$('#check_dermapen').val(0);
																				}
																			});

																			$('#div_tattoo').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_tattoo').val(1);
																				} else {
																					$('#check_tattoo').val(0);
																				}
																			});

																			$('#div_carbon').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_carbon').val(1);
																				} else {
																					$('#check_carbon').val(0);
																				}
																			});

																			$('#div_bleaching').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_bleaching').val(1);
																				} else {
																					$('#check_bleaching').val(0);
																				}
																			});

																			$('#div_peeling').click(function(event) {
																				if ($(this).hasClass('active')) {
																					$('#check_peeling').val(1);
																				} else {
																					$('#check_peeling').val(0);
																				}
																			});
																		</script>


																		<div class="form-group"><br>
																			<label class="font-weight-bold">Remarks</label>
																			<textarea class="form-control" name="remarks_derma" id="remarks_derma" rows="3"><?= $val['remarks']; ?></textarea>
																		</div>
																		<?php
																		$query = $this->db->query("SELECT * FROM tbl_treat_derma WHERE derma_id = '$derma_id'");
																		$doc_name = $query->row();
																		$doc_name = $doc_name->doctor_id;
																		?>

																		<div class="row show_all hide-text"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Diagnosis:</label>
																			</div>
																			<div class="col-md-10">
																				<?php
																				$derma_id = $val['derma_id'];
																				$query = $this->db->query("SELECT * FROM tbl_treat_derma_subs WHERE derma_id = '$derma_id'");
																				$result =  $query->result_array();
																				$arr = [];
																				if ($result) {
																					foreach ($result as $vals) {
																						$arr[] = $vals['diagnosis_name'];
																					}
																				}
																				$result = array_unique($arr);
																				?>

																				<span><?php if ($result) {
																							foreach ($result as $vals) {
																								echo "-" . $vals . "<br>";
																							}
																						} ?></span>
																				<br>
																			</div>
																		</div>

																		<div class="row show_all hide-text">
																			<div class="col-md-2">
																				<label class="font-weight-bold">Procedure:</label>
																			</div>
																			<div class="col-md-10">
																				<?php
																				$derma_id = $val['derma_id'];
																				$query = $this->db->query("SELECT * FROM tbl_treat_derma_subs WHERE derma_id = '$derma_id'");
																				$result =  $query->result_array();
																				?>

																				<span><?php if ($result) {
																							foreach ($result as $vals) {
																								echo "-" . $vals['treatment_name'] . "<br>";
																							}
																						} ?></span>
																				<br>
																			</div>
																		</div>

																		<div class="row show_all">
																			<div class="col-md-2">
																				<label class="font-weight-bold">Medication :</label>
																			</div>
																			<div class="col-md-10">
																				<?php
																				$pres_id = $val['log_id'];

																				$this->db->select('*, tbl_drugs_list.drug_name');
																				$this->db->from('tbl_prescription');
																				$this->db->join('tbl_prescription_main', 'tbl_prescription.prescription_main_id = tbl_prescription_main.prescription_main_id', 'left');
																				$this->db->join('tbl_drugs_list', 'tbl_prescription.drug_id = tbl_drugs_list.drug_id');
																				$this->db->where('tbl_prescription.log_id', $log_id);

																				$query = $this->db->get();
																				$prescription_result = $query->result_array();
																				?>

																				<span>
																					<?php if ($prescription_result) {
																						foreach ($prescription_result as $vals) {
																							echo "-" . $vals['drug_id'] . ' ' . $vals['after_before'] . ' ' . $vals['drug_qty'] . ' ' . $vals['drug_note'] . "<br>";
																						}
																					} ?>
																				</span><br>
																			</div>
																		</div>


																		<div class="row no-print mt-2">
																			<div class="col-md-2">
																				<label class="font-weight-bold">Attachment</label>
																			</div>
																			<div class="col-md-10">
																				<div class="input-group hide-input">
																					<span class="input-group-btn">
																						<span class="btn btn-default btn-file">
																							<label for="attach_derma">Browse&hellip; </label><input type="file" id="attach_derma" multiple name="attach_derma[]">
																						</span>
																					</span>
																					<input type="text" class="form-control" readonly>
																				</div>
																				<span id="attach" class="hide-text">
																					<?php if ($attachment != FALSE) : ?>
																						<?php foreach ($attachment as $val_attach) : ?>
																							<?php echo $val_attach['attachment']; ?> <a target="_blank" href="<?= base_url(''.UPLOAD_PATH.'derma/') . $val_attach['document']; ?>" id="single_1" title="View">View</a>
																							<a href="<?= base_url(''.UPLOAD_PATH.'derma/') . $val_attach['document']; ?>" download title="Download">Download</a>
																							<a href="javascript:void(0);" onclick="deleteAtt(<?= $val_attach['id']; ?>);" title="Delete">Delete</a><br>
																						<?php endforeach; ?>
																					<?php else : ?>
																						<span>Nothing uploaded</span>
																					<?php endif; ?>
																				</span>

																			</div>
																		</div>

																		<div class="row hide-input mt-2">
																			<div class="col-md-6">
																				<b>Diagnosis</b><input type="text" class="form-control diagnosis_auto" id="diagnosis_derma" name="diagnosis_derma">
																			</div>
																			<div class="col-md-6">
																				<b>Treatment</b>
																				<select class="form-control" name="derma_diag" id="derma_diag">
																					<option value="-1">Select Category</option>
																					<?php
																					$query = $this->db->query("SELECT * FROM tbl_insurance_prices WHERE treatment_category IN ('2') AND deleted =0");
																					$result =  $query->result_array();
																					if ($result != FALSE) {
																						foreach ($result as $value1) {
																					?>
																							<option value="<?= $value1['treatment_id'] . " | " . $value1['treatment_name'] . " | " . $value1['lqdc_gross']; ?>"><?= $value1['treatment_name'] . " | " . $value1['lqdc_gross']; ?></option>
																						<?php }
																					} else { ?>
																						<option>Records Not Found</option>
																					<?php } ?>
																				</select>
																			</div>
																		</div>
																		<div class="row hide-input mb-2">
																			<div class="col-md-12">
																				<b>&nbsp;</b><br>
																				<button type="button" class="btn btn-light btn-sm hidden-print" id="addRow_derm"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
																			</div>
																		</div>
																		<div class="row hide-input">
																			<div class="col-md-12">
																				<div class="panel panel-primary">
																					<div class="panel-heading hidden-print">
																						<label for="">Treatment List</label>
																					</div>
																					<table class="table table-hover display table-striped" id="treatemnts_derma">
																						<thead>
																							<tr>
																								<th>No</th>
																								<th>Primary Diagnosis</th>
																								<th>Procedure</th>
																								<th>Discount(QR)</th>
																								<th>Discount(%)</th>
																								<th class="hidden-print">Fees</th>
																								<th class="text-center"></th>
																							</tr>
																						</thead>
																						<?php
																						$derma_id = $val['derma_id'];
																						$query = $this->db->query("SELECT * FROM tbl_treat_derma_subs WHERE derma_id = '$derma_id'");
																						$diagnosis_data = $query->result_array();
																						$ctr = 1;
																						foreach ($diagnosis_data as $index => $value1) {

																							echo "<tr>
																							<td>".(++$index)."</td>
																							<td>{$value1['diagnosis_name']}
																								<input type='hidden' name='derma_diagnosis_name[]' value='{$value1['diagnosis_name']}'>
																								<input type='hidden' name='derma_diagnosis_id[]' value='{$value1['diagnosis_id']}'>
																							</td>
																							<td>{$value1['treatment_name']}
																								<input type='hidden' name='derma_treatment_name[]' value='{$value1['treatment_name']}'>
																								<input type='hidden' name='derma_treatment_id[]' value='{$value1['treatment_id']}'>
																							</td>
																							<td>
																								<input type='hidden' size='7' class='orgi' name='orig_price[]' value='{$value1['orig_price']}'>
																								<input type='text' name='discount[]' value='{$value1['discount_qr']}' class='discount discount_derma form-control'>
																							</td>
																							<td>
																								<input type='text' name='discount_per[]' value='{$value1['discount_per']}' class='discount_per discount_per_derma form-control'>
																							</td>
																							<td class='hidden-print'>
																								<input type='text' class='teeth_price fees_derma form-control' size='7' name='fees_derma[]' value='{$value1['fee']}'>
																							</td>
																							<td><button type='button' class='btn btn-light deleteRow_derm_up'><i class='fa fa-trash' aria-hidden='true'></i></button></td>
																						  </tr>";

																							$ctr++;
																						}
																						?>
																					</table>
																				</div>
																			</div>
																		</div>

																		<div class="row hide-input">
																			<div class="col-md-12">
																				<div class="panel panel-success">
																					<div class="panel-heading">Prescription</div><br>
																					<div class="row">
																						<div class="input_fields_wrap_derma w-100">
																							<div class="col-md-12">
																								<div class="row">
																									<div class="col-md-4">
																										<div class="form-group">
																											<label for="drugs">Select Drugs</label>
																											<input type="text" class="form-control drugs" name="drugs_derma" id="drugs_derma">
																										</div>
																									</div>
																									<div class="col-md-1">
																										<div class="form-group">
																											<label for="drug_qty_derma">QTY</label>
																											<input type="number" class="form-control" name="drug_qty_derma" id="drug_qty_derma">
																										</div>
																									</div>
																									<div class="col-md-2">
																										<div class="form-group">
																											<label for="meal_derma">Meal</label></br>
																											<label class="radio-inline">
																												<input type="radio" name="meal_derma" id="meal_derma" value="1"> After
																											</label>
																											<label class="radio-inline">
																												<input type="radio" name="meal_derma" id="meal_derma" value="2"> Before
																											</label>
																										</div>
																									</div>
																									<div class="col-md-5">
																										<div class="form-group">
																											<label for="drug_note_derma">Description</label>
																											<div class="input-group">
																												<input type="text" class="form-control" name="drug_note_derma" id="drug_note_derma">
																												<span class="input-group-addon">
																													<button type="button" class="btn btn-light add_field_button_derma ml-1" id="add_drug_derma">
																														<i class="fa fa-plus-circle" aria-hidden="true"></i>
																													</button>
																													<button type="button" class="btn btn-light clear_field" id="clear_field_derma">
																														<i class="fa fa-trash" aria-hidden="true"></i>
																													</button>
																												</span>
																											</div>
																										</div>
																									</div>
																								</div>
																							</div>
																							<?php if ($prescription_result) : ?>
																								<?php foreach ($prescription_result as $prescription) : ?>
																									<div class="xys col-md-12">
																										<div class="row">
																											<div class="col-md-4">
																												<div class="form-group">
																													<input type="text" class="form-control drugs" name="drug[]" value="<?= $prescription['drug_name']; ?>" id="drugs" disabled="">
																													<input type="hidden" name="drug_name_derma[]" value="<?= $prescription['drug_name']; ?>">
																													<input type="hidden" name="drug_id_derma[]" value="ABIAD1"><input type="hidden" class="form-control drugs" name="bill_items_id_derma[]" value="undefined" id="drugs">
																												</div>
																											</div>
																											<div class="col-md-1">
																												<div class="form-group">
																													<input type="text" class="form-control" name="drugs_qty_derma[]" value="<?= $prescription['drug_qty']; ?>" id="drug_qty_derma" disabled="">
																													<input type="hidden" class="form-control" name="drugs_qty_derma[]" value="<?= $prescription['drug_qty']; ?>" id="drug_qty_derma">
																												</div>
																											</div>
																											<div class="col-md-2">
																												<div class="form-group">
																													<input type="text" class="form-control" name="meals_derma[]" value="<?= $prescription['after_before']; ?>" id="meal_derma" disabled="">
																													<input type="hidden" class="form-control" name="meals_derma[]" value="<?= $prescription['after_before']; ?>" id="meal_derma">
																												</div>
																											</div>
																											<div class="col-md-5">
																												<div class="form-group">
																													<div class="input-group">
																														<input type="text" class="form-control" name="drug_notes_derma[]" value="<?= $prescription['drug_note']; ?>" id="drug_note_derma" disabled="">
																														<input type="hidden" class="form-control" name="drug_notes_derma[]" value="<?= $prescription['drug_note']; ?>" id="drug_note_derma">
																														<span class="input-group-addon ml-1">
																															<button type="button" class="btn btn-light remove_field_derma" id="remove_drug_derma">
																																<i class="fa fa-trash" aria-hidden="true"></i>
																															</button>
																														</span>
																													</div>
																												</div>
																											</div>
																										</div>
																									</div>
																								<?php endforeach; ?>
																							<?php endif; ?>
																						</div>
																					</div>
																				</div>
																			</div>
																		</div>

																		<div class="form-group"><br>
																			<label class="font-weight-bold">Note</label>
																			<textarea class="form-control" name="prog_note_derma" id="prog_note_derma" rows="3"><?= $val['prog_note']; ?></textarea>
																		</div>
																		<br>

																		<div class="form-group hide-input">
																			<label class="font-weight-bold">Nurse</label>
																			<select name="nurse_name" id="nurse_name" class="form-control">
																				<option value="-1">Select nurse</option>
																				<?php

																				foreach ($nurses as $value) {
																					$value = (array)$value;
																					($value['doctor_id'] == $val['nurse_id']) ? $selected = "selected" : $selected = "";
																					echo "<option value='" . $value['user_Id'] . "' " . $selected . ">" . $value['full_name'] . "</option>";
																				}
																				?>
																			</select>
																		</div>

																		<div class="form-group hide-input">
																			<label class="font-weight-bold">Doctor</label>
																			<select name="doctor_name" id="doctor_name" class="form-control">
																				<option value="-1">Select doctor</option>
																				<?php
																				foreach ($doctors as $value) {
																					$value = (array)$value;
																					($value['doctor_id'] == $doc_name) ? $selected = "selected" : $selected = "";
																					echo "<option value='" . $value['user_Id'] . "' " . $selected . ">" . $value['full_name'] . "</option>";
																				}
																				?>
																			</select>
																		</div>


																		<div class="row hide-text">
																			<?php if ($val['nurse_id'] != "-1" and $val['nurse_id'] != NULL) { ?>
																				<div class="col-sm-6 col-md-6">
																					<p class="borderpara" align="center">
																						<?php
																						$nurse_id = $val['nurse_id'];
																						$this->load->model('admin/Patients/PatientsModel');
																						$results = $this->PatientsModel->getNurseById($nurse_id);
																						echo $results ? $results->employee_name : "";
																						?>
																					</p>
																					<h4 align="center">Nurse</h4>
																				</div>
																			<?php } ?>
																			<div class="col-sm-6 col-md-6">
																				<p class="borderpara" align="center">
																					<?php
																					// $doctor_id = $val['doctor_id'];
																					$results = $this->PatientsModel->getDoctorById($doc_name);
																					echo $results ? $results->employee_name : "";
																					?>
																				</p>
																				<h4 align="center">Doctor</h4>
																			</div>
																		</div>
																		<br><br><br>

																	<?php } ?>

																</div>
															</div>

															<input name="patient_id" id="patient_id" type="hidden" value="<?php if ($profile != FALSE) {
																																foreach ($profile as $row) {
																																	echo $row['patient_id'];
																																}
																															} ?>">
															<input name="option_uro" id="option_internal" type="hidden">
															<input type="hidden" value="<?= $val['treatment_payment_id']; ?>" name="treatment_payment_id">
															<input type="hidden" value="<?= $val['log_id']; ?>" name="log_id">
															<input type="hidden" value="<?= $prescription_id; ?>" name="prescription_id">
															<input type="hidden" value="<?= $val['derma_id']; ?>" name="derma_id">



															<div class="col-md-12">
																<?php
																if ($follow_up) {

																	foreach ($follow_up as $value) {
																?>
																		<hr style="border: 2px;">
																		<input type="hidden" name="follow_up_id[]" value="<?= $value['treatment_payment_id'] ?>">
																		<input type="hidden" name="follow_derma_id[]" value="<?= $value['derma_id'] ?>">
																		<div class="row">
																			<div class="col-md-12">
																				<center>
																					<h4><b>Follow Up</b></h4>
																				</center><br>
																			</div>
																			
																		</div>
																		<div class="form-group">
																			<div class="row">
																				<div class="col-md-5">
																					<label for="poppup_atime">Date</label>
																					<input type="date" class="form-control app_date hide-input" name="follow_up_date_derma[]" id="follow_up_date_derma" value="<?= $value['treat_date'] ?>" required>
																					<span class="hide-text" style="margin-left: 10px"><?= $value['treat_date'] ?></span>
																				</div>
																				<div class="col-md-5">
																					<label for="follow_up_time_derma">Time</label>
																					<div class="input-group clockpicker hide-input">
																						<input type="text" class="form-control" name="follow_up_time_derma[]" id="follow_up_time_derma" value="<?= $value['treatment_time'] ?>" required>
																						<span class="input-group-addon">
																							<span class="glyphicon glyphicon-time"></span>
																						</span>
																					</div>
																					<span class="hide-text" style="margin-left: 10px"><?= $value['treatment_time'] ?></span>
																				</div>
																				<div class="col-md-2">
																					<button class="btn btn-dark btn-sm deletelogid_f" data-id="<?php echo $value['treatment_payment_id'] . "-" . $value['derma_id'] . "-" . $value['log_id']; ?>" type="button">
																						<i class="fa fa-trash" aria-hidden="true"></i> Delete
																					</button>
																				</div>
																			</div>
																		</div>

																		<div class="row"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Chief Complaint</label>
																			</div>
																			<div class="col-md-10">
																				<input type="text" class="form-control chief_complain_auto_derma hide-input" id="chief_complaint_derma_follow" name="chief_complaint_derma_follow[]" value="<?= $value['chief_complaint'] ?>">
																				<span class="hide-text"><?= $value['chief_complaint'] ?></span>
																			</div>
																		</div>

																		<div class="row"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Present History</label>
																			</div>
																			<div class="col-md-10">
																				<input type="text" name="present_history_follow[]" class="form-control hide-input" value="<?= $value['present_history'] ?>">
																				<span class="hide-text"><?= $value['present_history'] ?></span>
																			</div>
																		</div>

																		<div class="row"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Physical Examination</label>
																			</div>
																			<div class="col-md-10">
																				<input type="text" name="physical_examination_follow[]" class="form-control hide-input" value="<?= $value['physical_examination'] ?>">
																				<span class="hide-text"><?= $value['physical_examination'] ?></span>
																			</div>
																		</div>

																		<div class="row"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Impression</label>
																			</div>
																			<div class="col-md-10">
																				<input type="text" name="impression_follow[]" class="form-control hide-input" value="<?= $value['impression'] ?>">
																				<span class="hide-text"><?= $value['impression'] ?></span>
																			</div>
																		</div>

																		<div class="row"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Plan</label>
																			</div>
																			<div class="col-md-10">
																				<input type="text" name="plan_follow[]" class="form-control hide-input" value="<?= $value['plan'] ?>">
																				<span class="hide-text"><?= $value['plan'] ?></span>
																			</div>
																		</div>

																		<div class="row"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Note</label>
																			</div>
																			<div class="col-md-10">
																				<textarea class="form-control hide-input" name="prog_note_follow[]" id="prog_note_follow" rows="3"><?= $value['prog_note'] ?></textarea>
																				<span class="hide-text"><?= $value['prog_note'] ?></span>
																			</div>
																		</div>

																		<div class="row hidden-print">
																			<div class="col-md-2">
																				<label class="hide-text">Attachment</label>
																			</div>
																			<div class="col-md-10">

																				<span id="attach_followup" class="hide-text">
																					<?php
																					$pri_id = $value['derma_id'];
																					$patient_id = $value['patient_id'];
																					$query = $this->db->query("SELECT * FROM tbl_patient_attachments WHERE patient_id = $patient_id AND category = '5' AND treat_id = $pri_id");
																					$attachment = $query->result_array();

																					if ($attachment != FALSE) {
																						foreach ($attachment as $val_attach) { ?>
																							<?php echo $val_attach['attachment']; ?> <a href="<?= base_url(''.UPLOAD_PATH.'derma/') . $val_attach['attachment']; ?>" id="single_1" title="View">View</a>
																							<a href="<?= base_url(''.UPLOAD_PATH.'derma/') . $val_attach['attachment']; ?>" download title="Download">Download</a> <a href="javascript:void(0);" onclick="deleteAtt_followup(<?= $val_attach['id']; ?>);" title="Delete">Delete</a><br>
																					<?php }
																					} ?>
																				</span>

																			</div>
																		</div>

																		<div class="row show_all hide-text"><br>
																			<div class="col-md-2">
																				<label class="font-weight-bold">Diagnosis:</label>
																			</div>
																			<div class="col-md-10">
																				<?php
																				$derma_id = $value['derma_id'];
																				$query = $this->db->query("SELECT * FROM tbl_treat_derma_subs WHERE derma_id = '$derma_id'");
																				$result =  $query->result_array();
																				$arr = [];
																				if ($result) {
																					foreach ($result as $vals) {
																						$arr[] = $vals['diagnosis_name'];
																					}
																				}
																				$result = array_unique($arr);
																				?>

																				<span><?php if ($result) {
																							foreach ($result as $vals) {
																								echo "-" . $vals . "<br>";
																							}
																						} ?></span>
																				<br>
																			</div>
																		</div>

																		<div class="row show_all hide-text">
																			<div class="col-md-2">
																				<label class="font-weight-bold">Procedure:</label>
																			</div>
																			<div class="col-md-10">
																				<?php
																				$derma_id = $value['derma_id'];
																				$query = $this->db->query("SELECT * FROM tbl_treat_derma_subs WHERE derma_id = '$derma_id'");
																				$result =  $query->result_array();
																				?>

																				<span><?php if ($result) {
																							foreach ($result as $vals) {
																								echo "-" . $vals['treatment_name'] . "<br>";
																							}
																						} ?></span>
																				<br>
																			</div>
																		</div>

																		<div class="row show_all hide-text">
																			<div class="col-md-2">
																				<label class="font-weight-bold">Medication:</label>
																			</div>
																			<div class="col-md-10">
																				<?php
																				$pres_id = $value['log_id'];
																				$query = $this->db->query("SELECT *
																					FROM tbl_prescription
																					LEFT JOIN tbl_prescription_main
																					ON tbl_prescription.prescription_main_id = tbl_prescription_main.prescription_main_id
																					WHERE tbl_prescription.log_id = '$pres_id'");
																				$result =  $query->result_array();
																				?>

																				<span><?php if ($result) {
																							foreach ($result as $vals) {
																								echo "-" . $vals['drug_id'] . ' ' . $vals['after_before'] . ' ' . $vals['drug_qty'] . ' ' . $vals['drug_note'] . "<br>";
																							}
																						} ?></span>
																				<br>
																			</div>
																		</div>

																<?php }
																} ?>
															</div>

														</form>
														<button class="btn btn-sm btn-light hidden-print" id="delete" onclick="window.print()">
															<i class="fa fa-print" aria-hidden="true"></i> Print
														</button>

														<button class="btn btn-sm btn-light hidden-print" id="edit">
															<i class="fa fa-pencil-square-o" aria-hidden="true"></i> Edit
														</button>

														<button class="btn btn-sm btn-light hidden-print" id="update">
															<i class="fa fa-check-circle" aria-hidden="true"></i> Update
														</button>

														<button class="btn btn-sm btn-light hidden-print hide-input" id="back">
															<i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Back
														</button>

														<button class="btn btn-sm btn-light hidden-print" type="button" id="follow_up_treat">
															<i class="fa fa-hashtag" aria-hidden="true"></i> Follow Up
														</button>

													</div><!-- end panel -->

												</div>
											</div>
										</div>

										<!-- Derma end -->
									</div>
								</div>
							</div>
						</div>


		</section>
		<input type="hidden" id="_id" name="_id" value="<?php echo $_id; ?>">

	</div>

	<?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>
<?php require_once(APPPATH . "views/admin/Modules/Dermatology/dermatologyFollowUpDelete.php"); ?>
<?php require_once(APPPATH . "views/admin/Modules/Dermatology/dermatologyFollowUp.php"); ?>
<script src="<?= base_url('js/jquery.magnific-popup.js'); ?>"></script>
<script>
	$(document).ready(function() {
		$('.image-link').magnificPopup({
			type: 'image'
		});
	});

	function deleteAtt(id) {
		if (confirm("Are you sure to delete this attachment?")) {

			$.ajax({
				url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/delete_attachment_derma'); ?>",
				type: 'post',
				data: {
					id: id
				},
				success: function(result) {
					$('#attach').html(result);
				},
			});
		} else {}
	}

	function deleteAtt_followup(id) {
		if (confirm("Are you sure to delete this attachment?")) {

			$.ajax({
				url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/delete_attachment_derma'); ?>",
				type: 'post',
				data: {
					id: id
				},
				success: function(result) {
					$('#attach_followup').html(result);
				},

			});

		}
	}

	$(document).on('change', '.btn-file :file', function() {
		var input = $(this),
			numFiles = input.get(0).files ? input.get(0).files.length : 1,
			label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
		input.trigger('fileselect', [numFiles, label]);
	});

	$(document).ready(function() {
		$('.btn-file :file').on('fileselect', function(event, numFiles, label) {

			var input = $(this).parents('.input-group').find(':text'),
				log = numFiles > 1 ? numFiles + ' files selected' : label;

			if (input.length) {
				input.val(log);
			} else {
				if (log) alert(log);
			}

		});

		// cooltech
		$('#addRow_derma').click(function(event) {
			$("#cooltech_table tr:eq(0)").append('<td><input type="text" name="area_cooltech[]" id="area_derma-1" class="form-control derma_auto"></td>');
			$("#cooltech_table tr:eq(1)").append('<td><input type="text" name="sessions_cooltech[]" id="sessions_derma-2" class="form-control derma_auto"></td>');
			$("#cooltech_table tr:eq(2)").append('<td><input type="text" name="measurement_cooltech[]" id="measurement_derma[]" class="form-control"></td>');
			$("#cooltech_table tr:eq(3)").append('<td><select name="pads_cooltech[]" class="form-control"><option value="1">1</option><option value="2">2</option></select>');
			$("#cooltech_table tr:eq(4)").append('<td><input type="text" name="duration_cooltech[]" id="duration_derma[]" class="form-control "></td>');
		});

		// elite
		$('#addRow_elite').click(function(event) {
			$("#elite_table tr:eq(0)").append('<td><input type="text" name="area_elite[]" id="area_derma-5" class="form-control derma_auto"></td>');
			$("#elite_table tr:eq(1)").append('<td><select name="wavelength_elite[]" class="form-control"><option value="755">755</option><option value="1064">1064</option></select></td>');
			$("#elite_table tr:eq(2)").append('<td><select name="spot_size_elite[]" class="form-control"><option value="3">3</option><option value="5">5</option><option value="7">7</option><option value="10">10</option><option value="12">12</option><option value="15">15</option><option value="18">18</option></select></td>');
			$("#elite_table tr:eq(3)").append('<td><input type="text" name="fluence_elite[]" id="fluence_derma" class="form-control"></td>');
			$("#elite_table tr:eq(4)").append('<td><select name="pulse_elite[]" class="form-control"><option value="5">5</option><option value="10">10</option><option value="15">15</option><option value="20">20</option><option value="25">25</option><option value="30">30</option><option value="40">40</option></select></td>');
			$("#elite_table tr:eq(5)").append('<td><select name="rep_rate_elite[]" class="form-control"><option value="SGL">SGL</option><option value="1">1</option><option value="1.5">1.5</option><option value="2.0">2.0</option></select></td>');
			$("#elite_table tr:eq(6)").append('<td><input type="text" name="count_elite[]" id="count_derma" class="form-control"></td>');
		});

		// acclaim
		$('#addRow_acclaim').click(function(event) {
			$("#acclaim_table tr:eq(0)").append('<td><input type="text" name="area_acclaim[]" id="area_derma-5" class="form-control derma_auto"></td>');
			$("#acclaim_table tr:eq(1)").append('<td><select name="wavelength_acclaim[]" class="form-control"><option value="755">755</option><option value="1064">1064</option></select></td>');
			$("#acclaim_table tr:eq(2)").append('<td><select name="spot_size_acclaim[]" class="form-control"><option value="3">3</option><option value="5">5</option><option value="7">7</option><option value="10">10</option><option value="12">12</option><option value="15">15</option><option value="18">18</option></select></td>');
			$("#acclaim_table tr:eq(3)").append('<td><input type="text" name="fluence_acclaim[]" id="fluence_derma" class="form-control"></td>');
			$("#acclaim_table tr:eq(4)").append('<td><select name="pulse_acclaim[]" class="form-control"><option value="5">5</option><option value="10">10</option><option value="15">15</option><option value="20">20</option><option value="25">25</option><option value="30">30</option><option value="40">40</option></select></td>');
			$("#acclaim_table tr:eq(5)").append('<td><select name="rep_rate_acclaim[]" class="form-control"><option value="SGL">SGL</option><option value="1">1</option><option value="1.5">1.5</option><option value="2.0">2.0</option></select></td>');
			$("#acclaim_table tr:eq(6)").append('<td><input type="text" name="count_acclaim[]" id="count_derma" class="form-control"></td>');
		});

		// apogee
		$('#addRow_apogee').click(function(event) {
			$("#apogee_table tr:eq(0)").append('<td><input type="text" name="area_apogee[]" id="area_derma-5" class="form-control derma_auto"></td>');
			$("#apogee_table tr:eq(1)").append('<td><select name="wavelength_apogee[]" class="form-control"><option value="755">755</option><option value="1064">1064</option></select></td>');
			$("#apogee_table tr:eq(2)").append('<td><select name="spot_size_apogee[]" class="form-control"><option value="3">3</option><option value="5">5</option><option value="7">7</option><option value="10">10</option><option value="12">12</option><option value="15">15</option><option value="18">18</option></select></td>');
			$("#apogee_table tr:eq(3)").append('<td><input type="text" name="fluence_apogee[]" id="fluence_derma" class="form-control"></td>');
			$("#apogee_table tr:eq(4)").append('<td><select name="pulse_apogee[]" class="form-control"><option value="5">5</option><option value="10">10</option><option value="15">15</option><option value="20">20</option><option value="25">25</option><option value="30">30</option><option value="40">40</option></select></td>');
			$("#apogee_table tr:eq(5)").append('<td><select name="rep_rate_apogee[]" class="form-control"><option value="SGL">SGL</option><option value="1">1</option><option value="1.5">1.5</option><option value="2.0">2.0</option></select></td>');
			$("#apogee_table tr:eq(6)").append('<td><input type="text" name="count_apogee[]" id="count_derma" class="form-control"></td>');
		});

		// filler
		$('#addRow_filler').click(function(event) {
			$("#filler_table tr:eq(0)").append('<td><input type="text" name="area_filler[]" id="area_derma-7" class="form-control derma_auto"></td>');
			$("#filler_table tr:eq(1)").append('<td><input type="text" name="filler_filler[]" id="filler_derma-6" class="form-control derma_auto"></td>');
			$("#filler_table tr:eq(2)").append('<td><input type="text" name="quantity_filler[]" id="quantity_derma" class="form-control"></td>');
		});

		// velashape
		$('#addRow_velashape').click(function(event) {
			$("#velashape_table tr:eq(0)").append('<td><select name="area_velashape[]" class="form-control"><option value="chin">chin</option><option value="abdomen">abdomen</option><option value="arms">arms</option><option value="thighs">thighs</option><option value="buttocks">buttocks</option><option value="back">back</option></select>');
			$("#velashape_table tr:eq(1)").append('<td><input type="text" name="measurement_velashape[]" class="form-control"></td>');
			$("#velashape_table tr:eq(2)").append('<td><select name="applicator_velashape[]" class="form-control"><option value="Vsmooth">Vsmooth</option><option value="Vcontour Large">Vcontour Large</option><option value="Vcontour Medium">Vcontour Medium</option><option value="Vcontour Small">Vcontour Small</option></select>');
			$("#velashape_table tr:eq(3)").append('<td><select name="ir_velashape[]" class="form-control"><option value="0">0</option><option value="1">1</option><option value="2">2</option><option value="3">3</option></select>');
			$("#velashape_table tr:eq(4)").append('<td><select name="rf_velashape[]" class="form-control"><option value="1">1</option><option value="2">2</option><option value="3">3</option></select>');
			$("#velashape_table tr:eq(5)").append('<td><select name="vac_velashape[]" class="form-control"><option value="0">0</option><option value="1">1</option><option value="2">2</option><option value="3">3</option></select>');
			$("#velashape_table tr:eq(6)").append('<td><input type="text" name="duration_velashape[]" class="form-control"></td>');
		});

	});
</script>
<!-- Date Picker -->
<script src="<?php //echo base_url('/js/jquery.plugin.js'); 
				?>"></script>

<script>
	$(document).ready(function() {

		$('.hide-input').hide();
		$('#update').hide();

		$("#edit").click(function() {
			$(".hide-input").show();
			$('#update').show();
			$("#edit").hide();
			$(".hide-text").hide();
		});

		$("#back").click(function() {
			$(".hide-input").hide();
			$('#update').hide();
			$("#edit").show();
			$(".hide-text").show();
		});


		$("#update").click(function() {
			$("#update_main").submit();
			$(".hide-input").hide();
			$(".hide-text").show();
			$('#update').hide();
			$("#edit").show();
		});

		/* Data table*/
		$('#episode').dataTable({
			"scrollX": true,
			"info": false,
			"searching": false,
			"paging": false,
			"order": [
				[0, "desc"]
			]
		});
	});

	function selectPCategory(category_id) {
		if (category_id != "-1") {
			loadTreatment(category_id);
		} else {
			$("#procedure").html("<option value='-1'>Select Category</option>");
			$("#regular").html("<option value='-1'>Select Category</option>");
		}
	}

	function loadTreatment(loadId) {
		post_data = {

			'loadId': loadId,
			'insurance_id': 1
		};
		$.ajax({
			type: "POST",
			url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/load_private_procedure_list'); ?>",
			data: post_data,
			success: function(result) {
				$("#procedure_treat").html(result);
			}
		});
	}

	var l = $('#treatemnts_pedia').DataTable({
		"bFilter": false,
		"paging": false,
		"info": false
	});
	var td = $("#treatemnts_pedia tr").length;
	var counter = td;

	$('#addRow_pedia').on('click', function() {

		var split_treatment = $('select[name=procedure_pedia]').val().split(' | ');
		var split_diagnosis = $('input[name=diagnosis_auto_pedia]').val().split(' - ');
		var treat_treat = split_treatment[1] + '<input type="hidden" name="pedia_treatment_name[]" value="' + split_treatment[1] + '"><input type="hidden" name="pedia_treatment_id[]" value="' + split_treatment[0] + '">';

		if ($('input[name=diagnosis_auto_pedia]').val().indexOf('-') == -1) {
			var diagnosis = $('input[name=diagnosis_auto_pedia]').val() + '<input type="hidden" name="pedia_diagnosis_name[]" value="' + $('input[name=diagnosis_auto_pedia]').val() + '"><input type="hidden" name="pedia_diagnosis_id[]" value="">';
		} else {
			var diagnosis = split_diagnosis[1] + '<input type="hidden" name="pedia_diagnosis_name[]" value="' + split_diagnosis[1] + '"><input type="hidden" name="pedia_diagnosis_id[]" value="' + split_diagnosis[0] + '">';
		}

		l.row.add([
				counter,
				diagnosis,
				treat_treat,
				'<input type="text" name="fees_pedia[]" size="7" value="' + split_treatment[2] + '">'
			])
			.draw();

		counter++;
	});

	$('#treatemnts_pedia tbody').on('click', 'tr', function() {
		if ($(this).hasClass('selected')) {
			$(this).removeClass('selected');
		} else {
			l.$('tr.selected').removeClass('selected');
			$(this).addClass('selected');
		}
	});

	$('#deleteRow_pedia').click(function() {
		l.row('.selected').remove().draw(false);
	});

	$('.diagnosis_auto').on("focus", function() {
		$(this).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_derma_diagnosis_multi'); ?>",
					dataType: "json",
					data: {
						term: request.term,
						type: 'diagnosis'
					},
					success: function(data) {
						response($.map(data, function(item) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			autoFocus: false,
			minLength: 2
		});
	});

	$('.diagnosis_auto_f').on("focus", function() {

		$(this).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_derma_diagnosis_multi'); ?>",
					dataType: "json",
					data: {
						term: request.term,
						type: 'diagnosis'
					},
					success: function(data) {
						response($.map(data, function(item) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			autoFocus: false,
			minLength: 2
		});
	});

	$('.drugs').on("focus", function() {
		$(this).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_drugs'); ?>",
					dataType: "json",
					data: {
						name_startsWith: request.term,
						type: 'drug'
					},
					success: function(data) {
						response($.map(data, function(item) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			autoFocus: false,
			minLength: 1
		});
	});

	//Pedia prescription
	var max_fields = 10; //maximum input boxes allowed
	var wrapper_pedia = $(".input_fields_wrap_pedia"); //Fields wrapper
	var add_button = $(".add_field_button_pedia"); //Add button ID


	var x = 1; //initlal text box count
	$(add_button).on('click', function(e) { //on add input button click
		var drug = $('input[name=drugs_pedia]').val().split(' - ');
		var drug_qty = $('input[name=drug_qty_pedia]').val();
		var drug_note = $('input[name=drug_note_pedia]').val();

		if ($('input[name=drugs_pedia]').val().length === 0) {
			alert("Please select drugs");
			return false;
		} else if ($('input[name=drug_qty_pedia]').val().length === 0) {
			alert("Please enter drug quantity");
			return false;

		}

		var meal;

		if ($('input:radio[name=meal_pedia]:checked').val() == '1') {
			meal = 'After Meal';
		} else if ($('input:radio[name=meal_pedia]:checked').val() == '2') {
			meal = 'Before Meal';
		} else {
			meal = '';
		}

		if ($('input[name=drugs_pedia]').val().indexOf('-') == -1) {
			var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[0] + '" id="drugs" disabled>' + '<input type="hidden" class="form-control drugs" name="drug_name_pedia[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="drug_id_pedia[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_pedia[]" value="" id="drugs">';
		} else {
			var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[1] + '" id="drugs" disabled>' + '<input type="hidden" name="drug_name_pedia[]" value="' + drug[1] + '"><input type="hidden" name="drug_id_pedia[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="bill_items_id_pedia[]" value="' + drug[2] + '" id="drugs">';
		}

		var treat = '<div class="xys">\
              <div class="col-md-12">\
                <div class="col-md-4">\
                  <div class="form-group">' +
			diagnosis +
			'</div>\
                </div>\
                <div class="col-md-1">\
                  <div class="form-group">\
                     <input type="text" class="form-control" name="drugs_qty_pedia[]" value="' + drug_qty + '" id="drug_qty_pedia" disabled>\
                     <input type="hidden" class="form-control" name="drugs_qty_pedia[]" value="' + drug_qty + '" id="drug_qty_pedia" >\
                  </div>\
                </div>\
                <div class="col-md-2">\
                  <div class="form-group">\
                    <input type="text" class="form-control" name="meals_pedia[]" value="' + meal + '" id="meal_pedia" disabled>\
                    <input type="hidden" class="form-control" name="meals_pedia[]" value="' + meal + '" id="meal_pedia">\
                  </div>\
                </div>\
                <div class="col-md-5">\
                  <div class="form-group">\
                    <div class="input-group">\
                      <input type="text" class="form-control" name="drug_notes_pedia[]" value="' + drug_note + '" id="drug_note_pedia" disabled>\
                      <input type="hidden" class="form-control" name="drug_notes_pedia[]" value="' + drug_note + '" id="drug_note_pedia">\
                      <span class="input-group-addon">\
                      <button type="button" class="btn btn-danger btn-xs remove_field_pedia" id="remove_drug_pedia">-</button>\
                      </span>\
                    </div>\
                  </div>\
                </div>\
              </div>\
            </div>';

		$(wrapper_pedia).append(treat);

		var drug = $('input[name=drugs_pedia]').val('');
		var drug_qty = $('input[name=drug_qty_pedia]').val('');
		var drug_note = $('input[name=drug_note_pedia]').val('');
		var drug_meal = $('input[name=meal_pedia]').prop('checked', false);

		return false;

	});

	$(wrapper_pedia).on("click", ".remove_field_pedia", function(e) { //user click on remove text
		$(this).parentsUntil('.xys').remove();
		return false;
	})

	$('.clear_field_pedia').on('click', function(e) {
		var drug = $('input[name=drugs_pedia]').val('');
		var drug_qty = $('input[name=drug_qty_pedia]').val('');
		var drug_note = $('input[name=drug_note_pedia]').val('');
		var drug_meal = $('input[name=meal_pedia]').prop('checked', false);
		return false;
	});


	var t = $('#treatemnts_derma').DataTable({
		"bFilter": false,
		"paging": false,
		"info": false
	});
	var td = $("#treatemnts_derma tr").length;
	var counter = td;

	$('#addRow_derm').on('click', function() {


		var split_diagnosis = $('input[name=diagnosis_derma]').val().split(' - ');
		var split_treatment = $('select[name=derma_diag]').val().split(' | ');

		if ($('input[name=diagnosis_derma]').val().indexOf('-') == -1) {
			var diagnosis = $('input[name=diagnosis_derma]').val() + '<input type="hidden" name="derma_diagnosis_name[]" value="' + $('input[name=diagnosis_derma]').val() + '">';
		} else {
			var diagnosis = split_diagnosis[1] + '<input type="hidden" name="derma_diagnosis_name[]" value="' + split_diagnosis[1] + '"><input type="hidden" name="derma_diagnosis_id[]" value="' + split_diagnosis[0] + '">';
		}
		var treat_derma = split_treatment[1] + '<input type="hidden" name="derma_treatment_name[]" value="' + split_treatment[1] + '"><input type="hidden" name="derma_treatment_id[]" value="' + split_treatment[0] + '">';

		t.row.add([
				counter,
				diagnosis,
				treat_derma,
				'<input type="hidden" class="orgi" name="orig_price[]" value="' + split_treatment[2] + '"><input type="text" size="7" name="discount[]" value="0" class="discount discount_derma form-control">',
				'<input type="text" size="7" name="discount_per[]" value="0" class="discount_per discount_per_derma form-control">',
				'<input type="text" name="fees_derma[]" size="7" value="' + split_treatment[2] + '" class="teeth_price fees_derma form-control">',
				'<button type="button" class="btn btn-light deleteRow_derm"><i class="fa fa-trash" aria-hidden="true"></i></button>',
			])
			.draw();


		counter++;

	});

	$('#treatemnts tbody').on('click', 'tr', function() {
		if ($(this).hasClass('selected')) {
			$(this).removeClass('selected');
		} else {
			t.$('tr.selected').removeClass('selected');
			$(this).addClass('selected');
		}
	});

	$('body').on("click", ".deleteRow_derm_up", function(e) {
		t.row($(this).parents('tr')).remove().draw();
	});

	$('#sub_category').change(function() {
		hide_all();
		$('.' + this.value).show();
	});

	hide_all();
	$('.2a').show();

	function hide_all() {
		$('.hides').hide();
	}

	$('#delete_last_column').click(function(event) {
		$("#cooltech_table th:last-child, #cooltech_table td:last-child").remove();
	});

	$('#delete_last_column_elite').click(function(event) {
		$("#elite_table th:last-child, #elite_table td:last-child").remove();
	});

	$('#delete_last_column_acclaim').click(function(event) {
		$("#acclaim_table th:last-child, #acclaim_table td:last-child").remove();
	});

	$('#delete_last_column_apogee').click(function(event) {
		$("#apogee_table th:last-child, #apogee_table td:last-child").remove();
	});

	$('#delete_last_column_filler').click(function(event) {
		$("#filler_table th:last-child, #filler_table td:last-child").remove();
	});

	$('#delete_last_column_velashape').click(function(event) {
		$("#velashape_table th:last-child, #velashape_table td:last-child").remove();
	});

	$('#follow_up_treat').on('click', function() {
		$('#follow_up_derma').modal({
			keyboard: false
		})
	});

	$('.drugs').on("focus", function() {
		$(this).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_drugs'); ?>",
					dataType: "json",
					data: {
						name_startsWith: request.term,
						type: 'drug'
					},
					success: function(data) {
						response($.map(data, function(item) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			autoFocus: false,
			minLength: 1
		});
	});

	$(document).ready(function() {
		var counter = 1;
		var x = $('#treatemnts_derma_follow').DataTable({
			"bFilter": false,
			"paging": false,
			"info": false
		});
		$('#addRow_derma_follow').on('click', function() {

			if ($("#diagnosis_derma_follow").val() === "") {
				alert('Diagnosis is required.');
				return false;

			}

			var split_diagnosis = $('input[name=diagnosis_derma_follow]').val().split(' - ');
			var split_treatment = $('select[name=f_pro_derma]').val().split(' | ');

			if ($('input[name=diagnosis_derma_follow]').val().indexOf('-') == -1) {
				var diagnosis = $('input[name=diagnosis_derma_follow]').val() + '<input type="hidden" name="derma_diagnosis_name[]" value="' + $('input[name=diagnosis_derma_follow]').val() + '"><input type="hidden" name="derma_diagnosis_id[]" value="">';
			} else {
				var diagnosis = split_diagnosis[1] + '<input type="hidden" name="treat_derma_diagnosis_name[]" value="' + split_diagnosis[1] + '"><input type="hidden" name="treat_derma_diagnosis_id[]" value="' + split_diagnosis[0] + '">';
			}

			var treat = split_treatment[1] + '<input type="hidden" name="treat_derma_name[]" value="' + split_treatment[1] + '"><input type="hidden" name="treat_derma_id[]" value="' + split_treatment[0] + '">';

			x.row.add([
					counter,
					diagnosis,
					treat,
					'<input type="text" name="fees_follow_derma[]" size="7" class="form-control" value="' + split_treatment[2] + '">',
					'<div class="text-center"><button type="button" class="btn btn-light deleteRow_derma_follow"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
				])
				.draw();

			counter++;
		});

		$('#treatemnts_derma_follow tbody').on('click', 'tr', function() {
			if ($(this).hasClass('selected')) {
				$(this).removeClass('selected');
			} else {
				x.$('tr.selected').removeClass('selected');
				$(this).addClass('selected');
			}
		});


		$('body').on("click", ".deleteRow_derma_follow", function(e) {
			x.row($(this).parents('tr')).remove().draw();
			return false;
		});
	});


	var insurance = 0;
	post_data = {
		'loadId': 4,
		'insurance_id': insurance
	};

	$.ajax({
		type: "POST",
		url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/load_private_procedure_list'); ?>",
		data: post_data,
		success: function(result) {
			$("#procedure_derma").html(result);
			$("#f_pro_derma").html(result);
		}
	});

	//derma prescription
	var max_fields = 10; //maximum input boxes allowed
	var wrapper_derma = $(".input_fields_wrap_derma"); //Fields wrapper
	var add_button_derma = $(".add_field_button_derma"); //Add button ID

	var x = 1; //initlal text box count
	$(add_button_derma).on('click', function(e) { //on add input button click
		var drug = $('input[name=drugs_derma]').val().split(' - ');
		var drug_qty = $('input[name=drug_qty_derma]').val();
		var drug_note = $('input[name=drug_note_derma]').val();

		if ($('input[name=drugs_derma]').val().length === 0) {
			alert("Please select drugs");
			return false;
		} else if ($('input[name=drug_qty_derma]').val().length === 0) {
			alert("Please enter drug quantity");
			return false;

		}

		var meal;

		if ($('input:radio[name=meal_derma]:checked').val() == '1') {
			meal = 'After Meal';
		} else if ($('input:radio[name=meal_derma]:checked').val() == '2') {
			meal = 'Before Meal';
		} else {
			meal = '';
		}

		if ($('input[name=drugs_derma]').val().indexOf('-') == -1) {
			var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[0] + '" id="drugs" disabled>' + '<input type="hidden" class="form-control drugs" name="drug_name_derma[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="drug_id_derma[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_derma[]" value="" id="drugs">';
		} else {
			var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[1] + '" id="drugs" disabled>' + '<input type="hidden" name="drug_name_derma[]" value="' + drug[1] + '"><input type="hidden" name="drug_id_derma[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="bill_items_id_derma[]" value="' + drug[2] + '" id="drugs">';
		}

		var treat = '<div class="xys col-md-12">\
                        <div class="row">\
                            <div class="col-md-4">\
                            <div class="form-group">' +
			diagnosis +
			'</div>\
                            </div>\
                            <div class="col-md-1">\
                            <div class="form-group">\
                                <input type="text" class="form-control" name="drugs_qty_derma[]" value="' + drug_qty + '" id="drug_qty_derma" disabled>\
                                <input type="hidden" class="form-control" name="drugs_qty_derma[]" value="' + drug_qty + '" id="drug_qty_derma" >\
                            </div>\
                            </div>\
                            <div class="col-md-2">\
                            <div class="form-group">\
                                <input type="text" class="form-control" name="meals_derma[]" value="' + meal + '" id="meal_derma" disabled>\
                                <input type="hidden" class="form-control" name="meals_derma[]" value="' + meal + '" id="meal_derma">\
                            </div>\
                            </div>\
                            <div class="col-md-5">\
                            <div class="form-group">\
                                <div class="input-group">\
                                <input type="text" class="form-control" name="drug_notes_derma[]" value="' + drug_note + '" id="drug_note_derma" disabled>\
                                <input type="hidden" class="form-control" name="drug_notes_derma[]" value="' + drug_note + '" id="drug_note_derma">\
                                <span class="input-group-addon ml-1">\
                                <button type="button" class="btn btn-light remove_field_derma" id="remove_drug_derma"><i class="fa fa-trash" aria-hidden="true"></i></button>\
                                </span>\
                                </div>\
                            </div>\
                            </div>\
                        </div>\
                        </div>';

		$(wrapper_derma).append(treat);

		var drug = $('input[name=drugs_derma]').val('');
		var drug_qty = $('input[name=drug_qty_derma]').val('');
		var drug_note = $('input[name=drug_note_derma]').val('');
		var drug_meal = $('input[name=meal_derma]').prop('checked', false);

		return false;

	});

	$(wrapper_derma).on("click", ".remove_field_derma", function(e) { //user click on remove text
		$(this).parentsUntil('.xys').remove();
		return false;
	});


	$('.clear_field_derma').on('click', function(e) {
		var drug = $('input[name=drugs_derma]').val('');
		var drug_qty = $('input[name=drug_qty_derma]').val('');
		var drug_note = $('input[name=drug_note_derma]').val('');
		var drug_meal = $('input[name=meal_derma]').prop('checked', false);
		return false;
	});

	$('.clear_field_derma_follow').on('click', function(e) {
		var drug = $('input[name=drugs_derma_follow]').val('');
		var drug_qty = $('input[name=drug_qty_derma_follow]').val('');
		var drug_note = $('input[name=drug_note_derma_follow]').val('');
		var drug_meal = $('input[name=meal_derma_follow]').prop('checked', false);
		return false;
	});

	//prp
	var max_fields = 10; //maximum input boxes allowed
	var wrapper_prp = $(".input_fields_wrap_prp"); //Fields wrapper
	var add_button_prp = $(".add_field_button_prp"); //Add button ID

	var xx = 1; //initlal text box count
	$('body').on('click', '.add_field_button_prp', function(e) { //on add input button click

		var name = $(this).closest(".col-md-12").find(":input").val();
		var ml = $(this).closest(".col-md-4").find(":input").val();
		var xx = this.value

		var treat = '<div class="xys">\
              <div class="row">\
                <div class="col-md-8">\
                  <div class="form-group">\
                     <input type="text" class="form-control" name="vitamin_name[]" value="' + name + '" id="vitamin_name" disabled>\
                     <input type="hidden" class="form-control" name="vitamin_name-' + xx + '[]" value="' + name + '" id="vitamin_name" >\
                  </div>\
                </div>\
                <div class="col-md-4">\
                  <div class="form-group">\
                    <div class="input-group">\
                      <input type="text" class="form-control" name="vitamin_ml[]" value="' + ml + '" id="vitamin_ml" disabled>\
                      <input type="hidden" class="form-control" name="vitamin_ml-' + xx + '[]" value="' + ml + '" id="vitamin_ml">\
                      <span class="input-group-addon ml-1">\
                      <button type="button" class="btn btn-light remove_field_prp" id="remove_drug_derma"><i class="fa fa-trash" aria-hidden="true"></i></button>\
                      </span>\
                    </div>\
                  </div>\
                </div>\
              </div>\
            </div>';

		$($(this).closest(".input_fields_wrap_prp")).append(treat);
		let textFields = $(this).closest(".col-md-12").find("input[type=text]");
		$(textFields[0]).val('');
		$(textFields[1]).val('');
		xx++;
	});

	$('body').on("click", ".remove_field_prp", function(e) { //user click on remove text
		$(this).parentsUntil('.xys').remove();
		return false;
	})

	$("#delete_last_column_prp").on("click", function(e) { //user click on remove text
		$('body #prp_table:last').remove();
		$('#counter').val(parseInt($('#counter').val()) - 1);
		return false;
	})

	$('body').on("click", ".clear_field_prp", function(e) { //user click on remove text
		$(this).closest(".col-md-12").find(":input").val('');
		$(this).closest(".col-md-4").find(":input").val('');
		return false;
	})

	$('#addRow_prp').on('click', function(e) {

		$('#counter').val(parseInt($('#counter').val()) + 1);
		var ctr = $('#counter').val();

		var treat = '<table class="table table-bordered" id="prp_table" style="width: 100%">\
        <tr>\
          <td>Area</td>\
          <td><input type="text" name="area_prp[]" id="area_prp" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>PRP set</td>\
          <td><input type="text" name="prp_set[]" id="prp_set" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Tubes</td>\
          <td><input type="text" name="tubes_prp[]" id="tubes_prp" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Vitamins</td>\
          <td><div class="row"> \
              <div class="input_fields_wrap_prp col-md-12"> \
			  <div class="row">\
                    <div class="col-md-8">\
                      <div class="form-group">\
                        <label class="font-weight-bold">NAME</label>\
                         <input type="text" class="form-control" name="vitamin_name" id="vitamin_name">\
                      </div>\
                    </div>\
                    <div class="col-md-4">\
                      <div class="form-group">\
                        <label class="font-weight-bold">ML</label>\
                        <div class="input-group">\
                          <input type="text" class="form-control" name="vitamin_ml" id="vitamin_ml">\
                            <span class="input-group-addon">\
                              <button type="button" class="btn btn-success btn-xs add_field_button_prp" id="add_drug_prp" value=' + ctr + '>+</button>\
                              <button type="button" class="btn btn-warning btn-xs clear_field_prp" id="clear_field_prp">x</button>\
                            </span>\
                        </div>\
                      </div>\
                    </div>\
                </div>\
            </div></td>\
        </tr>\
      </table>';

		$("#print_prp").append(treat);
		// $('#counter').val(parseInt($('#counter').val())+1);
	});


	//mesotherapy
	var max_fields = 10; //maximum input boxes allowed
	var wrapper_mesotherapy = $(".input_fields_wrap_mesotherapy"); //Fields wrapper
	var add_button_mesotherapy = $(".add_field_button_mesotherapy"); //Add button ID

	var xx = 1; //initlal text box count
	$('body').on('click', '.add_field_button_mesotherapy', function(e) { //on add input button click

		var name = $(this).closest(".col-md-12").find(":input").val();
		var ml = $(this).closest(".col-md-4").find(":input").val();
		var xx = this.value;

		var treat = '<div class="xys">\
              <div class="row">\
                <div class="col-md-8">\
                  <div class="form-group">\
                     <input type="text" class="form-control" name="vitamin_name[]" value="' + name + '" id="vitamin_name" disabled>\
                     <input type="hidden" class="form-control" name="vitamin_name_mesotherapy-' + xx + '[]" value="' + name + '" id="vitamin_name" >\
                  </div>\
                </div>\
                <div class="col-md-4">\
                  <div class="form-group">\
                    <div class="input-group">\
                      <input type="text" class="form-control" name="vitamin_ml[]" value="' + ml + '" id="vitamin_ml" disabled>\
                      <input type="hidden" class="form-control" name="vitamin_ml_mesotherapy-' + xx + '[]" value="' + ml + '" id="vitamin_ml">\
                      <span class="input-group-addon ml-1">\
                      <button type="button" class="btn btn-light remove_field_mesotherapy" id="remove_drug_derma"><i class="fa fa-trash" aria-hidden="true"></i></button>\
                      </span>\
                    </div>\
                  </div>\
                </div>\
              </div>\
            </div>';

		$($(this).closest(".input_fields_wrap_mesotherapy")).append(treat);
		let textFields = $(this).closest(".col-md-12").find("input[type=text]");
		$(textFields[0]).val('');
		$(textFields[1]).val('');
	});

	$('body').on("click", ".remove_field_mesotherapy", function(e) { //user click on remove text
		$(this).parentsUntil('.xys').remove();
		return false;
	})

	$("#delete_last_column_mesotherapy").on("click", function(e) { //user click on remove text
		$('body #mesotherapy_table:last').remove();
		$('#counter_mesotherapy').val(parseInt($('#counter_mesotherapy').val()) - 1);
		return false;
	})

	$('body').on("click", ".clear_field_mesotherapy", function(e) { //user click on remove text
		$(this).closest(".col-md-12").find(":input").val('');
		$(this).closest(".col-md-4").find(":input").val('');
		return false;
	})

	$('#addRow_mesotherapy').on('click', function(e) {

		$('#counter_mesotherapy').val(parseInt($('#counter_mesotherapy').val()) + 1);
		var ctr = $('#counter_mesotherapy').val();

		var treat = '<table class="table table-bordered" id="mesotherapy_table" style="width: 100%">\
        <tr>\
          <td>Area</td>\
          <td><input type="text" name="area_mesotherapy[]" id="area_mesotherapy" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Vitamins</td>\
          <td><div class="row"> \
              <div class="input_fields_wrap_mesotherapy col-md-12"> \
			  <div class="row">\
                    <div class="col-md-8">\
                      <div class="form-group">\
                        <label class="font-weight-bold">NAME</label>\
                         <input type="text" class="form-control" name="vitamin_name" id="vitamin_name">\
                      </div>\
                    </div>\
                    <div class="col-md-4">\
                      <div class="form-group">\
                        <label class="font-weight-bold">ML</label>\
                        <div class="input-group">\
                          <input type="text" class="form-control" name="vitamin_ml" id="vitamin_ml">\
                            <span class="input-group-addon">\
                              <button type="button" class="btn btn-success btn-xs add_field_button_mesotherapy" id="add_drug_mesotherapy" value=' + ctr + '>+</button>\
                              <button type="button" class="btn btn-warning btn-xs clear_field_mesotherapy" id="clear_field_mesotherapy">x</button>\
                            </span>\
                        </div>\
                      </div>\
                    </div>\
                </div>\
            </div></td>\
        </tr>\
      </table>';

		$("#print_mesotherapy").append(treat);
	});

	//threading
	$("#delete_last_column_threading").on("click", function(e) { //user click on remove text
		$('body #threading_table:last').remove();
		$('#counter_threading').val(parseInt($('#counter_threading').val()) - 1);
		return false;
	})

	$('#addRow_threading').on('click', function(e) {

		var treat = '<table class="table table-bordered" id="threading_table" style="width: 100%">\
        <tr>\
          <td>Area</td>\
          <td><input type="text" name="area_threading[]" id="area_threading" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Name of Thread</td>\
          <td><input type="text" name="thread[]" id="thread" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Size Description</td>\
          <td><input type="text" name="size_threading[]" id="size_threading" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Quantity</td>\
          <td><input type="text" name="quantity_threading[]" id="quantity_threading" class="form-control"></td>\
        </tr>\
      </table>';

		$("#print_threading").append(treat);
		$('#counter_threading').val(parseInt($('#counter_threading').val()) + 1);
	});

	//injections
	$("#delete_last_column_injections").on("click", function(e) { //user click on remove text
		$('body #injections_table:last').remove();
		$('#counter_injections').val(parseInt($('#counter_injections').val()) - 1);
		return false;
	})

	$('#addRow_injections').on('click', function(e) {

		var treat = '<table class="table table-bordered" id="injections_table" style="width: 100%">\
        <tr>\
          <td>Area</td>\
          <td><input type="text" name="area_injections[]" id="area_injections" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Name of Injections</td>\
          <td><input type="text" name="injection[]" id="injection" class="form-control"></td>\
        </tr>\
        <tr>\
          <td>Quantity</td>\
          <td><input type="text" name="quantity_injections[]" id="quantity_injections" class="form-control"></td>\
        </tr>\
      </table>';

		$("#print_injections").append(treat);
		$('#counter_injections').val(parseInt($('#counter_injections').val()) + 1);
	});

	//Derma follow up prescription
	var max_fields = 10; //maximum input boxes allowed
	var wrapper_derma_follow = $(".input_fields_wrap_derma_follow"); //Fields wrapper
	var add_button_derma_follow = $(".add_field_button_derma_follow"); //Add button ID


	// var x = 1; //initlal text box count
	$(add_button_derma_follow).on('click', function(e) { //on add input button click
		var drug = $('input[name=drugs_derma_follow]').val().split(' - ');
		var drug_qty = $('input[name=drug_qty_derma_follow]').val();
		var drug_note = $('input[name=drug_note_derma_follow]').val();

		if ($('input[name=drugs_derma_follow]').val().length === 0) {
			alert("Please select drugs");
			return false;
		}
		// if($('input[name=drugs]').val().indexOf('-') == -1){
		//   alert("Please select from the choices");
		//   $('input[name=drugs]').val('');
		//   return false;
		// }
		else if ($('input[name=drug_qty_derma_follow]').val().length === 0) {
			alert("Please enter drug quantity");
			return false;

		}

		var meal;

		if ($('input:radio[name=meal_derma_follow]:checked').val() == '1') {
			meal = 'After Meal';
		} else if ($('input:radio[name=meal_derma_follow]:checked').val() == '2') {
			meal = 'Before Meal';
		} else {
			meal = '';
		}

		if ($('input[name=drugs_derma_follow]').val().indexOf('-') == -1) {
			var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[0] + '" id="drugs" disabled>' + '<input type="hidden" class="form-control drugs" name="drug_name_derma_follow[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="drug_id_derma_follow[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_derma_follow[]" value="" id="drugs">';
		} else {
			var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[1] + '" id="drugs" disabled>' + '<input type="hidden" name="drug_name_derma_follow[]" value="' + drug[1] + '"><input type="hidden" name="drug_id_derma_follow[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="bill_items_id_derma_follow[]" value="' + drug[2] + '" id="drugs">';
		}

		var treat = '<div class="xys w-100">\
			<div class="row">\
			<div class="col-md-4">\
				<div class="form-group">' +
			diagnosis +
			'</div>\
			</div>\
			<div class="col-md-1">\
				<div class="form-group">\
					<input type="text" class="form-control" name="drugs_qty_derma_follow[]" value="' + drug_qty + '" id="drug_qty_derma_follow" disabled>\
					<input type="hidden" class="form-control" name="drugs_qty_derma_follow[]" value="' + drug_qty + '" id="drug_qty_derma_follow" >\
				</div>\
			</div>\
			<div class="col-md-2">\
				<div class="form-group">\
				<input type="text" class="form-control" name="meals_derma_follow[]" value="' + meal + '" id="meal_derma_follow" disabled>\
				<input type="hidden" class="form-control" name="meals_derma_follow[]" value="' + meal + '" id="meal_derma_follow">\
				</div>\
			</div>\
			<div class="col-md-5">\
				<div class="form-group">\
				<div class="input-group">\
					<input type="text" class="form-control" name="drug_notes_derma_follow[]" value="' + drug_note + '" id="drug_note_derma_follow" disabled>\
					<input type="hidden" class="form-control" name="drug_notes_derma_follow[]" value="' + drug_note + '" id="drug_note_derma_follow">\
					<span class="input-group-addon ml-1">\
					<button type="button" class="btn btn-light remove_field_derma_follow ml-1" id="remove_drug_derma_follow"><i class="fa fa-trash" aria-hidden="true"></i></button>\
					</span>\
				</div>\
				</div>\
			</div>\
			</div>\
		</div>';

		$(wrapper_derma_follow).append(treat);

		var drug = $('input[name=drugs_derma_follow]').val('');
		var drug_qty = $('input[name=drug_qty_derma_follow]').val('');
		var drug_note = $('input[name=drug_note_derma_follow]').val('');
		var drug_meal = $('input[name=meal_derma_follow]').prop('checked', false);

		return false;

	});

	$(wrapper_derma_follow).on("click", ".remove_field_derma_follow", function(e) { //user click on remove text
		$(this).parentsUntil('.xys').remove();
		return false;
	})

	$('.clear_field_derma_follow').on('click', function(e) {
		var drug = $('input[name=drugs_derma_follow]').val('');
		var drug_qty = $('input[name=drug_qty_derma_follow]').val('');
		var drug_note = $('input[name=drug_note_derma_follow]').val('');
		var drug_meal = $('input[name=meal_derma_follow]').prop('checked', false);
		return false;
	});

	$(document).on("click", ".deletelogid_f", function() {
		var logid = $(this).data('id');
		$(".modal-body #logid").val(logid);
		$('#delete_record_f').modal('show');
	});

	$(document).on("click", ".deletelogid_f", function() {
		var logid = $(this).data('id');
		$(".modal-body #logid").val(logid);
		$('#delete_record_f').modal('show');
	});
</script>

<script>
	$(document).ready(function() {
		//drawsf();
		drawsb();
		facdraw();
	});
</script>

<script>
	$(document).ready(function() {
		$('body').on('keyup', '.fees_derma', function() {
			this_td = $(this).closest('td'),
				dis_per_td = this_td.prev('td');
			discount_per = $(dis_per_td).find('input').val(),
				dis_td = dis_per_td.prev('td'),
				orig_price = $(dis_td).find('input').val(),
				discount = $(dis_td).find('input').next().val(),
				fees = Number($(this).val()).toFixed(2);

			dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
			dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
		});
		var limit_discount= Number("<?php echo get_discount_limt($this) ?? '' ?>");

		$('body').on('keyup', '.discount_derma', function() {
			this_td = $(this).closest('td'),
				orig_price = $(this).prev('input').val(),
				dis_per_td = this_td.next('td');
			discount_per = $(dis_per_td).find('input').val(),
				fees_td = dis_per_td.next('td');
			fees = $(fees_td).find('input').val(),
				discount = Number($(this).val()).toFixed(2);
				var dis_per =Number((discount * 100 / orig_price).toFixed(2));
					if(limit_discount !=''){
						if(dis_per > limit_discount){
						
						showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
						dis_per = limit_discount
						discount =((dis_per * orig_price) / 100).toFixed(2);

						$(this).val(discount);
					}
					}
					
					//discount


				dis_per_td.find('input').val(dis_per); //discount_per
			fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
		});

		$('body').on('keyup', '.discount_per_derma', function() {
			this_td = $(this).closest('td'),
				dis_td = this_td.prev('td'),
				orig_price = $(dis_td).find('input').val(),
				discount = $(dis_td).find('input').next().val(),
				fees_td = this_td.next('td');
			fees = $(fees_td).find('input').val(),
				discount_per = Number($(this).val()).toFixed(2);
				if(limit_discount !=''){

				if (discount_per > limit_discount) {
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
            $(this).val(limit_discount); // Optionally, reset the value to the limit
            discount_per = limit_discount; // Update discount_per to the limit value
            }
		}
			dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
			fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));

		});

		$('body').on('keyup', '.fees_derma', function() {
			this_td = $(this).closest('td'),
				dis_per_td = this_td.prev('td');
			discount_per = $(dis_per_td).find('input').val(),
				dis_td = dis_per_td.prev('td'),
				orig_price = $(dis_td).find('input').val(),
				discount = $(dis_td).find('input').next().val(),
				fees = parseFloat($(this).val()).toFixed(2);

			dis_td.find('input').next().val(parseFloat(orig_price - fees).toFixed(2)); //discount
			dis_per_td.find('input').val(parseFloat((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
		});


		draws();

	});
</script>

<script>
	$('.diagnosis_auto').on("focus", function() {
		$(this).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_derma_diagnosis_multi'); ?>",
					dataType: "json",
					data: {
						term: request.term,
						type: 'diagnosis'
					},
					success: function(data) {
						response($.map(data, function(item) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			autoFocus: false,
			minLength: 2
		});
	});

	$('.diagnosis_auto_f').on("focus", function() {
		$(this).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_derma_diagnosis_multi'); ?>",
					dataType: "json",
					data: {
						term: request.term,
						type: 'diagnosis'
					},
					success: function(data) {
						response($.map(data, function(item) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			autoFocus: false,
			minLength: 2
		});
	});

	$.ajax({
		type: "POST",
		url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/load_private_procedure_list'); ?>",
		data: post_data,
		success: function(result) {
			$("#procedure_derma").html(result);
			$("#f_pro_derma").html(result);
		}
	});

	// Change icon expand - collapse
	const expand_class = 'fa-plus-circle';
	const collapse_class = 'fa-minus-circle';

	for (element of document.getElementsByClassName('accordion')) {
		element.addEventListener('click', function() {
			const icon = this.querySelector('i');

			if (icon.classList.contains(expand_class)) {
				icon.classList.remove(expand_class);
				icon.classList.add(collapse_class);
			} else if (icon.classList.contains(collapse_class)) {
				icon.classList.remove(collapse_class);
				icon.classList.add(expand_class);
			}
		});
	}
</script>