<form role="form" action="<?php echo site_url('admin/Modules/ENT/ENTController/save'); ?>" method="post" enctype="multipart/form-data" id="ent_submit">
  <?php
  date_default_timezone_set('Asia/Kuwait');
  $date_string = '%Y-%m-%d';
  $curr_date = mdate($date_string);
  ?>
  <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
  <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
  <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">


  <div class="form-group p-3">
    <div class="row">
      <div class="col-12">
        <h4>ENT</h4><br>
      </div>
    </div>
    <div class="col-12">
      <div class="row">
        <div class="col-2">
          <label>Weight</label>
        </div>
        <div class="col-2">
          <input type="text" class="form-control general_weight" id="triage_weight" name="triage_weight" value="<?= $weight; ?>">
        </div>
        <div class="col-2">
          <label>Height</label>
        </div>
        <div class="col-2">
          <input type="text" class="form-control general_height" id="triage_height" name="triage_height" value="<?= $height; ?>">
        </div>
        <div class="col-2">
          <label>BMI</label>
        </div>
        <div class="col-2">
          <input type="text" class="form-control general_bmi" id="triage_bmi" name="triage_bmi" value="<?= $bmi; ?>">
        </div>
      </div>
      <br>
      <div class="row">
        <div class="col-2">
          <label>BP</label>
        </div>
        <div class="col-2">
          <input type="text" class="form-control" id="triage_bp" name="triage_bp" value="<?= $bp; ?>">
        </div>
        <div class="col-2">
          <label>Temperature</label>
        </div>
        <div class="col-2">
          <input type="text" class="form-control" id="triage_temperature" name="triage_temperature" value="<?= $temperature; ?>">
        </div>
        <div class="col-2">
          <label>Pulse</label>
        </div>
        <div class="col-2">
          <input type="text" class="form-control" id="triage_pulse" name="triage_pulse" value="<?= $pulse; ?>">
        </div>
      </div>
      <br>
      <div class="row">
        <div class="col-2">
          <label>RR</label>
        </div>
        <div class="col-2">
          <input type="text" class="form-control" id="triage_rr" name="triage_rr" value="<?= $rr; ?>">
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
        <label for="app_date">Treatment Date</label>
        <input type="text" class="form-control select_date" name="treatment_date_general" id="treatment_date_general" value="<?php echo $curr_date; ?>">
        <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
      </div>
      <div class="form-group">
        <label for="lab_test">Chief Complaint</label>
        <textarea class="form-control ent_chief_complaint_auto1" name="chief_complaint_general" id="chief_complaint_general" rows="5"></textarea>
      </div>
      <div class="form-group">
        <label for="lab_test">Past Medical History</label>
        <textarea class="form-control ent_past_medical_auto1" name="subjective_general" id="subjective_general" rows="5"></textarea>
      </div>
      <div class="form-group">
        <label for="lab_test">P. Examination</label>
        <textarea class="form-control ent_physical_examination_auto1" name="objective_general" id="objective_general" rows="5"></textarea>
      </div>
      <div class="form-group">
        <label for="lab_test">Investigation</label>
        <textarea class="form-control ent_investigation_auto1" name="assessment_general" id="assessment_general" rows="5"></textarea>
      </div>
      <div class="form-group">
        <label for="lab_test">Recommendation</label>
        <textarea class="form-control ent_recommendation_auto1" name="recommendation_general" id="recommendation_general" rows="5"></textarea>
      </div>
      <div class="form-group">
        <label for="drugs">Select Diagnosis</label>
        <input type="text" class="multi_diagnosis" name="diagnosis_general" id="diagnosis_general">
      </div>

      <div class="form-group">
        <label for="procedure">Select Procedure</label>
        <select class="procedure" data-department="4" name="procedure_general" id="procedure_general">
        </select>
      </div>

    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <button type="button" class="btn btn-sm btn-dark" id="addRow_general"><i class="fa fa-plus-circle"></i> Add</button>
    </div>
  </div>

  <div class="row mt-2">
    <div class="col-12">
      <div class="panel panel-primary">
        <div class="panel-heading">
          <h5>
          Procedure List
          </h5>
        </div>
        <table class="table table-hover display table-striped w-100" id="treatemnts_ent">
          <thead>
            <tr>
              <th>No</th>
              <th>Primary Diagnosis</th>
              <th>Procedure</th>
              <th>Discount(QR)</th>
              <th>Discount(%)</th>
              <th>Fees</th>
              <th class="text-center">Actions</th>
            </tr>
          </thead>
        </table>
      </div>
    </div>
  </div>

  <div class="row">

    <div class="col-12">
     
      <div class="form-group">
        <label for="drugs">Note</label>
        <textarea type="text" class="form-control note" name="note" id="note"></textarea>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-12">
      <label for="attachment">Attachment</label>
      <div class="input-group">
        <span class="input-group-btn">
          <span class="btn btn-default btn-file">
            Browse&hellip; <input type="file" multiple name="attach_general[]">
          </span>
        </span>
        <input type="text" class="form-control" readonly>
      </div>
    </div>
  </div>
  <div class="form-group">
                    <label for="condition">Treatmen Type</label><br>
                    <div class="followup_div">

                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_0" value="0" class="jq_followup"> New Treatment
                        </label>
                        <br>
                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_1" value="1" class="jq_followup"> FOC
                        </label>
                        <br>
                        <?php if($is_package==1){
                           $desired_module_id=4;
                            include(APPPATH . "views/admin/Modules/packages.php");
                             
                             } ?>
                                

                            
                    </div>
                </div>

  <div class="row mt-2">
    <div class="col-12">
      <div class="form-group">
        <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle"></i> Save</button>
        <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
      </div>
    </div>
  </div>


  <!-- <div class="row">
    <div class="col-12">
      <div class="panel panel-success">
        <div class="panel-heading">Prescription</div><br>
        <div class="row">
          <div class="col-md-3">
            <div class="form-group">
              <label for="drugs">Select Drugs</label>
              <input type="text" class="form-control drugs" name="drugs_ent" id="drugs_ent">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label for="drugs">Doses</label>
              <input type="text" class="form-control ent_doses_auto" name="drug_qty_ent" id="drug_qty_ent">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label for="meal">Frequency</label><br>
              <input type="text" class="form-control ent_frequency_auto" name="drug_meal_ent" id="drug_meal_ent">
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label for="drugs">Duration(Days)</label>
              <div class="input-group">
                <input type="text" class="form-control ent_duration_auto" name="drug_note_ent" id="drug_note_ent">
                <span class="input-group-addon">
                  <button type="button" class="btn btn-light btn-xs add_field_button_ent" id="add_drug_ent">+</button>
                  <button type="button" class="btn btn-danger btn-xs clear_field_ent" id="clear_field_ent">x</button>
                </span>
              </div>
            </div>
          </div>
        </div>
        <div class="input_fields_wrap_ent"></div>
      </div>
    </div>
  </div> -->


  <!-- <div class="form-group">
    <label for="note">Note</label>
    <textarea class="form-control" name="note_con" id="note_con" rows="3"></textarea>
  </div> -->



</form>
<script>
  $(document).ready(function() {
    jQuery(function() {
      weight = $('.general_weight');
      height = $('.general_height');
      bmi = $('.general_bmi');

      weight.on('input', function() {
        bmi.val((weight.val() / (height.val() * 2)).toFixed(2));
      })

      height.on('input', function() {
        bmi.val((weight.val() / (height.val() * 2)).toFixed(2));
      })
    });
  });
</script>

<script src="<?php echo base_url('js/Modules/ent.js') ?>" type="text/javascript"></script>