<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title>Patient</title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->

  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        &nbsp;Edit ENT Treatment
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->
    <section class="content">

    <div class="row mb-2">
				<div class="col-md-12">
					<div class="box margin-bottom-5px" style="border: none;">
						<div class="box-body">
							<div class="d-flex justify-content-start">
								<a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode($patient_id, $this) ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back</a>
							</div>
						</div>
					</div>
				</div><!-- /.box-body -->
			</div>

      <?php print_header($this); ?>
      <form role="form" action="<?php echo site_url('admin/Modules/ENT/ENTController/update'); ?>" method="post" enctype="multipart/form-data" id="ent_submit">
        <?php
        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        ?>
        <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
        <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
        <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">
        <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">

        <?php
        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);

        $query = $this->db->query("SELECT * FROM tbl_nurse_triage WHERE treatment_id = '$treatment_payment_id' AND patient_id = '$patient_id' ORDER BY triage_id DESC LIMIT 1");
        $details = $query->row();

        if ($details) {

          $weight = $details->weight;
          $height = $details->height;
          $bmi = $details->bmi;
          $bp = $details->bp;
          $temperature = $details->temperature;
          $pulse = $details->pulse;
          $rr = $details->rr;
        } else {

          $weight = "";
          $height = "";
          $bmi = "";
          $bp = "";
          $temperature = "";
          $pulse = "";
          $rr = "";
        }
        ?>


        <div class="box  box-info">
          <div class="box-body">
            <div class="form-group">
              <div class="col-12">
                <div class="row">
                  <div class="col-2">
                    <label>Weight</label>
                  </div>
                  <div class="col-2">
                    <input type="text" class="form-control general_weight" id="triage_weight" name="triage_weight" value="<?= $weight; ?>">
                  </div>
                  <div class="col-2">
                    <label>Height</label>
                  </div>
                  <div class="col-2">
                    <input type="text" class="form-control general_height" id="triage_height" name="triage_height" value="<?= $height; ?>">
                  </div>
                  <div class="col-2">
                    <label>BMI</label>
                  </div>
                  <div class="col-2">
                    <input type="text" class="form-control general_bmi" id="triage_bmi" name="triage_bmi" value="<?= $bmi; ?>">
                  </div>
                </div>
                <br>
                <div class="row">
                  <div class="col-2">
                    <label>BP</label>
                  </div>
                  <div class="col-2">
                    <input type="text" class="form-control" id="triage_bp" name="triage_bp" value="<?= $bp; ?>">
                  </div>
                  <div class="col-2">
                    <label>Temperature</label>
                  </div>
                  <div class="col-2">
                    <input type="text" class="form-control" id="triage_temperature" name="triage_temperature" value="<?= $temperature; ?>">
                  </div>
                  <div class="col-2">
                    <label>Pulse</label>
                  </div>
                  <div class="col-2">
                    <input type="text" class="form-control" id="triage_pulse" name="triage_pulse" value="<?= $pulse; ?>">
                  </div>
                </div>
                <br>
                <div class="row">
                  <div class="col-2">
                    <label>RR</label>
                  </div>
                  <div class="col-2">
                    <input type="text" class="form-control" id="triage_rr" name="triage_rr" value="<?= $rr; ?>">
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-12">
                <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                  <label for="app_date">Treatment Date</label>
                  <input type="text" class="form-control select_date" name="treatment_date_general" id="treatment_date_general" value="<?php echo $ent->treat_date; ?>">
                  <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                </div>
                <div class="form-group">
                  <label for="lab_test">Chief Complaint</label>
                  <textarea class="form-control ent_chief_complaint_auto1" name="chief_complaint_general" id="chief_complaint_general" rows="5"><?php echo $ent->chief_complaint_general; ?></textarea>
                </div>
                <div class="form-group">
                  <label for="lab_test">Past Medical History</label>
                  <textarea class="form-control ent_past_medical_auto1" name="subjective_general" id="subjective_general" rows="5"><?php echo $ent->subjective_general; ?></textarea>
                </div>
                <div class="form-group">
                  <label for="lab_test">P. Examination</label>
                  <textarea class="form-control ent_physical_examination_auto1" name="objective_general" id="objective_general" rows="5"><?php echo $ent->objective_general; ?></textarea>
                </div>
                <div class="form-group">
                  <label for="lab_test">Investigation</label>
                  <textarea class="form-control ent_investigation_auto1" name="assessment_general" id="assessment_general" rows="5"><?php echo $ent->assessment_general; ?></textarea>
                </div>
                <div class="form-group">
                  <label for="lab_test">Recommendation</label>
                  <textarea class="form-control ent_recommendation_auto1" name="recommendation_general" id="recommendation_general" rows="5"><?php echo $ent->recommendation_general; ?></textarea>
                </div>
                <div class="form-group">
                  <label for="drugs">Select Diagnosis</label>
                  <input type="text" class="multi_diagnosis" name="diagnosis_general" id="diagnosis_general">
                </div>

                <div class="form-group">
                  <label for="procedure">Select Procedure</label>
                  <select class="procedure" data-department="4" name="procedure_general" id="procedure_general">
                  </select>
                </div>

                <div class="row">
                  <div class="col-10">
                    <button type="button" class="btn btn-sm btn-dark" id="addRow_general">
                      <i class="fa fa-plus-circle"></i> Add
                    </button>
                  </div>
                </div>
                <br>
                <div class="row">
                  <div class="col-12">
                    <div class="panel panel-primary">
                      <div class="panel-heading">
                        <h5>Procedure List</h5>
                      </div>
                      <table class="table table-hover display table-striped w-100" id="treatemnts_ent">
                        <thead>
                          <tr>
                            <th>No</th>
                            <th>Primary Diagnosis</th>
                            <th>Procedure</th>
                            <th>Discount(QR)</th>
                            <th>Discount(%)</th>
                            <th>Fees</th>
                            <th class="text-center">Actions</th>
                          </tr>
                        </thead>
                        <?php
                        foreach ($episodes as $index => $value1) {
                          echo "<tr>
                                        <td>".(++$index). "</td>
                                        <td>" . $value1['aditional_diagnostise_name'] . "<input type='hidden' name='general_diagnosis_name[]' value='" . $value1['aditional_diagnostise_name'] . "'><input type='hidden' name='general_diagnosis_id[]' value='" . $value1['diagnostise_id'] . "'></td>
                                        <td>" . $value1['treatment_name'] . "<input type='hidden' name='general_treatment_name[]' value='" . $value1['treatment_name'] . "'><input type='hidden' name='general_treatment_id[]' value='" . $value1['treatment_id'] . "'></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='hidden' size='7' name='orig_price_general[]' value='" . $value1['fees'] . "'><input type='text' size='7' name='discount_general[]' value='" . $value1['discount_qr'] . "' class='discount_general form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='discount_per_general[]' value='" . $value1['discount_per'] . "' class='discount_per_general form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='fees_general[]' value='" . ($value1['fees'] - $value1['discount_qr']) . "' class='fees_general form-control'></span></td>
                                        <td><button type='button' class='btn btn-light deleteRow_general'><i class='fa fa-trash' aria-hidden='true'></i></button></td>
                                        </tr>";
                          $ctr++;
                        }
                        ?>
                      </table>
                    </div>
                  </div>
                </div>


              </div>
            </div>
            <!-- <div class="row">
            <div class="col-12">
              <div class="panel panel-success">
                <div class="panel-heading">Prescription</div><br>
                <div class="row">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Select Drugs</label>
                      <input type="text" class="form-control drugs" name="drugs_ent" id="drugs_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Doses</label>
                      <input type="text" class="form-control ent_doses_auto" name="drug_qty_ent" id="drug_qty_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="meal">Frequency</label><br>
                      <input type="text" class="form-control ent_frequency_auto" name="drug_meal_ent" id="drug_meal_ent">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="drugs">Duration(Days)</label>
                      <div class="input-group">
                        <input type="text" class="form-control ent_duration_auto" name="drug_note_ent" id="drug_note_ent">
                        <span class="input-group-addon">
                          <button type="button" class="btn btn-light btn-xs add_field_button_ent" id="add_drug_ent">+</button>
                          <button type="button" class="btn btn-danger btn-xs clear_field_ent" id="clear_field_ent">x</button>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="input_fields_wrap_ent"></div>
              </div>
            </div>
          </div> -->
            <div class="row">
              <div class="col-12">
                <div class="form-group">
                  <label for="drugs">Note</label>
                  <textarea type="text" class="form-control note" name="note" id="note"><?php echo $ent->note; ?></textarea>
                </div>
              </div>
            </div>

            <!-- <div class="form-group">
    <label for="note">Note</label>
    <textarea class="form-control" name="note_con" id="note_con" rows="3"></textarea>
  </div> -->

            <label for="attachment">Attachment</label>
            <div class="input-group">
              <span class="input-group-btn">
                <span class="btn btn-default btn-file">
                  Browse&hellip; <input type="file" multiple name="attach_general[]">
                </span>
              </span>
              <input type="text" class="form-control" readonly>
            </div><br>
            <div class="row">
              <div class="col-12">
                <div class="form-group">
                  <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle"></i> Save</button>
                  <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                </div>
              </div>
            </div>
          </div>
        </div>


    </section>
  </div>
  <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>
<script>

  var counter = <?= count($episodes) + 1; ?>;

  $(document).ready(function() {
    var procedureElements = document.querySelectorAll('.procedure');

    var procedureCount = procedureElements.length;

    for (var i = 0; i < procedureCount; i++) {
      var currentElement = procedureElements[i];
      var departmentId = currentElement.getAttribute('data-department');
      initTomSelectProcedres(currentElement, departmentId);
    }

    var diagnosisElements = document.querySelectorAll('.multi_diagnosis');
    var diagnosisCount = diagnosisElements.length;

    for (var i = 0; i < diagnosisCount; i++) {
      var currentElement = diagnosisElements[i];
      var departmentId = currentElement.getAttribute('data-department');
      initTomSelectDiagnosis(currentElement, departmentId);
    }

  });

  $('.drugs').on("focus", function() {
    $(this).autocomplete({
      source: function(request, response) {
        $.ajax({
          url: "<?= base_url('index.php/admin/Modules/Dermatology/DermatologyController/get_drugs'); ?>",
          dataType: "json",
          data: {
            name_startsWith: request.term,
            type: 'drug'
          },
          success: function(data) {
            response($.map(data, function(item) {
              return {
                label: item,
                value: item
              }
            }));
          }
        });
      },
      autoFocus: false,
      minLength: 2
    });
  });

  function initTomSelectProcedres(selector, departmentId) {
    var initTomSelecs = new TomSelect(selector, {
      valueField: 'id',
      labelField: 'name',
      searchField: 'name',
      load: function(query, callback) {
        var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                      echo encrypt_and_url_encode($patient_id, $this) . '&' ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

        fetch(apiUrl)
          .then(response => response.json())
          .then(data => {
            callback(data);
          })
          .catch(() => {
            callback();
          });
      },
      render: {
        option: function(item, escape) {
          return '<div>' +
            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        },
        item: function(item, escape) {
          return '<div>' +
            '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        }
      },
    });

    initTomSelecs.settings.minLength = 2;
  }

  function initTomSelectDiagnosis(selector, departmentId) {
    var multiDiagnosisSelect = new TomSelect(selector, {
      valueField: 'id',
      labelField: 'name',
      searchField: 'name',
      load: function(query, callback) {
        var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

        fetch(apiUrl)
          .then(response => response.json())
          .then(data => {
            callback(data);
          })
          .catch(() => {
            callback();
          });
      },
      render: {
        option: function(item, escape) {
          return '<div>' +
            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        },
        item: function(item, escape) {
          return '<div>' +
            '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
            '</div>';
        }
      },
    });

    multiDiagnosisSelect.settings.minLength = 2;
  }
  var treatemnts_ent = $("#treatemnts_ent").DataTable({
    bFilter: false,
    paging: false,
    info: false,
  });

  $("#addRow_general").on("click", function() {
    // if($("#diagnosis_general").val() === "") {
    //      alert('Diagnosis is required.');
    //       return false;

    //   }

    if ($("#procedure_general").val() == "-1") {
      alert("Procedure is required.");
      return false;
    }

    var split_diagnosis = $("input[name=diagnosis_general]").val().split(",");
    var primary_diagnosis = $("input[name=diagnosis_general]").val().split(" - ");
    var diag_name = "";
    $.each(split_diagnosis, function(index, value) {
      if (value) {
        
        var temp = value.split(" - ");
        diag_name += temp[1] + ",";
      }
    });

    var split_treatment = $("select[name=procedure_general]").val().split(" | ");
    

    if ($("input[name=diagnosis_general]").val().indexOf("-") == -1) {
      var diagnosis =
        $("input[name=diagnosis_general]").val() +
        '<input type="hidden" name="general_diagnosis_name[]" value="' +
        $("input[name=diagnosis_general]").val() +
        '"><input type="hidden" name="general_diagnosis_id[]" value="">';
    } else {
      var diagnosis =
        diag_name +
        '<input type="hidden" name="general_diagnosis_name[]" value="' +
        diag_name +
        '"><input type="hidden" name="general_diagnosis_id[]" value="' +
        primary_diagnosis[0] +
        '">';
    }
    var treat_general =
      split_treatment[1] +
      '<input type="hidden" name="general_treatment_name[]" value="' +
      split_treatment[1] +
      '"><input type="hidden" name="general_treatment_id[]" value="' +
      split_treatment[0] +
      '">';

    treatemnts_ent.row
      .add([
        counter,
        diagnosis,
        treat_general,
        '<input type="hidden" name="orig_price_general[]" value="' +
        split_treatment[2] +
        '"><input type="text" size="7" name="discount_general[]" value="0" class="discount_general form-control">',
        '<input type="text" size="7" name="discount_per_general[]" value="0" class="discount_per_general form-control">',
        '<input type="text" name="fees_general[]" size="7" value="' +
        split_treatment[2] +
        '" class="fees_general form-control">',
        '<div class="text-center"><button type="button" class="btn btn-light deleteRow_general"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
      ])
      .draw();

    counter++;
  });

  $("body").on("click", ".deleteRow_general", function(e) {
    treatemnts_ent.row($(this).parents("tr")).remove().draw();
    return false;
  });

  //ent prescription
  var max_fields = 10; //maximum input boxes allowed
  var wrapper_ent = $(".input_fields_wrap_ent"); //Fields wrapper
  var add_button_ent = $(".add_field_button_ent"); //Add button ID

  var x = 1; //initlal text box count
  $(add_button_ent).on("click", function(e) {
    //on add input button click
    var drug = $("input[name=drugs_ent]").val().split(" - ");
    var drug_qty = $("input[name=drug_qty_ent]").val();
    var meal = $("input[name=drug_meal_ent]").val();
    var drug_note = $("input[name=drug_note_ent]").val();

    if ($('input[name=drugs_ent]').val().length === 0) {
      alert("Please select drugs");
      return false;
    }

    if ($("input[name=drugs_ent]").val().indexOf("-") == -1) {
      var diagnosis =
        '<input type="text" class="form-control drugs" name="drug[]" value="' +
        drug[0] +
        '" id="drugs" disabled>' +
        '<input type="hidden" class="form-control drugs" name="drug_name_ent[]" value="' +
        drug[0] +
        '"><input type="hidden" class="form-control drugs" name="drug_id_ent[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="" id="drugs">';
    } else {
      var diagnosis =
        '<input type="text" class="form-control drugs" name="drug[]" value="' +
        drug[1] +
        '" id="drugs" disabled>' +
        '<input type="hidden" name="drug_name_ent[]" value="' +
        drug[1] +
        '"><input type="hidden" name="drug_id_ent[]" value="' +
        drug[0] +
        '"><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="' +
        drug[2] +
        '" id="drugs">';
    }

    var treat =
      '<div class="row drug_details">\
          <div class="col-md-3">\
            <div class="form-group">' +
      diagnosis +
      '</div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
               <input type="text" class="form-control" name="drugs_qty_ent[]" value="' +
      drug_qty +
      '" id="drug_qty_ent" disabled>\
               <input type="hidden" class="form-control" name="drugs_qty_ent[]" value="' +
      drug_qty +
      '" id="drug_qty_ent" >\
            </div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
              <input type="text" class="form-control" name="meals_ent[]" value="' +
      meal +
      '" id="meal_ent" disabled>\
              <input type="hidden" class="form-control" name="meals_ent[]" value="' +
      meal +
      '" id="meal_ent">\
            </div>\
          </div>\
          <div class="col-md-3">\
            <div class="form-group">\
              <div class="input-group">\
                <input type="text" class="form-control" name="drug_notes_ent[]" value="' +
      drug_note +
      '" id="drug_note_ent" disabled>\
                <input type="hidden" class="form-control" name="drug_notes_ent[]" value="' +
      drug_note +
      '" id="drug_note_ent">\
                <span class="input-group-addon">\
                <button type="button" class="btn btn-danger btn-xs remove_field_ent" id="remove_drug_ent">-</button>\
                </span>\
              </div>\
            </div>\
        </div>\
      </div>';

    $(wrapper_ent).append(treat);

    var drug = $("input[name=drugs_ent]").val("");
    var drug_qty = $("input[name=drug_qty_ent]").val("");
    var drug_note = $("input[name=drug_note_ent]").val("");
    var drug_meal = $("input[name=drug_meal_ent]").val("");
    // var drug_meal = $('input[name=meal_ent]').prop('checked', false);

    return false;
  });

  $(wrapper_ent).on("click", ".remove_field_ent", function(e) {
    //user click on remove text
    $(this).closest(".drug_details").remove();
    return false;
  });

  $(".clear_field_ent").on("click", function(e) {
    var drug = $("input[name=drugs_ent]").val("");
    var drug_qty = $("input[name=drug_qty_ent]").val("");
    var drug_note = $("input[name=drug_note_ent]").val("");
    var drug_meal = $("input[name=meal_ent]").prop("checked", false);
    return false;
  });

  var limit_discount= Number("<?php echo get_discount_limt($this) ?>");


  $('body').on('keyup', '.discount_general', function() {
    this_td = $(this).closest('td'),
      orig_price = $(this).prev('input').val(),
      dis_per_td = this_td.next('td');
    discount_per = $(dis_per_td).find('input').val(),
      fees_td = dis_per_td.next('td');
    fees = $(fees_td).find('input').val(),
      discount = Number($(this).val()).toFixed(2);
      var dis_per =Number((discount * 100 / orig_price).toFixed(2));
                if(limit_discount !=''){
                if(dis_per > limit_discount){
                    
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
                    dis_per = limit_discount
                    discount =((dis_per * orig_price) / 100).toFixed(2);

                    $(this).val(discount);
                }
            }


    dis_per_td.find('input').val(dis_per); //discount_per
    fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
  });

  $('body').on('keyup', '.discount_per_general', function() {
    this_td = $(this).closest('td'),
      dis_td = this_td.prev('td'),
      orig_price = $(dis_td).find('input').val(),
      discount = $(dis_td).find('input').next().val(),
      fees_td = this_td.next('td');
    fees = $(fees_td).find('input').val(),
      discount_per = Number($(this).val()).toFixed(2);
      if(limit_discount !=''){
                if (discount_per > limit_discount) {
                    showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
            $(this).val(limit_discount); // Optionally, reset the value to the limit
            discount_per = limit_discount; // Update discount_per to the limit value
            }
        }
    dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
    fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
  });

  $('body').on('keyup', '.fees_general', function() {
    this_td = $(this).closest('td'),
      dis_per_td = this_td.prev('td');
    discount_per = $(dis_per_td).find('input').val(),
      dis_td = dis_per_td.prev('td'),
      orig_price = $(dis_td).find('input').val(),
      discount = $(dis_td).find('input').next().val(),
      fees = Number($(this).val()).toFixed(2);

    dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
    dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
  });
</script>

</html>