<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .fa-chevron-circle-down.rotate {
            transition-duration: .2s;
            transform: rotate(-180deg);
        }
    </style>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>User group<small> - <?= ($user_group_id_val > 0 ? "Edit" : "Create New") ?> User Group</small></strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>


        <?php if (strlen(trim($error)) > 0) { ?>
            <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
                <p><i class="icon fa fa-warning"></i><?php echo $error; ?></p>
            </div>
        <?php } ?>

        <!-- Main content -->
        <form id="save_form" name="save_form" role="form" action="<?php echo base_url('index.php/admin/UserGroup/UserGroupController/SaveUserGroup') ?>" method="post">
            <section class="content">
                <div class="row">
                    <div class="col-12">
                        <div class="box margin-bottom-5px" style="border-top:none;">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex justify-content-between">
                                            <a href="<?= base_url('index.php/admin/UserGroup/UserGroupController') ?>" class="btn btn-dark btn-sm">
                                                <i class="fa fa-chevron-circle-left" aria-hidden="true"></i>
                                                Go Back
                                            </a>

                                            <a onclick="document.getElementById('save_form').submit(); return false;" href="#" class="btn btn-sm btn-dark <?php echo $this->config->item('save'); ?>">
                                                <i class="fa fa-check-circle" aria-hidden="true"></i> Save
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="box box-info">
                                    <div class="box-header">
                                        <h3 class="box-title font-weight-bold">General Informations</h3>
                                    </div>

                                    <div class="box-body">

                                        <div class="form-group">
                                            <label>Group Name</label>
                                            <input id="UserGroupName" name="UserGroupName" type="text" class="form-control" value="<?php echo $user_group_name_val; ?>" placeholder="Enter ..." />
                                        </div>

                                        <div class="form-group">
                                            <label>Description</label>
                                            <textarea id="UserGroupDescription" name="UserGroupDescription" class="form-control" rows="3" placeholder="Enter ..."><?php echo $user_group_description_val; ?></textarea>
                                        </div>

                                        <input type="hidden" runat="server" id="user_group_Id" name="user_group_Id" value=" <?php echo $user_group_id_val; ?> ">

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <!-- general form elements disabled -->
                                <div class="box box-info">
                                    <div class="box-header">
                                        <h3 class="box-title font-weight-bold">Select user rights</h3>
                                    </div>
                                    <div class="box-body" id="accordion">
                                        <table id="" class="table table-bordered table-striped" style="font-size: 12px;">
                                            <thead>
                                                <tr>
                                                    <th>User rights</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                foreach ($user_right_main_menu_name->result() as $row) {
                                                ?>
                                                    <tr>
                                                        <td>
                                                            <div class="panel grid-panel">
                                                                <div class="box-header padding-0px">
                                                                    <h4 class="box-title w-100">
                                                                        <a class="grid-font" data-toggle="collapse" data-parent="#accordion" href="#collapse_<?php echo  $row->main_menu_code; ?>" onclick="rotateIcon(this)">
                                                                            <div class="d-flex justify-content-between">
                                                                                <span>
                                                                                    <?php
                                                                                    $last_main_menu_name = $row->main_menu_name;
                                                                                    echo $row->main_menu_name;
                                                                                    ?>
                                                                                </span>
                                                                                <i class="fa fa-chevron-circle-down" aria-hidden="true"></i>
                                                                            </div>
                                                                        </a>
                                                                    </h4>
                                                                </div>

                                                            </div>

                                                            <div id="collapse_<?php echo  $row->main_menu_code; ?>" class="panel-collapse collapse">
                                                                <div class="box-body">
                                                                    <div class="row">
                                                                        <?php foreach ($user_group_right->result() as $rowdetails) {
                                                                            if ($last_main_menu_name == $rowdetails->main_menu_name) {
                                                                        ?>
                                                                                <div class="col-md-6" style="padding: 0px;">
                                                                                    <div class="checkbox" style="margin: 0px;">
                                                                                        <label>
                                                                                            <?php if ($rowdetails->selected == 1) { ?>
                                                                                                <label class="lbl_CheckBx"><input type="checkbox" checked name="UserRightName[]" id="dash_user_group_Id[]" value="<?php echo $rowdetails->user_right_Id; ?>">&nbsp;&nbsp;

                                                                                                    <?php echo $rowdetails->second_level != '' ? $rowdetails->second_level : $rowdetails->user_right_name; ?>
                                                                                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>
                                                                                            <?php } else { ?>
                                                                                                <label class="lbl_CheckBx"><input type="checkbox" name="UserRightName[]" id="dash_user_group_Id[]" value="<?php echo $rowdetails->user_right_Id; ?>">&nbsp;&nbsp;

                                                                                                    <?php echo $rowdetails->second_level != '' ? $rowdetails->second_level : $rowdetails->user_right_name; ?>
                                                                                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>
                                                                                            <?php   } ?>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                        <?php }
                                                                        } ?>
                                                                    </div>

                                                                </div>
                                                            </div>

                                                        </td>


                                                    </tr>
                                                <?php } ?>


                                            </tbody>

                                        </table>
                                    </div>
                                </div><!-- /.box -->
                            </div><!--/.col (right) -->
                        </div>
                    </div>


                </div> <!-- /.row -->
            </section><!-- /.content -->
        </form>

    </div><!-- /.content-wrapper -->

    <!-- ./wrapper -->

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>



</body>

</html>

<script>
    function rotateIcon(a) {
        let icon = a.querySelector('.fa-chevron-circle-down');
        icon.classList.toggle('rotate');
    }
</script>