<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>


    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">

    <style>
        .single_line {
            display: flex;
            /* margin: 10px 0; */
            font-size: 18px;
        }

        .single_line label {
            width: 320px;
            margin-bottom: 0;
            text-align: left;
        }

        .single_line label.ar {
            text-align: right;
            direction: rtl;
        }

        .main_title {
            font-size: 25px;
            font-weight: bold;
        }


        @media print {
            .single_line {
                font-size: 20px;
            }

            address {
                font-size: 16px;
            }

        }

        .border {
            border: 1px solid #000 !important;
        }

        .arabic {
            font-size: 20px;
            font-weight: 900;
            text-align: right;
        }

        .w-auto {
            width: auto !important;
        }

        .no-border {
            border: 0 !important;
        }

        .bb-1 {
            border: 0;
            border-bottom: 1px dotted #000;
            text-align: center;
            font-weight: bold;
            background: transparent;
        }

        .bb-1:focus {
            outline: none !important;
        }

        .w-100 {
            width: 100% !important;
        }

        .p-0 {
            padding: 0 !important
        }

        .pt-0,
        .py-0 {
            padding-top: 0 !important
        }

        .pr-0,
        .px-0 {
            padding-right: 0 !important
        }

        .pb-0,
        .py-0 {
            padding-bottom: 0 !important
        }

        .pl-0,
        .px-0 {
            padding-left: 0 !important
        }

        .p-1 {
            padding: .25rem !important
        }

        .pt-1,
        .py-1 {
            padding-top: .25rem !important
        }

        .pr-1,
        .px-1 {
            padding-right: .25rem !important
        }

        .pb-1,
        .py-1 {
            padding-bottom: .25rem !important
        }

        .pl-1,
        .px-1 {
            padding-left: .25rem !important
        }

        .p-2 {
            padding: .5rem !important
        }

        .pt-2,
        .py-2 {
            padding-top: .5rem !important
        }

        .pr-2,
        .px-2 {
            padding-right: .5rem !important
        }

        .pb-2,
        .py-2 {
            padding-bottom: .5rem !important
        }

        .pl-2,
        .px-2 {
            padding-left: .5rem !important
        }

        .p-3 {
            padding: 1rem !important
        }

        .pt-3,
        .py-3 {
            padding-top: 1rem !important
        }

        .pr-3,
        .px-3 {
            padding-right: 1rem !important
        }

        .pb-3,
        .py-3 {
            padding-bottom: 1rem !important
        }

        .pl-3,
        .px-3 {
            padding-left: 1rem !important
        }

        .p-4 {
            padding: 1.5rem !important
        }

        .pt-4,
        .py-4 {
            padding-top: 1.5rem !important
        }

        .pr-4,
        .px-4 {
            padding-right: 1.5rem !important
        }

        .pb-4,
        .py-4 {
            padding-bottom: 1.5rem !important
        }

        .pl-4,
        .px-4 {
            padding-left: 1.5rem !important
        }

        .p-5 {
            padding: 3rem !important
        }

        .pt-5,
        .py-5 {
            padding-top: 3rem !important
        }

        .pr-5,
        .px-5 {
            padding-right: 3rem !important
        }

        .pb-5,
        .py-5 {
            padding-bottom: 3rem !important
        }

        .pl-5,
        .px-5 {
            padding-left: 1rem !important
        }

        .px-15 {
            font-size: 15px !important;
        }
    </style>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->
    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <div class="content-wrapper">

        <section class="content-header no-print">
            <h1>
                <strong>Prescription</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <section class="content">

            <div class="row no-print">
                <div class="col-12">
                    <div class="box box-solid">
                        <div class="box-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="d-flex w-100 justify-content-between">
                                        <a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this)); ?>" class="btn btn-dark btn-sm"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go back</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row print-remove-top-space">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border no-print">
                            <h3 class="box-title font-weight-bold">Prescription</h3>
                        </div>

                        <div class="box-body">
                            <div class="panel-group" id="accordion">

                                <div class="d-block mb-3">
                                    <div class="panel panel-default">
                                        <div class="panel-body">

                                            <div class="row hidden-print">
                                                <div class="col-md-12">
                                                    <?php print_header($this); ?>

                                                    <div class="row mb-2 mt-2">
                                                        <div class="col-md-12 text-center">
                                                            <h2 class="main_title">PRESCRIPTION وصفة طبية </h2>
                                                        </div>
                                                    </div>

                                                    <div class="row pt-2">
                                                        <div class="col-md-12">

                                                            <div class="single_line">
                                                                <label class="px-15 " for="patient_name">Name : </label>
                                                                <input class="px-15 w-100 bb-1" type="text" name="patient_name" id="patient_name" value="<?= $patient_info[0]['patient_name'] ?>">
                                                                <label class="px-15 ar" for="patient_name">الإ سم :</label>
                                                            </div>

                                                            <div class="single_line hidden-print">
                                                                <label class="px-15 " for="patient_num">Patient's Number : </label>
                                                                <input class="px-15 w-100 bb-1" type="text" name="patient_num" id="patient_num" value="<?= $prescription[0]['patient_id'] ?>">
                                                                <label class="px-15 ar" for="patient_num">رقم المريض :</label>
                                                            </div>

                                                            <?php $age = isset($patient_info[0]['dob']) ? date_diff(date_create($patient_info[0]['dob']), date_create('now'))->y : ''; ?>

                                                            <div class="single_line">
                                                                <label class="px-15 " for="age">Age : </label>
                                                                <input class="px-15 w-100 bb-1" type="text" name="age" id="age" value="<?= $age ?>">
                                                                <label class="px-15 ar" for="age">عمر :</label>
                                                            </div>
                                                            <div class="single_line">
                                                                <label class="px-15 " for="age">Physician : </label>
                                                                <input class="px-15 w-100 bb-1" type="text" name="physician" id="physician" value="<?= $prescription[0]['employee_name'] ?>">
                                                                <label class="px-15 ar" for="physician">طبيب :</label>
                                                            </div>
                                                            <div class="single_line">
                                                                <label class="px-15 " for="diagnosis">Diagnosis : </label>
                                                                <textarea class="px-15 w-100 bb-1"><?= $prescription_main->diagnostise_id ?></textarea>
                                                                <label class="px-15 ar" for="diagnosis">تشخبص :</label>
                                                            </div>

                                                        </div>
                                                    </div>

                                                    <div class="row no-print" style="padding-left: 10px;">
                                                        <div class="col-md-10 pt-5">
                                                            <img src="<?php echo IMG . '/rx_symbol.png' ?>" class="img-responsive" alt="<?php ?>">
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <table class="lab table table-bordered table-striped" width="100%">
                                                                <thead>
                                                                    <th class="title" width="34%">Name</th>
                                                                    <th class="title" width="22%">Doses</th>
                                                                    <th class="title" width="22%">Frequency</th>
                                                                    <th class="title" width="22%">Duration(Days)</th>
                                                                </thead>
                                                                <tbody>
                                                                    <?php if ($prescription != FALSE) : ?>
                                                                        <?php foreach ($prescription as $value) : ?>
                                                                            <tr>
                                                                                <td><?= $value['drug_name']; ?></td>
                                                                                <td><?= $value['drug_qty']; ?></td>
                                                                                <td><?= $value['after_before']; ?></td>
                                                                                <td><?= $value['drug_note']; ?></td>
                                                                            </tr>
                                                                        <?php endforeach; ?>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>

                                                    <div class="row physician_sign">
                                                        <div class="col-12 col-sm-6 col-md-6 text-left">
                                                            <p><b>Physician Signature</b></p>
                                                            <img src="<?php echo $doctor_info->doctor_stamp; ?>" alt="">
                                                        </div>
                                                        <div class="col-12 col-sm-6 col-md-6 text-right">
                                                            <p><?php echo "<b>Date:</b> " . $prescription[0]['enter_date']; ?></p>
                                                        </div>
                                                    </div>

                                                    <div class="row hidden-print">
                                                        <div class="col-md-12">
                                                            <div class="d-flex flex-row justify-content-end">
                                                                <button class="btn btn-light btn-sm bt-lg" onclick="window.print();">
                                                                    <i class="fa fa-print" aria-hidden="true"></i> Print
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                    <!-- <table id="price_list" class="table table-light table-bordered table-striped"></table> -->

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>

</html>

<script type="text/javascript">
    $(document).ready(function() {
        var sum = 0;
        //iterate through each input and add to sum
        $('.fees').each(function() {
            sum += parseInt($(this).text());
        });

        $('#total_fees').html('<strong>' + sum.toFixed(2) + '<strong>');
    });
</script>