<?php 
class DatabaseController extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        // Load the Migrate_model
        $this->load->model('Migrator');
    }


    public function migrate_users() {
        // Fetch old users
        $old_users = $this->Migrator->get_old_users();
        
        if (!empty($old_users)) {
            foreach ($old_users as $old_user) {
        
                // Prepare data for the new 'tbl_users' table
                $users = array(
                    'user_Id'        => $old_user['user_id'],
                    'user_name'      => $old_user['username'],
                    'full_name'      => $old_user['employee_name'],
                    'email'          => $old_user['email'] ?? 'hmate@gmail.com',
                    'phone_no'       => $old_user['emp_mobile'] ?? 'hmate@gmail.com',
                    'password'       => $this->generate_password($old_user['username'] . '123'),
                    'user_group_id'  => $old_user['permission_type'],
                    'designation_id' => $this->findDesignation($old_user['permission_type']?? 0),
                     'image'=>$this->image(),   
                    'create_user_Id' => '1'
                );
                
                // Insert into the 'tbl_users' table
                $this->Migrator->savenew('tbl_users',$users);
        
                // Prepare data for the 'tbl_employee' table
                $employees = array(
                    'employee_id'    => $old_user['employee_id'],
                    'user_id'        => $old_user['user_id'],
                    'doctor_stamp'   => $old_user['stamp'],
                    'doctor_license' => $old_user['img_file'],
                    'doctor_type'    => $old_user['specialty_id'] ?? 'NULL',
                    'employee_code'  => $old_user['org_code'],
                    'employee_type'  => 1, // Assuming this is always 1 as in the original code
                    'doctor_color'   => $old_user['color_code'],
                    'department_id'  => $this->findModule($old_user['specialty_id']?? 0),
                    'department'     => $this->findModule($old_user['specialty_id'] ?? 0)
                );
        
                // Insert into the 'tbl_employee' table
                $this->Migrator->savenew('tbl_employees',$employees);
            }
        } else {
            echo "No data found in the old users table.";
        }
    }

    public function image(){
        return 'data:image/png;base64,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';
    }
    
    public function generate_password($password){
        $cost = 10;
        //  $salt = strtr(base64_encode(mcrypt_create_iv(16, MCRYPT_DEV_URANDOM)), '+', '.');
        $salt = strtr(base64_encode(random_bytes(16)), '+', '.');
        $salt = sprintf("$2a$%02d$", $cost) . $salt;
        $hash = crypt($password, $salt);
        return $hash;
    }

    public function findModule($sp){
     
        $dep_id=0;
        switch($sp):
            case 2:
               $dep_id=2;
            break;
            case 3:
                $dep_id=3;
             break;
             case 4:
                $dep_id=9;
             break;
             case 4:
                $dep_id=9;
             break;  
             case 7:
                $dep_id=20;
             break;  
             case 8:
                $dep_id=21;
             break; 
             case 9:
                $dep_id=5;
             break; 
            
             default: $dep_id = $sp;


            endswitch;   
            
            return $dep_id;

    }
    public function findDesignation($sp){
     
        $dep_id=0;
        switch($sp):
            case 2:
               $dep_id=1;
            break;
             default: $dep_id = $sp;


            endswitch;   
            
            return $dep_id;

    }



    // appointments start 

    public function migrate_appointments() {
        // Increase memory limit and execution time
        // ini_set('memory_limit', '512M'); // Increase memory limit if necessary
        set_time_limit(0); // Removes the time limit on script execution
    
        // Fetch old appointments in batches
        $batch_size = 1000;  // Process 1000 records at a time
        $offset = 0;
        
        while (true) {
            // Fetch batch of old appointments
            $old_appointments = $this->Migrator->get_old_appointments($batch_size, $offset);
    
            // Check if there are no more appointments to process
            if (empty($old_appointments)) {
                break;
            }
    
            // Begin transaction for this batch
            $this->db->trans_start();
    
            foreach ($old_appointments as $item) {
                // Prepare data for the new 'tbl_appointment' table
                $appointment_data = array(
                    'appointment_id' => $item['appointment_id'],
                    'appointment_date' => $item['appointment_date'],
                    'appointment_time' => $item['appointment_time'],
                    'appointment_etime' => $item['appointment_etime'],
                    'patient_id' => $item['patient_id'],
                    'doctor_id' => $item['doctor_id'],
                    'user_id' => $item['user_id'],
                    'app_info_id' => $item['app_info_id'],
                    'app_treat_id' => $item['app_treat_id'],
                    'procedure_id' => $item['procedure_id'],
                    'end_time' => $item['end_time'],
                    'note' => $item['note'],
                    'branch' => $item['branch'],
                    'resource_id' => $item['room_nu'],
                    'department' => $item['department'],
                    'datetime' => $item['datetime'],
                    'sms_active' => $item['sms_active'],
                    'send_time' => $item['send_time'],
                    'sms_lang' => $item['sms_lang'],
                    'sms_status' => $item['sms_status']
                );
                
                // Insert the data into the new 'tbl_appointment' table
                $this->Migrator->savenew('tbl_appointment', $appointment_data);
            }
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
    
            // Increase offset for the next batch
            $offset += $batch_size;
        }
    
        echo "Migration completed successfully.";
    }

    public function migrate_app_info() {
        $batch_size = 1000;  // Batch size for processing
        $offset = 0;
    
        // Fetch column names of the new table (tbl_appointment in this case)
        $new_table_columns = $this->db->list_fields('tbl_appointment_patient_info');
    
        
        // Define manual mapping for columns that differ
        $column_mapping = array(
            'nationality' => 'nationality_code',   // old column => new column
            'marital' => 'marital_status',
            'insurance_type' => 'insurance_type_id',
            'building' => 'build',
            'note' => 'patient_note',
            'black' => 'black_list',
           
            // Add more manual mappings as needed...
        );
       
        while (true) {
            // Fetch a batch of old patient records
            $old_patients = $this->Migrator->get_old_app_info($batch_size, $offset);
    
            // Exit the loop if there are no more records to process
            if (empty($old_patients)) {
                break;
            }
    
            // Begin transaction for batch processing
            $this->db->trans_start();
         
            foreach ($old_patients as $item) {
                // Initialize an array for the new data
                $appointment_data = array();
    
                // Iterate through new table column names and map data
                foreach ($new_table_columns as $new_column) {
                    // Check if the old column name exists in the mapping
                    if (array_key_exists($new_column, $column_mapping)) {
                        // Use the old column name from the mapping
                        $old_column = $column_mapping[$new_column];
                        $appointment_data[$new_column] = $item[$old_column];
                    } else {
                        // If column names are the same, map them directly
                        if (isset($item[$new_column])) {
                            $appointment_data[$new_column] = $item[$new_column];
                         
                        }
                    }
                }
               
                $this->Migrator->savenew('tbl_appointment_patient_info', $appointment_data);
            }
           
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
    
            // Move to the next batch
            $offset += $batch_size;
        }
        
        echo "Migration completed successfully.";
    }

    public function migrate_appointments_block() {
        // Increase memory limit and execution time
        // ini_set('memory_limit', '512M'); // Increase memory limit if necessary
        set_time_limit(0); // Removes the time limit on script execution
    
        // Fetch old appointments in batches
        $batch_size = 1000;  // Process 1000 records at a time
        $offset = 0;
        
        while (true) {
            // Fetch batch of old appointments
            $old_appointments = $this->Migrator->get_old_appointments_block($batch_size, $offset);
           
            // Check if there are no more appointments to process
            if (empty($old_appointments)) {
                break;
            }
    
            // Begin transaction for this batch
            $this->db->trans_start();
    
            foreach ($old_appointments as $item) {
                // Prepare data for the new 'tbl_appointment' table
                $appointment_data = array(
                    'app_block_date' => $item['app_block_date'],
                    'app_block_date_to' => $item['app_block_date_to'],
                    'app_block_stime' => $item['app_block_stime'],
                    'app_block_etime' => $item['app_block_etime'],
                    'user_id' => $item['user_id'],
                    'doctor_id' => $item['doctor_id'],
                    'remarks' => $item['remarks'],
                    'block_id' => $item['app_block_id'],
                    'resource_id' => $item['room_nu'],
                   
                );
                
                // Insert the data into the new 'tbl_appointment' table
                $this->Migrator->savenew('tbl_appointment_block', $appointment_data);
            }
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
    
            // Increase offset for the next batch
            $offset += $batch_size;
        }
    
        echo "Migration completed successfully.";
    }


    public function migrate_patients() {
        $batch_size = 1000;  // Batch size for processing
        $offset = 0;
    
        // Fetch column names of the new table (tbl_appointment in this case)
        $new_table_columns = $this->db->list_fields('tbl_patients');
    
        
        // Define manual mapping for columns that differ
        $column_mapping = array(
            'nationality' => 'nationality_code',   // old column => new column
            'marital' => 'marital_status',
            'insurance_type' => 'insurance_type_id',
            'building' => 'build',
            'note' => 'patient_note',
            'black' => 'black_list',
           
            // Add more manual mappings as needed...
        );
        $qid=1;
        while (true) {
            // Fetch a batch of old patient records
            $old_patients = $this->Migrator->get_old_patients($batch_size, $offset);
    
            // Exit the loop if there are no more records to process
            if (empty($old_patients)) {
                break;
            }
    
            // Begin transaction for batch processing
            $this->db->trans_start();
         
            foreach ($old_patients as $item) {
                // Initialize an array for the new data
                $appointment_data = array();
    
                // Iterate through new table column names and map data
                foreach ($new_table_columns as $new_column) {
                    // Check if the old column name exists in the mapping
                    if (array_key_exists($new_column, $column_mapping)) {
                        // Use the old column name from the mapping
                        $old_column = $column_mapping[$new_column];
                        $appointment_data[$new_column] = $item[$old_column];
                    } else {
                        // If column names are the same, map them directly
                        if (isset($item[$new_column])) {
                            $appointment_data[$new_column] = $item[$new_column];
                            $appointment_data['qatar_id'] = $item['qatar_id'];
                        }
                    }
                }
               
                $this->Migrator->savenew('tbl_patients', $appointment_data);
            }
           
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
    
            // Move to the next batch
            $offset += $batch_size;
        }
        
        echo "Migration completed successfully.";
    }

    public function deletePatientsByIds($ids) {
        // Ensure that $ids is an array
        if (!is_array($ids) || empty($ids)) {
            return false; // or handle the error as needed
        }

        // Sanitize IDs to avoid SQL injection (ensure they're integers)
        $sanitized_ids = array_map('intval', $ids);

        // Convert the array of IDs into a comma-separated string
        $ids_string = implode(',', $sanitized_ids);

        // Prepare the SQL DELETE statement
        $this->Migrator->deletePatients($ids_string);
    }

    public function dt(){
        $ids= [19170,19456,1223,15922,18515,10620,13150,2289,13462,16421,5696,15061,6231,4119,3007,18566,7489,11571,1727,14270,3948,8409,9633,7831,13027,18937,16569,17871,10490,17065,4896,8074,12221,16311,2135,3326,15027,4286,13794,4349,3373,8434,7535,11655,9989,17377,16534,17998,13909,3658,11318,3901,11519,17251,2586,17538,11471,2193,13151,16475,14070,6520,4480,7756,2539,9666,6567,1986,9477,13286,9301,3207,5285,18307,960,13310,15165,10407,15140,5902,1228,1602,11208,19098,14889,12884,5865,8935,2619,2526,10711,5966,2838,9694,17740,3569,4322,1553,17521,2799,8898,12251,1809,3426,7210,2753,1007,19062,6310,18533,9959,15787,13505,1630,2519,5601,16682,2438,13777,102,7653,5572,9047,1930,15694,15710,6128,1852,2133,14216,697,16586,16643,5585,6288,4250,6972,7362,8246,14336,1087,1260,7120,10540,1940,2858,10720,6390,5964,798,4701,19130,19131,19043,7391,6771,7461,1131,19165,19166,3425,13582,15892,3612,11144,16292,5306,4808,5004,9926,2458,3138,3084,7303,8956,7426,2114,1778,2621,19342,7782,14370,12234,18572,7310,5261,4633,18518,6225,12027,1323,4447,9844,6357,9067,8603,3890,18032,1476,3076,1558,17873,17701,6493,10730,17653,3533,9042,11166,11785,16878,15301,10779,489,15823,2616,2261,1320,6274,328,7258,5831,2367,3911,7586,10353,5797,17411,17671,12505,9427,7075,5424,1635,11882,10360,8899,7110,11947,2300,8382,4360,10348,3092,6240,4386,487,1445,9745,5200,6764,7207,17011,1857,12144,6333,3674,6883,16866,4844,9487,15367,16966,2317,9995,1084,13987,12177,2250,3660,3846,18332,755,500,18232,15335,18942,14249,13874,1498,5653,4793,2988,1206,6198,5525,13180,18975,10333,10788,16507,4590,1766,18987,1189,16750,18683,1556,1570,1575,1645,1682,1799,1910,1915,1961,2013,2049,2147,2160,2188,2210,2296,2348,2559,2565,2625,2687,2754,2755,2771,2831,2868,2874,2927,3002,3014,14071,14079,14081,14102,14327,14328,14343,14423,14427,14450,14520,14531,14575,14580,14761,14786,15051,15095,15100,15114,15245,15306,15510,15529,10969,11018,11033,11120,11252,11312,11338,11341,11352,11419,11454,11487,11509,11707,11712,11778,11807,11936,11961,11962,12029,12054,12070,12214,12229,12325,12399,4771,4917,4962,4969,5006,5065,5075,5092,5121,5323,5359,5418,5567,5633,5675,5804,5879,5933,5940,5997,6068,6116,6152,6214,17185,17246,17252,17254,17396,17417,17442,17464,17470,17478,17632,17799,17813,17952,17969,18010,18025,18054,18216,18225,18287,18302,18335,18418,18419,18506,18523,18525,18526,18535,18538,18590,18625,7795,7816,7829,7832,7882,7883,7904,7947,8169,8280,8283,8432,8517,8519,8537,8650,8710,8852,8960,9024,9030,9031,9061,9081,9102,9257,9272,9277,9294,6229,6299,6311,6321,6329,6419,6420,6428,6429,6456,6467,6532,6533,6554,6563,6573,6631,6644,6661,6715,6720,6726,6758,6814,6824,6918,6950,6967,7020,7039,7090,7091,7117,7133,7147,7158,7162,7193,7287,7320,7397,7431,7440,7459,7597,7629,7658,7662,7705,7717,7731,7733,7774,12468,12557,12599,12632,12690,12777,12803,13020,13029,13160,13255,13264,13357,13448,13521,13552,13631,13707,13759,13787,13848,13931,3224,3227,3253,3337,3343,3421,3442,3489,3548,3678,3804,3918,3922,4104,4167,4227,4354,4440,4455,4470,4500,4551,4620,9472,9554,9559,9695,9696,9762,9767,9787,9916,9944,10012,10014,10050,10175,10192,10237,10355,10519,10640,10731,10782,10798,10862,15684,15690,15691,15709,15843,15844,15863,15934,16164,16189,16202,16210,16222,16238,16240,16257,16282,16326,16350,16524,16547,16553,16565,16587,16588,16601,16733,16736,16748,16779,16840,16996,16997,17007,17012,17040,18689,18693,18760,18763,18788,19617,19969,1276,1290,1313,1357,1381,1409,1450];
        $this->deletePatientsByIds($ids);
    }

    public function migrate_patient_medical() {
        $batch_size = 1000;  // Batch size for processing
        $offset = 0;
    
        // Fetch column names of the new table (tbl_appointment in this case)
        $new_table_columns = $this->db->list_fields('tbl_patient_medicals');
    
        
        // Define manual mapping for columns that differ
        $column_mapping = array(
           
           
            // Add more manual mappings as needed...
        );
        $qid=1;
        while (true) {
            // Fetch a batch of old patient records
            $old_patients = $this->Migrator->get_old_medical($batch_size, $offset);
           
            // Exit the loop if there are no more records to process
            if (empty($old_patients)) {
                break;
            }
           
            // Begin transaction for batch processing
            $this->db->trans_start();
         
            foreach ($old_patients as $item) {
                // Initialize an array for the new data
                $appointment_data = array();
    
                // Iterate through new table column names and map data
                foreach ($new_table_columns as $new_column) {
                    // Check if the old column name exists in the mapping
                    if (array_key_exists($new_column, $column_mapping)) {
                        // Use the old column name from the mapping
                        $old_column = $column_mapping[$new_column];
                        $appointment_data[$new_column] = $item[$old_column];
                    } else {
                        // If column names are the same, map them directly
                        if (isset($item[$new_column])) {
                            $appointment_data[$new_column] = $item[$new_column];
                            $appointment_data['patient_signature'] = $item['filename'];
                        }
                    }
                }
               
                $this->Migrator->savenew('tbl_patient_medicals', $appointment_data);
            }
           
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
    
            // Move to the next batch
            $offset += $batch_size;

            echo "Migrated".$batch_size;
        }
        
        echo "Migration completed successfully.";
    }
    public function migrate_treatment_payment() {
        $batch_size = 1000;  // Batch size for processing
        $offset = 0;
    
        // Fetch column names of the new table (tbl_appointment in this case)
        $new_table_columns = $this->db->list_fields('tbl_treatment_payment');
    
        
        // Define manual mapping for columns that differ
        $column_mapping = array(
            'treatement_payment_id' => 'treatment_payment_id', 
            'deleted' => 'check_delete',
            'remarks' => 'notes',
            
           
            // Add more manual mappings as needed...
        );
       
        while (true) {
            // Fetch a batch of old patient records
            $old_patients = $this->Migrator->get_old_treatment_payment($batch_size, $offset);
         
            // Exit the loop if there are no more records to process
            if (empty($old_patients)) {
                break;
            }
    
            // Begin transaction for batch processing
            $this->db->trans_start();
    
            foreach ($old_patients as $item) {
                // Initialize an array for the new data
                $appointment_data = array();
    
                // Iterate through new table column names and map data
                foreach ($new_table_columns as $new_column) {
                    // Check if the old column name exists in the mapping
                    if (array_key_exists($new_column, $column_mapping)) {
                        // Use the old column name from the mapping
                        $old_column = $column_mapping[$new_column];
                        $appointment_data[$new_column] = $item[$old_column];
                    } else {
                        // If column names are the same, map them directly
                        if (isset($item[$new_column])) {
                            $appointment_data[$new_column] = $item[$new_column];
                            $appointment_data['insurance_type'] =1;
                            $appointment_data['created_date'] =$item['treat_date'];
                            $appointment_data['department_id'] =$item['dept_id'];
                            $appointment_data['discount'] =$item['doctor_discount']?? 0.00;
                        }
                    }
                }
               
               
                $this->Migrator->savenew('tbl_treatment_payment', $appointment_data);
            }
           
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
    
            // Move to the next batch
            $offset += $batch_size;

            
        }
        
        echo "Migration completed successfully.";
    }

    public function migrate_patient_payment() {
        $batch_size = 1000;  // Batch size for processing
        $offset = 0;
  
       
        while (true) {
            // Fetch a batch of old patient records
            $old_p_payment = $this->Migrator->get_old_patient_payments($batch_size, $offset);
         
            // Exit the loop if there are no more records to process
            if (empty($old_p_payment)) {
                break;
            }
              // Begin transaction for batch processing
              $this->db->trans_start();
    
            foreach($old_p_payment as $p_payment){
                $cashier_discount=0;
                $balance =0;
                $paid_amount= (int)$p_payment['paid_amount'];
              
                if((int)$p_payment['cashier_discount'] > 0){
                    $cashier_discount= (int)$p_payment['cashier_discount'] - (int)$p_payment['doctor_discount'];
                    $cashier_discount = abs($cashier_discount);
                }
                $treatment_total= (int)$p_payment['treatment_total'] - (int)$cashier_discount -(int)$p_payment['doctor_discount'] ;
                if($paid_amount > $treatment_total){
                    $excess_amount = $paid_amount - $treatment_total;
                    $cashier_discount = max(0, (int)$cashier_discount - $excess_amount); // Ensure it doesn't go negative
                    $treatment_total = (int)$p_payment['treatment_total'] - (int)$cashier_discount - (int)$p_payment['doctor_discount'];
                }   
            
                $t_p_payment = $this->Migrator->get_t_payment($p_payment['treatment_payment_id']);
                // $total_payments = count($t_p_payment); // Get the total number of payments
               
                // // Calculate equal discount for each patient payment
                // $discount_per_payment = $total_payments > 0 ? $cashier_discount / $total_payments : 0;
                $first_item = true; 
                foreach($t_p_payment as $item){
                     $data= array(
                        'patient_payment_id'=>$item['patient_payment_id'],
                        'treatment_payment_id'=>$item['treatment_payment_id'],
                        'patient_id'=>$item['patient_id'],
                        'pay_date'=>$item['pay_date'],
                        'pay_time'=>$item['pay_time'],
                        'cash'=>$item['amount'],
                        'pay_type'=>$item['pay_type'],
                        'user_id'=>$item['user_id'],
                        'discount' => $first_item ? $cashier_discount : 0,
                        'bank_name'=>$item['bank_name'],
                        'cheque_date'=>$item['cheque_date'],
                        'cheque_number'=>$item['cheque_number'],
                        'branch'=>$item['branch'] ?? 0,
                        'co_payment'=>0.00,
                        'discount_per'=>'',
                        'total'=>$item['amount'] + $first_item ? $cashier_discount : 0,
                        'excess'=>0.00,
                        'insurance_amount'=>0.00,
                        'createddate'=>$item['pay_date'],
                        'is_refund'=>0,
                     );
                    

                     $this->Migrator->savenew('tbl_patient_payment', $data);
                     $first_item = false;
                }

            }
          
            // Commit the transaction for this batch
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            echo "Transaction failed for batch with offset: $offset. Rolled back.";
            return;  // Exit function after rollback
            }
            // Move to the next batch
            $offset += $batch_size;
        }
        
        echo "Migration completed successfully.";
    }

    public function migrate_episode_payment() {
        $batch_size = 1000;  // Batch size for processing
        $offset = 0;
  
       
        while (true) {
            // Fetch a batch of old patient records
            $old_p_payment = $this->Migrator->get_old_episode_payments($batch_size, $offset);
         
            // Exit the loop if there are no more records to process
            if (empty($old_p_payment)) {
                break;
            }
              // Begin transaction for batch processing
              $this->db->trans_start();
    
            foreach($old_p_payment as $item){
                $fees=(int)$item['fees'] - (int)$item['discount_qr'];
                $orig_price =(int)$item['fees'];
              
                     $data= array(
                        'episode_id'=>$item['episode_id'],
                        'procedure_id'=>$this->get_procedure_id($item['procedure_id']),
                        'episode_type'=>$item['episode_type'],
                        'teeth_number'=>$item['teeth_number'] ?? '',
                        'full_tooth'=>$item['full_tooth'],
                        'quantity'=>$item['bill_qty'],
                        'diagnostise_id'=>$item['diagnostise_id'] ?? 0,
                        'aditional_diagnostise_name'=>$item['aditional_diagnostise_id'],
                        'fees' => $fees,
                        'discount_qr'=>$item['discount_qr'],
                        'discount_per'=>$item['discount_per'],
                        'treatement_payment_id'=>$item['treatement_payment_id'],
                        'orig_price'=>$orig_price,
                        'treat_type'=>$item['visit_type'] ?? '',
                       
                     );
                    

                     $this->Migrator->savenew('tbl_episode_payment', $data);
                     
                }

            
          
            // Commit the transaction for this batch
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            echo "Transaction failed for batch with offset: $offset. Rolled back.";
            return;  // Exit function after rollback
            }
            // Move to the next batch
            $offset += $batch_size;
        }
        
        echo "Migration completed successfully.";
    }
    
    public function get_procedure_id($id){
        $data= $this->Migrator->retrieve_data_unique_row('tbl_insurance_prices','treatment_id',$id);
        return $data->id ?? '';
    }
    public function migrate_treatment_price() {
        $batch_size = 1000;  // Batch size for processing
        $offset = 0;
  
       
        while (true) {
            // Fetch a batch of old patient records
            $old_p_payment = $this->Migrator->get_old_treatment_price($batch_size, $offset);
         
            // Exit the loop if there are no more records to process
            if (empty($old_p_payment)) {
                break;
            }
              // Begin transaction for batch processing
              $this->db->trans_start();
    
            foreach($old_p_payment as $item){
           
              
                     $data= array(
                        'insurance_type_id'=>1,
                        'treatment_id'=>$item['p_treatment_id'],
                        'treatment_name'=>$item['p_treatment_name'] ?? '',
                        'treatment_name_ar'=>$item['p_treatment_name_ar'] ?? '',
                        'lqdc_gross'=>$item['lqdc_gross'],
                        'treatment_category'=>$this->findCat($item['p_treatment_category']?? 0),
                       
                     );
                    

                     $this->Migrator->savenew('tbl_insurance_prices', $data);
                     
                }

            
          
            // Commit the transaction for this batch
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            echo "Transaction failed for batch with offset: $offset. Rolled back.";
            return;  // Exit function after rollback
            }
            // Move to the next batch
            $offset += $batch_size;
        }
        
        echo "Migration completed successfully.";
    }
    public function findCat($cat){
        $newcat=0;
       switch ($cat) {
       
            case 4:
            $newcat=8;
            break;

            case 6:
            $newcat=20;
            break;
            case 8:
            $newcat=9;
            break;
            case 9:
            $newcat=21;
            break;
            case 10:
                $newcat=13;
                break;
                case 9:
                    $newcat=21;
                    break;
        
        default:
        $newcat=$cat;
            break;
       }

       return $newcat;

    }

//derma treatments

public function migrate_derma() {
    $batch_size = 1000;  // Batch size for processing
    $offset = 0;

    // Fetch column names of the new table (tbl_appointment in this case)
    $new_table_columns = $this->db->list_fields('tbl_treat_derma');

    
    // Define manual mapping for columns that differ
    $column_mapping = array(
       
        // Add more manual mappings as needed...
    );
    $qid=1;
    while (true) {
        // Fetch a batch of old patient records
        $old_patients = $this->Migrator->get_old_derma($batch_size, $offset);

        // Exit the loop if there are no more records to process
        if (empty($old_patients)) {
            break;
        }
     
        // Begin transaction for batch processing
        $this->db->trans_start();
     
        foreach ($old_patients as $item) {
            // Initialize an array for the new data
            $appointment_data = array();

            // Iterate through new table column names and map data
            foreach ($new_table_columns as $new_column) {
                // Check if the old column name exists in the mapping
                if (array_key_exists($new_column, $column_mapping)) {
                    // Use the old column name from the mapping
                    $old_column = $column_mapping[$new_column];
                    $appointment_data[$new_column] = $item[$old_column];
                } else {
                    // If column names are the same, map them directly
                    if (isset($item[$new_column])) {
                        $appointment_data[$new_column] = $item[$new_column];
                        $appointment_data['patient_id'] = $item['patient_id'] ?? 0;
                    }
                }
            }
           
            $this->Migrator->savenew('tbl_treat_derma', $appointment_data);
        }
       

        // Commit the transaction for this batch
        $this->db->trans_complete();

        // Move to the next batch
        $offset += $batch_size;
    }
    
    echo "Migration completed successfully.";
}
public function migrate_derma_subs() {
    $batch_size = 1000;  // Batch size for processing
    $offset = 0;

    // Fetch column names of the new table (tbl_appointment in this case)
    $new_table_columns = $this->db->list_fields('tbl_treat_derma_subs');

    
    // Define manual mapping for columns that differ
    $column_mapping = array(
       
        // Add more manual mappings as needed...
    );
    $qid=1;
    while (true) {
        // Fetch a batch of old patient records
        $old_patients = $this->Migrator->get_old_derma_subs($batch_size, $offset);

        // Exit the loop if there are no more records to process
        if (empty($old_patients)) {
            break;
        }
     
        // Begin transaction for batch processing
        $this->db->trans_start();
     
        foreach ($old_patients as $item) {
            // Initialize an array for the new data
            $appointment_data = array();

            // Iterate through new table column names and map data
            foreach ($new_table_columns as $new_column) {
                // Check if the old column name exists in the mapping
                if (array_key_exists($new_column, $column_mapping)) {
                    // Use the old column name from the mapping
                    $old_column = $column_mapping[$new_column];
                    $appointment_data[$new_column] = $item[$old_column];
                } else {
                    // If column names are the same, map them directly
                    if (isset($item[$new_column])) {
                        $appointment_data[$new_column] = $item[$new_column];
                        $appointment_data['orig_price'] = $item['fee'] ?? 0;
                        $appointment_data['fee'] = (int)$item['fee'] - (int)$item['discount_qr'] ?? 0;
                    }
                }
            }
           
            $this->Migrator->savenew('tbl_treat_derma_subs', $appointment_data);
        }
       

        // Commit the transaction for this batch
        $this->db->trans_complete();

        // Move to the next batch
        $offset += $batch_size;
    }
    
    echo "Migration completed successfully.";
}
public function migrate_documents() {
    $batch_size = 1000;  // Batch size for processing
    $offset = 0;

 
    while (true) {
        // Fetch a batch of old patient records
        $old_patients = $this->Migrator->get_old_docs($batch_size, $offset);

        // Exit the loop if there are no more records to process
        if (empty($old_patients)) {
            break;
        }
     
        // Begin transaction for batch processing
        $this->db->trans_start();
     
        foreach ($old_patients as $item) {
            // Initialize an array for the new data
            $appointment_data = array(
                'id'=>$item['doc_id'],
                'patient_id'=>$item['patient_id'],
                'name'=>$item['attachment ']??'',
                'document'=>$item['attachment'] ?? '',
                'user_id'=>$item['uploaded_by'],
                
                'date'=>$item['date'],
                'document_type'=>0,
            );

           
           
            $this->Migrator->savenew('tbl_patient_attachments', $appointment_data);
        }
       

        // Commit the transaction for this batch
        $this->db->trans_complete();

        // Move to the next batch
        $offset += $batch_size;
    }
    
    echo "Migration completed successfully.";
}

public function migrate_consent_data() {
    $batch_size = 1000;  // Batch size for processing
    $offset = 0;

    // Fetch column names of the new table (tbl_appointment in this case)
 

    
    // Define manual mapping for columns that differ
    $column_mapping = array(
       
        // Add more manual mappings as needed...
    );
    $qid=1;
    while (true) {
        // Fetch a batch of old patient records
        $old_patients = $this->Migrator->get_old_conset_data($batch_size, $offset);

        // Exit the loop if there are no more records to process
        if (empty($old_patients)) {
            break;
        }
     
        // Begin transaction for batch processing
        $this->db->trans_start();
     
        foreach ($old_patients as $item) {
           $consent_values='';
           $structured_data = [
            'PATIENT_1'    => $item['patient_name'],
            'DOCTOR_1'     => $item['doctor_name'] ?? '',
            'CHECKBOX_1'   => isset($item['checkbox_1']) ? 'on' : 'off',
            'CHECKBOX_2'   => isset($item['checkbox_2']) ? 'on' : 'off',
            'CHECKBOX_3'   => isset($item['checkbox_3']) ? 'on' : 'off',
            'CHECKBOX_4'   => isset($item['checkbox_4']) ? 'on' : 'off',
            'CHECKBOX_5'   => isset($item['checkbox_5']) ? 'on' : 'off',
            'DATE_1'       => $item['print_date'],
            'SIGNATURE_1'  => $item['patient_sign'],
            'SIGNATURE_2'  => $item['witness_sign'],
            'SIGNATURE_3'  => $item['rep_sign'],
            'SIGNATURE_3'  => $item['doctor_sign']
        ];
        
        // Step 3: Serialize the data
        $serialized_data = serialize($structured_data);

print_r($serialized_data);
die();

            $appointment_data = array(
                'consent_data_id'=>$item['concern_form_id'],
                'created_date'=>$item['print_date'],
                'created_time'=>$item['print_time'],
                'consent_values'=>$consent_values,
                'patient_id'=>$item['patient_id'],
                'doctor_id'=>$item['doctor_id'] ?? 0,
                'consent_type'=>$item['concern_type'],
                'consent_lang'=>'en',

            );

        
            
           
            $this->Migrator->savenew('tbl_treat_derma_subs', $appointment_data);
        }
       

        // Commit the transaction for this batch
        $this->db->trans_complete();

        // Move to the next batch
        $offset += $batch_size;
    }
    
    echo "Migration completed successfully.";
}


    public function migrate_countries() {
        // Increase memory limit and execution time
        // ini_set('memory_limit', '512M'); // Increase memory limit if necessary
        set_time_limit(0); // Removes the time limit on script execution
    
        // Fetch old appointments in batches
        $batch_size = 1000;  // Process 1000 records at a time
        $offset = 0;
        
        while (true) {
            // Fetch batch of old appointments
            $old_appointments = $this->Migrator->get_old_countries($batch_size, $offset);
        
            // Check if there are no more appointments to process
            if (empty($old_appointments)) {
                break;
            }
    
            // Begin transaction for this batch
            $this->db->trans_start();
    
            foreach ($old_appointments as $item) {
                
                $this->Migrator->updateCountryID('tbl_countries', trim($item['name']),$item['country_id']);
                
            }
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                // Handle transaction failure
                echo "Transaction failed in batch at offset: " . $offset;
                break;
            }
    
            // Increase offset for the next batch
            $offset += $batch_size;
        }
    
        echo "Migration completed successfully.";
    }
     public function update_logs($id) {
        // Increase memory limit and execution time
        // ini_set('memory_limit', '512M'); // Increase memory limit if necessary
        set_time_limit(0); // Removes the time limit on script execution
    
        // Fetch old appointments in batches
        $batch_size = 1500;  // Process 1000 records at a time
        $offset = 0;
        
        while (true) {
            // Fetch batch of old appointments
            $old_appointments = $this->Migrator->get_old_logs($batch_size, $offset,$id);
     
            // Check if there are no more appointments to process
            if (empty($old_appointments)) {
                break;
            }
          
            // Begin transaction for this batch
            $this->db->trans_start();
    
            foreach ($old_appointments as $item) {
             
               $this->Migrator->updateDocId('tbl_treatment_log',$item['log_id'],6244);
                
            }
    
            // Commit the transaction for this batch
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                // Handle transaction failure
                echo "Transaction failed in batch at offset: " . $offset;
                break;
            }
    
            // Increase offset for the next batch
            $offset += $batch_size;
        }
    
        echo "Migration completed successfully.";
    }
    
    

}
