
<?php
use Twilio\Rest\Client;
class TestController extends CI_Controller
{
    function __construct()
    {
        parent::__construct(); //
        $this->load->model('admin/Calender/CalenderModel');
   
    }
    public function receive_message() {
        // Get incoming data from Twilio
        $data = $this->input->post();
        
        // Log the received data (for debugging)
        $dataString = print_r($data, true);
        $filePath = APPPATH . 'logs/twilio_messages.txt';
        file_put_contents($filePath, "Received Message at " . date('Y-m-d H:i:s') . ":\n" . $dataString . "\n\n", FILE_APPEND);

        // Extract ButtonPayload which contains appointment_id and status
        if (isset($data['ButtonPayload'])) {
            list($appointment_id, $status) = explode('-', $data['ButtonPayload']);

            // Update the appointment status in the database
            $this->update_appointment_status($appointment_id, $status);
            
            // Send a response to Twilio
            echo "Appointment status updated successfully.";
        } else {
            echo "No ButtonPayload found.";
        }
    }

    // Function to update appointment status in the database
    private function update_appointment_status($appointment_id, $status) {
        // Load the database model if you have one (replace 'Appointment_model' with your actual model)
     

        // Update the appointment status in the database
        $this->CalenderModel->update_status($appointment_id, $status);
    }

}