<?php

require_once APPPATH . 'controllers/admin/Jobs/Job/SmsNotification.php';

class CalenderController extends MY_Controller
{

	private $job = null;

	function __construct()
	{
		parent::__construct();

		$this->job = new Job($this);
		$this->load->helper('date');
		$this->load->model('admin/Employees/EmployeesModel');
		$this->load->model('admin/UserGroup/UserGroupModel');
		$this->load->model('admin/Users/UserModel');
		$this->load->model('admin/Calender/CalenderModel');
		$this->load->model('admin/SmsPortal/SmsPortalModel');
		//Commen -------------------------------------
		$this->load->model('admin/CommonModel');
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->load->library('TwilioWhatsApp');
		$this->load->library('SMSAPI');
		
        $this->load->model('admin/Job/NotificationJob');
	}

	public function index()
	{

		if ($this->session->userdata('user_Id') != '') {

			//Commen -------------------------------------
			$loginId = $this->session->userdata('user_Id');
			$data['loginId'] = $loginId;
			$data['active_menu'] = 12;
			$data['active_submenu'] = 1;
			$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
			$data['profile'] = $this->CommonModel->profile($loginId);
			$user = $this->UserModel->get_user_details($loginId);

			$data['countries'] = $this->CalenderModel->retrieve_data('tbl_countries');
			$data['doctors'] = $this->CalenderModel->logged_user_doctors($user[0]['user_group_Id'], $loginId);
			$data['selectedDate'] = date('Y-m-d');

// 			$data['dataList'] = $this->CalenderModel->getList($data);
			$data['pending_orders'] = $this->CalenderModel->get_pending_orders();
			$data['booking_status'] = $this->CalenderModel->get_booking_status();
			$data['general_settings'] = $this->CalenderModel->retrieve_data_unique_row('general_settings', 'type', 'appointment');
			$data['queue_system'] = $this->checkQueueSystem();
		
			$this->load->view('admin/Calender/Appointment', $data);
		} else {
			redirect('admin/Login/LoginController', 'refresh');
		}
	}


	public function dayOrders()
	{

		$data['selectedDate'] = $_POST['selected_date'];

		$details = $this->CalenderModel->getList($data);

		echo json_encode($details->result());
		return;
	}


	public function load_appointments()
	{
		// $events = " ";
		$loginId = $this->session->userdata('user_Id');
		$events['calendar'] = array();
		//$doctor_id = $this->input->post('doctor_id');
		$start_date = $_GET['start'];
		$end_date = $_GET['end'];
		$doctors_str = $_GET['doctors'];

		$user = $this->UserModel->get_user_details($loginId);

		$doctors = $this->CalenderModel->logged_user_doctors($user[0]['user_group_Id'], $loginId);
		
		$doctor_list = [];
		foreach ($doctors  as  $value) {
			$doctor_list[] = $value->user_Id;
		};
		$doctors_str_user = (implode(',', $doctor_list));

		$doctors_str = $doctors_str != 1 ? $doctors_str : $doctors_str_user;
		
		$appointments = $this->CalenderModel->get_appointments($doctors_str, $start_date, $end_date);
		$app_block = $this->CalenderModel->get_block_appointments($doctors_str, $start_date, $end_date);
		

		if ($appointments != FALSE) {
			foreach ($appointments as  $value) {

				$status = "";
				$color_code = "#4db8ff";
				$status_element = '<label class="badge" STYLE>STATUS</label>';
                $statusMapping = [
    '1' => ['BOOKED', '#1E88E5'],       // Blue
    '2' => ['NO ANSWER', '#9E9E9E'],    // Grey
    '3' => ['CONFIRMED', '#A5D6A7'],    // Light Green
    '4' => ['CANCEL', '#FFEB3B'],       // Yellow
    '5' => ['WAITING', '#FF9800'],      // Orange
    '6' => ['NOT CAME', '#F44336'],     // Red
    '7' => ['ARRIVED', '#9C27B0'],      // Purple
    '8' => ['ONGOING', '#BDBDBD'],      // Light Grey
    '9' => ['DONE', '#388E3C'],         // Dark Green
    '10' => ['RESCHEDULE', '#FFC107'],  // Amber
    '11' => ['CALLING', '#03A9F4'],     // Light Blue
];

				if (array_key_exists($value['now_waiting'], $statusMapping)) {
					list($status, $color_code) = $statusMapping[$value['now_waiting']];
				} else {
					// Default values for unknown status
					$status = "UNKNOWN";
					$color_code = "#000000";
				}
				$status = str_replace("STATUS", $status, $status_element);
				$status = str_replace("STYLE", 'style="background-color:' . $color_code . ';color:black;margin: 2px;font-weight:600;border:0.2px inset black"', $status);

				if ($value['app_patient_name'] == "Close") {
					$eventsArray['title'] = "";
				} else {
					if ($value['patient_id'] == NULL) {
						$eventsArray['title'] = "New," . $value['app_patient_name'] . ', ' . $value['app_patient_contact'] . ', -' . preg_replace('~[\r\n]+~', '\n', $value['note']);
						$eventsArray['new'] = '1';
					} else {
						if ($value["insurance_type_id"] == 1) {

							if ($value["company_id"] == -1) {
								$eventsArray['title'] = $value['patient_id'] . ", " . $value["app_patient_name"] . ", " . $value["app_patient_contact"] . ", -" . preg_replace('~[\r\n]+~', '\n', $value['note']);
							} else {
								$eventsArray['title'] = $value['patient_id'] . "," . $value["app_patient_name"] . ", " . $value["app_patient_contact"] . ", -" . preg_replace('~[\r\n]+~', '\n', $value['note']);
							}
						} else {
							$eventsArray['title'] = $value['patient_id'] . ",  " . $value["app_patient_name"] . ", " . $value["app_patient_contact"] . ", -" . preg_replace('~[\r\n]+~', '\n', $value['note']) ."(" . $value["insurance_name"] . ")" ;
						}
						$eventsArray['new'] = '2';
					}
				}

				$eventsArray['start'] =  $value['appointment_date'] . 'T' . $value['appointment_time'];
				$eventsArray['end'] =  $value['appointment_date'] . 'T' .   $value['appointment_etime'];
				// $eventsArray['color'] =  $color_code;
				// if ($doctor_id!=000) {
				// $eventsArray['color'] =  $value['col_code'];
				// } else {
				// $eventsArray['color'] =  $value['color_code'];
				// }
				$eventsArray['textColor'] = 'black';
				$eventsArray['start_time'] =  $value['appointment_time'];
				$eventsArray['end_time'] =  $value['appointment_etime'];
				$eventsArray['adate'] =  $value['appointment_date'];
				$eventsArray['doctor_id'] =  $value['doctor_id'];
				$eventsArray['doctor_name'] =  $value['doctor_name'];
				$eventsArray['event_id'] =  $value['appointment_id'];
				$eventsArray['app_treat_id'] =  $value['app_treat_id'];
				$eventsArray['username'] =  $value['username'];
				$eventsArray['patient_id'] =  encrypt_and_url_encode($value['patient_id'], $this);
				$eventsArray['app_patient_id'] =  $value['app_patient_id'];
				$eventsArray['app_patient_contact'] =  $value['app_patient_contact'];
				$eventsArray['app_patient_name'] =  $value['app_patient_name'];
				$eventsArray['app_patient_qatar_id'] =  $value['app_patient_qatar_id'];
				$eventsArray['app_patient_category_id'] =  $value['app_patient_category_id'];
				$eventsArray['type'] = '1';
				$eventsArray['resourceId'] = $value['doctor_id'];
				$eventsArray['note'] =  preg_replace('~[\r\n]+~', '\n', $value['note']);
				$eventsArray['status'] = $value['now_waiting'];
				$eventsArray['sms_active'] =  $value['sms_active'];
				$eventsArray['sms_lang'] =  $value['sms_lang'];
				$eventsArray['doctor_color'] =  $value['doctor_color'];
				$eventsArray['wa_mobile'] =  $value['wa_mobile'];
				$eventsArray['wa_code'] =  $value['wa_code'];
				$eventsArray['status_element'] = $status;
				$events['calendar'][] = $eventsArray;
			}
		}

		if ($app_block != FALSE) {
			foreach ($app_block as  $value) {

				$eventsArray['resourceId'] =  $value['doctor_id'];
				$eventsArray['doctor_id'] =  $value['doctor_id'];
				$eventsArray['title'] =  ($value['remarks']) ? $value['remarks'] : "Unavailable";
				$eventsArray['start'] =  $value['app_block_date'] . 'T' . $value['app_block_stime'];
				$eventsArray['end'] =  $value['app_block_date_to'] . 'T' . $value['app_block_etime'];
					$eventsArray['start_time'] =   $value['app_block_stime'];
				$eventsArray['end_time'] =   $value['app_block_etime'];
				$eventsArray['color'] =  'white';
				$eventsArray['className'] = 'fc-unavailable';
				$eventsArray['block_id'] =  $value['block_id'];
				$eventsArray['block_date'] =  $value['app_block_date'];
				$eventsArray['block_date_to'] =  $value['app_block_date_to'];
				$eventsArray['block_time_from'] =  $value['app_block_stime'];
				$eventsArray['block_time_to'] =  $value['app_block_etime'];
				$eventsArray['doctor_color'] =  'black';
				$eventsArray['type'] =  '2';
				$eventsArray['note'] = $value['remarks'];
				$eventsArray['status_element'] = '<label  style="background-color:#f6bf26;color:black;margin: 2px;font-weight:600;border:0.2px solid #494949" class="badge" STYLE>BLOCKED</label>';
				$events['calendar'][] = $eventsArray;
			}
		}
		$events['doctors'] = explode(',', $doctors_str);
		
		echo json_encode($events);
	}
	public function checkQueueSystem()
	{
		$data =   $this->db->select('*')
			->from('queue_config')
			->get()
			->row();
		return $data;
	}


	public function saveAppoinment()
	{

		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");

		$patient_array = explode(' - ', $this->input->post('apatient_id'));
		// $br_id = $this->get_file->get_branch();
		$patient_appointment = $this->input->post('patient_appointment');
		$new_patient = ucwords(strtolower($this->input->post('new_patient_id')));
		$new_mobile = $this->input->post('new_mobile_id');
		$existing_mobile = $this->input->post('a_mobile_id');
		$new_qatar_id = $this->input->post('new_qatar_id');
		$new_category = $this->input->post('category');
		$poppup_adate = $this->input->post('poppup_adate');
		$poppup_edate = $this->input->post('poppup_edate');
		$poppup_atime = $this->input->post('poppup_atime');
		$poppup_etime = $this->input->post('poppup_aetime');
		$doctor_id = $this->input->post('doctor_id');
		$status = $this->input->post('status');
		$treatment_name = $this->input->post('treatment_name');
		$note = $this->input->post('notes');
		$user_id = $this->session->userdata('user_Id');
		$sms = $this->input->post('popup_sms');
		$language = $this->input->post('popup_language');
		$popup_whatsapp = $this->input->post('popup_whatsapp');
		$appointment_id = "";
		$wa_mobile = $this->input->post('wa_mobile');
		$country = $this->input->post('country');
		$whatsapp_mobile='';
// 		$check_appointment = $this->CalenderModel->checkAlreadyAppointment($poppup_adate, $poppup_atime, $poppup_etime, $doctor_id);

// 		if (!empty($check_appointment)) {
// 			return $this->sendJsonResponse('error', 'Appointment Slot is Blocked');
// 			exit;
// 		}

		$this->db->trans_start();
		try {
			if ($patient_appointment == 0) {

				$newdata = array(
					'app_patient_name' => $new_patient,
					'app_patient_contact' => $new_mobile,
					'app_patient_qatar_id' => $new_qatar_id,
					'app_patient_category_id' => $new_category,
					'app_reg_date' => $curr_date,
					'now_waiting' => $status,
					'wa_mobile' => $wa_mobile,
					'wa_code' => $country,
					'patient_id' => null
				);
				$whatsapp_mobile = $country.$wa_mobile;
				$app_info_id = $this->CalenderModel->insert_data('tbl_appointment_patient_info', $newdata);

				$newdata_apt = array(
					'app_info_id' => $app_info_id,
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'doctor_id' => $doctor_id,
					'note' => $note,
					'sms_active' => $sms,
					'sms_lang' => $language,
					'user_id' => $this->session->userdata('user_Id')
				);



				$log_details = array(
					'app_patient_name' => $new_patient,
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'doctor_id' => $doctor_id,
				);

				$id = $appointment_id = $this->CalenderModel->insert_data('tbl_appointment', $newdata_apt);

				// $log_details_old = $this->prepLogArray([],'appointment');
				$log_details_new = $this->prepLogArray($log_details, 'appointment');
				
				$this->logRecord('Appointments Laser', 'Create', $id, [], $log_details_new);

				$msg = 'Appointment Created Successfully';
			} else if ($patient_appointment == 1) {
				$patient_data =$this->CalenderModel->retrieve_data_unique_row('tbl_patients', 'patient_id',$patient_array[0]);
				$newdata = array(
					'app_patient_name' => $patient_array[1],
					'app_patient_contact' => $patient_array[2],
					'app_patient_category_id' => $new_category,
					'patient_id' => $patient_array[0],
					'now_waiting' => $status,
					'app_reg_date' => $curr_date,
					'wa_mobile' => $patient_data->wa_mobile,
					'wa_code' => $patient_data->wa_code,
					
				);
				$whatsapp_mobile = $patient_data->wa_code.$patient_data->wa_mobile;
				$app_info_id = $this->CalenderModel->insert_data('tbl_appointment_patient_info', $newdata);

				$newdata_apt = array(
					'app_info_id' => $app_info_id,
					'patient_id' => $patient_array[0],
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'doctor_id' => $doctor_id,
					'note' => $note,
					'app_treat_id' => $treatment_name,
					'sms_active' => $sms,
					'sms_lang' => $language,
					'user_id' => $user_id
				);

				// $log_details = array_merge($newdata_apt, $newdata);
				$id = $appointment_id = $this->CalenderModel->insert_data('tbl_appointment', $newdata_apt);

				$log_details = array(
					'app_patient_name' => $patient_array[1],
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'doctor_id' => $doctor_id,
				);

				$log_details_new = $this->prepLogArray($log_details, 'appointment');
				
				$this->logRecord('Appointment', 'Create', $id, [], $log_details_new);
				// $this->createLog('appointment', $user_id, 'Create', $log_details);

				$msg = 'Appointment Created Successfully';
			} else if ($patient_appointment == 2) {
				$newdata = array(
					'app_block_date' => $poppup_adate,
					'app_block_date_to' => $poppup_edate,
					'app_block_stime'  => $poppup_atime,
					'app_block_etime'  => $poppup_etime,
					'user_id' => $user_id,
					'remarks' => $note,
					'doctor_id' => $doctor_id
				);

				$id = $this->CalenderModel->insert_data('tbl_appointment_block', $newdata);
				// $this->createLog('Appintments Block', $user_id, 'Create', $newdata);

				$log_details_new = $this->prepLogArray($newdata, 'appointment_block');
				
				$this->logRecord('Appointment Block', 'Create', $id, [], $log_details_new);

				$msg = 'Block Appointment Created Successfully';
			}
			

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				
				
				if ((int)$sms && (!empty($existing_mobile) || !empty($new_mobile))) {

					/**
					 * ar = 2
					 * en = 1
					 */
					
					if (!empty($new_mobile)) $phone = $new_mobile;
					if (!empty($existing_mobile)) $phone = $existing_mobile;
					$message = $this->SmsPortalModel->getTemplate('create_appointment', (int)$language == 1 ? 'en' : 'ar');
					
					if (!empty($message->template)) {
						
						$patient_name = null;
						if (!empty($new_patient)) $patient_name = $new_patient;
						if (!empty($patient_appointment)) $patient_name = $patient_data->patient_name;
						//send msg
						$message->template = str_replace(['{PATIENT_NAME}', '{APP_DATE}', '{APP_TIME}'], [$patient_name, $poppup_adate, $poppup_atime . ' - ' . $poppup_etime], $message->template);
						$message->template = $message->template . "\r\nDate:" . $poppup_adate;
						$smsjob = array(
							'message' => $message->template,
							'phone' => $phone,
							'whatsapp_mobile' => $whatsapp_mobile ?? '',
							'patient_name' => $patient_name,
							'app_date' => $poppup_adate,
							'app_time' => $poppup_atime . ' - ' . $poppup_etime
						);
						$smsjob = json_encode($smsjob);
						$job = array(
							'queue' => 'DEFAULT',
							'payload' => $smsjob,
							'event' => 'create_appointment',

						);
						
						$smsJob = $this->CalenderModel->insert_data('tbl_jobs', $job);
					}
				}
				$this->db->trans_commit();
			}
		} catch (Exeception $e) {
			$this->db->trans_rollback();
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}

		if ($this->checkQueueSystem()->enable == 1) {
			if ($status == 5) {
				$newdata_queue = array(
					'doctor_id' => $doctor_id,
					'patient_id' => $app_info_id,
					'appointment_id' => $appointment_id,
					'status' => $status
				);


				$queue = $this->CalenderModel->createQueue('queue', $newdata_queue);
				if ($this->checkQueueSystem()->print_sms == 1) {
					$sms = new SmsNotification($this, null, null, '77393781', 'Your token Number is' . $queue->number);
					$this->job->new('DEFAULT', $payload = $sms, $attempts = 2, $available_at = null);
				}
			}
			if ($status == 11 || $status == 8 || $status == 9) {
				$newdata_queue = array(
					'doctor_id' => $doctor_id,
					'patient_id' => $app_info_id,
					'appointment_id' => $appointment_id,
					'status' => $status
				);
				$queue = $this->CalenderModel->updateQueue($newdata_queue);
			}
		}

		$this->db->trans_complete();
		return $this->sendJsonResponse('success', $msg, $queue);
	}

	public function dragUpdateEvent()
	{

		$poppup_adate = $this->input->post('date');
		$poppup_atime = $this->input->post('start_time');
		$poppup_etime = $this->input->post('end_time');
		$doctor_id = $this->input->post('doctor_id');
		$appointment_id = $this->input->post('id');

		$newdata = array(
			'appointment_date' => $poppup_adate,
			'appointment_time'  => $poppup_atime,
			'appointment_etime'  => $poppup_etime,
			'doctor_id' => $doctor_id
		);

		$this->CalenderModel->update_data_where(
			'tbl_appointment',
			'appointment_id',
			$appointment_id,
			$newdata
		);
		return $this->sendJsonResponse('success', 'Appointment Updated!');
	}
	
	public function dragUpdateEventBlock()
	{

		$poppup_adate = $this->input->post('date');
		$poppup_atime = $this->input->post('start_time');
		$poppup_etime = $this->input->post('end_time');
		$doctor_id = $this->input->post('doctor_id');
		$appointment_id = $this->input->post('id');

		$newdata = array(
			'app_block_date' => $poppup_adate,
			'app_block_stime'  => $poppup_atime,
			'app_block_etime'  => $poppup_etime,
			'doctor_id' => $doctor_id
		);

		$this->CalenderModel->update_data_where(
			'tbl_appointment_block',
			'block_id',
			$appointment_id,
			$newdata
		);
		return $this->sendJsonResponse('success', 'Appointment Updated!');
	}

	public function updateAppointment()
	{
		$event_id = $this->input->post('event_id');
		$app_date = $this->input->post('poppup_adate_edit');
		$app_time = $this->input->post('poppup_atime_edit');
		$app_etime = $this->input->post('poppup_aetime_edit');
		$doctor_id = $this->input->post('doctor_id_edit');
		$note = $this->input->post('notes_edit');
		$app_treat_id = $this->input->post('treatment_name');
		$user_id = $this->session->userdata('user_Id');
		$poppup_mobile = $this->input->post('poppup_mobile');
		$app_patient_id = $this->input->post('app_patient_id');
		$pat_id = $this->input->post('pat_id');
		$status_edit = $this->input->post('status_edit');
		// $language = $this->input->post('language');
		$this->session->set_userdata('sch_date', $app_date);
		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");

		$qatar_id = $this->input->post('poppup_qatar_id');
		$category_id = $this->input->post('category_edit');
		$wa_mobile = $this->input->post('wa_mobile');

		$sms = $this->input->post('popup_sms_edit');
		$language = $this->input->post('popup_language_edit');

// 		$check_appointment = $this->CalenderModel->checkAlreadyAppointmentUpdate($app_date, $app_time, $app_etime, $doctor_id, $event_id);

// 		if (!empty($check_appointment)) {
// 			return $this->sendJsonResponse('error', 'Appointment Slot is Blocked');
// 			exit;
// 		}

		$this->db->trans_start();
		try {

			$newdata = array(
				'appointment_date' => $app_date,
				'appointment_time'  => $app_time,
				'appointment_etime'  => $app_etime,
				'doctor_id' => $doctor_id,
				'note' => $note,
				'app_treat_id' => $app_treat_id,
				// 'sms_status' =>0,
				//'user_id' => $user_id
				'sms_active' => $sms,
				'sms_lang' => $language,
			);

			$old_app = $this->CommonModel->get_data_row('tbl_appointment', 'appointment_id', $event_id);
			$this->CalenderModel->update_data_where('tbl_appointment', 'appointment_id', $event_id, $newdata);
			$new_app = $this->CommonModel->get_data_row('tbl_appointment', 'appointment_id', $event_id);

			$newdata_apt = array(
				'app_patient_category_id' => $category_id,
				'app_patient_contact' => $poppup_mobile,
				'now_waiting' => $status_edit,
				'wa_mobile' => $wa_mobile
			);


			$old_app_info = $this->CommonModel->get_data_row('tbl_appointment_patient_info', 'app_patient_id', $app_patient_id);
			$this->CalenderModel->update_data_where('tbl_appointment_patient_info', 'app_patient_id', $app_patient_id, $newdata_apt);
			$new_app_info = $this->CommonModel->get_data_row('tbl_appointment_patient_info', 'app_patient_id', $app_patient_id);

			// $this->createLog('appointment', $user_id, 'Update', $log_details);
			$log_details_old = array_merge((array)$old_app, (array)$old_app_info);
			$log_details_new = array_merge((array)$new_app, (array)$new_app_info);


			$log_details_old = $this->prepLogArray($log_details_old, 'appointment');
			$log_details_new = $this->prepLogArray($log_details_new, 'appointment');

			$this->logRecord('Appointment', 'Update', $event_id, $log_details_old, $log_details_new);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
		} catch (Exeception $e) {
			$this->db->trans_rollback();
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}

		if ($this->checkQueueSystem()->enable == 1) {

			if ($status_edit == 5) {
				$newdata_queue = array(
					'doctor_id' => $doctor_id,
					'patient_id' => $app_patient_id,
					'appointment_id' => $event_id,
					'status' => $status_edit
				);

				$queue = $this->CalenderModel->createQueue('queue', $newdata_queue);

				if ($this->checkQueueSystem()->print_sms == 1) {
					$smsdata = array(
						'token_number' => $queue['number'],
						'patient_id' => $app_patient_id,
					);
					$this->sendSMS($smsdata, 'queue_token');
				}
			}
			if ($status_edit == 11 || $status_edit == 8 || $status_edit == 9) {
				$newdata_queue = array(
					'doctor_id' => $doctor_id,
					'patient_id' => $app_patient_id,
					'appointment_id' => $event_id,
					'status' => $status_edit
				);
				$queue = $this->CalenderModel->updateQueue($newdata_queue);
			}
		}
		$this->db->trans_complete();
		return $this->sendJsonResponse('success', 'Appointment Updated!', $queue);
	}

	public function sendSMS($data, $event_name)
	{

		$patient_id = $data['patient_id'];
		$patient_data = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment_patient_info', 'app_patient_id', $patient_id);
		$message = $this->SmsPortalModel->getTemplate($event_name, 'en');
		if (!empty($message->template)) {

			$patient_name = null;
			$patient_phone = null;

			$placeholders = ['{PATIENT_NAME}', '{TOKEN_NUMBER}'];
			$patient_name =  $patient_data->app_patient_name;
			$patient_phone = $patient_data->app_patient_contact;
			$patient_whatsapp = $patient_data->wa_code.$patient_data->wa_mobile;
			$values = [$patient_name, $data['token_number']];
			$template = str_replace($placeholders, $values, $message->template);
		}

		$smsjob = array(
			'message' => $template,
			'phone' => $patient_phone,
			'whatsapp_mobile' => $patient_whatsapp,
			'patient_name' => $patient_name,
			'token_number' => $data['token_number']

		);
		$smsjob = json_encode($smsjob);
		$job = array(
			'queue' => 'DEFAULT',
			'payload' => $smsjob,
			'event' => $event_name,

		);
		$smsJob = $this->SmsPortalModel->insert_data('tbl_jobs', $job);
	}

	public function deleteAppointment()
	{

		try {
			$event_id = $this->input->post('event_id');
			$appointment = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment', 'appointment_id', $event_id);
			$appointment_info = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment_patient_info', 'app_patient_id', $appointment->app_info_id);
			
			$result = $this->CalenderModel->delete_data_where('tbl_appointment', 'appointment_id', $event_id);

			$log_details_old = array_merge((array)$appointment, (array)$appointment_info);


			$log_details = array(
				'app_patient_name' => $log_details_old['app_patient_name'],
				'appointment_date' => $log_details_old['appointment_date'],
				'appointment_time'  => $log_details_old['appointment_time'],
				'appointment_etime'  => $log_details_old['appointment_etime'],
				'doctor_id' => $log_details_old['doctor_id'],
			);
			$log_details_old = $this->prepLogArray($log_details, 'appointment');
			$log_details_new = $this->prepLogArray(array('app_patient_name' =>null,'appointment_date' =>null,'appointment_time'  => null,'doctor_id'=>null), 'appointment');
			
			$this->logRecord('Appointment', 'Delete', $event_id, $log_details_old, $log_details_new);
			return $this->sendJsonResponse('success', 'Appointment Deleted Successfully!');
		} catch (Exeception $e) {
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}
	}

	public function mark_as_ongoing()
	{
		try {
			$_id = $this->input->post('id');
			$appointment = $this->input->post('appointment');
			$doctor = $this->input->post('doctor');
			$newdata_apt = array(
				'now_waiting' => '8'
			);

			$this->CalenderModel->update_data_where('tbl_appointment_patient_info', 'app_patient_id', $_id, $newdata_apt);
			$newdata_queue = array(
				'patient_id' => $_id,
				'doctor_id' => $doctor,
				'appointment_id' => $appointment,
				'status' => 8
			);
			$this->CalenderModel->updateQueue($newdata_queue);
		} catch (Exeception $e) {
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}
	}

	public function mark_as_notShow()
	{
		try {
			$_id = $this->input->post('id');
			$appointment = $this->input->post('appointment');
			$doctor = $this->input->post('doctor');
			$newdata_apt = array(
				'now_waiting' => '6'
			);

			$this->CalenderModel->update_data_where('tbl_appointment_patient_info', 'app_patient_id', $_id, $newdata_apt);
			$newdata_queue = array(
				'patient_id' => $_id,
				'doctor_id' => $doctor,
				'appointment_id' => $appointment,
				'status' => 6
			);
			$this->CalenderModel->updateQueue($newdata_queue);
		} catch (Exeception $e) {
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}
	}
	public function create_patient_by_app($app_id)
	{

		$appointment = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment_patient_info', 'app_patient_id', $app_id);

		$loginId = $this->session->userdata('user_Id');
		$data['active_menu'] = 22;
		$data['active_submenu'] = 1;
		$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
		$data['profile'] = $this->CommonModel->profile($loginId);
		$data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');
		$data['insurances'] = $this->PatientsModel->retrieve_data('tbl_insurance_types');
		$data['modules'] = $this->PatientsModel->retrieve_data_unique('tbl_modules', 'is_enable', 1);

		$_id = 0;
		$data['_id'] = $_id;
		$data['first_name'] = '';
		$data['middle_name'] = '';
		$data['last_name'] = '';
		$data['qatar_id'] = '';
		$data['guardian_id'] = '';
		$data['passport_number'] = '';
		$data['dob'] = '';
		$data['nationality'] = '';
		$data['mobile'] = '';
		$data['second_mobile'] = '';
		$data['emergency_mobile'] = '';
		$data['email'] = '';
		$data['zone'] = '';
		$data['street'] = '';
		$data['building'] = '';
		$data['country'] = '';
		$data['insurance_type'] = '';
		$data['category'] = '';
		$data['note'] = '';
		$data['sex'] = '';
		$data['black'] = '';

		$this->load->view('admin/Patients/Patient', $data);
	}

public function appointment_log_by_json()
	{
		$app_id = $this->input->post('app_id');

		$this->db->select('tbl_logs.action, tbl_logs.created_date, tbl_users.full_name');
		$this->db->from('tbl_logs');
		$this->db->join('tbl_users', 'tbl_logs.user_id = tbl_users.user_Id', 'left');

		// $this->db->join(
		// 	'tbl_appointment_patient_info',
		// 	'JSON_EXTRACT(tbl_logs.data, "$.app_info_id") = tbl_appointment_patient_info.app_patient_id',
		// 	'left'
		// );

		$this->db->join('tbl_appointment', 'tbl_logs.record_id = tbl_appointment.appointment_id');

		$this->db->where('tbl_appointment.appointment_id', $app_id);
		$this->db->where('tbl_logs.type', 'appointment');

		$result = $this->db->get()->result();

		// echo $this->db->last_query();
		// exit;

		$this->output
			->set_content_type('application/json')
			->set_output(json_encode($result));
	}

	public function update_block_schedule()
	{

		$block_id = $this->input->post('block_id');
		$data = array_diff_key($this->input->post(), array('block_id' => ''));

		$old_data = $this->CommonModel->get_data_row('tbl_appointment_block', 'block_id', $block_id);
		$this->CalenderModel->update_block_schedule($block_id, $data);

		$log_details_old = $this->prepLogArray((array)$old_data, 'appointment_block');
		$log_details_new = $this->prepLogArray($data, 'appointment_block');

		$this->logRecord('Appointment Block', 'Update', $block_id, $log_details_old, $log_details_new);
		return $this->sendJsonResponse('success', 'Block Schedule Updated!');
	}

	public function delete_block_schedule()
	{
		$block_id = $this->input->post('block_id');
		$appointment_old = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment_block', 'block_id', $event_id);
		$this->CalenderModel->delete_data_where('tbl_appointment_block', 'block_id', $block_id);

		$log_details = array(
			'app_block_date' => $appointment_old->app_block_date,
			'doctor_id' => $appointment_old->doctor_id,
		);

		$log_details_old = $this->prepLogArray($log_details, 'appointment_block');
		$log_details_new = $this->prepLogArray(array('app_block_date' =>null,'doctor_id' =>null), 'appointment_block');
		
		$this->logRecord('Appointment Block', 'Delete', $block_id, $log_details_old, $log_details_new);



		return $this->sendJsonResponse('success', 'Block Schedule Deleted!');
	}

	public function getNextPatient()
	{
		$doc_id = $this->input->post('doc_id');

		// Query to get the first patient with status 5 for the specified doctor
		$this->db->select('queue.*, tbl_users.full_name as doctor_name');
		$this->db->from('queue');
		$this->db->join('tbl_users', 'tbl_users.user_Id = queue.doctor_id', 'left');
		$this->db->where('queue.doctor_id', $doc_id);
		$this->db->where('(queue.status = 5 OR queue.status = 11)');
		$this->db->order_by('queue.number', 'ASC');
		$this->db->limit(1);
		$query = $this->db->get();

		// Check if a result was found
		if ($query->num_rows() > 0) {
			$newdata = array(

				'now_waiting' => 11
			);

			$patient = $query->row();
			$newdata_queue = array(
				'doctor_id' => $patient->doctor_id,
				'patient_id' => $patient->patient_id,
				'appointment_id' => $patient->appointment_id,
				'status' => 11
			);
			$this->CalenderModel->updateQueue($newdata_queue);
			$this->CalenderModel->update_data_where('tbl_appointment_patient_info', 'app_patient_id', $patient->patient_id, $newdata);
			// Return the patient data
			return $this->sendJsonResponse('success', 'success', $patient);
		} else {
			// No patient found
			return $this->sendJsonResponse('error', 'error');
		}
	}



	public function send_reminder()
	{
		$channel = $this->CalenderModel->retrieve_data_unique_row('notification_reminders','reminder','appt_confirmation');
		$id = $this->input->post('patient_id');
		$id = decrypt_and_url_decode($id, $this);
		$patient_type = $this->input->post('type');
		$appointment_id = $this->input->post('appointment_id');

		if(!empty($channel)){
		if($patient_type == 2){
				$data = $this->CalenderModel->getAppointment($appointment_id);
			
			}else if($patient_type == 1){
				$data = $this->CalenderModel->getNewAppointment($appointment_id);
				
			}
			if($channel->type =='sms'){
				$sms = $this->prepareSMSMessage('appt_confirmation', $data );
			
				$response = $this->smsapi->send_sms($data->mobile, $sms);
				echo json_encode(['status' => 'success', 'message' => 'Reminder Sent successfully!']);
			}else if($channel->type == 'whatsapp'){
				if(empty($data->second_mobile)){
					echo json_encode(['status' => 'error', 'message' => 'Patient Dont Have Whatsapp Number!']);
					die();
				}
				$sent_msg = $this->send_whatsapp($data);
				if ($sent_msg) {
					echo json_encode(['status' => 'success', 'message' => 'Reminder Sent successfully!']);
				} else {
					echo json_encode(['status' => 'false', 'message' => 'Something Went Wrong']);
				}

			}elseif($channel->type =='none'){
				echo json_encode(['status' => 'success', 'message' => 'Reminder Not Configured']);
			}
		
			
		}
		
		// echo json_encode(['status' => 'success', 'message' => 'Status updated successfully!'.$data]);
	}
public function prepareSMSMessage($event_name,$data){
    $placeholders = array();  // Initialize the placeholders array

    // Define placeholders based on the event type
    switch ($event_name) {
        case 'appt_confirmation':
            $placeholders = [
                '{PATIENT_NAME}' => $data->patient_name,
                '{APPOINTMENT_DATE}' => $data->appointment_date,
                '{APPOINTMENT_TIME}' => $data->appointment_time . '-' . $data->appointment_etime,
				'{DOCTOR_NAME}' => $data->doctor_name,
            ];
            break;
        default:
            // Return a default message if no event matches
            return "Notification from our system.";
    }



    $template= $this->NotificationJob->getActiveTemplate($event_name);
   
    $message_template = $template->template;
    
    $final_message = str_replace(array_keys($placeholders), array_values($placeholders), $message_template);

   return $final_message;
}
	public function send_whatsapp($data)
	{
		//reminder template with buttons
		$to = $data->second_mobile;
		if ($to != "") {
			$content_sid = "HXb63665bd422dd53c4df3c9b350c99565";
			$template_data = array(
				"1" => $data->appointment_id . "-", // Ensure these match the variables in your template
				"2" => "3",
				"3" => $data->appointment_id . "-",
				"4" => '4',
				"5" => $data->patient_name,
				"6" => $data->appointment_time,
				"7" => $data->doctor_name,

			);
			$response = $this->twiliowhatsapp->send_template_message($to, $content_sid, $template_data);
			if ($response) {
				return true;
			}
		} else {
			return false;
		}
	}


	public function appointmentSearch(){
		$query=$this->input->post('query');
		$date=$this->input->post('date');
		$appointmetns = $this->CalenderModel->appointmentSearch($query,$date);
		echo json_encode($appointmetns);
	}
}
