<?php

require_once APPPATH . 'controllers/admin/Jobs/Job/SmsNotification.php';

class LaserCalenderController extends MY_Controller
{

	function __construct()
	{
		parent::__construct();

		$this->job = new Job($this);
		$this->load->helper('date');
		$this->load->model('admin/Employees/EmployeesModel');
		$this->load->model('admin/UserGroup/UserGroupModel');
		$this->load->model('admin/Users/UserModel');
		$this->load->model('admin/Calender/LaserCalenderModel');
		$this->load->model('admin/SmsPortal/SmsPortalModel');
		$this->load->model('admin/Calender/CalenderModel');
        $this->load->model('admin/Patients/PatientsModel');
		//Commen -------------------------------------
		$this->load->model('admin/CommonModel');
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
	}

	public function index()
	{

		if ($this->session->userdata('user_Id') != '') {

			//Commen -------------------------------------
			$loginId = $this->session->userdata('user_Id');
			$data['active_menu'] = 12;
			$data['active_submenu'] = 1;
			$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
			$data['profile'] =  $this->CommonModel->profile($loginId);
			$user = $this->UserModel->get_user_details($loginId);

			$data['resources'] = $this->LaserCalenderModel->get_resources();
		
			$data['selectedDate'] = date('Y-m-d');
			
            $data['nurses'] = $this->PatientsModel->get_users_by_designation(2);
			$data['dataList'] = $this->LaserCalenderModel->getList($data);
			$data['pending_orders'] = $this->LaserCalenderModel->get_pending_orders();
			$data['booking_status'] = $this->LaserCalenderModel->get_booking_status();
			$data['general_settings'] = $this->CalenderModel->retrieve_data_unique_row('general_settings', 'type', 'appointment');
			$data['queue_system']= $this->checkQueueSystem();
			
			$this->load->view('admin/Calender/Laser/LaserAppointment', $data);
		} else {
			redirect('admin/Login/LoginController', 'refresh');
		}
	}

	public function dayOrders()
	{

		$data['selectedDate'] = $_POST['selected_date'];

		$details = $this->LaserCalenderModel->getList($data);

		echo json_encode($details->result());
		return;
	}


	public function load_appointments()
	{
		// $events = " ";
		$loginId = $this->session->userdata('user_Id');
		$events = array();
		//$resource_id = $this->input->post('resource_id');
		$start_date = $_GET['start'];
		$end_date = $_GET['end'];
		$resources_str = $_GET['doctors'];
		$user = $this->UserModel->get_user_details($loginId);

		$resources = $this->LaserCalenderModel->retrieve_data_unique('tbl_resources','status','1');;
		$resources_list = [];
		
		foreach ($resources  as  $value) {
			$resources_list[] = $value['resource_id'];
		};
		$resources_str_user = (implode(',', $resources_list));
		$resources_str = $resources_str != 1 ? $resources_str : $resources_str_user;
		$appointments = $this->LaserCalenderModel->get_appointments($resources_str, $start_date, $end_date);
		$app_block = $this->LaserCalenderModel->get_block_appointments($resources_str, $start_date, $end_date);
		
		if ($appointments != FALSE) {
			foreach ($appointments as  $value) {

				$status = "";
				$color_code = "#4db8ff";
				$status_element = '<label class="badge" STYLE>STATUS</label>';

			  $statusMapping = [
    '1' => ['BOOKED', '#1E88E5'],       // Blue
    '2' => ['NO ANSWER', '#9E9E9E'],    // Grey
    '3' => ['CONFIRMED', '#A5D6A7'],    // Light Green
    '4' => ['CANCEL', '#FFEB3B'],       // Yellow
    '5' => ['WAITING', '#FF9800'],      // Orange
    '6' => ['NOT CAME', '#F44336'],     // Red
    '7' => ['ARRIVED', '#9C27B0'],      // Purple
    '8' => ['ONGOING', '#BDBDBD'],      // Light Grey
    '9' => ['DONE', '#388E3C'],         // Dark Green
    '10' => ['RESCHEDULE', '#FFC107'],  // Amber
    '11' => ['CALLING', '#03A9F4'],     // Light Blue
];


				if (array_key_exists($value['now_waiting'], $statusMapping)) {
					list($status, $color_code) = $statusMapping[$value['now_waiting']];
				} else {
					// Default values for unknown status
					$status = "UNKNOWN";
					$color_code = "#000000";
				}
				$status = str_replace("STATUS", $status, $status_element);
				$status = str_replace("STYLE", 'style="background-color:' . $color_code . ';color:black;margin: 2px;font-weight:600;border:0.2px solid #494949"', $status);

				if ($value['app_patient_name'] == "Close") {
					$eventsArray['title'] = "";
				} else {
					if ($value['patient_id'] == NULL) {
						$eventsArray['title'] = "New," . $value['app_patient_name'] . ', ' . $value['app_patient_contact'] . ', -' . preg_replace('~[\r\n]+~', '\n', $value['note']) ;
						$eventsArray['new'] = '1';
					} else {
						if ($value["insurance_type_id"] == 1) {

							if ($value["company_id"] == -1) {
								$eventsArray['title'] = $value['patient_id'] . ", " . $value["app_patient_name"] . ", " . $value["app_patient_contact"] . ", -" . preg_replace('~[\r\n]+~', '\n', $value['note']) ;
							} else {
								$eventsArray['title'] = $value['patient_id'] . "," . $value["app_patient_name"] . ", " . $value["app_patient_contact"] . ", -" . preg_replace('~[\r\n]+~', '\n', $value['note']) ;
							}
						} else {
							$eventsArray['title'] = $value['patient_id'] . "," . $value["app_patient_name"]  ."" . ", " . $value["app_patient_contact"] ."--". $value["insurance_name"] . ", -" . preg_replace('~[\r\n]+~', '\n', $value['note']) ;
						}
						$eventsArray['new'] = '2';
					}
				}

				$eventsArray['start'] =  $value['appointment_date'] . 'T' . $value['appointment_time'];
				$eventsArray['end'] =  $value['appointment_date'] . 'T' .   $value['appointment_etime'];
				// $eventsArray['color'] =  $color_code;
				// if ($resource_id!=000) {
				// $eventsArray['color'] =  $value['col_code'];
				// } else {
				// $eventsArray['color'] =  $value['color_code'];
				// }
				$eventsArray['textColor'] = 'black';
				$eventsArray['start_time'] =  $value['appointment_time'];
				$eventsArray['end_time'] =  $value['appointment_etime'];
				$eventsArray['adate'] =  $value['appointment_date'];
				$eventsArray['resource_id'] =  $value['resource_id'];
				$eventsArray['event_id'] =  $value['appointment_id'];
				$eventsArray['app_treat_id'] =  $value['app_treat_id'];
				$eventsArray['username'] =  $value['username'];
				$eventsArray['patient_id'] =  encrypt_and_url_encode($value['patient_id'], $this);
				$eventsArray['app_patient_id'] =  $value['app_patient_id'];
				$eventsArray['app_patient_contact'] =  $value['app_patient_contact'];
				$eventsArray['app_patient_name'] =  $value['app_patient_name'];
				$eventsArray['app_patient_qatar_id'] =  $value['app_patient_qatar_id'];
				$eventsArray['app_patient_category_id'] =  $value['app_patient_category_id'];
				$eventsArray['type'] = '1';
				$eventsArray['resourceId'] = $value['resource_id'];
				$eventsArray['note'] =  preg_replace('~[\r\n]+~', '\n', $value['note']);
				$eventsArray['status'] = $value['now_waiting'];
				$eventsArray['sms_active'] =  $value['sms_active'];
				$eventsArray['sms_lang'] =  $value['sms_lang'];
				$eventsArray['doctor_color'] =  $value['doctor_color'];
				$eventsArray['nurse_id'] =  $value['nurse_id'];
				$eventsArray['status_element'] = $status;
				$events['calendar'][] = $eventsArray;
			
			}
		}

		if ($app_block != FALSE) {
			foreach ($app_block as  $value) {

				$eventsArray['resourceId'] =  $value['resource_id'];
				$eventsArray['resource_id'] =  $value['resource_id'];
				$eventsArray['title'] =  ($value['remarks']) ? $value['remarks'] : "Unavailable";
				$eventsArray['start'] =  $value['app_block_date'] . 'T' . $value['app_block_stime'];
				$eventsArray['end'] =  $value['app_block_date_to'] . 'T' . $value['app_block_etime'];
				$eventsArray['start_time'] =  $value['app_block_stime'];
				$eventsArray['end_time'] =  $value['app_block_etime'];
				$eventsArray['color'] =  'white';
				$eventsArray['className'] = 'fc-unavailable';
				$eventsArray['block_id'] =  $value['block_id'];
				$eventsArray['block_date'] =  $value['app_block_date'];
				$eventsArray['block_date_to'] =  $value['app_block_date_to'];
				$eventsArray['block_time_from'] =  $value['app_block_stime'];
				$eventsArray['block_time_to'] =  $value['app_block_etime'];
				$eventsArray['doctor_color'] =  'black';
				$eventsArray['type'] =  '2';
				$eventsArray['note'] = $value['remarks'];
				$eventsArray['status_element'] = '<label  style="background-color:#f6bf26;color:black;margin: 2px;font-weight:600;border:0.2px solid #494949" class="badge" STYLE>BLOCKED</label>';
				$events['calendar'][] = $eventsArray;
			}
		}
		$events['resources'] = explode(',', $resources_str);
		echo json_encode($events);
	}

	public function checkQueueSystem(){
		$data=   $this->db->select('*')
        ->from('queue_config')
        ->get()
        ->row();
		return $data;
	}

	public function delete_block_schedule()
	{
		$block_id = $this->input->post('block_id');
		$appointment_old = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment_block', 'block_id', $event_id);
		$this->CalenderModel->delete_data_where('tbl_appointment_block', 'block_id', $block_id);

		$log_details = array(
			'app_block_date' => $appointment_old->app_block_date,
			'doctor_id' => $appointment_old->doctor_id,
		);

		$log_details_old = $this->prepLogArray($log_details, 'appointment_block');
		$log_details_new = $this->prepLogArray(array('app_block_date' =>null,'doctor_id' =>null), 'appointment_block');
		
		$this->logRecord('Appointment Laser Block', 'Delete', $block_id, $log_details_old, $log_details_new);



		return $this->sendJsonResponse('success', 'Block Schedule Deleted!');
	}

	
	public function update_block_schedule()
	{

		$block_id = $this->input->post('block_id');
		$data = array_diff_key($this->input->post(), array('block_id' => ''));

		$old_data = $this->CommonModel->get_data_row('tbl_appointment_block', 'block_id', $block_id);
		$this->CalenderModel->update_block_schedule($block_id, $data);

		$log_details_old = $this->prepLogArray((array)$old_data, 'appointment_block');
		$log_details_new = $this->prepLogArray($data, 'appointment_block');

		$this->logRecord('Appointment Laser Block', 'Update', $block_id, $log_details_old, $log_details_new);
		return $this->sendJsonResponse('success', 'Block Schedule Updated!');
	}

	public function saveAppoinment()
	{

		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");

		$patient_array = explode(' - ', $this->input->post('apatient_id'));
		// $br_id = $this->get_file->get_branch();
		$patient_appointment = $this->input->post('patient_appointment');
		$new_patient = ucwords(strtolower($this->input->post('new_patient_id')));
		$new_mobile = $this->input->post('new_mobile_id');
		$existing_mobile = $this->input->post('a_mobile_id');
		$new_qatar_id = $this->input->post('new_qatar_id');
		$new_category = $this->input->post('category');
		$poppup_adate = $this->input->post('poppup_adate');
		$poppup_edate = $this->input->post('poppup_edate');
		$poppup_atime = $this->input->post('poppup_atime');
		$poppup_etime = $this->input->post('poppup_aetime');
		$resource_id = $this->input->post('resource_id');
		$status = $this->input->post('status');
		$treatment_name = $this->input->post('treatment_name');
		$note = $this->input->post('notes');
		$user_id = $this->session->userdata('user_Id');
		$sms = $this->input->post('popup_sms');
		$language = $this->input->post('popup_language');
		$popup_whatsapp = $this->input->post('popup_whatsapp');
		$nurse_id =  $this->input->post('nurse_id');

		$this->db->trans_start();
		try {
			if ($patient_appointment == 0) {
				$newdata = array(
					'app_patient_name' => $new_patient,
					'app_patient_contact' => $new_mobile,
					'app_patient_qatar_id' => $new_qatar_id,
					'app_patient_category_id' => $new_category,
					'app_reg_date' => $curr_date,
					'now_waiting' => $status,
					'patient_id' => Null
				);

				$app_info_id = $this->LaserCalenderModel->insert_data('tbl_appointment_patient_info', $newdata);

				$newdata_apt = array(
					'app_info_id' => $app_info_id,
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'resource_id' => $resource_id,
					'note' => $note,
					'app_treat_id' => $treatment_name,
					'sms_active' => $sms,
					'sms_lang' => $language,
					'user_id' => $user_id,
					'nurse_id' => $nurse_id
				);

				
				$log_details = array(
					'app_patient_name' => $new_patient,
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'resource_id' => $resource_id,
					
				);

				$id = $this->LaserCalenderModel->insert_data('tbl_appointment', $newdata_apt);

				
				$log_details_new = $this->prepLogArray($log_details, 'appointment');
				$this->logRecord('Appointments Laser', 'Create', $id, [], $log_details_new);

				$msg = 'Appointment Created Successfully';
			} else if ($patient_appointment == 1) {
				$newdata = array(
					'app_patient_name' => $patient_array[1],
					'app_patient_contact' => $patient_array[2],
					'app_patient_category_id' => $new_category,
					'patient_id' => $patient_array[0],
					'now_waiting' => $status,
					'app_reg_date' => $curr_date
				);

				$app_info_id = $this->LaserCalenderModel->insert_data('tbl_appointment_patient_info', $newdata);

				$newdata_apt = array(
					'app_info_id' => $app_info_id,
					'patient_id' => $patient_array[0],
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'resource_id' => $resource_id,
					'note' => $note,
					'app_treat_id' => $treatment_name,
					'sms_active' => $sms,
					'sms_lang' => $language,
					'user_id' => $user_id,
					'nurse_id' => $nurse_id
				);

			
				$log_details = array(
					'app_patient_name' => $new_patient,
					'appointment_date' => $poppup_adate,
					'appointment_time'  => $poppup_atime,
					'appointment_etime'  => $poppup_etime,
					'resource_id' => $resource_id,
					
				);

				$id = $appointment_id = $this->LaserCalenderModel->insert_data('tbl_appointment', $newdata_apt);
				
				$log_details_new = $this->prepLogArray($log_details, 'appointment');
				$this->logRecord('Appointments Laser', 'Create', $id, [], $log_details_new);


				$msg = 'Appointment Created Successfully';
			} else if ($patient_appointment == 2) {
				$newdata = array(
					'app_block_date' => $poppup_adate,
					'app_block_date_to' => $poppup_edate,
					'app_block_stime'  => $poppup_atime,
					'app_block_etime'  => $poppup_etime,
					'user_id' => $user_id,
					'remarks' => $note,
					'resource_id' => $resource_id
				);

				$id = $this->LaserCalenderModel->insert_data('tbl_appointment_block', $newdata);
				
				
				$log_details_new = $this->prepLogArray($newdata, 'appointment_block');
				$this->logRecord('Appointment Laser Block', 'Create', $id, [], $log_details_new);

				$msg = 'Block Appointment Created Successfully';
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();

				if((int)$sms && (!empty($existing_mobile) || !empty($new_mobile))) {

					/**
					 * ar = 2
					 * en = 1
					 */
					if(!empty($new_mobile)) $phone = $new_mobile;
					if(!empty($existing_mobile)) $phone = $existing_mobile;
					$message = $this->SmsPortalModel->getTemplate('create_appointment', (int)$language == 1 ? 'en' : 'ar');
					if(!empty($message->template)) {
						$sms = new SmsNotification($this,null, null, $phone, $message->template."\r\nDate:".$poppup_adate);
						$this->job->new($queue = 'DEFAULT', $payload = $sms , $attempts = 2, $available_at = null);
					}
				}
			}
		} catch (Exeception $e) {
			$this->db->trans_rollback();
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}

		if($this->checkQueueSystem()->laser_enable ==1){
			if($status == 5 ){
				$newdata_queue = array(
					'room_number' => $resource_id,
					'patient_id' => $app_info_id,
					'appointment_id' => $appointment_id,
					'status' => $status,
					'type' => 1,
				);
			
	
				$queue=$this->CalenderModel->createQueue('queue', $newdata_queue);
				if($this->checkQueueSystem()->print_sms==1){
					$sms = new SmsNotification($this,null, null, '77393781', 'Your token Number is'.$queue->number);
							$this->job->new( 'DEFAULT', $payload = $sms , $attempts = 2, $available_at = null);
				}
			}
			if($status == 11 ||$status == 8 || $status == 9  ){
				$newdata_queue = array(
					'room_number' => $resource_id,
					'patient_id' => $app_info_id,
					'appointment_id' => $appointment_id,
					'type' => 1,
				);
				$queue=$this->CalenderModel->updateQueue($newdata_queue);
			}
		}
		

		$this->db->trans_complete();
		return $this->sendJsonResponse('success', $msg,$queue);
	}

	public function dragUpdateEvent()
	{

		$poppup_adate = $this->input->post('date');
		$poppup_atime = $this->input->post('start_time');
		$poppup_etime = $this->input->post('end_time');
		$resource_id = $this->input->post('resource_id');
		$appointment_id = $this->input->post('id');

		$newdata = array(
			'appointment_date' => $poppup_adate,
			'appointment_time'  => $poppup_atime,
			'appointment_etime'  => $poppup_etime,
			'resource_id' => $resource_id
		);

		$this->LaserCalenderModel->update_data_where(
			'tbl_appointment',
			'appointment_id',
			$appointment_id,
			$newdata
		);
		return $this->sendJsonResponse('success', 'Appointment Updated!');
	}
	public function dragUpdateEventBlock()
	{

		$poppup_adate = $this->input->post('date');
		$poppup_atime = $this->input->post('start_time');
		$poppup_etime = $this->input->post('end_time');
		$doctor_id = $this->input->post('resource_id');
		$appointment_id = $this->input->post('id');

		$newdata = array(
			'app_block_date' => $poppup_adate,
			'app_block_stime'  => $poppup_atime,
			'app_block_etime'  => $poppup_etime,
			'resource_id'=> $doctor_id
		);

		$this->CalenderModel->update_data_where(
			'tbl_appointment_block',
			'block_id',
			$appointment_id,
			$newdata
		);
		return $this->sendJsonResponse('success', 'Appointment Updated!');
	}

	public function updateAppointment()
	{
		$event_id = $this->input->post('event_id');
		$app_date = $this->input->post('poppup_adate_edit');
		$app_time = $this->input->post('poppup_atime_edit');
		$app_etime = $this->input->post('poppup_aetime_edit');
		$resource_id = $this->input->post('resource_id_edit');
		$note = $this->input->post('notes_edit');
		$app_treat_id = $this->input->post('treatment_name');
		$user_id = $this->session->userdata('user_Id');
		$poppup_mobile = $this->input->post('poppup_mobile');
		$app_patient_id = $this->input->post('app_patient_id');
		$pat_id = $this->input->post('pat_id');
		$status_edit = $this->input->post('status_edit');
		$nurse_id = $this->input->post('nurse_id');
		// $language = $this->input->post('language');
		$this->session->set_userdata('sch_date', $app_date);
		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");

		$qatar_id = $this->input->post('poppup_qatar_id');
		$category_id = $this->input->post('category_edit');

		$sms = $this->input->post('popup_sms_edit');
		$language = $this->input->post('popup_language_edit');

		$this->db->trans_start();
		try {

			$newdata = array(
				'appointment_date' => $app_date,
				'appointment_time'  => $app_time,
				'appointment_etime'  => $app_etime,
				'resource_id' => $resource_id,
				'note' => $note,
				'app_treat_id' => $app_treat_id,
				// 'sms_status' =>0,
				//'user_id' => $user_id
				'sms_active' => $sms,
				'sms_lang' => $language,
				'nurse_id' => $nurse_id
			);

			$this->LaserCalenderModel->update_data_where('tbl_appointment', 'appointment_id', $event_id, $newdata);

			$newdata_apt = array(
				'app_patient_category_id' => $category_id,
				'app_patient_contact' => $poppup_mobile,
				'now_waiting' => $status_edit
			);

			$log_details = array_merge($newdata_apt, $newdata);

			$this->LaserCalenderModel->update_data_where('tbl_appointment_patient_info', 'app_patient_id', $app_patient_id, $newdata_apt);

			$this->createLog('appointment', $user_id, 'Update', $log_details);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
		} catch (Exeception $e) {
			$this->db->trans_rollback();
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}

		if($this->checkQueueSystem()->laser_enable == 1){
			
			if($status_edit == 5 ){
				$newdata_queue = array(
					'room_number' => $resource_id,
					'patient_id' => $app_patient_id,
					'appointment_id' => $event_id,
					'status' => $status_edit,
					'type' => 1,
				);
	
				$queue =$this->CalenderModel->createQueue('queue', $newdata_queue);
				if($this->checkQueueSystem()->print_sms==1){
					$sms = new SmsNotification($this,null, null, '77393781', 'Your token Number is'.$queue->number);
							$this->job->new( 'DEFAULT', $payload = $sms , $attempts = 2, $available_at = null);
				}
			}
			if($status_edit == 11 ||$status_edit == 8 || $status_edit == 9  ){
				$newdata_queue = array(
					'room_number' => $resource_id,
					'patient_id' => $app_patient_id,
					'appointment_id' => $event_id,
					'status' => $status_edit,
					'type' => 1,
				);
				$queue=$this->CalenderModel->updateQueue($newdata_queue);
			}
		}

		$this->db->trans_complete();
		return $this->sendJsonResponse('success', 'Appointment Updated!',$queue);
	}

	public function deleteAppointment()
	{

		try {
			$event_id = $this->input->post('event_id');
			$appointment = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment', 'appointment_id', $event_id);
			$appointment_info = $this->CalenderModel->retrieve_data_unique_row('tbl_appointment_patient_info', 'app_patient_id', $appointment->app_info_id);
			$result = $this->LaserCalenderModel->delete_data_where('tbl_appointment', 'appointment_id', $event_id);

			$log_details_old = array_merge((array)$appointment, (array)$appointment_info);

			$log_details = array(
				'app_patient_name' => $log_details_old['app_patient_name'],
				'appointment_date' => $log_details_old['appointment_date'],
				'appointment_time'  => $log_details_old['appointment_time'],
				'appointment_etime'  => $log_details_old['appointment_etime'],
				'resource_id' => $log_details_old['resource_id'],
			);
			$log_details_old = $this->prepLogArray($log_details, 'appointment');
			$log_details_new = $this->prepLogArray(array('app_patient_name' =>null,'appointment_date' =>null,'appointment_time'  => null,'resource_id'=>null), 'appointment');

			$this->logRecord('Appointment Laser', 'Delete', $event_id, $log_details_old, $log_details_new);

		} catch (Exeception $e) {
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}
	}

	public function mark_as_ongoing()
	{
		try {
			$_id = $this->input->post('id');
			$newdata_apt = array(
				'now_waiting' => '8'
			);

			$this->LaserCalenderModel->update_data_where('tbl_appointment_patient_info', 'app_patient_id', $_id, $newdata_apt);
		} catch (Exeception $e) {
			return $this->sendJsonResponse('error', 'Appointment Not Saved Properly');
		}
	}

	public function create_patient_by_app($app_id)
	{

		$appointment = $this->LaserCalenderModel->retrieve_data_unique_row('tbl_appointment_patient_info', 'app_patient_id', $app_id);

		$loginId = $this->session->userdata('user_Id');
		$data['active_menu'] = 22;
		$data['active_submenu'] = 1;
		$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
		$data['profile'] = $this->CommonModel->profile($loginId);
		$data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');
		$data['insurances'] = $this->PatientsModel->retrieve_data('tbl_insurance_types');
		$data['modules'] = $this->PatientsModel->retrieve_data_unique('tbl_modules', 'is_enable', 1);

		$_id = 0;
		$data['_id'] = $_id;
		$data['first_name'] = '';
		$data['middle_name'] = '';
		$data['last_name'] = '';
		$data['qatar_id'] = '';
		$data['guardian_id'] = '';
		$data['passport_number'] = '';
		$data['dob'] = '';
		$data['nationality'] = '';
		$data['mobile'] = '';
		$data['second_mobile'] = '';
		$data['emergency_mobile'] = '';
		$data['email'] = '';
		$data['zone'] = '';
		$data['street'] = '';
		$data['building'] = '';
		$data['country'] = '';
		$data['insurance_type'] = '';
		$data['category'] = '';
		$data['note'] = '';
		$data['sex'] = '';
		$data['black'] = '';

		$this->load->view('admin/Patients/Patient', $data);
	}

	public function appointment_log_by_json()
	{
	
		$app_id = $this->input->post('app_id');

		$this->db->select('tbl_logs.action, tbl_logs.created_date, tbl_users.full_name');
		$this->db->from('tbl_logs');
		$this->db->join('tbl_users', 'tbl_logs.user_id = tbl_users.user_Id', 'left');

		// $this->db->join(
		// 	'tbl_appointment_patient_info',
		// 	'JSON_EXTRACT(tbl_logs.data, "$.app_info_id") = tbl_appointment_patient_info.app_patient_id',
		// 	'left'
		// );

		$this->db->join('tbl_appointment', 'tbl_logs.record_id = tbl_appointment.appointment_id');

		$this->db->where('tbl_appointment.appointment_id', $app_id);
// 		$this->db->where('tbl_logs.type', 'Aappointments Laser');

		$result = $this->db->get()->result();

		 

		$this->output
			->set_content_type('application/json')
			->set_output(json_encode($result));
	}

	public function get_resources_list()
	{

		$draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];

        $records = $this->LaserCalenderModel->getResourcesList($search, $length, $start, $order_column, $order);
        

        $total_records = count($records); // Get total records

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
	}

}
