<?php

class CategoryController extends MY_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/Category/CategoryModel');
    }

    public function index($page=0) {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['page_count'] = $this->config->item('page_count');
			$data['page'] = $page;
			$data['search_url'] = 'Category/CategoryController/index/';
			$data['form'] = 'submitForm';
			
			$data['category_list'] = $this->CategoryModel->get_category_list($data);  
			
			$data['paginationData'] = $data['category_list'];

            $this->load->view('admin/Category/CategoryList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	  public function createnew() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = 0;
			$category_code = '';
			$item_image = 'dist/img/empty.png';
			$is_new_image = 'false';
			$category_name = '';
			$status = '';
			
			$data['_id'] = $_id;
			$data['category_code'] = $category_code;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			$data['category_name'] = $category_name;
			$data['status'] = $status;
			
            $this->load->view('admin/Category/Category', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	  public function save() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = $this->input->post('_id');
			$category_code = $this->input->post('category_code');
			$category_name = $this->input->post('category_name');
			$item_image = $this->input->post('item_image');
			$is_new_image = $this->input->post('is_new_image');
			$status = $this->input->post('status');
			
			$data['_id'] = $_id;
			$data['category_code'] = $category_code;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			$data['status'] = $status;
			
			//print_r($data['brand_name']);die;
			$this->form_validation->set_rules('category_code', 'Category Code', 'trim|required|callback_code_exists_check');
			$this->form_validation->set_rules('category_name', 'Category Name', 'trim|required');
			
			
			if ($this->form_validation->run() == FALSE) {
				
                $this->load->view('admin/Category/Category', $data);
                return;
				
            }
			
			
			$data_save = array (

				'category_code' => $category_code,				
				'category' => $category_name,				
				'status' =>  $status == 'active' ? 1 : 0 ,	
				'image_path' => ''	
			);
			
			//print_r($data_save);die;
			
			if($_id > 0 ) {
								
				$this->CategoryModel->update($_id,$data_save,$is_new_image,$item_image);
				
			} else {
				
				$this->CategoryModel->save($data_save,$is_new_image,$item_image);
				
			}
			
			
			redirect('admin/Category/CategoryController', 'refresh');

			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	  public function edit() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 14;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = base64_decode(urldecode($this->input->post('selected_id')));
			
			
			if($_id != null && $_id != ''){
			
				$details = $this->CategoryModel->get_details_by_id($_id);
				foreach ($details->result() as $row) {

					$category_code = $row->category_code;
					$category_name = $row->category;
					$status = $row->status == 1 ? 'active' : '';
					$item_image = $row->image_path;
					$is_new_image = false;
				}

				$data['_id'] = $_id;
				$data['category_code'] = $category_code;
				$data['category_name'] = $category_name;
				$data['item_image'] = $item_image;
				$data['is_new_image'] = $is_new_image;
				$data['status'] = $status;
				
				
				
				$this->load->view('admin/Category/Category', $data);
				
			} else {
				
				redirect('admin/CommenController/page_not_found', 'refresh');
				
			}
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	  public function delete() {
        
        if ($this->session->userdata('user_Id') != '') {
            
            $_id = base64_decode(urldecode($this->input->post('selected_id')));
			
			if($_id == '' || $_id == null){
				$_id = 0;
			}
			
			
			$this->CommonModel->update_column('tbl_categories','category_id',$_id,'is_delete',1);
			
			redirect('admin/Category/CategoryController', 'refresh');
			

        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
        
    }
	
	//validations
    public function code_exists_check() {
		
        $this->db->where('category_code', trim($this->input->post('category_code')));
        $this->db->where_not_in('category_id', $this->input->post('_id'));
        $query = $this->db->get('tbl_categories');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('code_exists_check', 'Category Code Already Added.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

}
