<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CommenController extends MY_Controller {

    function __construct() {
        parent::__construct();
        error_reporting(E_ERROR | E_PARSE);
        $this->load->helper('url');
        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
		$this->load->model('admin/Calender/CalenderModel');
		
    }

    public function get_diagnosis(){
		$result =  $this->CommonModel->get_diagnosis();
		$data = [];
		foreach ($result->result_array() as $row) {
			array_push($data, array(
                'id' => $row['diagnostise_id'].' | '.$row['name'],
                'name' =>  $row['diagnostise_id'].' | '.$row['name']));
		};
		echo json_encode($data);
    }

    // public function get_procedures(){
    //     $decryptedId = decrypt_and_url_decode($_GET['p'], $this);
    //     $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);
    //     $result = $this->CommonModel->get_procedures($patient->insurance_type, $_GET['q']);
    //     $data = [];
	// 	foreach ($result->result_array() as $row) {
	// 		array_push($data, array(
    //             'id' => $row['id'].' - '.$row['treatment_name'].' - '.$row['lqdc_gross'],
    //             'name' =>  $row['treatment_id'].' - '.$row['treatment_name'].' - '.$row['lqdc_gross']));
	// 	};
	// 	echo json_encode($data);
    // }
    public function get_patients()
	{
			$nameStartsWith = $this->input->get('p');
			$data = $this->CommonModel->getPatients($nameStartsWith);

			echo json_encode($data);
		
	}
    public function get_procedures() {
        $decryptedId = $this->input->get('p');
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

      
        $result = $this->CommonModel->get_procedures($patient->insurance_type, $this->input->get('q'),$this->input->get('t'));
    
        $data = [];
        foreach ($result->result_array() as $row) {
            $data[] = [
               'id'   => "{$row['id']} | {$row['treatment_id']} | {$row['treatment_name']} | {$row['lqdc_gross']}",
                'name' => "{$row['treatment_id']} | {$row['treatment_name']} | {$row['lqdc_gross']}",
            ];
        }
    
        echo json_encode($data);
    }
    public function get_departments() {
       
    
        $result = $this->CommonModel->retrieve_data_unique('tbl_modules','is_module','1');
        $data = array();    
        foreach ($result as $row) {
            array_push($data, array(
                'id' => $row['department_id'],
                'name' => $row['module_name'],
              
            ));
        }
       
    
        echo json_encode($data);
    }

    public function get_programs() {
    
        $result = $this->CommonModel->retrieve_data_unique_like('tbl_programs', 'program_name',  $this->input->get('q'));

        $data = [];
        foreach ($result as $row) {
            $data[] = [
                'id'   => "{$row['program_name']}",
                'name' => "{$row['program_name']}",
            ];
        }
    
        echo json_encode($data);
    }
    
    
    public function get_notifications() {

        $start_date = date('Y-m-d');
        $end_date = date('Y-m-d' , strtotime('+1 day'));
		$appointments = $this->CalenderModel->get_appointments($this->loginId, $start_date, $end_date);
        $data = [];
        foreach ($appointments as $appointment) {
            if($appointment['now_waiting']=='5'){
                $child_data = array(
                    'message'=> $appointment['app_patient_name'].' Patient is waiting.',
                    'date' => $appointment['appointment_date'].' '.$appointment['appointment_time'],
                    'id'=> $appointment['app_patient_id'],
                );
                array_push($data, $child_data);
            }
        }
        echo json_encode($data);
    }

    public function support_ticket(){

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Setting/Configurations/SupportTicket', $data);
    }

    public function Subscriptions(){

        $sample=1;
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['subscriptions'] = $this->CommonModel->subscriptions();

    

        $this->load->view('admin/Setting/Configurations/Subscriptions', $data);
    }
public function PaymentCard($month=12){

        $sample=1;
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['subscriptions'] = $this->CommonModel->subscriptions();
        $data['months']= $month ?? 12;
        $data['company']= $this->CommonModel->get_company_info();
    

        $this->load->view('admin/Setting/Configurations/PaymentForm', $data);
    }


    public function validate(){

        $bin = $this->input->post('bin') ;
        header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://bin-ip-checker.p.rapidapi.com/?bin=".$bin);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
    'bin' =>$bin
]));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "x-rapidapi-key: 4c3fffc5a0msh8bf54759aa3d8cap174184jsn34e67fa8cc9f",
    "x-rapidapi-host: bin-ip-checker.p.rapidapi.com",
    "Content-Type: application/json"
]);
$response = curl_exec($ch);
curl_close($ch);
echo $response;
    }
    
	
}
