<?php

class CreditsController extends MY_Controller
{

	function __construct()
	{
		parent::__construct();

		//Commen -------------------------------------
		$this->load->model('admin/CommonModel');
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');

		$this->load->model('admin/Credits/CreditsModel');
        $this->load->model('admin/Reports/ReportsModel');
        $this->load->model('admin/Receipt/ReceiptModel');
		$this->load->model('admin/ConsentForm/RetriveProcessModel');
        $this->load->model('admin/Payments/PaymentsModel');
		
	}

	public function index($page = 0)
	{

		if ($this->session->userdata('user_Id') != '') {

			//Commen -------------------------------------
			$loginId = $this->session->userdata('user_Id');
			$data['active_menu'] = 29;
			$data['active_submenu'] = 1;
			$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
			$data['profile'] = $this->CommonModel->profile($loginId);
			
            $data['payment_types'] = $this->ReportsModel->payment_types();
            $data['refund_types'] = $this->ReportsModel->refund_types();

			$this->load->view('admin/Credits/CreditsList', $data);
		} else {
			redirect('admin/Login/LoginController', 'refresh');
		}
	}

	public function saveAdvance()
	{

		$loginId = $this->session->userdata('user_Id');
		$data['active_menu'] = 29;
		$data['active_submenu'] = 1;
		$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
		$data['profile'] = $this->CommonModel->profile($loginId);

		$payment_type = $this->input->post('payment_type');
		$payment_amount = $this->input->post('payment_amount');
		$card = $this->input->post('card_amount');
		$pay_date = $this->input->post('pay_date');
		$pay_time = $this->input->post('pay_time');
		$advance_id = decrypt_and_url_decode($this->input->post('advance_id'),$this);
		$patient_id = $this->input->post('patient_id');

		$new_data = [];
		array_push($new_data,array(
			'pay_type' => $payment_type,
			'amount' =>  $payment_amount,
			'pay_date' => $pay_date,
			'pay_time' => $pay_time,
			'patient_id' => $patient_id,
			'user_id' => $this->loginId
		));

		if ($advance_id != '') {
			$this->CreditsModel->update_data_where('tbl_advance', 'advance_id', $advance_id, $new_data[0]);
			$this->createLog('Advance Payment', $this->loginId, 'Update', $new_data);
			$this->session->set_flashdata('success', 'Advance Payment Updated successfully.');
		} else {
			if ($payment_type == 3) {
				//cash card invoice creation
				$new_data = [];
				for ($i = 1; $i < 3; $i++) {
					$_amount = $i == 1 ? $payment_amount :  $card;
					array_push($new_data, array(
						'pay_type' => $i,
						'amount' => $_amount,
						'pay_date' => $pay_date,
						'pay_time' => $pay_time,
						'patient_id' => $patient_id,
						'user_id' => $this->loginId
					));
				}
			}
			
			$this->CreditsModel->insert_data_multiple('tbl_advance', $new_data);
			$this->createLog('Advance Payment', $this->loginId, 'Create', $new_data);
			$this->session->set_flashdata('success', 'Advance Payment saved successfully.');
		}
		
		redirect('admin/Credits/CreditsController');
	}

	
	public function saveRefund()
	{

		$payment_type = $this->input->post('payment_type');
        $payment_amount = $this->input->post('payment_amount');
        $card = $this->input->post('card');
        $co_payment = $this->input->post('co_payment');
        $discount = $this->input->post('discount');
        $pay_date = $this->input->post('pay_date');
        $pay_time = $this->input->post('pay_time');
        $discount_for = $this->input->post('discount_for');
        $treatment_payment_id = $this->input->post('treatment_payment_id');
        $payment_id = $this->input->post('payment_id');
        $patient_id = $this->input->post('patient_id');
        $patient_id = $this->input->post('invoice_id');
		$result = $this->CommonModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $treatment_payment_id);

		
        $total = $payment_amount + $card + $discount;
        $new_data = [];
		array_push($new_data,array( 
            'pay_type' => $payment_type,
            'amount' => $payment_amount,
            'pay_date' => $pay_date,
            'pay_time' => $pay_time,
            'patient_id' => $result->patient_id,
            'is_insurance' => 0,
            'user_id' => $this->loginId,
            'total' => $total,
            'is_refund' => 1,
            'treatment_payment_id' => $treatment_payment_id
        ));

		// $this->form_validation->set_rules('invoice_id', 'Invoice Number', 'required');
		$validation_rules = array(
			array(
				'field' => 'invoice_id',
				'label' => 'Invoice Number',
				'rules' => 'required'
			),
			array(
				'field' => 'payment_amount',
				'label' => 'Refund Amount',
				'rules' => 'required|greater_than[0]'
			)
		);
		
		$this->form_validation->set_rules($validation_rules);


		if ($this->form_validation->run() == FALSE) {
			$error_message ="";
			foreach ($validation_rules as $rule) {
				$field = $rule['field'];
				$error_message .= "*".form_error($field)."<br>";
			}
			$this->session->set_flashdata('error', $error_message);
            redirect('admin/Credits/CreditsController');
            return;
        }

		// print_r($payment_id);die;

        if ($payment_id != '') {
            $this->PaymentsModel->update_data_where('tbl_refund', 'id', $payment_id, $new_data[0]);
            $this->createLog('Refund', $this->loginId, 'Update', $new_data);
            $this->session->set_flashdata('success', 'Payment Updated Successfully.');
        } else {

            $this->PaymentsModel->insert_data_multiple('tbl_refund', $new_data);
            $this->createLog('Refund', $this->loginId, 'Create', $new_data);
            $this->session->set_flashdata('success', 'Payment Saved Successfully.');
        }
		
		redirect('admin/Credits/CreditsController');
	}



	public function deleteAdvance($encrypt_id)
	{

		$advance_id = decrypt_and_url_decode($encrypt_id,$this);
		$result = $this->CreditsModel->retrieve_data_unique_row('tbl_advance', 'advance_id', $advance_id);
		$this->CreditsModel->delete_data_where('tbl_advance', 'advance_id', $advance_id);
		$log_data = array(
            'user_id' => $this->loginId,
            'data' => $result
        );
        $this->createLog('Advance Payment', $this->loginId, 'Delete', $log_data);
		$this->session->set_flashdata('success', 'Advance Payment Deleted!');
		redirect('admin/Credits/CreditsController');

	}

	public function editAdvance($encrypt_id){

		$loginId = $this->session->userdata('user_Id');
		$data['active_menu'] = 29;
		$data['active_submenu'] = 1;
		$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
		$data['profile'] = $this->CommonModel->profile($loginId);
		
		$data['payment_types'] = $this->ReportsModel->payment_types();

		$advance_id = decrypt_and_url_decode($encrypt_id,$this);
		$result = $this->CreditsModel->retrieve_data_unique_row('tbl_advance', 'advance_id', $advance_id);
		$patient = $this->CreditsModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $result->patient_id);
		$data = array_merge($data, (array)$result);
		$data = array_merge($data, (array)$patient);
		
		$this->load->view('admin/Credits/CreditsList', $data);
	}

    public function get_advance_list()
	{

		$draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];

        $records = $this->CreditsModel->getAdvanceList($search, $length, $start, $order_column, $order);
        foreach ($records as $key => $row) {
            $row->advance_id = encrypt_and_url_encode($row->advance_id, $this);
            $records[$key] = $row;
        }
		$total_records = $this->CreditsModel->getAdvanceList($search, -1, $start, $order_column, $order);


        // $total_records = count($records); // Get total records

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records[0]->total,
            "recordsFiltered" => $total_records[0]->total,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
	}

	public function get_refund_list()
	{

		$draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];

        $records = $this->CreditsModel->getRefundList($search, $length, $start, $order_column, $order);
		
        foreach ($records as $key => $row) {
            $row->id = encrypt_and_url_encode($row->id, $this);
            $records[$key] = $row;
        }
		// print_r($records);die;
        $total_records = count($records); // Get total records

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
	}

	public function check_refund_full()
	{
		if ($this->session->userdata('emp_name')=='') {
			redirect(site_url());
		}else{
				$ctr = 0;
				$search_data = $this->input->post('search_data');
				$patient_id = explode(' - ', $search_data);
				$result = $this->retrive_payment->get_invoices($patient_id[0]);
				$HTML = '';
				$HTML.='<br><br>

				<table id="root" class="table table-striped table-bordered table-hover">
					<tr>
						<td></td>
						<td>Invoice No</td>
						<td>Type</td>
						<td>Paid Amount</td>
						<td>Gross Amount</td>
						<td>Status</td>
					</tr><tbody>';
				if (isset($result) and $result != false) {
					foreach ($result as $value) {

						$result1 = $this->retrive_payment->get_treatment_paid($value['treatment_payment_id']);
						$result2 = $this->retrive_payment->get_total_refund($value['treatment_payment_id']);
						// $result2 = $this->retrive_payment->get_row_data('refund_full', 'treatment_payment_id',$value['treatment_payment_id']);
						$refund_amount = $result2->amount;
						$paid_amount = $result1->amount;
						$rem = $paid_amount-$refund_amount;
						$balance = $value['total']-$paid_amount;
						if($balance>0){
							$status = "<font color='#4cae4c'>Not Yet</font>";
						}else{
							$status = "<font color='#a94442'>Completed</font>";
						}
						// if(!$result2){
							if($rem > 0){
							$HTML.='
								<tr>
									<td><input type="checkbox" name="invoice[]" id="invoice" value="'.$value['treatment_payment_id'].'"></td>
									<td>'.$value['treatment_payment_id'].'</td>
									<td>'.$value['insurance_name'].'</td>
									<td>'.$value['total'].'</td>
									<td>'.number_format($rem,2).'</td>
									<td>'.$status.'</td>
								</tr>';
								$ctr++;
							}
						// }
					}
				}
				$HTML.='</tbody></table>';
				if($ctr!=0){
				$HTML.='<b>Refund amount: </b><input type="text" name="refund_amount" id="refund_amount"><br>';
				}
				$HTML .= '<input type="hidden" name="pat_id" id="pat_id"  value="'.$patient_id[0].'"><button type="submit" class="btn btn-default btn-primary" id="save">Refund</button>';

	            echo $HTML;
		}
	}

	public function get_invoices()
	{

		$nameStartsWith = $this->input->get('name_startsWith');
		$showAll = $this->input->get('show_all');

		$data = $this->RetriveProcessModel->getInvoices($nameStartsWith, $showAll);

		echo json_encode($data);
	}

	
	public function deleteRefund($encrypt_id)
	{

		$refund_id = decrypt_and_url_decode($encrypt_id,$this);
		$result = $this->CreditsModel->retrieve_data_unique_row('tbl_patient_payment', 'patient_payment_id', $refund_id);
		$this->CreditsModel->delete_data_where('tbl_patient_payment', 'patient_payment_id', $refund_id);
		$log_data = array(
            'user_id' => $this->loginId,
            'data' => $result
        );
        $this->createLog('Refund Payment', $this->loginId, 'Delete', $log_data);
		$this->session->set_flashdata('success', 'Refund Payment Deleted!');
		redirect('admin/Credits/CreditsController');

	}

	public function editRefund($encrypt_id){

		$loginId = $this->session->userdata('user_Id');
		$data['active_menu'] = 29;
		$data['active_submenu'] = 1;
		$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
		$data['profile'] = $this->CommonModel->profile($loginId);
		
		$data['payment_types'] = $this->ReportsModel->payment_types();

		$refund_id = decrypt_and_url_decode($encrypt_id,$this);
		$result = $this->CreditsModel->retrieve_data_unique_row('tbl_refund', 'id', $refund_id);
		$data = array_merge($data, (array)$result);
		// print_r($result);die;
		$this->load->view('admin/Credits/CreditsList', $data);
	}

}
