<?php

require_once APPPATH . 'controllers/admin/Jobs/Job/SmsNotification.php';
defined('BASEPATH') OR exit('No direct script access allowed');


use Twilio\Rest\Client;
class LabController extends MY_Controller
{

	private $job = null;

	function __construct()
	{
		parent::__construct();

		$this->job = new Job($this);
		$this->load->helper('date');
		$this->load->model('admin/Employees/EmployeesModel');
		$this->load->model('admin/UserGroup/UserGroupModel');
		$this->load->model('admin/Users/UserModel');
		$this->load->model('admin/Lab/Lab');
		$this->load->model('admin/Calender/CalenderModel');
		$this->load->model('admin/SmsPortal/SmsPortalModel');
		$this->load->model('admin/Lab/ParamModel');
		$this->load->model('admin/Patients/PatientsModel');
		
		//Commen -------------------------------------
		$this->load->model('admin/CommonModel');
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->load->model('admin/Reports/ReportsModel','report_retrive');
	
	}

	public function index()
	{
		
			$this->load->view('admin/Lab/index');
		
	}


	public function getParams()
	{

		
			$result = $this->Lab->getParams();

           
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
	}
	public function getTests()
	{

		
			$result = $this->Lab->getTests();

           
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
	}


	public function add_parameter()
	{
		$data['units'] = $this->report_retrive->retrieve_data('lab_units');
		$this->load->view('admin/Lab/Configuration/Parameters/add_parameter',$data);	
	}

	public function add_test()
	{
		$data['categories'] = $this->report_retrive->retrieve_data('test_categories');
		$data['test_parameters'] = $this->report_retrive->retrieve_data('test_parameters');
		$this->load->view('admin/Lab/Configuration/LabTest/add_test',$data);	
	}


	public function edit_parameter($id)
	{
		$data['parameter'] = $this->ParamModel->getParam($id);
		$data['parameter_values'] = $this->ParamModel->getParamValues($id);
		$data['units'] = $this->report_retrive->retrieve_data('lab_units');

		
		$this->load->view('admin/Lab/Configuration/Parameters/edit_parameter',$data);	
	}
	
	

	public function saveParam()
	{

		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");

		$name = $this->input->post('name');
		$unit = $this->input->post('unit');
		$field_type = $this->input->post('field_type');


		$genders = $this->input->post('gender');
		$min_ages = $this->input->post('min_age');
		$max_ages = $this->input->post('max_age');
		$lower_values = $this->input->post('lower_value');
		$upper_values = $this->input->post('upper_value');
		$normal_value = $this->input->post('normal_value');

		
		
		$basic_data= array(
			'name' => $name,
			'unit' => $unit,
			'field_type' => $field_type,
			
		);
		
		$param_id= $this->ParamModel->save($basic_data);
		
		foreach ($genders as $index => $gender) {
			$data = array(
				'param_id' => $param_id,
				'gender' => $gender,
				'min_age' => $min_ages[$index],
				'max_age' => $max_ages[$index],
				'lower_value' => $lower_values[$index],
				'max_value' => $upper_values[$index],
				'normal_value' => $normal_value
			);

			// Save data to the database
			$this->ParamModel->save_values($data);
		}


		$this->session->set_flashdata('success', 'Parameter Added Successfully');
		redirect('admin/Lab/LabController/add_parameter', 'refresh');
	}


	public function updateParam($id)
	{

		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");

		$name = $this->input->post('name');
		$unit = $this->input->post('unit');
		$field_type = $this->input->post('field_type');


		$genders = $this->input->post('gender');
		$min_ages = $this->input->post('min_age');
		$max_ages = $this->input->post('max_age');
		$lower_values = $this->input->post('lower_value');
		$upper_values = $this->input->post('upper_value');
		$normal_value = $this->input->post('normal_value');
		$vid = $this->input->post('value_id');
		

		
		
		$basic_data= array(
			'name' => $name,
			'unit' => $unit,
			'field_type' => $field_type,
			
		);
		
		 $this->ParamModel->update($id,$basic_data);
		
		foreach ($genders as $index => $gender) {
			$data = array(
				'param_id' => $id,
				'gender' => $gender,
				'min_age' => $min_ages[$index],
				'max_age' => $max_ages[$index],
				'lower_value' => $lower_values[$index],
				'max_value' => $upper_values[$index],
				'normal_value' => $normal_value
			);

			// Save data to the database
			$this->ParamModel->update_value($vid,$data);
		}


		$this->session->set_flashdata('success', 'Parameter Updated Successfully');
		redirect('admin/Lab/LabController/edit_parameter/'.$id, 'refresh');
	}
	public function delete_parameter($id){

		$affected_rows = $this->ParamModel->deleteParameter($id);

        if ($affected_rows > 0) {
			$this->session->set_flashdata('success', 'Parameter Deleted Successfully');
			
        } else {
			$this->session->set_flashdata('error', 'Soemthing Went Wrong');
        }
		redirect('admin/Lab/FilterController/parameters/', 'refresh');
	}


	public function saveTest()
	{

		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");

		$name = $this->input->post('name');
		$short_name = $this->input->post('short_name');
		$category = $this->input->post('categories');
		$price = $this->input->post('price');
		$order_show = $this->input->post('order_show');
		$params = $this->input->post('parameter');


	
		
		$basic_data= array(
			'name' => $name,
			'short_name' => $short_name,
			'categories' => $category,
			'price' => $price,
			
		);
		
		$test_id= $this->Lab->saveTest($basic_data);
		
		foreach ($params as $index => $param) {
			if($param != ''){
				$data = array(
					'test_id' => $test_id,
					'param_id' => $param,
					'order_show' => $order_show[$index]
					
				);
	
				// Save data to the database
				$this->Lab->save_params($data);
			}
			
		}


		$this->session->set_flashdata('success', 'Test Added Successfully');
		redirect('admin/Lab/LabController/add_test', 'refresh');
	}

	public function get_test()
    {
        $result = $this->Lab->get_test_by_detail();
        $data = array();
        foreach ($result->result_array() as $row) {
            array_push($data, array(
                'id' => $row['id'],
                'name' => $row['name'],
                'short_name' => $row['short_name'],
                'price' => $row['price'],
            ));
        }
        echo json_encode($data);
    }
	public function saveCase(){
			//patient Data
		$loginId = $this->session->userdata('user_Id');
		$qid = $this->input->post('qid');
		$patient_id = $this->input->post('file_no');
		$first_name = $this->input->post('first_name');
		$middle_name = $this->input->post('middle_name');
		$last_name = $this->input->post('last_name');
		$age = $this->input->post('age');
		$dob = $this->input->post('dob');
		$nationality = $this->input->post('nationality');
		$mobile = $this->input->post('mobile');
		//case Data

		$sub_total = $this->input->post('total_first');
		$total = $this->input->post('total_final');
		$total_discount = $this->input->post('total_discount');
		$amount_received = $this->input->post('amount_received');
		$balance = $this->input->post('balance');
		$payment_method = $this->input->post('payment_method');
		$tests = $this->input->post('tests');
		$existing_case = $this->input->post('case_id_existing');
		$type = $this->input->post('type');
		$make_invoice = $this->input->post('make_invoice');
		$testar = [];

		if(empty($type)){
			$type='0';
		}
		if(empty($make_invoice)){
			$make_invoice='0';
		}
		if(empty($existing_case)){
			$existing_case='0';
		}else{

			$case_data = $this->Lab->retrieve_data_unique_row('lab_cases','id', $existing_case);
		}


		// Loop through each test and add it to the array
		
	
		// Print the array of tests for debugging purposes
		
		
		// $patient_data= array(
		// 	'qatar_id' => $qid,
		// 	'patient_name' => $first_name . $last_name,
		// 	'last_name'=>$last_name,
		// 	'first_name' => $first_name,
		// 	'middle_name' => $middle_name,
		// 	'dob' => $dob,
		// 	'nationality' => $nationality,
		// 	'mobile' => $mobile,
			
		// );
		// $patientExist=$this->PatientsModel->checkPatientExist($qid);
		// if($patientExist ==0){
		// 	$patient_id = $this->PatientsModel->insert_data('tbl_patients', $patient_data);
		// }else{
		// 	$patient_id = $patientExist;
		// }

	
		
		$payment= array(
			'patient_id' => $patient_id,
			'total' => $sub_total ?? 0,
			'discount'=>$total_discount ?? 0,
			
			'created_date' => date('Y-m-d H:i:s'),
			'treat_date' => date('Y-m-d '),
			'treat_time'=>date('H:i:s'),
			'lab' =>1,
			'user_id'=> $loginId ,
			'department_id'=> 11 ,
			'insurance_type'=> 1 ,
			
			
		);
		if($existing_case == 0){

			$payment_id = $this->Lab->insert_data('tbl_treatment_payment', $payment);

		}else{
			
			if($case_data->make_invoice ==0){

				$payment_id = $this->Lab->insert_data('tbl_treatment_payment', $payment);
			}else{
				$payment_id = $case_data->treatment_payment_id;
			}

		}

		

		$case_data= array(
			'patient_id' => $patient_id,
			'sub_total' => $sub_total,
			'total' => $total ,
			'discount'=>$total_discount ?? 0,
			'payment_method' => $payment_method,
			'balance' => $balance,
			'created_at' => date('Y-m-d H:i:s'),
			'user_id' => $loginId,
			'treatment_payment_id' => $payment_id,
			'type' => $type,
			'make_invoice'=>$make_invoice,
			
		);
		if($existing_case == 0){
			$case_id = $this->Lab->insert_data('lab_cases', $case_data);
		}else{
			

			$case_data_update= array(
				'patient_id' => $patient_id,
				'sub_total' => $sub_total,
				'total' => $total ,
				'discount'=>$total_discount,
				'payment_method' => $payment_method,
				'balance' => $balance,
				'created_at' => date('Y-m-d H:i:s'),
				'user_id' => $loginId,
				'treatment_payment_id' => $payment_id,
				'type' => 0,
				'make_invoice'=>1,
				
			);

			$this->Lab->update_data('lab_cases','id', $existing_case, $case_data_update, );
			$case_id = $existing_case;
		}
		

		if (is_array($tests)) {

		
			foreach ($tests as $test) {
				$relation_data= array(
					'case_id' => $case_id,
					'test_id' => $test,
					
					
				);
				if($existing_case == 0){
				$case_has_tests = $this->Lab->insert_data('case_has_tests', $relation_data);
				}else{
					$case_has_tests = $this->Lab->update_data('case_has_tests','case_id', $case_id,$relation_data);
				}
				
			}
		}


		if ($case_id) {
			$response = array(
				'status' => 'success',
				'msg' => 'Case Created Successfully',
				'id' => $payment_id,
				'case_id' => $case_id,

			);
		} else {
			$response = array(
				'status' => 'error',
				'msg' => 'Something Went Wrong'
			);
		}
	
		// Set content type to JSON
		$this->output
			->set_content_type('application/json')
			->set_output(json_encode($response));
		
		
	}
	public function saveRequest(){
		$loginId = $this->session->userdata('user_Id');
		$patient_id = $this->input->post('patient_id');
		$more_tests = $this->input->post('more_tests');
		$tests = $this->input->post('tests');

		$case_data= array(
			'patient_id' => $patient_id,
			'created_at' => date('Y-m-d H:i:s'),
			'user_id' => $loginId,
			'reffered_by' => $loginId,
			'type' => 1,
			'make_invoice'=>0,
			'more_tests'=>$more_tests
			
			
		);

		$case_id = $this->Lab->insert_data('lab_cases', $case_data);

		if (is_array($tests)) {

		
			foreach ($tests as $test) {
				$relation_data= array(
					'case_id' => $case_id,
					'test_id' => $test,
					
					
				);

				$case_has_tests = $this->Lab->insert_data('case_has_tests', $relation_data);
				
			}
		}
		if ($case_id) {
			$response = array(
				'status' => 'success',
				'msg' => 'Lab Request Created Successfully',
				'case_id' => $case_id,

			);
		} else {
			$response = array(
				'status' => 'error',
				'msg' => 'Something Went Wrong'
			);
		}
	
		// Set content type to JSON
		$this->output
			->set_content_type('application/json')
			->set_output(json_encode($response));


	}

	public function get_all_cases_by_patient(){
		$patient_id = $this->input->post('patient_id');
			$from = $this->input->post('from');
			$qid = $this->input->post('qid');
			// $drug_array = explode("-",$drug);
         
			$result = $this->Lab->get_cases_list_by_patient($patient_id);

           
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
        

	}
	public function get_tests_by_case($case_id) {
        $tests = $this->Lab->get_tests_by_case($case_id);
        echo json_encode($tests);
    }
	

	public function deleteRequest($id){

		if ($this->Lab->delete_case_request($id)) {
			// Success message
			$this->session->set_flashdata('success', 'Lab Request deleted successfully.');
		} else {
			// Failure message
			$this->session->set_flashdata('error', 'Failed to delete Lab Request. Please try again.');
		}
		redirect($_SERVER['HTTP_REFERER']);
	}

	public function get_all_requests(){
		$to = $this->input->post('to');
			$from = $this->input->post('from');
			$file = $this->input->post('file_no');
			$type=$this->input->post('type');
			// $drug_array = explode("-",$drug);
         
			$result = $this->Lab->get_request_list($file, $from,$to,$type);

           
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
        

	}

	public function get_all_cases(){
		$to = $this->input->post('to');
			$from = $this->input->post('from');
			$qid = $this->input->post('qid');
			// $drug_array = explode("-",$drug);
			$type=$this->input->post('type');
         
			$result = $this->Lab->get_cases_list($qid, $from,$to,$type);

           
            if ($result) {
				
				foreach ($result as $key => $row) {
					
					$row['treatment_payment_id'] = encrypt_and_url_encode($row['treatment_payment_id'], $this);
					
					$result[$key] = $row;
				}
			} else {
				$result = [];
			}
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
        

	}

	public function add_result($case_id){

		$data['tests'] = $this->Lab->retrieve_data_unique('case_has_tests','case_id',$case_id);
		$data['patient'] = $this->Lab->get_patient_case($case_id);
		$data['test_params'] = $this->Lab->get_test_params_for_case($case_id);
	
		$data['case_id']=$case_id;
		$this->load->view('admin/Lab/Case/add_result',$data);

	}

	public function save_results(){
		$case_id = $this->input->post('case_id');
    $results = $this->input->post('test_results');
	$remarks = $this->input->post('remarks') ?? 'NA';

    // Save the results as JSON
	
    $this->Lab->save_test_result_json($case_id, $results,$remarks);

    // Send a response
    $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode(['status' => 'success']));
	}
	public function view_result($case_id) {
		$data['case_id'] = $case_id;
		$data['patient'] = $this->Lab->get_patient_case($case_id);
		$data['test_params'] = $this->Lab->get_test_params_with_results($case_id);
		
		$this->load->view('admin/Lab/Case/view_result', $data);
	}

	public function view_result_doc($case_id) {
		$data['case_id'] = $case_id;
		$data['patient'] = $this->Lab->get_patient_case($case_id);
		$data['test_params'] = $this->Lab->get_test_params_with_results($case_id);
		
		$this->load->view('admin/Lab/Case/view_result_doc', $data);
	}

	public function print_results($case_id) {
		$data['case_id'] = $case_id;
		$data['patient'] = $this->Lab->get_patient_case($case_id);
		$data['test_params'] = $this->Lab->get_test_params_with_results($case_id);
		$data['print_config'] = $this->Lab->get_print_config();

		
		$this->load->view('admin/Lab/Case/print_result', $data);
	}
	
	public function sendInvoice(){
	
        $sid    = "AC6ccfe83aae191ff7e6eae2098ee6dc07";
    $token  = "a6fb432dc37a99ca67c068da7e8e47e0";
    $twilio = new Client($sid, $token);
	$media_url = 'https://pdfobject.com/pdf/sample.pdf';

    $message = $twilio->messages
      ->create("whatsapp:+97477393781", // to
        array(
          "from" => "whatsapp:+923454186985",
          "body" => "Hey This is your Invoice ",
		  'MediaUrl' => $media_url
        )
      );

		print($message->sid);
	}

	

}


