<?php

class PackageController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Patients/PatientsModel');

   
    }

    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
    }


    public function save()
    {
        $loginId = $this->session->userdata('user_Id');
        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);
        $package_id = $this->input->post('package_id');

       $total= $this->PatientsModel->retrieve_data_unique_row('packages', 'id', $package_id)->price;

        $newdata = array(
            'package_id'=>$package_id,
            'patient_id'=>$decryptedId,
            'start_date'=>date('Y-m-d H:i:s')


        );
        $package = $this->PatientsModel->insert_data('user_has_package', $newdata);

        $treatmentPayment = array(
            'patient_id'  => $decryptedId,
            'user_id' => $loginId,
            'treat_date' => date('Y-m-d'),
            'treat_time' => date('H:i:s'),
            'total' => $total,     
            'department_id'  => 2,
            'discount' => 0,
            'insurance_type' => $this->PatientsModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $decryptedId)->insurance_type
        );

        $treatment_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatmentPayment);

        $this->session->set_flashdata('success', 'Package Assigned successfully.');
        redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
    }


   

    public function removePackage()
    {
        $patient_id = $this->input->post('patient_id');
        $package_id = $this->input->post('id');

    

        $this->db->where('patient_id', $patient_id);
        $this->db->where('package_id', $package_id);
        $deleted = $this->db->delete('user_has_package');
    
        // Check if the deletion was successful
        if ($deleted) {
            echo json_encode(['status' => 'success', 'message' => 'Package removed successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to remove the package.']);
        }
    }
}
