<?php

class PlasticSurgeryController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');

        $this->load->library('upload');
    }

    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
    }

    
    

    public function canvan_images($imagepath, $pid, $folder_name,$plastic_up_image)
    {

       

        if (!is_dir('./'.UPLOAD_PATH)) {
            mkdir('./'.UPLOAD_PATH);
        }

        if (!is_dir('/'.UPLOAD_PATH.'plastic/')) {
            mkdir('./'.UPLOAD_PATH.'plastic/');
        }

        if (!is_dir("./".UPLOAD_PATH."plastic/{$folder_name}")) {
            mkdir("./".UPLOAD_PATH."plastic/{$folder_name}");
        }
        $exist_image=''.UPLOAD_PATH.'plastic/' . $folder_name.$plastic_up_image;
        
        $imagepath = substr($imagepath, strpos($imagepath, ",") + 1);
        $imagepath = base64_decode($imagepath);
      
        $path = ''.UPLOAD_PATH.'plastic/' . $folder_name;
       
        // print_r($imagepath);die;
        $image_name = $pid . '_' . uniqid() . ".png";
        $file_path = $path . $image_name;
        file_put_contents($file_path, $imagepath, FILE_USE_INCLUDE_PATH);
        return $image_name;
    }


    public function save()
    {

        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        $treatment_date_plas_surg = $this->input->post('treatment_date_plas_surg');
		$chief_complaint_plas_surg = $this->input->post('chief_complaint_plas_surg');
		$subjective_plas_surg = $this->input->post('subjective_plas_surg');
		$objective_plas_surg = $this->input->post('objective_plas_surg');
		$assessment_plas_surg = $this->input->post('assessment_plas_surg');

		$diagnosis_id = $this->input->post('plas_surg_diagnosis_id');
		$diagnosis_name = $this->input->post('plas_surg_diagnosis_name');
		$treatment_name = $this->input->post('plas_surg_treatment_name');
		$treatment_id = $this->input->post('plas_surg_treatment_id');
		$fees = $this->input->post('orig_price_plas_surg');
		$imagepath_plastic = $this->input->post('imagepath-plastic');
		$note = $this->input->post('note');

		$discount = $this->input->post('discount_plas_surg');
		$discount_per = $this->input->post('discount_per_plas_surg');

		$drug_id = $this->input->post('drug_id_plas_surg');
		$drug_name = $this->input->post('drug_name_plas_surg');
		$drugs_qty = $this->input->post('drugs_qty_plas_surg');
		$meals = $this->input->post('meals_plas_surg');
		$drug_notes = $this->input->post('drug_notes_plas_surg');
		$pl_remark = $this->input->post('pl_remark');

        $triage_weight = $this->input->post('triage_weight');
        $triage_height = $this->input->post('triage_height');
        $triage_bmi = $this->input->post('triage_bmi');
        $triage_bp = $this->input->post('triage_bp');
        $triage_temperature = $this->input->post('triage_temperature');
        $triage_pulse = $this->input->post('triage_pulse');
        $triage_rr = $this->input->post('triage_rr');

        $assigned_package = $this->input->post('assigned_package');
        $followup = $this->input->post('followup');

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');

        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }
        

        $this->db->trans_start();
        try {

            if($followup == 0){
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_plas_surg,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => 0,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 4
            );
        }else{
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_plas_surg,
                'treat_time' => $treatment_time,
                'total' => 0,
                'discount' => 0,
                'followup'  => 0,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 4
            );
        }

            $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);

            if ($triage_weight != '' || $triage_height != '' || $triage_bmi != '' || $triage_bp != '' || $triage_temperature != '' || $triage_pulse != '' || $triage_rr != '') {

                $newdata = array(
                    'patient_id' => $decryptedId,
                    'create_by' => $this->loginId,
                    'weight' => $triage_weight,
                    'height' => $triage_height,
                    'bmi' => $triage_bmi,
                    'bp' => $triage_bp,
                    'temperature' => $triage_temperature,
                    'pulse' => $triage_pulse,
                    'rr' => $triage_rr,
                    'treatment_id' => $treatement_payment_id
                );
    
                $this->PatientsModel->insert_data('tbl_nurse_triage', $newdata);
               
            }

            $plastic_data = array(
				'mark_iname' => $this->canvan_images($imagepath_plastic, $decryptedId, 'marks/',''),
				'pl_remark' => $pl_remark,
                'chief_complaint_plas_surg'  => $chief_complaint_plas_surg,
                'subjective_plas_surg' => $subjective_plas_surg,
                'objective_plas_surg' => $objective_plas_surg,
                'assessment_plas_surg' => $assessment_plas_surg,
                // 'note' => $note,
                'treatment_payment_id' => $treatement_payment_id
			);
			
			$plastic_data_id = $this->PatientsModel->insert_data('tbl_treat_plastic', $plastic_data);

            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    // 'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }

            if($followup == 2){
                $this->PatientsModel->updateSessions($decryptedId,$assigned_package,5);
                 
                 
              }

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'Plastic Surgey Treatment saved successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'Plastic Surgey Treatment not saved.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
            exit;
        }

        $this->db->trans_complete();
    }

    public function update()
    {

        $patient_id = $this->input->post('patient_id');
        $treatement_payment_id = $this->input->post('treatement_payment_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        $treatment_date_plas_surg = $this->input->post('treatment_date_plas_surg');
		$chief_complaint_plas_surg = $this->input->post('chief_complaint_plas_surg');
		$subjective_plas_surg = $this->input->post('subjective_plas_surg');
		$objective_plas_surg = $this->input->post('objective_plas_surg');
		$assessment_plas_surg = $this->input->post('assessment_plas_surg');

		$diagnosis_id = $this->input->post('plas_surg_diagnosis_id');
		$diagnosis_name = $this->input->post('plas_surg_diagnosis_name');
		$treatment_name = $this->input->post('plas_surg_treatment_name');
		$treatment_id = $this->input->post('plas_surg_treatment_id');
		$fees = $this->input->post('orig_price_plas_surg');
		$imagepath_plastic = $this->input->post('imagepath-plastic');
		$note = $this->input->post('note');

		$discount = $this->input->post('discount_plas_surg');
		$discount_per = $this->input->post('discount_per_plas_surg');

		$drug_id = $this->input->post('drug_id_plas_surg');
		$drug_name = $this->input->post('drug_name_plas_surg');
		$drugs_qty = $this->input->post('drugs_qty_plas_surg');
		$meals = $this->input->post('meals_plas_surg');
		$drug_notes = $this->input->post('drug_notes_plas_surg');
		$pl_remark = $this->input->post('pl_remark');
		$plastic_up_image = $this->input->post('plastic_up_image');

        $triage_weight = $this->input->post('triage_weight');
        $triage_height = $this->input->post('triage_height');
        $triage_bmi = $this->input->post('triage_bmi');
        $triage_bp = $this->input->post('triage_bp');
        $triage_temperature = $this->input->post('triage_temperature');
        $triage_pulse = $this->input->post('triage_pulse');
        $triage_rr = $this->input->post('triage_rr');

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');
        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $this->db->trans_start();
        try {
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_plas_surg,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => 0,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 4
            );

            if ($triage_weight != '' || $triage_height != '' || $triage_bmi != '' || $triage_bp != '' || $triage_temperature != '' || $triage_pulse != '' || $triage_rr != '') {

                $newdata = array(
                    'patient_id' => $decryptedId,
                    'create_by' => $this->loginId,
                    'weight' => $triage_weight,
                    'height' => $triage_height,
                    'bmi' => $triage_bmi,
                    'bp' => $triage_bp,
                    'temperature' => $triage_temperature,
                    'pulse' => $triage_pulse,
                    'rr' => $triage_rr,
                    'treatment_id' => $treatement_payment_id
                );
    
                $this->PatientsModel->update_data_where('tbl_nurse_triage', 'treatment_id', $treatement_payment_id, $newdata);
            }

            $plastic_data = array(
				'mark_iname' => $this->canvan_images($imagepath_plastic, $decryptedId, 'marks/',$plastic_up_image),
				'pl_remark' => $pl_remark,
                'chief_complaint_plas_surg'  => $chief_complaint_plas_surg,
                'subjective_plas_surg' => $subjective_plas_surg,
                'objective_plas_surg' => $objective_plas_surg,
                'assessment_plas_surg' => $assessment_plas_surg,
                // 'note' => $note,
                'treatment_payment_id' => $treatement_payment_id
			);
			

            $this->PatientsModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatement_payment_id, $treatment_payment_data);
            $this->PatientsModel->update_data_where('tbl_treat_plastic', 'treatment_payment_id', $treatement_payment_id, $plastic_data);
            $this->PatientsModel->delete_data_where('tbl_episode_payment', 'treatement_payment_id', $treatement_payment_id);

            for ($i = 0; $i < count($treatment_id); $i++) {

                $newdata = array(
                    'procedure_id' => $treatment_id[$i],
                    'episode_type' => 1,
                    // 'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'orig_price' => $fees[$i]
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
            $this->session->set_flashdata('success', 'Plastic Surgery Treatment Updated Successfully.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            exit;
        }

        $this->db->trans_complete();
    }

    public function edit($treatement_payment_id)
    {
        $decryptedId = decrypt_and_url_decode($treatement_payment_id, $this);
        $data['invoice'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $decryptedId);
        $data['episodes'] = $this->PatientsModel->get_treatment_episodes($decryptedId);
        $data['plastic'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treat_plastic', 'treatment_payment_id', $decryptedId);
     
        if(!empty($data['invoice']->log_id)){
            
           $data['tdetails'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treatment_log', 'log_id',  $data['invoice']->log_id);
           
        }
          
         
        $data['patient_id'] = $data['invoice']->patient_id;
        $data['treatment_payment_id'] = $decryptedId;
         $data['patient'] = $this->PatientsModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $data['invoice']->patient_id);

        //  print_r($data);die;

        $this->load->view('admin/Modules/PlasticSurgery/plasticSurgeryEdit', $data);
    }
}
