<?php

use phpDocumentor\Reflection\PseudoTypes\False_;

class PatientsController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Calender/CalenderModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->model('admin/Modules/GynaeRecord/GynaeRecordModel');
        $this->load->model('admin/Modules/Ophthalmology/OphthalmologyModel');

        $this->load->helper('file');
        // $this->load->library('upload');
        $this->load->library('csvimport');
        $this->load->driver('cache', array('adapter' => 'apc', 'backup' => 'file'));
      
    }


    public function index()
    {

        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        // $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
        
    }

    public function print_sticker($id)
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $result = $this->PatientsModel->get_patient_details('patient_id', $id);

       

        $this->load->view('admin/Patients/PatientSticker', $result);
    }


    public function save()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 15;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');
        $data['insurances'] = $this->PatientsModel->retrieve_data('tbl_insurance_types');
        $data['modules'] = $this->PatientsModel->retrieve_data_unique('tbl_modules', 'is_enable', 1);
        $data['companies'] = $this->PatientsModel->retrieve_data_unique('tbl_companies', 'status', 1);

        $_id = $this->input->post('_id');
        $brand_name =
            $is_active = $this->input->post('is_active');
        $item_image = $this->input->post('item_image');
        $is_new_image = $this->input->post('is_new_image');

        $data['_id'] = $_id;
        $data['first_name'] = $first_name = $this->input->post('first_name');
        $data['middle_name'] = $middle_name = $this->input->post('middle_name');
        $data['last_name'] = $last_name = $this->input->post('last_name');
        $data['qatar_id'] = $qatar_id = $this->input->post('qatar_id');
        $data['guardian_id'] = $guardian_id = $this->input->post('guardian_id');
        $data['passport_number'] = $passport_number = $this->input->post('passport_number');
        $data['dob'] = $dob = $this->input->post('dob');
        $data['nationality'] = $nationality = $this->input->post('nationality');
        $data['mobile'] = $mobile = $this->input->post('mobile');
        $data['second_mobile'] = $second_mobile = $this->input->post('second_mobile');
        $data['wa_code'] = $wa_code = $this->input->post('wa_code');
        $data['wa_mobile'] = $wa_mobile = $this->input->post('wa_mobile');
        $data['emergency_mobile'] = $emergency_mobile = $this->input->post('emergency_mobile');
        $data['email'] = $email = $this->input->post('email');
        $data['zone'] = $zone = $this->input->post('zone');
        $data['street'] = $street = $this->input->post('street');
        $data['building'] = $building = $this->input->post('building');
        $data['country'] = $country = $this->input->post('country');
        $data['insurance_type'] = $insurance_type = $this->input->post('insurance_type');
        $data['category'] = $category = $this->input->post('category');
        $data['note'] = $note = $this->input->post('note');
        $data['sex'] = $sex = $this->input->post('sex');
        $data['marital'] = $marital = $this->input->post('marital');
        $data['black'] = $black = $this->input->post('black');
        $data['company'] = $company = $this->input->post('company');
        $data['vip'] = $vip = $this->input->post('vip');
        $data['app_id'] = $app_id = $this->input->post('app_id');
        $data['app_patient_id'] = $app_patient_id = $this->input->post('app_patient_id');
        $data['discount_category'] = $discount_category = $this->input->post('discount_category');
        // $data['qid_front_image'] = $qid_front_image = $this->input->post('qid_front_image');
        $old_image = $this->input->post('image_path_val');

        //print_r($data['brand_name']);die;

        $this->form_validation->set_rules('first_name', 'First name', 'trim|required');
        $this->form_validation->set_rules('middle_name', 'Middle name', 'trim');
        $this->form_validation->set_rules('last_name', 'Last name', 'trim|required');
     //   $this->form_validation->set_rules('qatar_id', 'Qatar ID', 'trim|required|numeric|exact_length[11]|is_exists[tbl_patients,qatar_id' . ($_id > 0 ? ',patient_id,' . $_id : null) . ']');
        $this->form_validation->set_rules('dob', 'Date of Birth', 'trim|required');
        $this->form_validation->set_rules('nationality', 'Nationality', 'trim|required');
        $this->form_validation->set_rules('sex', 'Gender', 'trim|required');
        $this->form_validation->set_rules('insurance_type', 'Insurance Type', 'trim|required');
        $this->form_validation->set_rules('country', 'Country', 'trim|required');
        $this->form_validation->set_rules('company', 'Company', 'trim');
        $this->form_validation->set_rules('email', 'Email', 'trim|valid_email');

        $this->form_validation->set_rules('mobile', 'Mobile Number', 'trim|required|exact_length[8]|numeric');
        // $this->form_validation->set_rules('second_mobile', 'Second Mobile Number', 'trim|exact_length[8]|numeric');
        $this->form_validation->set_rules('emergency_mobile', 'Emergency Number', 'trim|exact_length[8]|numeric');
        // $this->form_validation->set_rules('image_path', 'Qatar ID Image', 'required');
      
            $imageFileName='';

      

        

        //qid
        $userImageBase64 = trim($this->input->post('qid_front_image_val'));
        if($userImageBase64!=''){
            $imageFileNameQid = uniqid() . '.png';

            $uploadPath = './'.UPLOAD_PATH.'patients/profile/';
    
            // Check if the directory exists, if not, create it
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }
    
            $imageFilePath = $uploadPath . $imageFileNameQid;
    
            file_put_contents($imageFilePath, file_get_contents($userImageBase64));
        }
       

        if (!empty($_FILES['image_path']['name'])) {
            $imageFileName = uniqid() . '.png';
            $uploadPath = './' . UPLOAD_PATH . 'patients/profile/';
        
            // Check if the directory exists, if not, create it
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }
        
            // Get the temporary file path
            $tmpFilePath = $_FILES['image_path']['tmp_name'];
        
            // Set the destination file path
            $imageFilePath = $uploadPath . $imageFileName;
        
            // Move the uploaded file to the destination
            move_uploaded_file($tmpFilePath, $imageFilePath);
                
            
        }else{
            // if($_id>0){
                // if(empty($old_image)){
                //     $this->form_validation->set_rules('image_path', '', 'callback_file_check');
                // }
            // }else{
            //     $this->form_validation->set_rules('image_path', '', 'callback_file_check');
            // }
          
        }


        $name = $first_name . " " . $middle_name . " " . $last_name;
        $data_save = array(
            'patient_name' => $name,
            'first_name' => $first_name,
            'middle_name' => $middle_name,
            'last_name' => $last_name,
            'qatar_id'  => $qatar_id,
            'dob' => $dob,
            'passport_number' => $passport_number,
            'patient_identifier' => '',
            'nationality' => $nationality,
            'zone' => $zone,
            'street' => $street,
            'building' => $building,
            'sex' => $sex,
            'marital' => $marital,
            'insurance_type' => $insurance_type,
            'admit_type' => '',
            'user_id' => $loginId,
            'branch' => '',
            'about_us' => '',
            'refered_dr' => '',
            'refered_friend' => '',
            'sign_board' => '',
            'social_media' => '',
            'newspaper' => '',
            'guardian_id' => $guardian_id,
            'note' => $note,
            'black' => $black,
            'company_id' => $company,
           
            'notify_birthday' => '',
            'country' => $country,
            'mobile' => $mobile,
            'second_mobile' => $second_mobile,
            'emergency_mobile' => $emergency_mobile,
            'wa_code' => $wa_code,
            'wa_mobile' => $wa_mobile,
            'email' => $email,
            'category' => $category,
            'vip' => $vip,
            'qid_front_image' =>$imageFileNameQid,
            'discount_category' =>$discount_category
        );

        if ($this->form_validation->run() == FALSE) {
            $this->load->view('admin/Patients/Patient', $data);
            return;
        }
      
        if ($_id > 0) {
             if(!empty($_FILES['image_path']['name'])){
                $data_save['profile_img']=$imageFileName;
            }
            $this->PatientsModel->update_data_where('tbl_patients', 'patient_id', $_id, $data_save);
            $this->session->set_flashdata('success', 'Patient details updated!');
        } else {
            if(!empty($_FILES['image_path']['name'])){
                $data_save['profile_img']=$imageFileName;
            }
            $data_save['registerd_date'] = curr_date();
            $data_save['registerd_time'] = curr_time();
            $patient_id = $this->PatientsModel->insert_data('tbl_patients', $data_save);
            $log_details_new = $this->prepLogArray(array('Patient Name'=>$name,'File No'=>$patient_id), 'patients');
			$this->logRecord('Patients', 'Create', $patient_id, [], $log_details_new);
            if($app_id!=''){
                $this->PatientsModel->update_data_where('tbl_appointment', 'appointment_id', $app_id, array( 'patient_id'=> $patient_id));
                $this->PatientsModel->update_data_where('tbl_appointment_patient_info', 'app_patient_id', $app_patient_id, array( 'patient_id'=> $patient_id));
            }
            $this->session->set_flashdata('success', 'Patient has been created!');
        }
        $this->output->delete_cache('admin/Patients/PatientsController');
        redirect('admin/Patients/PatientsController', 'refresh');
    }
    public function file_check($str)
    {
        $allowed_mime_type_arr = array('application/pdf','image/gif','image/jpeg','image/pjpeg','image/png','image/x-png');
        $mime = get_mime_by_extension($_FILES['file']['name']);
        if(isset($_FILES['file']['name']) && $_FILES['file']['name']!=""){
            if(in_array($mime, $allowed_mime_type_arr)){
                return true;
            }else{
                $this->form_validation->set_message('file_check', 'Please select only pdf/gif/jpg/png file.');
                return false;
            }
        }else{
            $this->form_validation->set_message('file_check', 'Please choose a file to upload.');
            return false;
        }
    }

    public function createNew()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');
        $data['insurances'] = $this->PatientsModel->retrieve_data('tbl_insurance_types');
        $data['modules'] = $this->PatientsModel->retrieve_data_unique('tbl_modules', 'is_enable', 1);
        $data['companies'] = $this->PatientsModel->retrieve_data_unique('tbl_companies', 'status', 1);
        $data['discount_categories'] = $this->PatientsModel->retrieve_data('discount_category');

        $_id = 0;
        $data['_id'] = $_id;
        $data['first_name'] = '';
        $data['middle_name'] = '';
        $data['last_name'] = '';
        $data['qatar_id'] = '';
        $data['guardian_id'] = '';
        $data['passport_number'] = '';
        $data['dob'] = '';
        $data['nationality'] = '';
        $data['mobile'] = '';
        $data['second_mobile'] = '';
        $data['emergency_mobile'] = '';
        $data['email'] = '';
        $data['zone'] = '';
        $data['street'] = '';
        $data['building'] = '';
        $data['country'] = '';
        $data['insurance_type'] = '';
        $data['category'] = '';
        $data['note'] = '';
        $data['sex'] = '';
        $data['black'] = '';
        $data['vip'] = '';
        $data['app_id'] = '';
        
        $this->load->view('admin/Patients/Patient', $data);
    }

    public function edit($_id)
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 15;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');
        $data['insurances'] = $this->PatientsModel->retrieve_data('tbl_insurance_types');
        $data['modules'] = $this->PatientsModel->retrieve_data_unique('tbl_modules', 'is_enable', 1);
        $data['companies'] = $this->PatientsModel->retrieve_data_unique('tbl_companies', 'status', 1);
        $data['discount_categories'] = $this->PatientsModel->retrieve_data('discount_category');

        $_id = decrypt_and_url_decode($_id, $this);
        $data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');

        $result = $this->PatientsModel->retrieve_data_unique('tbl_patients', 'patient_id', $_id);
        foreach ($result[0] as $key => $value) {
            $data[$key] = $value;
        }
        $data['_id'] = $_id;

        $this->load->view('admin/Patients/Patient', $data);
    }

    public function view($patient_id)
    {
        try {
            $decryptedId = decrypt_and_url_decode($patient_id, $this);

            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;

            $result = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);
            $result->visits = $this->PatientsModel->getTreatmentList('', '', $decryptedId, 1, 0);
            $result->triage = $this->PatientsModel->retrieve_data_unique_fields_order('tbl_nurse_triage', "*", 'patient_id', $decryptedId, 'triage_id', 'desc');

            $result->documents = $this->PatientsModel->get_patient_documents($decryptedId);

            $this->load->view('admin/Patients/PatientView', $result);
        } catch (Exception $e) {
            echo $e;
            exit;
        }
    }

    public function medical_book($patient_id, $data = null)
    {
       
        try {
            $decryptedId = decrypt_and_url_decode($patient_id, $this);
            // print_r($patient_id);die;

            $result['active_menu'] = 15;
            $result['active_submenu'] = 1;
            $loginId = $this->session->userdata('user_Id');
            $result = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);
          
            $totals = $this->calculate_totals($decryptedId);
            $result->total = $totals['balance'];
            $result->total_advance = $totals['total_advance'];
            $result->doctor_module = $this->PatientsModel->get_logged_doctor($loginId);
            $result->triage = $this->PatientsModel->retrieve_data_unique_fields_order('tbl_nurse_triage', "*", 'patient_id', $decryptedId, 'triage_id', 'desc');
            $result->modules =  $this->PatientsModel->getModules();
         
            $result->departments = $this->PatientsModel->get_modules_by_user($result->doctor_module->department);
            $result->user_packages = $this->PatientsModel->getUserPackages($decryptedId);
              
            //remove packae 
            foreach ($result->user_packages as $package) {
                // Convert the start_date to a DateTime object
                if($package['is_limited']==1){

               
                $startDate = new DateTime($package['start_date']);
                // Get the current date
                $currentDate = new DateTime();
                // Calculate the remaining days
                $remainingDays = $package['days'] - $currentDate->diff($startDate)->days;
        
                // If remaining days are 0 or less, remove the package
                if ($remainingDays <= 0) {
                    // Call a method to remove the package from the database
                    $this->PatientsModel->removePackage($decryptedId, $package['id']);
                }
            }
            }
            //
            $extra_modules = $this->PatientsModel->retrieve_data('general_settings');
         
            $result->is_package=0;
            $result->is_refferal=0;
    
            foreach($extra_modules as $module){
                
                if($module['type']== 'package' && $module['name']== 'is_enable' && $module['value']== '1'  ){
                    $result->is_package =1;
                }
                if($module['type']== 'referal' && $module['name']== 'is_enable' && $module['value']== '1'){
                    $result->is_refferal=1;
                }
              }

          
            $data['palnofcare'] = $this->PatientsModel->get_planofcare($decryptedId);
            $result->history =  $this->PatientsModel->getPatientHistory($decryptedId);
            // $daa =  $this->PatientsModel->getPatientHistory($decryptedId);
          
            if ($result->insurance_type == 3) {
                $qlm = new Qlm();
                $result->ic = (array)json_decode($qlm->validateInsurance($result->qatar_id, $result->member_id));
            }
         

            $this->load->view('admin/Patients/PatientMedical', $result);
        } catch (Exception $e) {
            echo $e;
            exit;
        }
    }
    
    public function getPatientSummery(){
        $patient_id = $this->input->get('patient_id');
        $period = $this->input->get('period');
        $result = $this->PatientsModel->getPatientSummary($patient_id, $period);
        
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($result));
    }

    public function appeal_qlm()
    {
        $reference_no = $this->input->post('pa_reference_no');
        $appeal_type = $this->input->post('qlm_status');
        $appeal_remark = $this->input->post('qlm_remark');
        $justification = $this->input->post('justification');

        $qlm = new Qlm();
        $qlm->appeal_qlm($reference_no, $appeal_type, $appeal_remark, $justification);
    }

    public function print_quotation($id, $patient_id)
    {


        $data['title'] = 'Patient Profile::: Hospital Managemnt Software';
        $data['page_header'] = 'Print Quotation';
        $data['clinic_info'] = $this->PatientsModel->get_row('tbl_company');
        $data['planofdata_main'] = $this->PatientsModel->get_row_data('tbl_planofcare_main', 'planofcare_main_id', $id);
        $data['planofdata'] = $this->PatientsModel->patient_a_planofcare($id);
        $data['profile'] = $this->PatientsModel->get_profile_main($patient_id);
        $data['insurance_details'] = $this->PatientsModel->get_insurance($patient_id);
        $data['patient_id'] = $patient_id;
        $data['plancare_id'] = $id;

        if ($this->session->userdata('permission') == 2) {
            $get_doctor_id = $this->PatientsModel->get_row_data('doctors', 'employee_id', $this->session->userdata('emp_id'));
            $data['doctor_id'] = $get_doctor_id->doctor_id;
        } else {
            $data['doctor_id'] = '0';
        }

        $this->load->view('admin/Modules/Qlm/print_quotation', $data);
    }

    /**
     * Patient documet upload : Start
     */

    public function uploadPatientDocuments()
    {
        if ($this->input->method() === 'get') {
            redirect('admin/Patients/PatientsController', 'index');
        }

        $this->load->library('upload');

        $config['upload_path'] = './'.UPLOAD_PATH.'patients/';
        $config['allowed_types'] = 'pdf|doc|docx|png|jpeg|gif|xlsx|csv|txt';
        $config['max_size'] = 2048; // 2MB limit

        $patient_id = $this->input->post('patientId');
        $document_name = $this->input->post('documentName');
        $redirect_to = $this->input->post('redirect_to');

        // Check download folder exists
        if (!is_dir($config['upload_path'])) {
            mkdir('./'.UPLOAD_PATH.'');
        }

        // Check patient directory exists
        $patientFolder = $config['upload_path'] . '/documents';
        if (!is_dir($patientFolder)) {
            mkdir($patientFolder);
        }

        $this->upload->initialize($config);
        $this->form_validation->set_rules('patientDocument', 'File', 'callback_file_upload');
        $this->form_validation->set_rules('documentName', 'Document Name', 'required');

        if ($this->form_validation->run() == FALSE) {
            $this->view($patient_id);
            return;
        } else {
            $file_data = $this->upload->data();

            $new_filename = $this->rename_file($file_data['file_name']);
            rename($file_data['full_path'], $patientFolder . '/' . $new_filename);

            $this->insert_file_into_database(decrypt_and_url_decode($patient_id, $this), $document_name, $new_filename);

            $this->session->set_flashdata('success', 'Document uploaded.');
            redirect(!empty($redirect_to) ? $redirect_to : 'admin/Patients/PatientsController/view/' . ($patient_id));
        }
    }
    public function uploadPatientDocs()
    {
        if ($this->input->method() === 'get') {
            redirect('admin/Patients/PatientsController', 'index');
        }

        $this->load->library('upload');

        // Set up the upload configuration
        $config['upload_path'] = './' . UPLOAD_PATH . 'patients/';
        $config['allowed_types'] = 'pdf|doc|docx|png|jpeg|gif|xlsx|csv|txt';
        $config['max_size'] = 2048; // 2MB limit
        
        $patient_id = $this->input->post('patientId');
        $document_name = $this->input->post('documentName');
        $redirect_to = $this->input->post('redirect_to');
        
        // Check if the main upload folder exists
        if (!is_dir($config['upload_path'])) {
            mkdir($config['upload_path'], 0777, true);
        }
        
        // Generate the patient's folder name based on the decrypted patient ID
        $patientFolder = $config['upload_path'] . '/documents/';
        
        // Check if the patient's folder exists, if not, create it
        if (!is_dir($patientFolder)) {
            mkdir($patientFolder, 0777, true);
        }
        
        // Update the upload path to the patient's specific folder
        $config['upload_path'] = $patientFolder;
        
        // Initialize the upload library with the updated configuration
        $this->upload->initialize($config);
        
        // Attempt to upload the file
        if (!$this->upload->do_upload('patientDocument')) { // 'userfile' should be the name attribute of your file input field in the form
            // If the upload failed, set an error message
            $this->session->set_flashdata('error', $this->upload->display_errors());
            redirect(!empty($redirect_to) ? $redirect_to : 'admin/Patients/PatientsController/medical_book/' . ($patient_id));
        } else {
            // If the upload succeeded, get the uploaded file data
            $file_data = $this->upload->data();
        
            // Rename the uploaded file
            $new_filename = $this->rename_file($file_data['file_name']);
            rename($file_data['full_path'], $patientFolder . '/' . $new_filename);
        
            // Insert the file record into the database
            $this->insert_file_into_database(decrypt_and_url_decode($patient_id, $this), $document_name, $new_filename);
        
            // Set a success message and redirect
            $this->session->set_flashdata('success', 'Document uploaded.');
            redirect(!empty($redirect_to) ? $redirect_to : 'admin/Patients/PatientsController/medical_book/' . ($patient_id));
        }
        
    }


    public function file_upload($str)
    {
        if (!$this->upload->do_upload('patientDocument')) {
            $this->form_validation->set_message('file_upload', $this->upload->display_errors());
            return FALSE;
        } else {
            return TRUE;
        }
    }

    private function rename_file($filename)
    {
        $timestamp = time();
        $random_string = random_string('alnum', 8);
        $extension = pathinfo($filename, PATHINFO_EXTENSION);
        return "{$timestamp}_{$random_string}.{$extension}";
    }

    private function insert_file_into_database($patient_id, $name, $new_filename)
    {
        $this->PatientsModel->insert_patient_document_details([
            'patient_id' => $patient_id,
            'name' => $name,
            'document' => $new_filename
        ]);
    }

    public function downloadFile($patientId, $document)
    {
        
        $uploadPath = './'.UPLOAD_PATH.'patients/documents/';
        $filePath = $uploadPath . '/' . $document;
        $this->load->helper('download');
        force_download($filePath, NULL);
    }
   

    public function viewFile($patientId, $document)
    {
       
        $uploadPath = './'.UPLOAD_PATH.'patients/documents/';
        $filePath = $uploadPath . '/' . $document;
        $fileUrl = $filePath;
        echo base_url($filePath);
    }
    public function deleteFile($id)
{
    // Get the file data from the database
    $fileData = $this->db->get_where('tbl_patient_attachments', ['id' => $id])->row();

    if ($fileData) {
        $patientId = $fileData->patient_id; // Assuming patient_id is stored in the table
        $document = $fileData->document; // Assuming file_name is the column storing the filename

        // Build the file path
        $uploadPath = './' . UPLOAD_PATH . 'patients/documents';
        $filePath = $uploadPath . '/' . $document;

        // Check if the file exists
        if (file_exists($filePath)) {
            // Delete the file from the file system
            unlink($filePath);
        }

        // Delete the database record
        $this->db->where('id', $id);
        $this->db->delete('tbl_patient_attachments');

        // Set success message
        $this->session->set_flashdata('success', 'Document deleted successfully.');
    } else {
        // Set error message if file data is not found
        $this->session->set_flashdata('error', 'Document not found.');
    }

    // Redirect to the medical book page
    redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patientId,$this) );
}

    public function get_patient()
    {
        $result = $this->PatientsModel->get_patient_by_details();
        $data = array();
        foreach ($result->result_array() as $row) {
            array_push($data, array(
                'id' => $row['patient_id'] . ' - ' . $row['patient_name'] . ' - ' . $row['mobile'] . ' - ' . $row['backup_id'] . ' - ' . $row['qatar_id'],
                'name' =>  $row['patient_id'] . ' - ' . $row['patient_name'] . ' - ' . $row['mobile'] . ' - ' . $row['backup_id'] . ' - ' . $row['qatar_id']
            ));
        }
        echo json_encode($data);
    }
    public function get_patient_qid()
    {
        $result = $this->PatientsModel->get_patient_by_details();
        $data = array();
        foreach ($result->result_array() as $row) {
            array_push($data, array(
                'patient_id' => $row['patient_id'],
                'full_name' => $row['patient_name'],
                'fname' => $row['first_name'],
                'mname' => $row['middle_name'],
                'lname' => $row['last_name'],
                'nationality' => $row['nationality'],
                'dob' => $row['dob'],
                'sex' => $row['sex'],
                
                'mobile' => $row['mobile'],
                'backup_id' => $row['backup_id'],
                'name' => $row['qatar_id']
            ));
        }
        echo json_encode($data);
    }
    public function get_patient_fileno()
    {
        $result = $this->PatientsModel->get_patient_by_details();
        $data = array();
        foreach ($result->result_array() as $row) {
            array_push($data, array(
                'patient_id' => $row['patient_id'],
                'full_name' => $row['patient_name'],
                'fname' => $row['first_name'],
                'mname' => $row['middle_name'],
                'lname' => $row['last_name'],
                'nationality' => $row['nationality'],
                'dob' => $row['dob'],
                'sex' => $row['sex'],
                
                'mobile' => $row['mobile'],
                'backup_id' => $row['backup_id'],
                'name' => $row['qatar_id']
            ));
        }
        echo json_encode($data);
    }
    

    /**
     * Patient document upload : End
     */

    public function delete($id)
    {
        $this->output->delete_cache('admin/Patients/PatientsController');
        $patientId = decrypt_and_url_decode($id, $this);
        $this->PatientsModel->delete_patient($patientId);
       
        $this->session->set_flashdata('success', 'Patient deleted successfully.');
        redirect('admin/Patients/PatientsController', 'index');
    }

    public function get_treatment_list()
    {
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $patient_id = decrypt_and_url_decode($this->input->get('patient_id'), $this);
        $module_id = $this->input->get('module_id');

        $records = $this->PatientsModel->getTreatmentList($search, $module_id, $patient_id, $length, $start);
        foreach ($records as $key => $row) {
            $row->treatement_pay_id = encrypt_and_url_encode($row->treatement_payment_id, $this);
            $records[$key] = $row;
        }
        $total_records = count($records); // Get total records


        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function get_patients_list()
    {
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];
 $patient_mobile = $this->input->get('patient_mobile');
        $patient_file = $this->input->get('patient_file');
        $patient_qid = $this->input->get('patient_qid');
        $patient_name = $this->input->get('patient_name');
        $records = $this->PatientsModel->getPatientsList($search, $length, $start, $order_column, $order,$patient_mobile,$patient_file,$patient_qid,$patient_name);
      
        foreach ($records as $key => $row) {
            $row->patient_id = encrypt_and_url_encode($row->patient_id, $this);
            $records[$key] = $row;
        }

        $allrecords = $this->PatientsModel->getPatientsListSelect();

        $total_records = count($allrecords); // Get total records

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
    public function getpatients(){
        $records = $this->PatientsModel->getPatientsListSelect();

        echo json_encode($records);
    }
    public function patientStatement($patient_id)
    {
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;

        $patient_id = decrypt_and_url_decode($patient_id, $this);

        $data['patient'] = $this->PatientsModel->get_patient_details('patient_id', $patient_id);
        $data['paid_invoices'] = $this->PaymentsModel->paidInvoices($patient_id);
        $data['receipts'] = $this->PaymentsModel->getReceipts($patient_id);
        $data['advances'] = $this->PaymentsModel->getAdvanceReceipts($patient_id);
        $data = array_merge($data, $this->calculate_totals($patient_id));
        // Get invoices
        // Get patid list of treatments


        $this->load->view('admin/Patients/PatientStatement', $data);
    }

    public function savePatientMedicalBook()
    {
        $data = $this->input->post();
        $id = decrypt_and_url_decode($data['patient_id'], $this);
        $data['save_date'] = date('Y-m-d');
       
        $old_image = $this->input->post('old_signature');
        if(empty($data['patient_signature'])){
            if(!empty($old_image)){
                $data['patient_signature']=$old_image;  
              }
        }
      
        unset($data['old_signature']);
        // Check record exists or not
        if (empty($this->PatientsModel->getPatientHistory($id)->patient_id)) {
            $data['patient_id'] = $id;
            $this->PatientsModel->savePatientMedicalBook($data);
        } else {
            unset($data['patient_id']);
            $this->PatientsModel->updatePatientMedicalBook($data, $id);
        }

        $this->session->set_flashdata('success', 'Patient history saved.');
        redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($id, $this));
    }
    public function planeofcare_edit($pid, $id)
    {


        $data['title'] = 'Patient Profile::: Hospital Managemnt Software';
        $data['page_header'] = 'Treatment Plan';
        $data['treat_list'] = $this->PatientsModel->get_patient_tret();
        $data['patient_id'] = $pid;
        $data['profile'] = $this->PatientsModel->get_profile_main($pid);
        $data['doctor_list'] = $this->PatientsModel->get_doctors();
        $data['private_category'] = $this->PatientsModel->retrieve_data('tbl_treatment_category');
        $data['planofcare_sub'] = $this->PatientsModel->get_planofcare_treats($id);
        $data['planofcare_main'] = $this->PatientsModel->retrieve_data_unique('tbl_planofcare_main', 'planofcare_main_id', $id);

        // $data['treatment_list'] = $this->doctor_retrive->retrieve_data_order('p_treatment_price', 'p_treatment_id', 'ASC');
        // $data['axa_treatment_list'] = $this->doctor_retrive->retrieve_data_order('p_axa_price', 'p_axa_treatment_id', 'ASC');
        // $data['qlm_treatment_list'] = $this->doctor_retrive->retrieve_data_order('qlm_price_list', 'qlm_code', 'ASC');
        // $data['alkoot_treatment_list_dental'] = $this->doctor_retrive->retrieve_data_unique('p_alkoot_price', 'p_treatment_category', '1 ORDER BY p_alkoot_treatment_id ASC');
        // $data['alkoot_treatment_list_derma'] = $this->doctor_retrive->retrieve_data_unique('p_alkoot_price', 'p_treatment_category', '2 ORDER BY p_alkoot_treatment_id ASC');

        $last_exam = $this->PatientsModel->get_last_exam($pid);
        if ($last_exam) {
            $data['full_tooth'] = $last_exam->full_tooth;
        } else {
            $data['full_tooth'] = "";
        }

        if ($data['profile'][0]['insurance_type'] == 8) {
            $qlm = new Qlm();
            $data['ic'] = json_decode($qlm->validate_insurance($data['profile'][0]['qatar_id'], $data['profile'][0]['member_id']), true);
        }

        $data['insurance_id'] =  $data['profile'][0]['insurance_type'];


        $this->load->view('admin/Patients/PlanofcareEdit', $data);
    }

    public function edit_planeofcare()
    {

        $data['title'] = 'Patient Profile::: Hospital Managemnt Software';
        $data['page_header'] = 'Treatment Plan';

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");
        $split_time = explode(':', $curr_time);

        $plan_teeth = $this->input->post('plan_teeth');
        $plan_clinical_finding = $this->input->post('plan_clinical_finding');
        $plan_procedure = $this->input->post('plan_procedure');
        $plan_doctor = $this->input->post('plan_doctor');
        $patient_id = $this->input->post('patient_id');
        $full_teeth = $this->input->post('full_teeth');
        $discount = $this->input->post('discount');
        $discount_per = $this->input->post('discount_per');
        $teeth_price = $this->input->post('teeth_price');
        $patient_qid = $this->input->post('patient_qid');
        $member_id = $this->input->post('member_id');
        $p_category = $this->input->post('p_category');
        $p_category = (int)$p_category;
        $plan_diag = $this->input->post('plan_diag');
        $dia_id = $this->input->post('dia_id');
        $chief_complain = $this->input->post('illness_details');
        $medical_history = $this->input->post('medical_history');
        $line_of_management = $this->input->post('line_of_management');
        $illness = $this->input->post('illness');
        $priority = $this->input->post('priority');
        $plan_diag_full = $this->input->post('plan_diag_full');
        $pregnant = $this->input->post('pregnant');
        $lmp_date = $this->input->post('lmp_date');
        $insurance_id = $this->input->post('insurance_id');
        $patient_diagnostise = '';
        $preapproval = array();
        $planofcare_main_id = $this->input->post('planofcare_main_id');
        $pa_referance = $this->input->post('pa_referance');
        $proceed = $this->input->post('proceed');

        if (!empty($dia)) {
            $patient_diagnostise = implode(',', $dia_id);
        }

        $files = !empty($_FILES['xray']) ? $_FILES['xray'] : '';
        $data['private_category'] = $this->PatientsModel->retrieve_data('tbl_treatment_category');
        $last_exam = $this->PatientsModel->get_last_exam($patient_id);
        if ($last_exam) {
            $data['full_tooth'] = $last_exam->full_tooth;
        } else {
            $data['full_tooth'] = "";
        }

        $data['patient_id'] = $patient_id;

        if ($this->session->userdata('permission') == 2) {

            $get_doctor_id = $this->PatientsModel->get_row_data('doctors', 'employee_id', $this->session->userdata('emp_id'));
            $doctor_id = $get_doctor_id->doctor_id;
            $inpt = $this->input->post();
            $inpt['doctor_id'] = $get_doctor_id->license_no;

            if ($insurance_id == 3) {
                $qlm = new Qlm();
                $preapproval = $qlm->resubmit_pre_approval($inpt, $planofcare_main_id);
                $preapproval = json_decode($preapproval);

                $newdata = array(
                    'qlm_status' => !empty($preapproval->messageType) ? $preapproval->messageType : '',
                    'qlm_message' => !empty($preapproval->message) ? $preapproval->message : '',
                    'pa_reference_no' => !empty($preapproval->PAreferenceNo) ? $preapproval->PAreferenceNo : '',
                    'visit_no' => !empty($eligibility->visitNo) ? $eligibility->visitNo : '',
                    'insurance_id' => 3
                );

                $this->PatientsModel->update_data('planofcare_main', 'planofcare_main_id', $planofcare_main_id, $newdata);
            }

            $data['alert_msg'] = '';
            $data['error'] = '';
            $data['success'] = 'Treatment Plans have added successfully';
            $data['doctor_list'] = $this->PatientsModel->get_doctors();
            //$this->load->view('planofcare_add', $data);

        }
        $this->session->set_flashdata('success', 'Insurance Reappeal saved.');
        redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this));
    }

    public function import()
    {
        $config['upload_path']   = './'.UPLOAD_PATH.'csv/';
        $config['allowed_types'] = 'csv';
        $config['max_size']      = 1024;

        if (!is_dir('./'.UPLOAD_PATH.'')) {
            mkdir('./'.UPLOAD_PATH.'');
        }

        if (!is_dir($config['upload_path'])) {
            mkdir($config['upload_path']);
        }

        $this->load->library('upload', $config);
        $ignored_txt = "<div class='bg-light rounded p-2' style='width: fit-content;'><br><span class='text-danger'>Ignored the following patients due to database existence</span> : <br> <ol class='text-dark'>";
        $ignored = FALSE;
        try {
            if (!$this->upload->do_upload('csv_file')) {
                $error = array('error' => $this->upload->display_errors());
                $this->session->set_flashdata('errors', 'Failed to Import CSV Data.');
            } else {
                $file_data = $this->upload->data();
                $file_path = $config['upload_path'] . $file_data['file_name'];

                $column_headers = array(); // Provide alternate column headers if needed

                $data['csvData'] = $this->csvimport->get_array($file_path, $column_headers);

                foreach ($data['csvData'] as $row) {
                    // Check if qatar_id exists before inserting
                    $existingRecord = $this->db->get_where('tbl_patients', array('qatar_id' => $row['qatar_id'], 'mobile' => $row['mobile']))->row();

                    if (!$existingRecord) {
                        $this->db->insert('tbl_patients', $row);
                    } else {
                        // Handle the case when qatar_id already exists (ignore or update as needed)
                        $ignored = TRUE;
                        $ignored_txt .= `<li>QID: {$row['qatar_id']} | Name: {$row['patient_name']}</li>`;
                    }
                }

                $ignored_txt .= '</ol></div>';
                $ignored_txt = !$ignored ? null : $ignored_txt;
                $this->session->set_flashdata('success', "CSV Data Imported Successfully. {$ignored_txt}");
            }
            redirect(base_url('index.php/admin/Patients/PatientsController/index'));
        } catch (Exception $e) {
            $this->session->set_flashdata('errors', 'Critical Error: Failed to Import CSV Data.');
        }
    }

    public function saveTriage()
    {

        $user_id = decrypt_and_url_decode($this->session->userdata('user_Id'), $this);
        $patient_id = decrypt_and_url_decode($this->input->post('patient_id'), $this);
        $traige_id = decrypt_and_url_decode($this->input->post('traige_id'), $this);

        $triage_weight = $this->input->post('triage_weight');
        $triage_height = $this->input->post('triage_height');
        $triage_bmi = $this->input->post('triage_bmi');
        $triage_bp = $this->input->post('triage_bp');
        $triage_temperature = $this->input->post('triage_temperature');
        $triage_pulse = $this->input->post('triage_pulse');
        $triage_rr = $this->input->post('triage_rr');
        $triage_notes = $this->input->post('triage_notes');

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");

        $newdata = array(
            'patient_id' => $patient_id,
            'create_date' => $curr_date,
            'create_by' => $user_id,
            'weight' => $triage_weight,
            'height' => $triage_height,
            'bmi' => $triage_bmi,
            'bp' => $triage_bp,
            'temperature' => $triage_temperature,
            'pulse' => $triage_pulse,
            'rr' => $triage_rr,
            'notes' => $triage_notes,
        );

        if ($traige_id != "") {
            $this->session->set_flashdata('success', 'Patient Triage Updated!');
            $this->PaymentsModel->update_data_where('tbl_nurse_triage', 'triage_id', $traige_id, $newdata);
        } else {
            $this->session->set_flashdata('success', 'Patient Triage Saved!');
            $this->PaymentsModel->insert_data('tbl_nurse_triage', $newdata);
        }

        redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this));
    }

    public function RegisterPatient($app_id){

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');
        $data['insurances'] = $this->PatientsModel->retrieve_data('tbl_insurance_types');
        $data['modules'] = $this->PatientsModel->retrieve_data_unique('tbl_modules', 'is_enable', 1);
        $app_info = $this->CalenderModel->get_app_details($app_id);
        $data['companies'] = $this->PatientsModel->retrieve_data_unique('tbl_companies', 'status', 1);


        $_id = 0;
        $data['_id'] = $_id;
        $data['first_name'] = $app_info->app_patient_name;;
        $data['middle_name'] = '';
        $data['last_name'] = '';
        $data['qatar_id'] = $app_info->app_patient_qatar_id;;
        $data['guardian_id'] = '';
        $data['passport_number'] = '';
        $data['dob'] = '';
        $data['nationality'] = '';
        $data['mobile'] = $app_info->app_patient_contact;
        $data['second_mobile'] =  '+'.$app_info->wa_code.$app_info->wa_mobile;
        $data['emergency_mobile'] = '';
        $data['email'] = '';
        $data['zone'] = '';
        $data['street'] = '';
        $data['building'] = '';
        $data['country'] = '';
        $data['insurance_type'] = '';
        $data['category'] = '';
        $data['note'] = '';
        $data['sex'] = '';
        $data['black'] = '';
        $data['vip'] = '';
        $data['app_id'] = $app_info->appointment_id;
        $data['app_patient_id'] = $app_info->app_patient_id;
        

        $this->load->view('admin/Patients/Patient', $data);
    }

    public function get_refferals()
    {
        $loginId = $this->session->userdata('user_Id');
       
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $patient_id = decrypt_and_url_decode($this->input->post('patient_id'), $this);
        $module_id = $this->input->get('module_id');

        $records = $this->PatientsModel->getRefferal( $patient_id, $loginId);
      
        $total_records = count($records); // Get total records


        $response = array(
           
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
    public function  view_refferal_details($id){

        $referal_info = $this->PatientsModel->getRefferalDetails($id);
        $referal_discussion = $this->PatientsModel->getRefferalDiscussion($id);
      
        $data = array(
            'discussion'=>$referal_discussion,
            'referral'=>$referal_info,
            'doctors'=>$this->PatientsModel->getDoctors()
        );
      
        $this->load->view('admin/Modules/Refferal/Details.php', $data);

    }

    public function add_comment()
    {
        $loginId = $this->session->userdata('user_Id');

                    // File upload configuration
                $config['upload_path'] = './uploads/discussion/';
                $config['allowed_types'] = 'gif|jpg|png|pdf|doc|docx';
                $config['max_size'] = 2048; // Max size in KB (2MB)
                $fileName=null;
                $this->load->library('upload', $config);

                if ($this->upload->do_upload('attachment')) {
                    $fileData = $this->upload->data();
                    $fileName = $fileData['file_name'];
                    // Save comment and file name to database
                } else {
                    $error = $this->upload->display_errors();
                    // Handle the error, possibly return an error message
                }
        $data = [
            
            'refferal_id' => $this->input->post('reffer_item_id'),
            'user_id' =>  $loginId , // Assuming user_id is stored in session
            'comment' => $this->input->post('comment'),
            'atttachment' => $fileName,
            'created_at' => date('Y-m-d H:i:s')
        ];

        $ref_id= $this->input->post('reffer_item_id');
       

       $refferd= $this->PatientsModel->retrieve_data_unique('referred_item_doctors','refferal_id',$ref_id);
        
       if($refferd){
      
       foreach($refferd as $doctor){
        
        $sent_by= getLoginUser($this)->full_name;
        $notification= array(
            'url'=>'admin/Patients/PatientsController/view_refferal_details/'.$ref_id,
            'message'=>'Posted a Comment in Refferal Disccussion',
            'sent_by'=>$sent_by,
        );
        $this->createNotification($doctor['doctor_id'],$notification);
       }
    }
       
    
        $this->db->insert('refferal_discussion', $data);
        redirect('admin/Patients/PatientsController/view_refferal_details/' . $data['refferal_id']);
    }


    
    public function createNotification($doctor_id, $notification){

        $notification = json_encode($notification);
    $data= array(
        'type'=>'Notification',
        'user_id'=>$doctor_id,
        'response'=>$notification,
    );

    $this->db->insert('tbl_notifications', $data);

}

public function get_user_package(){

  $patient_id = $this->input->post('patient_id');
  $module_id = $this->input->post('module_id');
    $user_packages = $this->PatientsModel->getUserPackages($patient_id);

    if(count($user_packages)>0){ 
        
       
        $has_module = false;
        foreach($user_packages as $item) {
            foreach($item['modules'] as $module) {
                if($module['department_id'] == $module_id) {
                     // Replace $desired_module_id with the module ID you want to check
                     $remaining_session = isset($module['sessions'], $module['attended_sessions']) 
                     ? (int)$module['sessions'] - (int)$module['attended_sessions'] 
                     : (int)$module['sessions'];
                     if($remaining_session <=0){
                        $has_module = false;
                    break 2;
                     }

                    $has_module = true;
                    break 2; // Break both loops if the module is found
                }
            }
        }
    }


    echo json_encode(['has_module' => $has_module]);
}


public function load_module_view() {
   
    $view_path = $this->input->post('view_path');
    $key = $this->input->post('key');
    $loginId = $this->session->userdata('user_Id');
    $patient_id = $this->input->post('patient_id');
    
    // Pass any additional data as needed
    $data = array(
        'discount_limit' => $this->input->post('discount_limit'),
        'patient_id'=>$patient_id,
    );

    if($view_path == 'admin/Modules/Treatments/treatments.php'){
        
        $doctor_module = $this->PatientsModel->get_logged_doctor($loginId);
        $data['doctor_module'] = $doctor_module;
        
      
    $data['departments'] = $this->PatientsModel->get_modules_by_user($doctor_module->department);
        $data['tooth_treat'] = $this->PatientsModel->retrieve_data('tbl_tooth_treat');
        $data['patient_id'] = $decryptedId;
       
        
        $data['doctors'] = $this->PatientsModel->getDoctors();
        $data['prices'] = $this->PatientsModel->getPrices($doctor_module->insurance_type);
    
        $data->nurses = $this->PatientsModel->get_nurses();
        $data['rooms'] = $this->PatientsModel->retrieve_data_unique('tbl_rooms', 'status', '0');
        $data['ophthalmology_procedures'] = $this->OphthalmologyModel->getTreatmentList($doctor_module->insurance_type, 9);
        $data['treatment_categories'] = $this->PatientsModel->getTreatmentCategories();
        $data['patient_id'] = $patient_id;
       
       
    }
    if($view_path == 'admin/Modules/Treatments/treatmentPlan.php'){
        
        $doctor_module = $this->PatientsModel->get_logged_doctor($loginId);
        $data['doctor_module'] = $doctor_module;
        
      
    $data['departments'] = $this->PatientsModel->get_modules_by_user($doctor_module->department);
        $data['tooth_treat'] = $this->PatientsModel->retrieve_data('tbl_tooth_treat');
        $data['patient_id'] = $decryptedId;
       
        
        $data['doctors'] = $this->PatientsModel->getDoctors();
        $data['prices'] = $this->PatientsModel->getPrices($doctor_module->insurance_type);
    
        $data->nurses = $this->PatientsModel->get_nurses();
        $data['rooms'] = $this->PatientsModel->retrieve_data_unique('tbl_rooms', 'status', '0');
        $data['ophthalmology_procedures'] = $this->OphthalmologyModel->getTreatmentList($doctor_module->insurance_type, 9);
        $data['treatment_categories'] = $this->PatientsModel->getTreatmentCategories();
        $data['patient_id'] = $patient_id;
       
       
    }
    if($view_path == 'admin/Modules/Documents/documents.php'){
        $data['documents'] = $this->PatientsModel->get_patient_documents($patient_id);
         $data['consentForms'] = $this->PatientsModel->get_patient_consents($patient_id);
    }
    if($view_path == 'admin/Modules/Packages/Packages.php'){
        $data['packages'] = $this->PatientsModel->getPackages();
        $data['user_packages'] = $this->PatientsModel->getUserPackages($patient_id);
    }
    if($view_path == 'admin/Modules/Triage/triage.php'){
        $data['triage'] = $this->PatientsModel->retrieve_data_unique_fields_order('tbl_nurse_triage', "*", 'patient_id', $patient_id, 'triage_id', 'desc');
    }
    if($view_path == 'admin/Modules/Refferal/Refferal.php'){
        
        $data['doctors'] = $this->PatientsModel->getDoctors();
    }
    if($view_path == 'admin/Modules/History/history.php'){
        
        $data['history'] = $this->PatientsModel->getPatientHistory($patient_id);
    }

  
    // Check if the file exists
    $file_path = APPPATH . 'views/' . $view_path;
    if (file_exists($file_path)) {
       
        $this->load->view($view_path, $data);
    } else {
        echo "File does not exist. (" . $file_path . ")";
    }
}

public function load_single_module(){
    $department_id = $this->input->post('department_id');
    $patient_id = $this->input->post('patient_id');
    $type = $this->input->post('m_type');
    
    // Get the module's view path based on the department ID
    $module = $this->PatientsModel->get_module_by_department_id($department_id);
    $data = array(
        'patient_id'=>$patient_id
    ); 
    if ($module && $module['is_module'] == 1) {
        if($type =='treatment'){
            $view_path = $module['module_view_path']; 
        }else{
            $view_path = $module['paln_view_path']; 
           
        }
       // Retrieve the view path dynamically
        
        

        // Check if the view file exists and load it
        $file_path = APPPATH . 'views/' . $view_path;
        if (file_exists($file_path)) {
        if (!$view_cache = $this->cache->get($module['module_name'].'_'.$type. $module['department_id'])) {
            // Render and cache the view
            $view_content = $this->load->view($view_path, $data, TRUE);
            $this->cache->save($module['module_name'].'_'.$type . $module['department_id'], $view_content, 300);
        } else {
            // Use cached content
            $view_content = $view_cache;
        }
    echo $view_content;
}
    } else {
        echo "Invalid department or module.";
    }
}
public function load_plans(){
    $department_id = $this->input->post('department_id');
    $patient_id = $this->input->post('patient_id');
   
    $data['plans'] = $this->PatientsModel->get_patient_plan($patient_id,$department_id);
    $this->load->view('admin/Modules/Treatments/plans', $data);
}
public function visit_form($patient_id,$doc_id=0){
    $decryptedId = decrypt_and_url_decode($patient_id,$this);
   
    $data['doctors_list'] = $this->PatientsModel->get_doctors();
    $data['patient'] = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);
    $data['doc_id'] = $doc_id;
    
    $this->load->view('admin/Patients/PatientVisitForm', $data);

}
public function print_details($patient_id,$doc_id=0){
    $decryptedId = decrypt_and_url_decode($patient_id,$this);
   
 
    $data['patient'] = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);
  
    
    $this->load->view('admin/Patients/print_details', $data);

}

}
