<?php
require_once APPPATH . 'controllers/admin/Jobs/Job/SmsNotification.php';

class PaymentsController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->job = new Job($this);
        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->model('admin/Reports/ReportsModel');
        $this->load->model('admin/SmsPortal/SmsPortalModel');

        $this->load->library('upload');
    }

    public function index()
    {
        //Commen -------------------------------------
          $this->output->cache(5);
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 24;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        // $data['dataList'] = $this->PaymentsModel->getPaymentsList();

        $this->load->view('admin/Payments/PaymentsList', $data);
    }

    public function view($treatment_payment_id)
    { 

        try {
            $paymentId = decrypt_and_url_decode($treatment_payment_id, $this);
           
            $treatments =  $this->PaymentsModel->getTreatmentList($paymentId);
            $recipts =  $this->PaymentsModel->getTreatmentRecipts($paymentId);

            $data['active_menu'] = 24;
            $data['active_submenu'] = 1;

            $result = $this->PatientsModel->get_patient_details('patient_id', $treatments->patient_id);
            $result->company = $this->PaymentsModel->retrieve_data_unique_row('tbl_companies', 'company_id', $result->company_id);
            $result->documents = $this->PatientsModel->get_patient_documents($treatments->patient_id);
            $result->payment_types = $this->ReportsModel->payment_types();
            $result->total_advance = $this->calculate_totals($treatments->patient_id)['total_advance'];
            $result->discount_general = $this->PatientsModel->retrieve_data_unique('discount_general','name','multiple');
            $result->patient_discounts = $this->PatientsModel->getPatientDiscount($treatments->patient_id);
            $result->general_settings = $this->PatientsModel->retrieve_data_unique_row('general_settings', 'type', 'payment');
            $result->loyalty_program = $this->PatientsModel->retrieve_data_unique('loyalty_programs','is_active','1');
            $result->recipts = $recipts;
            $result->patient_id = $treatments->patient_id;
            $result->treatments = $treatments;
            $result->treatment_id = $treatment_payment_id;
            $result->payment_id = '';
            $result->skipcash_details= $this->db->select('*')->from('tbl_config_services')->where('service_name', 'skipcash_service')->get()->row();

            //coupon 
            foreach ($recipts as $item) {
                if (!empty($item->coupon_id)) {
                    // Retrieve the coupon details based on the coupon ID
                    $result->coupon = $this->PatientsModel->retrieve_data_unique_row('coupons', 'id', $item->coupon_id);
                }
            }
            
            
            $this->load->view('admin/Payments/Payment', $result);
        } catch (Exception $e) {
            echo $e;
            exit;
        }
    }

    public function saveNonInsurance()
    {
        

        $payment_type = $this->input->post('payment_type');
        $payment_amount = $this->input->post('payment_amount');
        $init_total = $this->input->post('base_total');
        $card = $this->input->post('card');
        $co_payment = $this->input->post('co_payment');
        $discount = $this->input->post('discount');
        $pay_date = $this->input->post('pay_date');
        $pay_time = $this->input->post('pay_time');
        $discount_for = $this->input->post('discount_for');
        $treatment_payment_id = decrypt_and_url_decode($this->input->post('treatment_payment_id'), $this);
     
        $payment_id = decrypt_and_url_decode($this->input->post('payment_id'), $this);
        $patient_id = decrypt_and_url_decode($this->input->post('patient_id'), $this);

        $other_discount = $this->input->post('other_discount_val');
        $category_discount = $this->input->post('category_discount');
        $company_discount = $this->input->post('company_discount');
        $coupon_id = $this->input->post('coupon_id');
        $coupon_discount = $this->input->post('coupon_discount');
        $loyalty = $this->input->post('loyalty_program');
        $points_discount = $this->input->post('points_discount');
        $no_points = $this->input->post('no_points');
       
        

        //redeem_points
        if(!empty($points_discount)){
            $get_user_points= $this->PatientsModel->retrieve_data_unique_row('user_loyalty_points', 'user_id', $patient_id);
            if (!empty($get_user_points)) {
                $user_points = (int)$get_user_points->points_balance ?? 0;
                $user_points -= $no_points;
                $points= array(
                    'points_balance'=>$user_points,
                );
            $this->PaymentsModel->update_data_where('user_loyalty_points', 'user_id', $patient_id,$points);
            $transactions= array(
                'user_id'=>$patient_id,
                'transaction_type'=>'redeem',
                'points'=>$no_points,
                'treatment_payment_id'=>$treatment_payment_id,
            );
            $this->PaymentsModel->insert_data('loyalty_transactions',$transactions);
        }
        }
        //

        //adding Loyalty points
        if(!empty($loyalty)){
            $loyalty_data = $this->PatientsModel->retrieve_data_unique_row('loyalty_programs', 'id', $loyalty);
            $points_per_dollar= $loyalty_data->points_per_dollar;
            $total_points= (int)$payment_amount * (float)$points_per_dollar;
            $initial_total_points= (int)$payment_amount * (float)$points_per_dollar;

            $get_user_points= $this->PatientsModel->retrieve_data_unique_row('user_loyalty_points', 'user_id', $patient_id);
            if (!empty($get_user_points)) {
                    $user_points = (int)$get_user_points->points_balance ?? 0;
                    $total_points += $user_points;
                    $points= array(
                        'points_balance'=>$total_points,
                        'expired_after'=>$loyalty_data->expired_after,
                    );
                $this->PaymentsModel->update_data_where('user_loyalty_points', 'user_id', $patient_id,$points);
            }else{
                $points= array(
                    'points_balance'=>$total_points,
                    'user_id'=>$patient_id,
                    'expired_after'=>$loyalty_data->expired_after,
                );
              $this->PaymentsModel->insert_data('user_loyalty_points',$points);
            }

            $transactions= array(
                'user_id'=>$patient_id,
                'transaction_type'=>'earn',
                'points'=>$initial_total_points,
                'treatment_payment_id'=>$treatment_payment_id,
            );
            $this->PaymentsModel->insert_data('loyalty_transactions',$transactions);
        
        }
        //
        
        
        $discount_data = array();

        if (!empty($category_discount)) {
            $discount_data['category_discount'] = $category_discount;
        }
        
        if (!empty($company_discount)) {
            $discount_data['company_discount'] = $company_discount;
        }

        $total = $payment_amount + $card + $discount;
        if($other_discount > 0){
            $category_discount_val = $this->input->post('category_discount_val');
            $company_discount_val = $this->input->post('company_discount_val');
            if(!empty($category_discount_val)){
                $category_discount_amount = (int)$init_total * (int)$category_discount_val / 100;
            }
            if(!empty($company_discount_val)){
                $company_discount_amount = (int)$init_total * (int)$company_discount_val / 100;
            }

            // $discount = (int)$this->input->post('payment_amount') * (int)$other_discount / 100;
         
        } 
        
        if(!empty($coupon_id)){
            $coupon = array(
                'coupon_id'=>$coupon_id,
                'user_id'=>$patient_id,
            );

            $this->PaymentsModel->insert_data('user_coupons', $coupon);

        }
        
        $new_data = [];
        $push_data=array(
            'pay_type' => $payment_type,
            'cash' => $payment_amount,
            'card' => $card,
            'discount' => $discount,
            'category_discount' => $category_discount_amount,
            'company_discount' => $company_discount_amount,
            'coupon_id' => $coupon_id ?? 0,
            'coupon_discount' => $coupon_discount,
            'points_discount' => $points_discount,
            'pay_date' => $pay_date,
            'pay_time' => $pay_time,
            'patient_id' => $patient_id,
            'is_insurance' => 0,
            'user_id' => $this->loginId,
            'total' => $total,
            'treatment_payment_id' => $treatment_payment_id
        );
        array_push($new_data, $push_data);

        $validation_rules = array(
            array(
                'field' => 'payment_amount',
                'label' => 'Payment Amount',
                'rules' => 'greater_than[0]'
            )
            
        );

        $this->form_validation->set_rules($validation_rules);

        // $this->form_validation->set_message('check_balance', 'Payment Amount Should not gerater than balance.');

      
        if ($this->form_validation->run() == FALSE) {
            $error_message = "";
            foreach ($validation_rules as $rule) {
                $field = $rule['field'];
                $error_message .= form_error($field) . "<br>";
            }
            $this->session->set_flashdata('error', $error_message);
            redirect('admin/Payments/PaymentsController/view/' . encrypt_and_url_encode($treatment_payment_id,$this), 'refresh');
            return;
        }

        if ($payment_id != '') {
           
            $old_data=$this->PaymentsModel->retrieve_data_unique_row('tbl_patient_payment', 'patient_payment_id', $payment_id);
            $new_data[0]['treatment_payment_id']=$old_data->treatment_payment_id;
            $push_data['treatment_payment_id']=$old_data->treatment_payment_id;
            if (!empty($discount_data)) {
            $this->PaymentsModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatment_payment_id, $discount_data);
            }
            $this->PaymentsModel->update_data_where('tbl_patient_payment', 'patient_payment_id', $payment_id, $new_data[0]);
            
            $log_details_new = $this->prepLogArray($push_data, 'Payment Receipt');
            
             $old_data_log=array(
                'pay_type' => $old_data->pay_type,
                'cash' => $old_data->cash,
                'card' => $old_data->card,
                'discount' =>$old_data->discount,
                'category_discount' => $old_data->category_discount,
                'company_discount' => $old_data->company_discount,
                'coupon_id' => $old_data->coupon_id ?? 0,
                'coupon_discount' => $old_data->coupon_discount,
                'points_discount' => $old_data->points_discount,
                'pay_date' => $old_data->pay_date,
                'pay_time' => $old_data->pay_time,
                'patient_id' =>$old_data->patient_id,
                'is_insurance' => 0,
                
                'total' => $old_data->total,
                'treatment_payment_id' => $old_data->treatment_payment_id,
            );
          
            $this->logRecord('Payment Receipt', 'Update', $payment_id, $old_data_log, $log_details_new);
            $treatment_payment_id= $old_data->treatment_payment_id;
          
            $this->session->set_flashdata('success', 'Payment Updated Successfully.');
        } else {
            if ($payment_type == 3) {
                //cash card invoice creation
                $new_data = [];

                for ($i = 1; $i < 3; $i++) {
                    $add_discount = $discount_for == $i ? $discount : 0;
                    $total = $i == 1 ? $payment_amount + $add_discount : $card + $add_discount;
                    
                    $push_data=array(
                        'pay_type' => $i,
                        'cash' => $i == 1 ? $payment_amount : $card,
                        'card' => 0, //not using for calculations
                        'discount' => $discount_for == $i ? $discount : 0,
                        'category_discount' => $category_discount_amount,
                         'company_discount' => $company_discount_amount,
                        'coupon_id' => $coupon_id,
                        'coupon_discount' => $coupon_discount,
                        'points_discount' => $points_discount,
                        'pay_date' => $pay_date,
                        'pay_time' => $pay_time,
                        'patient_id' => $patient_id,
                        'is_insurance' => 0,
                        'user_id' => $this->loginId,
                        'total' => $total,
                        'treatment_payment_id' => $treatment_payment_id
                    );
                    array_push($new_data, $push_data);
                    $total = 0;
                }
            }
          
            if (!empty($discount_data)) {

            $this->PaymentsModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatment_payment_id, $discount_data);
            }
           $id= $this->PaymentsModel->insert_data_multiple('tbl_patient_payment', $new_data);
          
            $log_details_new = $this->prepLogArray($push_data, 'Payment Receipt');
           
				$this->logRecord('Payment Receipt', 'Create', $id, [], $log_details_new);

            $this->session->set_flashdata('success', 'Payment Saved Successfully.');
            // Payment SMS
           $notification= $this->sendPaymentSms($new_data, $patient_id, $treatment_payment_id);
      
        }
        $ntid= encrypt_and_url_encode($treatment_payment_id,$this);
        
        redirect('admin/Payments/PaymentsController/view/' . $ntid, 'refresh');
    }

    private function sendPaymentSms($new_data, $patient_id, $treatment_payment_id)
    {
        
        $message = $this->SmsPortalModel->getTemplate('payment_receive', 'en');
        
        if(!empty($message->template)) {
            
            $patient_name = null;
            $patient_phone= null;
            $pay_types = ['cash', 'card'];
            $placeholders = ['{PATIENT_NAME}', '{PAY_DATE}', '{PAY_TIME}','{AMOUNT}','{INVOICE_NUMBER}','{RECEIPT_NUMBER}','{PAYMENT_TYPE}'];
            
            if(!empty($patient_id) && !empty($treatment_payment_id)){
                if($patient_details = $this->PaymentsModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $patient_id)) {
                    $patient_name =  $patient_details->patient_name;
                    $patient_phone= $patient_details->mobile;
                    $patient_whatsapp= $patient_details->wa_code.$patient_details->wa_mobile;
                }
                
                foreach ($new_data as $key => $data) {                    
                    // Get receipt number
                    $receipt_number = $this->db->select('patient_payment_id')
                        ->from('tbl_patient_payment')
                        ->where('treatment_payment_id', $treatment_payment_id)
                        ->where('pay_date', $data['pay_date'])
                        ->where('pay_time', $data['pay_time'])
                        ->where('pay_type', $data['pay_type'])
                        ->get()
                        ->row();

                    $values = [$patient_name, $data['pay_date'], $data['pay_time'], $data['cash'], $treatment_payment_id, $receipt_number->patient_payment_id, $pay_types[$key]];
                    $template = str_replace($placeholders, $values,$message->template);
                    
                    $smsjob = array(
                        'message'=>$template,
                        'phone'=>$patient_phone,
                        'whatsapp_mobile'=>$patient_whatsapp,
                        'patient_name'=>$patient_name,
                        'pay_date'=>$data['pay_date'],
                        'pay_time'=>$data['pay_time'],
                        'receipt_number'=>$receipt_number->patient_payment_id,
                        'amount'=>$data['cash'],
                        'type'=>$pay_types[$key]
                    );
                    $smsjob = json_encode($smsjob);
                    $job= array(
                        'queue'=>'DEFAULT',
                        'payload'=>$smsjob,
                        'event'=>'payment_receive',
                    
                    );
                     $smsJob= $this->SmsPortalModel->insert_data('tbl_jobs', $job);
                    return $smsJob;
                    
                }
            }          
        }
    }

    public function editRecipt($payment_id)
    {

        $decrypt_id = decrypt_and_url_decode($payment_id, $this);

        $result = $this->PaymentsModel->retrieve_data_unique_row('tbl_patient_payment', 'patient_payment_id', $decrypt_id);

        $patient = $this->PatientsModel->get_patient_details('patient_id', $result->patient_id);
        $data['payment_types'] = $this->ReportsModel->payment_types();

        // print_r($result);die;
        $data['discount_per'] = $result->discount_per;
        $data['payment_id'] = $result->patient_payment_id;
        $data['payment_type'] = $result->pay_type;
        $data['pay_amount'] = $result->cash;
        $data['card'] = $result->card;
        $data['discount'] = $result->discount;
        $data['pay_date'] = $result->pay_date;
        $data['pay_time'] = $result->pay_time;

        //insurance variables
        $data['discount_ins'] = $result->discount;
        $data['discount_per_ins'] = $result->discount_per;
        $data['co_payment_ins'] = $result->co_payment;
        $data['co_payment_per_ins'] = $result->co_payment_per;
        $data['excess_ins'] = $result->excess;
        $data['total_ins'] = $result->insurance_amount;
        $data['pay_date_ins'] = $result->pay_date;
        $data['pay_time_ins'] = $result->pay_time;
        $data['patient_name'] = $patient->patient_name;

        $data['patient_id'] = $result->patient_id;
        $data['treatment_payment_id'] = $result->treatment_payment_id;
        $data['is_insurance'] =  $result->is_insurance;
        $data['total_advance'] = $this->calculate_totals($result->patient_id)['total_advance'];
        $data['treatments'] =  $this->PaymentsModel->getTreatmentList($result->treatment_payment_id);
        $data['recipts'] =  $this->PaymentsModel->getTreatmentRecipts($result->treatment_payment_id);


        $this->load->view('admin/Payments/Payment', $data);
    }

    public function editInsuranceRecipt($payment_id)
    {
        $decrypt_id = decrypt_and_url_decode($payment_id, $this);
    }

    public function deleteRecipt($payment_id)
    {

        $decrypt_id = decrypt_and_url_decode($payment_id, $this);
        $result = $this->PaymentsModel->retrieve_data_unique_row('tbl_patient_payment', 'patient_payment_id', $decrypt_id);
        if(!empty($result->coupon_id)){
            $this->PaymentsModel->deleteUsedCoupon($result->coupon_id,$result->patient_id);
        }
        $this->PaymentsModel->delete_data_where('tbl_patient_payment', 'patient_payment_id', $decrypt_id);
        $result_array = (array) $result;
        $log_details_new = $this->prepLogArray($result_array, 'Payment Receipt');
          
		$this->logRecord('Payment Receipt', 'Delete', $decrypt_id, $log_details_new, []);
        $this->session->set_flashdata('success', 'Payment Recipt Deleted Successfully.');
        redirect('admin/Payments/PaymentsController/view/' . encrypt_and_url_encode($result->treatment_payment_id, $this), 'refresh');
    }

    public function deleteInvoice($treatment_payment_id)
    {

        $decrypt_id = decrypt_and_url_decode($treatment_payment_id, $this);
        $result = $this->PaymentsModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $decrypt_id);
        $this->PaymentsModel->delete_data_where('tbl_treatment_payment', 'treatement_payment_id', $decrypt_id);
        $data = (array)$result;
        
        $log_details_new = $this->prepLogArray($data, 'Invoice');
          
		$this->logRecord('Payment Invoice', 'Delete', $decrypt_id, $log_details_new, []);
       
        $pay_result = $this->PaymentsModel->retrieve_data_unique_row('tbl_patient_payment', 'treatment_payment_id', $decrypt_id);
        $this->PaymentsModel->delete_data_where('tbl_patient_payment', 'treatment_payment_id', $decrypt_id);
        if(!empty($pay_result)){
            $data = (array)$pay_result;
            $log_details_new = $this->prepLogArray($data, 'Payment Receipt');
            
            $this->logRecord('Payment Receipt', 'Delete', $decrypt_id, $log_details_new, []);
        }
        
        $pay_result = $this->PaymentsModel->retrieve_data_unique_row('tbl_episode_payment', 'treatement_payment_id', $decrypt_id);
        $this->PaymentsModel->delete_data_where('tbl_episode_payment', 'treatement_payment_id', $decrypt_id);
       
        $this->session->set_flashdata('success', 'Invoice Deleted Successfully.');
        // redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($result->patient_id, $this));
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function saveInsurance()
    {

        $payment_type = $this->input->post('payment_type');
        $insurance_amount = $this->input->post('total_ins');
        $card = $this->input->post('card');
        $co_payment = $this->input->post('co_payment_ins');
        $co_payment_per = $this->input->post('co_payment_per_ins');
        $discount = $this->input->post('discount_ins');
        $discount_per = $this->input->post('discount_per_ins');
        $pay_date = $this->input->post('pay_date_ins');
        $pay_time = $this->input->post('pay_time_ins');
        $excess = $this->input->post('excess_ins');
        $treatment_payment_id = decrypt_and_url_decode($this->input->post('treatment_payment_id'), $this);
        $patient_id = decrypt_and_url_decode($this->input->post('patient_id'), $this);
        $payment_id = decrypt_and_url_decode($this->input->post('payment_id'), $this);

        //sum up insurance discount and payment
        $total = $insurance_amount + $discount;
        $new_data = [
            'pay_type' => 0,
            'insurance_amount' => $insurance_amount,
            'discount' => $discount,
            'discount_per' => $discount_per,
            'pay_date' => $pay_date,
            'pay_time' => $pay_time,
            'patient_id' => $patient_id,
            'is_insurance' => 1,
            'user_id' => $this->loginId,
            'total' => $total,
            'co_payment' => $co_payment,
            'co_payment_per' => $co_payment_per,
            'excess' => $excess,
            'treatment_payment_id' => $treatment_payment_id
        ];

        if ($payment_id != '') {
            $this->PaymentsModel->update_data_where('tbl_patient_payment', 'patient_payment_id', $payment_id, $new_data);
            $this->createLog('Receipt Payment', $this->loginId, 'Update', $new_data);
            $this->session->set_flashdata('success', 'Insurance Payment Updated Successfully.');
        } else {
            $this->PaymentsModel->insert_data('tbl_patient_payment', $new_data);
            $this->createLog('Receipt Payment', $this->loginId, 'Create', $new_data);
            $this->session->set_flashdata('success', 'Insurance Payment Saved Successfully.');
        }

        redirect('admin/Payments/PaymentsController/view/' . $this->input->post('treatment_payment_id'), 'refresh');
    }

    public function get_recipts_list()
    {
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $is_insurance = $this->input->get('is_insurance');
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];

        $records = $this->PaymentsModel->getReceiptsList($search, $is_insurance, $length, $start, 'patient_payment_id', 'DESC');
        foreach ($records as $key => $row) {
            $row->patient_payment_id = encrypt_and_url_encode($row->patient_payment_id, $this);
            $row->treatment_no = encrypt_and_url_encode($row->treatement_payment_id, $this);
            $records[$key] = $row;
        }

        $allrecords = $this->PaymentsModel->getReceiptsList($search, $is_insurance, -1, $start, 'patient_payment_id', 'DESC');
        // Get total records
                //  $allRecords = $this->PaymentsModel->getReceiptsCount();
                 
        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $allrecords[0]->count,
            "recordsFiltered" => $allrecords[0]->count,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
     public function get_invoice_list()
    {
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];
        $status = $this->input->get('status');
           $p_mobile = $this->input->get('patient_mobile');
        $p_file = $this->input->get('patient_file');
        $count= 1;
      
        $records = $this->PaymentsModel->getInvoiceListDT($search, $length, $start, 'treatment_payment_id', 'DESC',$status, $p_mobile, $p_file);
        // print_r($this->db->last_query());die;
        foreach ($records as $key => $row) {
            $row->invoice_id = encrypt_and_url_encode($row->invoice_id, $this);
            $row->patient_id = encrypt_and_url_encode($row->patient_id, $this);
            $records[$key] = $row;
          
            $count++;
        }

        //  $allRecords = $this->PaymentsModel->getInvoiceCount();
        
        $allrecords = $this->PaymentsModel->getInvoiceListDT($search, -1, $start, 'treatment_payment_id', 'DESC',$status, $p_mobile, $p_file);
       

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" =>  count($allrecords),
            "recordsFiltered" => count($allrecords),
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    // public function get_invoice_list()
    // {
    //     $draw = $this->input->get('draw');
    //     $length = $this->input->get('length');
    //     $start = $this->input->get('start');
    //     $search = $this->input->get('search')['value'];
    //     $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
    //     $order = $this->input->get('order')[0]['dir'];
    //     $status = $this->input->get('status');

    //     $records = $this->PaymentsModel->getInvoiceListDT($search, $length, $start, $order_column, $order,$status);
    //     // print_r($this->db->last_query());die;
    //     foreach ($records as $key => $row) {
    //         $row->invoice_id = encrypt_and_url_encode($row->invoice_id, $this);
    //         $row->patient_id = encrypt_and_url_encode($row->patient_id, $this);
    //         $records[$key] = $row;
    //     }

    //     $allRecords =  $this->PaymentsModel->getInvoiceListDT($search, -1, $start='', $order_column, $order,$status);
    //     // $total_records = $allRecords;
    //      $total_records = count($records);

    //     $response = array(
    //         "draw" => intval($draw),
    //         "recordsTotal" => $total_records,
    //         "recordsFiltered" => $total_records,
    //         "data" => $records
    //     );

    //     $this->output
    //         ->set_content_type('application/json')
    //         ->set_output(json_encode($response));
    // }

 public function createBill()
    {
        $patient_id =  decrypt_and_url_decode($this->input->get('id'),$this);
        $doc_id= $this->input->get('doctor_id');
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 24;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        // $data['dataList'] = $this->PaymentsModel->getPaymentsList();
        $data['doctors'] = $this->PatientsModel->getDoctors();
        $data['modules'] = $this->PatientsModel->getModulesList();
        $data['patient_id']=$patient_id;
        $data['doctor_id']=$doc_id;
        $this->load->view('admin/Payments/CreateInvoice', $data);
    }

    public function insertPayment()
    {
        $patient_id = $this->input->post('patient_id');
        
        $patient = $this->PatientsModel->get_patient_details('patient_id', $patient_id);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;
        $procedure_id = $this->input->post('billing_treatment_id');
        $dept_id = $this->input->post('dept_id');
        $doctor_id = $this->input->post('doctor_id');
        $fees = $this->input->post('orig_price_billing');
        $discount = $this->input->post('discount_billing');
        $discount_per = $this->input->post('discount_per_billing');
        $user_id = $this->session->userdata('user_id');
         $quantity_billing = $this->input->post('quantity_billing');

        $note = $this->input->post('note');
     
        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $this->db->trans_start();
        try {
          
            $treatment_payment_data = array(
                'patient_id'  => $patient_id,
                'user_id' => $doctor_id,
                'treat_date' => date('Y-m-d H:ia'),
                'treat_time' => date('H:iA'),
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => 0,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => $dept_id,
                'notes' => $note,
                'created_by'=>$this->loginId,
            );
  
                $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);
                
    

            for ($i = 0; $i < count($procedure_id); $i++) {

                $newdata = array(
                    'procedure_id' => $procedure_id[$i],
                    'episode_type' => 1,
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'orig_price' => $fees[$i],
                    'quantity'=> $quantity_billing[$i],
                );
                // print_r($newdata);
                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }
          
		
           
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
      
            $this->session->set_flashdata('success', 'Payment Saved Succesfully.');
            redirect('admin/Payments/PaymentsController/createBill?id=' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'Physiotherapy Treatment not saved.');
            redirect('admin/Payments/PaymentsController/createBill?id=' . $patient_id, 'refresh');
            exit;
        }

        $this->db->trans_complete();
    }

    public function check_balance()
    {
        $balance = $this->input->post('balance');
        $payment_amount = $this->input->post('payment_amount');
        $discount = $this->input->post('discount');
        $total = $payment_amount + $discount;
        // if($balance >= $total) {
        //     return true;
        // } else {
            return false;
        // }
    }

    public function loyalty_points($id){
        $data['patient_id']= $id;
        $data['patient']= $this->PaymentsModel->retrieve_data_unique_row('tbl_patients','patient_id',$id);
        $this->load->view('admin/Payments/Loyalty_Points_Transactions',$data);
    }
    public function get_loyalty_transactions(){
        $patient_id = $this->input->get('patient_id');
     
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        
        // $total_records = count($records);
        $status = $this->input->get('status');
        $records = $this->PaymentsModel->getLoyaltyTransactions($patient_id,$search,$status);
        $total_records = count($records);
        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
       
    }

    

   

   
}
