<?php

class QueueController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->model('admin/Modules/GynaeRecord/GynaeRecordModel');
        $this->load->model('admin/Modules/Ophthalmology/OphthalmologyModel');

        $this->load->helper('file');
        // $this->load->library('upload');
        $this->load->library('csvimport');
    }

    public function index()
    {
        $data['config']=   $this->db->select('*')
        ->from('queue_config')
        ->get()
        ->row();

        $data['company']=$this->db->select('*')
        ->from('tbl_company')
        ->get()
        ->row();
        if($data['config']->display=="d2"){
            $this->load->view('admin/Queue/d2',$data);
        }else{
            $this->load->view('admin/Queue/index',$data);
        }
        
    }
    public function d2()
    {
        $data['config']=   $this->db->select('*')
        ->from('queue_config')
        ->get()
        ->row();

        $data['company']=$this->db->select('*')
        ->from('tbl_company')
        ->get()
        ->row();

        $this->load->view('admin/Queue/d2',$data);
    }
    public function Control()
    {
        //Commen -------------------------------------
        $data['config']=   $this->db->select('*')
        ->from('queue_config')
        ->get()
        ->row();

     

        $this->load->view('admin/Queue/control',$data);
    }

    public function saveConfig(){
        $this->load->library('upload');

        $audio = $this->input->post('audio');
     
        $display = $this->input->post('display');
        $promotion = $this->input->post('promotion');
        $video = $this->input->post('video');
        $enable = $this->input->post('enable');
        $voice_enable = $this->input->post('voice_enable');
        $laser_enable = $this->input->post('laser_enable');
        $print_sms = $this->input->post('print_sms');
        $data = array();
        if (!empty($_FILES['audio']['name'])) {
            // Configure upload settings
            $config['upload_path'] = './'.UPLOAD_PATH.'audio/';
            $config['allowed_types'] = 'mp3|wav|ogg';
            $config['max_size'] = 2048; // 2MB
            $this->upload->initialize($config);
        // Prepare data for insertion
        if (!$this->upload->do_upload('audio')) {
            // File upload failed, load the form again with upload errors
            $data['upload_error'] = $this->upload->display_errors();
            $this->session->set_flashdata('error', 'File Not Uploaded.');
            redirect('admin/Queue/QueueController/Control'); // Adjust the redirection as needed
        } else {
            // File upload succeeded, get the file data
            $uploadData = $this->upload->data();
            $data['audio'] = $uploadData['file_name'];
        }
        }
      

            if ($display !== null) {
                $data['display'] = $display;
            }
           
            
            if ($promotion !== null) {
                $data['promotion'] = $promotion;
            }
            
            if ($video !== null) {
                $data['video'] = $video;
            }
            
        
                $data['enable'] = $enable ?? 0;
                $data['print_sms'] = $print_sms ?? 1;
            
                $data['laser_enable'] = $laser_enable ?? 0;
            
                $data['voice_enable'] = $voice_enable ?? 0;
            
          
            // Load the model and save the data
            $this->load->model('admin/Queue/Queue');
            if ($this->Queue->saveConfig($data)) {
                // Successfully saved
                
                $this->session->set_flashdata('success', 'Queue Configuration Saved.');
                redirect('admin/Queue/QueueController/Control'); // Adjust the redirection as needed
            } else {
                // Save failed
                $this->session->set_flashdata('success', 'Queue Configuration.');
                redirect('admin/Queue/QueueController/Control');
            }
        
        }
    

}