<?php

class BankController extends CI_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('admin/Setting/Bank/BankModel');

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
    }

    public function index() {

        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			 //Locals =========================================================================
			$data['List'] = $this->BankModel->get_list();

            $this->load->view('admin/Setting/Bank/BankList', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function createNew() {

        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['bank_id_val'] = 0;
            $data['bank_name_val'] = '';
            $data['note_val'] = '';
			
			 //Locals =========================================================================
			$data['List'] = $this->BankModel->get_list();

            $this->load->view('admin/Setting/Bank/Bank', $data);
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }
	

    public function name_exists_check() {
        $this->db->where('bank_name', trim($this->input->post('bank_name')));
        $this->db->where_not_in('bank_id', $this->input->post('bank_id'));
        $query = $this->db->get('tbl_bank');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('name_exists_check', 'Bank Already Added.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function Save() {
        if ($this->session->userdata('user_Id') != '') {
            //Commen =========================================================================
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            //Validation ====================================================================
           $this->form_validation->set_rules('bank_name', 'Bank Name', 'required|callback_name_exists_check');
			
			
            //Locals =========================================================================
            $bank_id = trim($this->input->post('bank_id'));
            $data['bank_id_val'] = trim($this->input->post('bank_id'));
            $data['bank_name_val'] = trim($this->input->post('bank_name'));
            $data['note_val'] = trim($this->input->post('note'));
			
			
            if ($this->form_validation->run() == FALSE) {
				
				$data['List'] = $this->BankModel->get_list();
                $this->load->view('admin/Setting/Bank/Bank', $data);
                return;
				
            }

            //Save =========================================================================
            $data_save = array(
                'bank_name' => $this->input->post('bank_name'),
                'note' => $this->input->post('note'),
                'create_user_Id' => $loginId,
                'create_datetime' => date('Y-m-d H:i:s')
            );

            if ($bank_id > 0) {
				
                $this->BankModel->update($bank_id, $data_save);
            } else {
				
                $bank_id = $this->BankModel->save($data_save);
            }
			
			$data['bank_id_val'] = '';
			$data['bank_name_val'] = '';
			$data['note_val'] = '';

            //load screen defaults ============================================================= 
            $data['List'] = $this->BankModel->get_list();
            $this->load->view('admin/Setting/Bank/BankList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function Edit($bank_id) {
        if ($this->session->userdata('user_Id') != '') {
            //Commen =========================================================================
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);

            //Load ===========================================================================
            $load_data = $this->BankModel->get_by_id($bank_id);
			$data['List'] = $this->BankModel->get_list();

            //load screen defaults ============================================================ 
            foreach ($load_data AS $row) {
				
				$data['bank_id_val'] = $row['bank_id'];
				$data['bank_name_val'] = $row['bank_name'];
				$data['note_val'] = $row['note'];
				
            }
            
             $this->load->view('admin/Setting/Bank/Bank', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

}
