<?php

class TabController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->check_permission($this->session->userdata('user_Id'), 'configurations');
        $this->load->model('admin/Setting/Configurations/ConfigurationsModel');
        $this->load->model('admin/Setting/Treatments/TreatmentsModel');
        $this->load->model('admin/ConsentForm/ConfigurationRetriveModel');

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('csvimport');
    }


    public function general_setting(){
        $data['general_settings'] = $this->ConfigurationRetriveModel->retrieve_data_unique_row('general_settings');
        
        $modules = $this->ConfigurationRetriveModel->retrieve_data('general_settings');
        $data['is_package']=0;
        $data['is_referal']=0;

        foreach($modules as $module){
            
            if($module['type']== 'package' && $module['name']== 'is_enable' && $module['value']== '1'  ){
                $data['is_package'] =1;
            }
            if($module['type']== 'referal' && $module['name']== 'is_enable' && $module['value']== '1'){
                $data['is_referal']=1;
            }
          }
        $this->load->view('admin/Setting/Configurations/Tabs/GeneralSettings', $data);
    }
    public function invoice_template(){
        $data['invoice_templates'] = $this->ConfigurationsModel->getInvoiceTemplates();
        $data['invoice_types'] = $this->ConfigurationsModel->getInvoiceTypes();
        $this->load->view('admin/Setting/Configurations/Tabs/InvoiceConfigTab', $data);
    }

    public function qlm_portal(){
        $data['general_settings'] = $this->ConfigurationRetriveModel->retrieve_data_unique_row('general_settings');
        $this->load->view('admin/Setting/Configurations/Tabs/QlmConfigTab', $data);
    }

    public function notification_template(){
        $data['event_types'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_event_names');
        
        $this->load->view('admin/Setting/Configurations/Tabs/NotificationTemplatesTab', $data);
    }

    public function notification_reminder(){
        $data['general_settings'] = $this->ConfigurationRetriveModel->retrieve_data_unique_row('general_settings');
        $this->load->view('admin/Setting/Configurations/Tabs/NotificationRemindersTab', $data);
    }
    public function dynamic_consents(){
        $data['consents'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $this->load->view('admin/Setting/Configurations/Tabs/ConsentFormsTab', $data);
    }

    public function laser_calendar(){
        $data['laser_resources'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $this->load->view('admin/Setting/Configurations/Tabs/LaserCalendarTab', $data);
    }

    public function companies(){
        $data['general_settings'] = $this->ConfigurationRetriveModel->retrieve_data_unique_row('general_settings');
        $this->load->view('admin/Setting/Configurations/Tabs/CompaniesTab', $data);
    }
    public function price_list(){
        $data['insurance_types'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_insurance_types', 'insurance_type_id as value,insurance_name as label', '1', '1');
        $data['departments'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_modules', 'department_id as value,module_name as label', 'is_module', 1);
        
        $this->load->view('admin/Setting/Configurations/Tabs/PriceListTab', $data);
    }
    public function modules(){
        $data['departments'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_modules', 'department_id as value,module_name as label', 'is_module', 1);
        $data['modules'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_modules');
        $this->load->view('admin/Setting/Configurations/Tabs/Modules', $data);
    }
    public function discounts(){
        $data['general_settings'] = $this->ConfigurationRetriveModel->retrieve_data_unique_row('general_settings');
        $this->load->view('admin/Setting/Configurations/Tabs/Discounts', $data);
    }
    public function packages(){
        
        $modules = $this->ConfigurationRetriveModel->retrieve_data('general_settings');
        $data['is_package']=0;
        $data['is_referal']=0;

        foreach($modules as $module){
            
            if($module['type']== 'package' && $module['name']== 'is_enable' && $module['value']== '1'  ){
                $data['is_package'] =1;
            }
            if($module['type']== 'referal' && $module['name']== 'is_enable' && $module['value']== '1'){
                $data['is_referal']=1;
            }
          }
        $this->load->view('admin/Setting/Configurations/Tabs/Packages', $data);
    }

    public function coupons(){
        $this->load->view('admin/Setting/Configurations/Tabs/Coupons');
    }
    public function loyalty(){
        $this->load->view('admin/Setting/Configurations/Tabs/Loyalty');
    }
    public function notification_reminder_sub(){
        $this->load->view('admin/Setting/Configurations/Tabs/notification_reminder_sub');
    }
    public function automated_messages(){
        $data['auto_messages'] = $this->ConfigurationRetriveModel->retrieve_data_unique('notification_reminders','reminder_type','2');
        $this->load->view('admin/Setting/Configurations/Tabs/automated_messages',$data);
    }
}