<?php
use Twilio\Rest\Client;
class CreditCardController extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
       
        $this->load->library('form_validation');
        Header('Access-Control-Allow-Origin: *'); //for allow any domain, insecure
                Header('Access-Control-Allow-Headers: *'); //for allow any headers, insecure
               
    }
    private $testPGDetails = [
        'paymentURL' => 'https://skipcashtest.azurewebsites.net',
        'secretKey' => 'ZKqNcXp2A5xulfjJBqxATF0kY97rDslHFhvEMwMSPdh7ZxKq0G0Z4raD638M7Lucu3DgCCKD3BGFIed8RhU9pp04HfHhfdA7qYSjH9/Z2cvEMm4tt3XXwC7QFn7l/S9g76E3/NzaGBBsV59mvjT3V51NnJPGbhQpWcWuGk1AAFXcXv3N2tmh8GEAWbPCTMXvybj4mI7tItIXDrRb0L/XlyBFSZGUBforFvFK5FaIjS6OU6xc0w7q2wsBRjLT3cIApYqCl/Ri2Bx1C2/Ai9BUrywGJolVE3FsDQl+diayZW4KW0rPYJVjtY4BIr2wUiPpZSFuE22cwuZLasa/3CC2Misbs5B7LKHpkpjFEQsQxCzPno+KzdvIEGvcanj49SyIzVq5R2xoZWltCdzaPCWBhDUWAb7WvfKGKXVC+ubzP0wMSC2QmDiwGz1CsXvshvKv+n+x1bE/YMFneZ/W9yH9uDcjtWcSdutuFNAxZgsDlH53u8J0YFEBTE++yuuLQyFdd+eFGf2Lpzan6Qj7XLi6kA==',
        'keyId' => '79b0651b-00e2-4f9c-a0f7-2bffc535c348',
        'clientId' => '2582ac48-8b6f-418d-b323-f6d11e104fcc',
        'webhookKey' => '61097f22-9222-4a52-8ef1-a1cab7ac2b0d'
    ];

    public function index(){
        echo 'hello';
    }

    public function payAuthHash()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        $combinedData = "KeyId={$this->testPGDetails['keyId']},Amount={$data['Amount']},FirstName={$data['FirstName']},LastName={$data['LastName']},Phone={$data['Phone']},Email={$data['Email']},TransactionId={$data['TransactionId']},Custom1={$data['Custom1']}";

        $hash = hash_hmac('sha256', $combinedData, base64_decode($this->testPGDetails['secretKey']), true);
        $hashInBase64 = base64_encode($hash);

        echo json_encode(['hashInBase64' => $hashInBase64]);
    }

    public function enrollmentHash()
    {
        $referenceId = $this->input->get('referenceId');
        $returnUrl = $this->input->get('returnUrl');

        $combinedData = "KeyId={$this->testPGDetails['keyId']},ReferenceId={$referenceId},ReturnURL={$returnUrl}";
        $hash = hash_hmac('sha256', $combinedData, base64_decode($this->testPGDetails['secretKey']), true);
        $hashInBase64 = base64_encode($hash);

        echo json_encode(['hashInBase64' => $hashInBase64]);
    }

    public function validationHash()
    {
        $referenceId = $this->input->get('referenceId');
        $transactionId = $this->input->get('transactionId');

        $combinedData = "KeyId={$this->testPGDetails['keyId']},ReferenceId={$referenceId},TransactionId={$transactionId}";
        $hash = hash_hmac('sha256', $combinedData, base64_decode($this->testPGDetails['secretKey']), true);
        $hashInBase64 = base64_encode($hash);

        echo json_encode(['hashInBase64' => $hashInBase64]);
    }
    public function generateCaptureContextHash()
{
    // Retrieve the `flexTargetOrgin` query parameter.
    // $flexTargetOrgin = $this->input->get('flexTargetOrgin');
// $flexTargetOrgin = $this->input->get('flexTargetOrgin');
$flexTargetOrgin = 'https://v1.h-mate.com';
    // Combine data to match the required format.
    $combinedData = "KeyId={$this->testPGDetails['keyId']},FlexTargetOrigin={$flexTargetOrgin},ClientId={$this->testPGDetails['clientId']}";
    
    // Generate HMAC hash and encode it in Base64.
    $hash = hash_hmac('sha256', $combinedData, $this->testPGDetails['secretKey'], true);
    $hashInBase64 = base64_encode($hash);

    // Optionally, make a POST request to the remote API.
    // Uncomment the below section if you need to make the API call.

    /*
    $apiUrl = "{$this->testPGDetails['paymentURL']}/payer/auth/generate-token";
    $postData = json_encode([
        'KeyId' => $this->testPGDetails['keyId'],
        'FlexTargetOrigin' => $flexTargetOrgin,
    ]);

    // Initialize cURL to make the request.
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "Authorization: $hashInBase64"
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200) {
        echo json_encode(['error' => 'Failed to fetch token', 'httpCode' => $httpCode]);
        return;
    }

    $responseBody = json_decode($response, true);
    */

    // Return the generated hash and optional response data.
    echo json_encode([
        'hashInBase64' => $hashInBase64,
        // 'apiResponse' => $responseBody ?? null
    ]);
}

    public function addTransactionId()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        log_message('info', 'Transaction received: ' . print_r($data, true));

        echo json_encode(['transactionId' => $data['TransactionId']]);
    }


    public function getTransactionId()
{
    $referenceId = $this->input->get('referenceId');
    $jsonFilePath = APPPATH . 'transactions.json';

    if (file_exists($jsonFilePath)) {
        $transactions = json_decode(file_get_contents($jsonFilePath), true);
        echo json_encode($transactions[$referenceId] ?? null);
    } else {
        echo json_encode(['error' => 'Transaction file not found']);
    }
}
}