<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . 'helpers/job/should_queue.interface.php';

class Job
{
    /**
     * Table coloumns
     * 
     * tbl_jobs
     * id, queue, payload, attempts, available_at, created_at,
     * 
     * tbl_executed_jobs
     * id, queue, payload, attempts, available_at, created_at, status
     * 
     * RUN JOBS USING CRON
     * php -d display_errors=on index.php admin/Jobs/JobController dispatch
     * [php] [php params] [index.php] [controller path] [controller function]
     * index.php - Codeigniter default (path/to/index.php)
     * 
     * In dispatch method, you can specify which queue should run via the cron job.  not specified, it will run all the available jobs.
     * In other way you can run specific job types in seperate cron jobs with different time gaps.
     */

    //  CREATE TABLE
    //  `tbl_jobs` (
    //    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    //    `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
    //    `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    //    `attempts` tinyint(3) unsigned NOT NULL DEFAULT '0',
    //    `available_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
    //    `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    //    `updated_at` timestamp NULL DEFAULT NULL,
    //    `is_running` tinyint(1) NOT NULL DEFAULT '0',
    //    PRIMARY KEY (`id`)
    //  ) ENGINE = InnoDB AUTO_INCREMENT = 30 DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci

    //  CREATE TABLE
    //  `tbl_executed_jobs` (
    //    `executed_job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    //    `id` bigint(20) unsigned NOT NULL,
    //    `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
    //    `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    //    `attempts` tinyint(3) unsigned NOT NULL DEFAULT '0',
    //    `available_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
    //    `created_at` timestamp NULL DEFAULT NULL,
    //    `updated_at` timestamp NULL DEFAULT NULL,
    //    `status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    //    PRIMARY KEY (`executed_job_id`)
    //  ) ENGINE = InnoDB AUTO_INCREMENT = 23 DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci

    private $CI;
    private $queue = 'DEFAULT';
    private $payload = null;
    private $attempts = 2;
    private $available_at = null;
    private $batchSize = 10;
    private $maxIterations = PHP_INT_MAX;

    public function __construct($CI)
    {
        $this->CI = $CI;
        date_default_timezone_set('Asia/Qatar');
    }

    public function test()
    {
        echo "Job Initiated";
    }

    public function new($queue = null, $payload = null, $attempts = null, $available_at = null)
    {
        if ($payload instanceof ShouldQueue && is_object($payload)) {
            $payload = serialize($payload);
        } else {
            throw new Exception('Payload must be a ShouldQueue instance.');
        }

        try {
            return $this->CI->db->insert('tbl_jobs', [
                'queue' => $queue ?? $this->queue,
                'payload' => $payload ?? $this->payload,
                'attempts' => $attempts ?? $this->attempts,
                'available_at' => $available_at ?? $this->available_at
            ]);
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function dispatch($queue = null)
    {
        $offset = 0;
        $iterations = 0;

        do {
            // $available_jobs = $this->CI->db
            //     ->select('*')
            //     ->from('tbl_jobs')
            //     ->order_by('created_at DESC')
            //     ->limit($this->batchSize, $offset)
            //     ->get()
            //     ->result();

            $jobs_query = $this->CI->db
                ->select('*')
                ->from('tbl_jobs')
                ->order_by('created_at DESC');

            if ($queue !== null) {
                $jobs_query->where('queue', $queue);
            }

            $jobs_query->where('is_running', 0);
            $available_jobs = $jobs_query
                ->limit($this->batchSize, $offset)
                ->get()
                ->result();

            foreach ($available_jobs as $index => $job) {

                // Marks job is_running = 1, Otherwise cron will run same job multiple times
                $this->CI->db->where('id',  $job->id);
                $this->CI->db->update('tbl_jobs', ['is_running' => 1]);

                if ($job->available_at !== null && (strtotime($job->available_at) > time())) {
                    echo (php_sapi_name() === 'cli') ? PHP_EOL . "Job not available at this time: (ID {$job->id}) | At:{$job->available_at} | Now:" . date('Y-m-d H:i:s') . PHP_EOL : "<br>Job not available at this time: (ID {$job->id})  | At:{$job->available_at} | Now:" . date('Y-m-d H:i:s') . "<br>";
                    continue;
                }

                $executed = false;

                $payload = $job->payload;

                if (is_string($payload)) {

                    try {
                        $payload = unserialize($payload);
                        $executed = $payload->handle($this->CI);

                        if (!is_bool($executed)) {
                            throw new Exception("\r\nError: Your handler must return a boolean.");
                            break;
                        }
                    } catch (Exception $e) {
                        throw new Exception($e->getMessage());
                    }
                }

                if ($executed) {
                    $this->handle_executed_job($job);
                    echo (php_sapi_name() === 'cli') ? PHP_EOL . "Job Success: (ID {$job->id})" . PHP_EOL : "<br>Job Success: (ID {$job->id})<br>";
                } else {
                    $this->handle_failed_job($job);
                    echo (php_sapi_name() === 'cli') ? PHP_EOL . "Job Failed: (ID {$job->id})" . PHP_EOL : "<br>Job Success: (ID {$job->id})<br>";
                }
            }

            $offset += $this->batchSize;

            $iterations++;
        } while (!empty($available_jobs) && $iterations < $this->maxIterations);

        return $iterations;
    }

    public function list()
    {
        $available_jobs = $this->CI->db
            ->select('*')
            ->from('tbl_jobs')
            ->order_by('created_at DESC')
            ->get()
            ->result();
    }

    public function remove()
    {
    }

    public function update()
    {
    }

    private function handle_executed_job($job, $status = 'DONE')
    {

        $this->CI->db->trans_begin();
        try {

            $job->status = $status;
            unset($job->is_running);
            $this->CI->db->insert('tbl_executed_jobs', $job);

            $this->CI->db->where('id', $job->id)->delete('tbl_jobs');

            if ($this->CI->db->trans_status() === FALSE) {
                $this->CI->db->trans_rollback();
                throw new Exception('Transaction failed.');
            } else {
                $this->CI->db->trans_commit();
            }
        } catch (Exception $e) {
            echo $e->getMessage();
            $this->CI->db->trans_rollback();
        }
    }

    private function handle_failed_job($job)
    {

        $attempts = ($job->attempts - 1);
        $id = $job->id;
        if ($attempts > 0) {
            $job->attempts = $attempts;
            $job->updated_at = date('Y-m-d H:i:s');
            $this->CI->db->update('tbl_jobs', $job, ['id' => $id]);
        } else {
            $this->handle_executed_job($job, 'FAILED');
        }
    }
}
