<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class qlm_base {

    private $env;
    private $baseUrl;
    private $username;
    private $password;
    private $companyId;

    private const ENVIRONMENTS = ['dev', 'prod'];

    private const QLM_TEST_HOST = 'https://www.devapi.anoudapps.com';
    private const QLM_PROD_HOST = 'https://www.api.qlm-online.com';

    private const ENDPOINTS = [
        'QLM_PREAPPROVAL_URL_V2' => '/api/medical/hospital-service/v2/pre-approval',
        'QLM_ELIGIBILITY_URL' => '/api/medical/hospital-service/eligibilityCheck',
        'QLM_PREAPPROVAL_URL' => '/api/medical/hospital-service/v3/pre-approval',
        'QLM_PREAPPROVAL_QUERY_URL' => '/api/medical/hospital-service/v2/pre-approval',
        'QLM_VISITFORM_URL' => '/api/medical/hospital-service/v2/visit-form',
        'QLM_APPEAL_URL' => '/api/medical/hospital-service/preApproval',
        'QLM_RECEIPT_URL' => '/api/medical/hospital-service/pre-approval',
        'QLM_APPEAL_PREAPPROVAL_URL' => '/api/medical/hospital-service/preApproval',
        'QLM_TOB' => '/api/medical/hospital-service/table-of-benefit'
    ];

    public function __construct()
    {
        if (!defined('QLM_ENV')){
            throw new Exception('Please defined \'QLM_ENV\' [prod, dev] in your config.php file.');
        }

        if (!in_array(QLM_ENV, self::ENVIRONMENTS)) {
            throw new Exception('Invalid environment');
        }

        if (!defined('QLM_COMPANY_ID')){
            throw new Exception('Please defined \'QLM_COMPANY_ID\' in your config.php file.');
        }

        $this->env = QLM_ENV;
        $this->companyId = QLM_COMPANY_ID;

        if($this->env === 'prod') {
            if(!defined('QLM_PROD_USERNAME') || !defined('QLM_PROD_PASSWORD')){
                throw new Exception('You must define QLM production username - \'QLM_PROD_USERNAME\' & password \'QLM_PROD_PASSWORD\' in your config.php file.');
            }

            $this->baseUrl = self::QLM_PROD_HOST;
            $this->username = QLM_PROD_USERNAME;
            $this->password = QLM_PROD_PASSWORD;
        }else{
            if(!defined('QLM_TEST_USERNAME') || !defined('QLM_TEST_PASSWORD')){
                throw new Exception('You must define QLM test username - \'QLM_TEST_USERNAME\' & password \'QLM_TEST_PASSWORD\' in your config.php file.');
            }

            $this->baseUrl = self::QLM_TEST_HOST;
            $this->username = QLM_TEST_USERNAME;
            $this->password = QLM_TEST_PASSWORD;
        }
		$this->ci = &get_instance();
        $this->ci->load->model('admin/ConsentForm/ConfigurationRetriveModel');
    }

	public function preapproval_query($id)
	{
		$url = $this->getUrl('QLM_PREAPPROVAL_QUERY_URL') . '?PAreferenceNo=' . $id;
		$pa = $this->connect(2, $url);
		curl_setopt($pa, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($pa);

		$this->close($pa);
		return $result;
	}


    public function test()
    {
        echo 'Hello World';
    }

    public function getUrl($endpoint_key)
    {
        if (!isset(self::ENDPOINTS[$endpoint_key])) {
            throw new Exception('Invalid endpoint key');
        }
        return $this->baseUrl . self::ENDPOINTS[$endpoint_key];
    }

    public function connect($type = 0, $url = '')
	{
		$auth = base64_encode(QLM_PROD_USERNAME . ":" . QLM_PROD_PASSWORD);
		$content_type = '';

		if ($type == 2 || $type == 3) {
			$ch = curl_init($url);
		} else {
			$ch = curl_init();

			switch ($type) {
				case 1:
					$content_type = 'multipart/form-data';
					break;
				default:
					$content_type = 'application/json';
					break;
			}
		}

		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Authorization: Basic ' . $auth,
			'Content-Type: ' . $content_type,
			'Accept: ' . ($type == 3 ? 'application/pdf' : 'application/json'),
			'company: ' . QLM_COMPANY_ID
		]);

		return $ch;
	}

    public function eligibilityCheck($patientId=null, $memberId=null, $doctorId=null)
	{
		$auth = base64_encode(QLM_PROD_USERNAME . ":" . QLM_PROD_PASSWORD);
		$qheader = ['Authorization: Basic ' . $auth, 'Content-Type: application/json', 'Accept: application/json', 'company: ' . QLM_COMPANY_ID];
		$ch = $this->connect();
		$check = [];
		$result = FALSE;
        
        $doctor_info = $this->db->select('*')
                        ->from('tbl_users')
                        ->join('tbl_employees', 'tbl_users.user_Id=tbl_employees.user_id')
                        ->where('tbl_users.user_Id', $doctorId ?? $this->session->userdata('user_Id'))
                        ->get()
                        ->row();


		if ($doctor_info->license_no != 0 && isset($doctor_info->license_no) && !empty($doctor_info)) $doctorLicen = $doctor_info->license_no;

		curl_setopt($ch, CURLOPT_URL, $this->getUrl('QLM_ELIGIBILITY_URL'));
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		if ((float)($patientId) != 0) {
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['civilId' => $patientId, 'docLicNo' => $doctorLicen]));
			curl_setopt($ch, CURLOPT_HTTPHEADER, $qheader);
			$result = curl_exec($ch);
			$check = json_decode($result, true);
		} else {
			$check['messageType'] = 'E';
		}

		if ($check['messageType'] == 'E') {
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['memberId' => $memberId, 'docLicNo' => $doctorLicen]));
			curl_setopt($ch, CURLOPT_HTTPHEADER, $qheader);
			$result = curl_exec($ch);
		}

		curl_close($ch);
		return $result;
	}

    public function close($ch)
	{
		curl_close($ch);
	}

    public function checkk($id)
	{
		$url = $this->getUrl('QLM_APPEAL_URL') . '?PAreferenceNo=' . $id;
		$pa = $this->connect(2, $url);
		curl_setopt($pa, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($pa);

		$this->close($pa);
		return $result;
	}

    public function validateInsurance($qatarId=null, $memberId=null)
	{
		$auth = base64_encode($this->username . ":" . $this->password);
		$qheader = ['Authorization: Basic ' . $auth, 'Content-Type: application/json', 'Accept: application/json', 'company: ' . $this->companyId];

		$ch = curl_init();
		$check['messageType'] = '';
		$result = '';

		curl_setopt($ch, CURLOPT_URL, $this->getUrl('QLM_ELIGIBILITY_URL'));
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		if ($qatarId != "0") {
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['civilId' => $qatarId]));
			curl_setopt($ch, CURLOPT_HTTPHEADER, $qheader);

			$result = curl_exec($ch);
			$check = json_decode($result, true);
		} else {
			$check['messageType'] = 'E';
		}

		if ($check['messageType'] == 'E') {
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['memberId' => $memberId]));
			curl_setopt($ch, CURLOPT_HTTPHEADER, $qheader);
			$result = curl_exec($ch);
		}

		curl_close($ch);
		return $result;
	}
	public function visit_form($inpt = array(), $id = '', $member_id = '')
	{
		$ch = json_decode($this->eligibilityCheck($id, $member_id));

		$category = ($inpt['p_category'] == 1) ? 'D' : 'O';
		$get_doctor_id = $this->ConfigurationRetriveModel->get_row_data('doctors', 'employee_id', $this->session->userdata('emp_id'));
		$doctor_id = $get_doctor_id->doctor_id;

		if ($ch->messageType != 'E') {
			$url = $this->getUrl("QLM_VISITFORM_URL") . '/' . $ch->visitNo . '?category=' . $category . '&docLicNo=' . $doctor_id;
			$pa = $this->connect(3, $url);

			curl_setopt($pa, CURLOPT_URL, $url);
			curl_setopt($pa, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($pa, CURLOPT_BINARYTRANSFER, 1);
			$data = curl_exec($pa);

			date_default_timezone_set('Asia/Kuwait');
			$date_string = '%Y-%m-%d';
			$curr_date = mdate($date_string);
			$curr_time = date("H:i");
			$split_time = explode(':', $curr_time);
			$fname = $inpt['patient_id'] . '~' . $curr_date . '~' . $split_time[0] . $split_time[1];

			$destination = "./".UPLOAD_PATH."qlm/" . $fname . ".pdf";
			$file = fopen($destination, "w+");
			fputs($file, $data);

			$this->close($pa);
			return $data;
		} else {
			return FALSE;
		}
	}
	public function pre_approval($inpt = array(), $pl_id)
	{
		$data = array();
		$id = $inpt['patient_qid'];
		$member_id = $inpt['member_id'];
		$doctor_id = $inpt['doctor_id'];

		$ch = json_decode($this->eligibilityCheck($id, $member_id));
		$vf = $this->visit_form($inpt, $id, $member_id);

		$pa = $this->connect(1);
		$testarr = array();
		$trr = array();
		$trr2 = array();
		$proc_str = '';
		$temp = array();
		$temp2 = array();
		$pharmacy_drug_data = array();
		$docs = '';

		$req_sent = FALSE;

		// print_r($inpt);
		// die();

		$category = '001';
		switch ($inpt['p_category']) {
			case 1:
				$category = '002';
				break; // dental
			case 2:
				$category = '001';
				break; // derma
			case 3:
				$category = '001';
				break; // general surgery
			case 4:
				$category = '001';
				break; // plastic surgery
			case 5:
				$category = '001';
				break; // consultation
			case 6:
				$category = '006';
				break; // physiotheraphy
			case 7:
				$category = '001';
				break; // general medical
			case 8:
				$category = '003';
				break; // gynecology
			case 9:
				$category = '001';
				break; // lab
			case 10:
				$category = '004';
				break; // opthalmology
			case 11:
				$category = '001';
				break; // pediatric
			case 12:
				$category = '005';
				break; // pharmacy
			default:
				$category = '001';
				break; // unspecified or additional
		}

		if (!empty($inpt['dia_id']))
			foreach ($inpt['dia_id'] as $k => $dia) {
				// if($k != 0) {			
				$temp2['diagCode'] = $dia;

				array_push($trr2, $temp2);
				// }
			}

		$primary_diag = !empty($inpt['dia_id']) ? $inpt['dia_id'][0] : '';
		array_shift($trr2);

		$contact = $this->ConfigurationRetriveModel->get_row_data('tbl_patients', 'patient_id', $inpt['patient_id']);

		if ($inpt['p_category'] == 12) {
			$drug_id = $inpt['drug_id'];
			$drug_name = $inpt['drug_name'];
			$drug_dosage = $inpt['drug_dosage'];
			$drug_duration_unit = $inpt['drug_d_unit'];
			$drug_duration = $inpt['drug_duration'];
			$drug_qty = $inpt['drugs_qty'];

			for ($i = 0; $i < count($drug_id); $i++) {
				$drug_result = $this->db->query("SELECT * FROM drugs_list WHERE drug_id ='" . $drug_id[$i] . "'");
				if ($drug_result->num_rows() > 0) {
					$drug_details = $drug_result->row();

					$pharmacy_drug_data[] = array(
						'treatType' => 'P',
						'treatCode' => $drug_details->register_no,
						'treatDesc' => $drug_details->drug_name,
						'dosage' => $drug_dosage[$i],
						'durationUnit' => $drug_duration_unit[$i],
						'duration' => $drug_duration[$i],
						'quantity' => $drug_qty[$i]
					);
				}
			}

			$data1 = array(
				'policyNo' => isset($ch->policyNo) ? $ch->policyNo : '',
				'memberId' => isset($ch->memberId) ? $ch->memberId : '',
				'category' => $category,
				'illness'  => $inpt['illness'],
				'priority' => $inpt['priority'],
				'primaryDiagnosis' => $primary_diag,
				'medicalRecordNo' => $pl_id,
				'serviceType' => 'O',
				'admissionType' => 'M',
				'admissionPeriod' => 1,
				'visitDate' => date('d/m/Y', strtotime($inpt['enter_date'])),
				'doctorLicenseNo' => $inpt['doctor_id'],
				'currency' => 'QAR',
				'mobileNo' => isset($contact->mobile) ? $contact->mobile : '',
				'illnessDetails' => $inpt['illness_details'],
				'medicalHistory' => $inpt['medical_history'],
				'treatmentsData' => json_encode($pharmacy_drug_data),
				// 'diagnosisData' => json_encode($trr2)
				'justification' =>  $inpt['justification_main']
			);

			if (!empty($trr2)) {
				$data1['diagnosisData'] = json_encode($trr2);
			}

			$auth = base64_encode(QLM_PROD_USERNAME . ":" . QLM_PROD_PASSWORD);
			$content_type = '';

			curl_setopt($pa, CURLOPT_URL, $this->getUrl("QLM_PREAPPROVAL_URL"));
			curl_setopt($pa, CURLOPT_POST, 1);
			curl_setopt($pa, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($pa, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($pa, CURLOPT_POSTFIELDS, $data1);
			$result = curl_exec($pa);
		} else {
			$teethh = '';
			$curr_teeth = '';

			if (!empty($inpt['plan_teeth'])) {
				// $teethh = explode(';',$inpt['plan_teeth'][0]);
				// $primary_tooth = explode('-',$teethh[0]);

				foreach ($inpt['plan_teeth'] as $no => $pteeth) {
					$teethh = explode(';', $inpt['plan_teeth'][$no]);
					$primary_tooth[$no] = explode('-', $teethh[0]);
				}
			}

			if (!empty($inpt['plan_procedure_full'])) {
				foreach ($inpt['plan_procedure_full'] as $kk => $proc) {
					$procedures = explode(' | ', $proc);

					$temp = array();
					$temp['treatType'] = 'O';
					$temp['treatCode'] = $procedures[0];
					$temp['treatDesc'] = $procedures[1];
					$temp['quantity'] = 1;

					if ($inpt['p_category'] == 1) {
						$temp['toothNumber'] = (!empty($primary_tooth[$kk][0]) && $primary_tooth[$kk][0] != 's&p') ? $primary_tooth[$kk][0] : '0';
					}

					$temp['estimatedAmount'] = $procedures[2];
					$temp['remarks'] = '';
					$temp['justification'] = $inpt['justification'][$kk];
					$temp['proceed'] = 'N';
					$temp['srJustification'] = $inpt['srJustification'][$kk];

					array_push($trr, $temp);
				}
			}


			if ($_FILES['xray']['size'] > 0) {
				$docs = new CURLFile($_FILES['xray']['tmp_name'], $_FILES['xray']['type'], $_FILES['xray']['name']);

				$data = array(
					'policyNo' => isset($ch->policyNo) ? $ch->policyNo : '',
					'memberId' => isset($ch->memberId) ? $ch->memberId : '',
					'category' => $category,
					'illness'  => $inpt['illness'],
					'priority' => $inpt['priority'],
					'primaryDiagnosis' => $primary_diag,
					'medicalRecordNo' => $pl_id,
					'serviceType' => 'O',
					'admissionType' => 'M',
					'admissionPeriod' => 1,
					'visitDate' => date('d/m/Y', strtotime($inpt['enter_date'])),
					'doctorLicenseNo' => $inpt['doctor_id'],
					'currency' => 'QAR',
					'mobileNo' => isset($contact->mobile) ? $contact->mobile : '',
					'illnessDetails' => $inpt['illness_details'],
					'medicalHistory' => $inpt['medical_history'],
					'treatmentsData' => json_encode($trr),
					// 'diagnosisData' => json_encode($trr2),
					'document' => $docs,
					'justification' =>  $inpt['justification_main']
				);
				if (!empty($trr2)) {
					$data1['diagnosisData'] = json_encode($trr2);
				}
			} else {
				$data = array(
					'policyNo' => isset($ch->policyNo) ? $ch->policyNo : '',
					'memberId' => isset($ch->memberId) ? $ch->memberId : '',
					'category' => $category,
					'illness'  => $inpt['illness'],
					'priority' => $inpt['priority'],
					'primaryDiagnosis' => $primary_diag,
					'medicalRecordNo' => $pl_id,
					'serviceType' => 'O',
					'admissionType' => 'M',
					'admissionPeriod' => 1,
					'visitDate' => date('d/m/Y', strtotime($inpt['enter_date'])),
					'doctorLicenseNo' => $inpt['doctor_id'],
					'currency' => 'QAR',
					'mobileNo' => isset($contact->mobile) ? $contact->mobile : '',
					'illnessDetails' => $inpt['illness_details'],
					'medicalHistory' => $inpt['medical_history'],
					'treatmentsData' => json_encode($trr),
					// 'diagnosisData' => json_encode($trr2)
					'justification' =>  $inpt['justification_main']
				);

				if (!empty($trr2)) {
					$data1['diagnosisData'] = json_encode($trr2);
				}
			}

			$auth = base64_encode(QLM_PROD_USERNAME . ":" . QLM_PROD_PASSWORD);
			$content_type = '';


			// 			print_r($data);die;

			curl_setopt($pa, CURLOPT_URL, $this->getUrl("QLM_PREAPPROVAL_URL"));
			curl_setopt($pa, CURLOPT_POST, 1);
			curl_setopt($pa, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($pa, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($pa, CURLOPT_POSTFIELDS, $data);
			$result = curl_exec($pa);
			// 			print_r($result);die;
		}
		$this->close($pa);
		return $result;
	}

	public function resubmit_pre_approval($inpt = array(), $pl_id)
	{
		$data = array();
		$id = $inpt['patient_qid'];
		$member_id = $inpt['member_id'];
		$doctor_id = $inpt['doctor_id'];

		$ch = json_decode($this->eligibility_check($id, $member_id));
		$vf = $this->visit_form($inpt, $id, $member_id);

		$pa = $this->connect(1);
		$testarr = array();
		$trr = array();
		$trr2 = array();
		$proc_str = '';
		$temp = array();
		$temp2 = array();
		$pharmacy_drug_data = array();
		$docs = '';

		$req_sent = FALSE;

		// print_r($inpt);
		// die();

		$category = '001';
		switch ($inpt['p_category']) {
			case 1:
				$category = '002';
				break; // dental
			case 2:
				$category = '001';
				break; // derma
			case 3:
				$category = '001';
				break; // general surgery
			case 4:
				$category = '001';
				break; // plastic surgery
			case 5:
				$category = '001';
				break; // consultation
			case 6:
				$category = '006';
				break; // physiotheraphy
			case 7:
				$category = '001';
				break; // general medical
			case 8:
				$category = '003';
				break; // gynecology
			case 9:
				$category = '001';
				break; // lab
			case 10:
				$category = '004';
				break; // opthalmology
			case 11:
				$category = '001';
				break; // pediatric
			case 12:
				$category = '005';
				break; // pharmacy
			default:
				$category = '001';
				break; // unspecified or additional
		}

		if (!empty($inpt['dia_id']))
			foreach ($inpt['dia_id'] as $k => $dia) {
				// if($k != 0) {			
				$temp2['diagCode'] = $dia;

				array_push($trr2, $temp2);
				// }
			}

		$primary_diag = !empty($inpt['dia_id']) ? $inpt['dia_id'][0] : '';
		array_shift($trr2);

		$contact = $this->appointment_retrive->get_row_data('patient_contact', 'patient_id', $inpt['patient_id']);

		if ($inpt['p_category'] == 12) {
			$drug_id = $inpt['drug_id'];
			$drug_name = $inpt['drug_name'];
			$drug_dosage = $inpt['drug_dosage'];
			$drug_duration_unit = $inpt['drug_d_unit'];
			$drug_duration = $inpt['drug_duration'];
			$drug_qty = $inpt['drugs_qty'];

			for ($i = 0; $i < count($drug_id); $i++) {
				$drug_result = $this->db->query("SELECT * FROM drugs_list WHERE drug_id ='" . $drug_id[$i] . "'");
				if ($drug_result->num_rows() > 0) {
					$drug_details = $drug_result->row();

					$pharmacy_drug_data[] = array(
						'treatType' => 'P',
						'treatCode' => $drug_details->register_no,
						'treatDesc' => $drug_details->drug_name,
						'dosage' => $drug_dosage[$i],
						'durationUnit' => $drug_duration_unit[$i],
						'duration' => $drug_duration[$i],
						'quantity' => $drug_qty[$i]
					);
				}
			}

			$data1 = array(
				'policyNo' => isset($ch->policyNo) ? $ch->policyNo : '',
				'memberId' => isset($ch->memberId) ? $ch->memberId : '',
				'category' => $category,
				'illness'  => $inpt['illness'],
				'priority' => $inpt['priority'],
				'primaryDiagnosis' => $primary_diag,
				'medicalRecordNo' => $pl_id,
				'serviceType' => 'O',
				'admissionType' => 'M',
				'admissionPeriod' => 1,
				'visitDate' => date('d/m/Y',strtotime($inpt['enter_date'])),
				'doctorLicenseNo' => $inpt['doctor_id'],
				'currency' => 'QAR',
				'mobileNo' => isset($contact->mobile) ? $contact->mobile : '',
				'illnessDetails' => $inpt['illness_details'],
				'medicalHistory' => $inpt['medical_history'],
				'treatmentsData' => json_encode($pharmacy_drug_data),
				// 'diagnosisData' => json_encode($trr2)
				'PAreferenceNo' =>  $inpt['pa_referance'],
				'justification' => $inpt['justification_main']
			);

			if(!empty($trr2)) {
				$data1['diagnosisData'] = json_encode($trr2);
			}


			$auth = base64_encode(QLM_PROD_USERNAME . ":" . QLM_PROD_PASSWORD);
			$content_type = '';

			curl_setopt($pa, CURLOPT_URL, $this->getUrl("QLM_PREAPPROVAL_URL"));
			curl_setopt($pa, CURLOPT_POST, 1);
			curl_setopt($pa, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($pa, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($pa, CURLOPT_POSTFIELDS, $data1);
			$result = curl_exec($pa);
		} else {
			$teethh = '';
			$curr_teeth = '';

			if (!empty($inpt['plan_teeth'])) {
				// $teethh = explode(';',$inpt['plan_teeth'][0]);
				// $primary_tooth = explode('-',$teethh[0]);

				foreach ($inpt['plan_teeth'] as $no => $pteeth) {
					$teethh = explode(';', $inpt['plan_teeth'][$no]);
					$primary_tooth[$no] = explode('-', $teethh[0]);
				}
			}

			if (!empty($inpt['plan_procedure_full'])) {
				foreach ($inpt['plan_procedure_full'] as $kk => $proc) {
					$procedures = explode(' | ', $proc);

					$temp = array();
					$temp['treatType'] = 'O';
					$temp['treatCode'] = $procedures[0];
					$temp['treatDesc'] = $procedures[1];
					$temp['quantity'] = 1;

					if ($inpt['p_category'] == 1) {
						$temp['toothNumber'] = (!empty($primary_tooth[$kk][0]) && $primary_tooth[$kk][0] != 's&p') ? $primary_tooth[$kk][0] : '0';
					}

					$temp['estimatedAmount'] = $procedures[2];
					$temp['remarks'] = '';
					$temp['justification'] = $inpt['justification'][$kk];
					$temp['proceed'] = 'N';
					$temp['srJustification'] = $inpt['srJustification'][$kk];

					array_push($trr, $temp);
				}
				
			}


			if ($_FILES['xray']['size'] > 0) {
				$docs = new CURLFile($_FILES['xray']['tmp_name'], $_FILES['xray']['type'], $_FILES['xray']['name']);

				$data = array(
					'policyNo' => isset($ch->policyNo) ? $ch->policyNo : '',
					'memberId' => isset($ch->memberId) ? $ch->memberId : '',
					'category' => $category,
					'illness'  => $inpt['illness'],
					'priority' => $inpt['priority'],
					'primaryDiagnosis' => $primary_diag,
					'medicalRecordNo' => $pl_id,
					'serviceType' => 'O',
					'admissionType' => 'M',
					'admissionPeriod' => 1,
					'visitDate' => date('d/m/Y',strtotime($inpt['enter_date'])),
					'doctorLicenseNo' => $inpt['doctor_id'],
					'currency' => 'QAR',
					'mobileNo' => isset($contact->mobile) ? $contact->mobile : '',
					'illnessDetails' => $inpt['illness_details'],
					'medicalHistory' => $inpt['medical_history'],
					'treatmentsData' => json_encode($trr),
					// 'diagnosisData' => json_encode($trr2),
					'document' => $docs,
					'PAreferenceNo' => $inpt['pa_referance'],
					'justification' => $inpt['justification_main']
				);
				if(!empty($trr2)) {
					$data1['diagnosisData'] = json_encode($trr2);
				}
			} else {
				$data = array(
					'policyNo' => isset($ch->policyNo) ? $ch->policyNo : '',
					'memberId' => isset($ch->memberId) ? $ch->memberId : '',
					'category' => $category,
					'illness'  => $inpt['illness'],
					'priority' => $inpt['priority'],
					'primaryDiagnosis' => $primary_diag,
					'medicalRecordNo' => $pl_id,
					'serviceType' => 'O',
					'admissionType' => 'M',
					'admissionPeriod' => 1,
					'visitDate' => date('d/m/Y',strtotime($inpt['enter_date'])),
					'doctorLicenseNo' => $inpt['doctor_id'],
					'currency' => 'QAR',
					'mobileNo' => isset($contact->mobile) ? $contact->mobile : '',
					'illnessDetails' => $inpt['illness_details'],
					'medicalHistory' => $inpt['medical_history'],
					'treatmentsData' => json_encode($trr),
					// 'diagnosisData' => json_encode($trr2)
					'PAreferenceNo' => $inpt['pa_referance'],
					'justification' => $inpt['justification_main']
				);

				if(!empty($trr2)) {
					$data1['diagnosisData'] = json_encode($trr2);
				}
			}

			$auth = base64_encode(QLM_PROD_USERNAME . ":" . QLM_PROD_PASSWORD);
			$content_type = '';
// 			print_r($data);die;

			curl_setopt($pa, CURLOPT_URL, $this->getUrl("QLM_PREAPPROVAL_URL"));
			curl_setopt($pa, CURLOPT_POST, 1);
			curl_setopt($pa, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($pa, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($pa, CURLOPT_POSTFIELDS, $data);
			$result = curl_exec($pa);
			print_r($result);die;
		}
		$this->close($pa);
		return $result;
	}

	public function appeal_qlm($reference_no,$appeal_type,$appeal_remark,$justification)
	{
		
			
			$pa = $this->connect(1);

			curl_setopt($pa, CURLOPT_URL, $this->getUrl("QLM_APPEAL_PREAPPROVAL_URL"));
			$data = array(
				'PAreferenceNo' => $reference_no,
				'appealType' => $appeal_type,
				'appealRemarks' => $appeal_remark,
				'justification' => $justification,
				'proceed' => 'N'
			);

// 			echo json_encode($data);die;
			curl_setopt($pa, CURLOPT_RETURNTRANSFER, false);
			curl_setopt($pa, CURLOPT_CUSTOMREQUEST, "PUT");
			curl_setopt($pa, CURLOPT_POSTFIELDS, $data);
			curl_setopt($pa, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($pa, CURLOPT_CONNECTTIMEOUT, 10);

			$result = curl_exec($pa);

			$this->close($pa);
			echo json_encode($result);die;
// 			redirect('doctor_process/patient_files/' . $patient_id);
		
	}

}