<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CalenderModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	public function getList($params)
	{

		$str_quary = "";

		$str_quary .= " select tbl_orders.*,tbl_order_status.status as status ";
		$str_quary .= " from tbl_orders ";
		$str_quary .= " inner join tbl_order_status on tbl_order_status.order_status_id = tbl_orders.status_id ";
		$str_quary .= " where tbl_orders.is_delete = 0 ";
		$str_quary .= " and tbl_orders.dp_date = '" . $params['selectedDate'] . "'";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_pending_orders()
	{

		$str_quary = "";

		$str_quary .= " select tbl_orders.dp_date ";
		$str_quary .= " from tbl_orders ";
		$str_quary .= " where tbl_orders.dp_date >= curdate() ";
		$str_quary .= " group by tbl_orders.dp_date ";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_appointments($doctors, $start_date, $end_date)
	{

		if ($start_date != '' && $end_date != '') {
			$start = '  tbl_appointment.appointment_date BETWEEN "' . $start_date . '" AND "' . $end_date . '"';
		}

		$query = $this->db->query("SELECT tbl_appointment.patient_id,
		tbl_appointment.appointment_id,
		tbl_appointment.appointment_date,
		tbl_appointment.appointment_time,
		tbl_appointment.appointment_etime,
		tbl_appointment_patient_info.app_patient_id,
		tbl_appointment_patient_info.patient_id,
		tbl_appointment_patient_info.app_patient_name,
		tbl_users.full_name AS username,
		tbl_appointment_patient_info.app_patient_contact,
		tbl_appointment_patient_info.wa_mobile,
		tbl_appointment_patient_info.wa_code,
		tbl_appointment_patient_info.app_patient_category_id,
		IFNULL(tbl_appointment_patient_info.app_patient_qatar_id, tbl_patients.qatar_id ) AS app_patient_qatar_id,
		tbl_appointment.doctor_id,
		
		tbl_appointment.note,
		tbl_patients.backup_id,
		tbl_appointment_treatment.col_code,
		tbl_appointment_treatment.treatment_name,
		tbl_appointment.app_treat_id,
		tbl_patients.insurance_type,
		tbl_insurance_types.insurance_name,
		tbl_appointment_patient_info.now_waiting,
		tbl_appointment_patient_info.black_mark,
		tbl_patients.company_id,
		tbl_company.company_name,
		tbl_appointment.sms_active,
		tbl_appointment.sms_lang,
		tbl_appointment.procedure_id,
		tbl_appointment.department,
		tbl_employees.doctor_color,
		dc.full_name as doctor_name
		
		FROM tbl_appointment
		LEFT JOIN tbl_patients
		ON tbl_appointment.patient_id = tbl_patients.patient_id
		Left JOIN tbl_employees
		ON tbl_appointment.doctor_id = tbl_employees.user_id
		LEFT JOIN tbl_appointment_treatment
		ON tbl_appointment.app_treat_id = tbl_appointment_treatment.app_treat_id
		Left JOIN tbl_appointment_patient_info
		ON tbl_appointment.app_info_id = tbl_appointment_patient_info.app_patient_id
		LEFT JOIN tbl_insurance_types
		ON tbl_insurance_types.insurance_type_id = tbl_patients.insurance_type
		LEFT JOIN tbl_users
		ON tbl_appointment.user_id = tbl_users.user_id
		LEFT JOIN tbl_users dc
		ON tbl_appointment.doctor_id = dc.user_id
		LEFT JOIN tbl_company
		ON tbl_company.company_id = tbl_patients.company_id
		WHERE
		$start
		AND tbl_appointment.doctor_id IN ($doctors)
		ORDER BY tbl_appointment.appointment_id DESC;
		");


		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}

	public function logged_user_doctors($user_group_id, $user_id)
	{
		$query = $this->db->query("
		select *
		from tbl_employees
		join tbl_users on tbl_users.user_id = tbl_employees.user_id
		join tbl_user_rights on tbl_user_rights.user_right_code = tbl_employees.user_id
		left join tbl_doctor_types on tbl_doctor_types.doctor_types_id = tbl_employees.doctor_type
        join tbl_user_group_rights on tbl_user_group_rights.user_right_Id = tbl_user_rights.user_right_Id
        	WHERE tbl_users.is_inactive =0
        AND tbl_user_group_rights.user_group_Id = '" . $user_group_id . "' OR tbl_users.user_id='" . $user_id . "'");

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return FALSE;
		}
	}

	public function save($data)
	{
		$this->db->insert('tbl_appointment', $data);
		$appointment_id = $this->db->insert_id();;

		return $appointment_id;
	}

	public function createQueue($table, $data)
	{
		// $// Check the last token number for the specific doctor
		$this->db->select('number');
		$this->db->from($table);
		$this->db->order_by('number', 'DESC');
		$this->db->limit(1);
		$query = $this->db->get();

		if ($query->num_rows() > 0) {
			$last_token = $query->row()->number;
		} else {
			$last_token = 1; // No previous token, start from 0
		}

		// Increment the token number
		$data['number'] = $last_token + 1;

		// Insert the new record
		$this->db->insert($table, $data);

		return $data;
	}
	public function updateQueue($data)
	{
		// $// Check the last token number for the specific doctor
		$this->db->where('doctor_id', $data['doctor_id']);
		$this->db->where('patient_id', $data['patient_id']);
		$this->db->where('appointment_id', $data['appointment_id']);
		$this->db->update('queue', $data);

		return $this->db->affected_rows() > 0;
	}

	public function get_block_appointments($doctors, $start_date, $end_date)
	{

		if ($start_date != '' && $end_date != '') {
			$start = '  tbl_appointment_block.app_block_date BETWEEN "' . $start_date . '" AND "' . $end_date . '"';
		}

		$query = $this->db->query("SELECT * from tbl_appointment_block WHERE $start AND tbl_appointment_block.doctor_id IN ($doctors);");
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}

	public function get_booking_status()
	{
		return $this->db->select('*')
			->from('tbl_booking_status')
			->get()
			->result();
	}

	public function update_block_schedule($block_id, $data)
	{
		$this->db->where('block_id', $block_id);
		$this->db->update('tbl_appointment_block', $data);

		return $this->db->affected_rows() > 0;
	}

	public function get_app_details($id)
	{

		$query = $this->db->query("SELECT * FROM tbl_appointment LEFT JOIN tbl_appointment_patient_info ON tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id WHERE appointment_id ='$id'");

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}
	public function getAppointment($id)
	{
		$query = $this->db->query("
			SELECT 
				tbl_appointment.appointment_id,
				tbl_appointment.appointment_date,
				tbl_appointment.appointment_time,
				tbl_patients.patient_name,
				tbl_patients.mobile,
				tbl_patients.second_mobile,
				tbl_users.full_name AS doctor_name
			FROM tbl_appointment
			LEFT JOIN tbl_patients ON tbl_patients.patient_id = tbl_appointment.patient_id
			LEFT JOIN tbl_users ON tbl_users.user_id = tbl_appointment.doctor_id
			WHERE tbl_appointment.appointment_id = '$id'
		");
	
		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}
	public function getNewAppointment($id)
	{
		$query = $this->db->query("
			SELECT 
				tbl_appointment.appointment_id,
				tbl_appointment.appointment_date,
				tbl_appointment.appointment_time,
				tbl_appointment_patient_info.app_patient_contact as mobile,
				tbl_appointment_patient_info.app_patient_name as patient_name,
				tbl_users.full_name AS doctor_name
			FROM tbl_appointment
			LEFT JOIN tbl_appointment_patient_info ON tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id
			LEFT JOIN tbl_users ON tbl_users.user_id = tbl_appointment.doctor_id
			WHERE tbl_appointment.appointment_id = '$id'
		");
	
		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}
	public function update_status($appointment_id, $status) {

		$app_info = $this->db->select('app_info_id')
		->from('tbl_appointment')
		->where('appointment_id',$appointment_id)
		->get()
		->row();

		if ($app_info && isset($app_info->app_info_id)) {
			// Update the status in tbl_appointment
			$this->db->where('app_patient_id', $app_info->app_info_id);
			$this->db->update('tbl_appointment_patient_info', ['now_waiting' => $status]);
	
			return true; // Return true to indicate successful update
		} else {
			return false; // Return false if app_info_id was not found
		} // Assuming the table is 'appointments' and 'status' is the column for the appointment status
    }

	public function checkAlreadyAppointment($date, $timestart, $timeend, $doctor_id) {
		// Check if any appointment exists that overlaps with the given time range
		$app_info = $this->db->select('block_id')
		->from('tbl_appointment_block')
		->where('app_block_date', $date)
		->where('doctor_id', $doctor_id)
		->group_start() // Start of grouping OR conditions
			// Exclude cases where $timestart is exactly equal to appointment_etime, allowing appointments to start exactly after the previous one
			->where("('$timestart' > app_block_stime AND '$timestart' < app_block_etime)", null, false) // New start time is within existing appointment
			->or_where("('$timeend' > app_block_stime AND '$timeend' <= app_block_etime)", null, false) // New end time is within existing appointment
			->or_where("(app_block_stime >= '$timestart' AND app_block_stime < '$timeend')", null, false) // Existing appointment start time overlaps new one
		->group_end(); // End of grouping
		$app_info = $this->db->get()->row();
		// Return true if any appointment found, false if no conflict
		// return !empty($app_info);
		if(!empty($app_info)){
			return $app_info;
		}else{
			return $app_info;
		}
		
	}
	public function checkAlreadyAppointmentUpdate($date, $timestart, $timeend, $doctor_id, $appointment_id = null) {
		// Check if any appointment exists that overlaps with the given time range
		$app_info = $this->db->select('appointment_id')
			->from('tbl_appointment')
			->where('appointment_date', $date)
			->where('doctor_id', $doctor_id)
			->group_start() // Start of grouping OR conditions
				// Exclude cases where $timestart is exactly equal to appointment_etime, allowing appointments to start exactly after the previous one
				->where("('$timestart' > appointment_time AND '$timestart' < appointment_etime)", null, false) // New start time is within existing appointment
				->or_where("('$timeend' > appointment_time AND '$timeend' <= appointment_etime)", null, false) // New end time is within existing appointment
				->or_where("(appointment_time >= '$timestart' AND appointment_time < '$timeend')", null, false) // Existing appointment start time overlaps new one
			->group_end(); // End of grouping
	
		if ($appointment_id !== null) {
			$this->db->where('appointment_id !=', $appointment_id); // Exclude current appointment by ID
		}
	
		$app_info = $this->db->get()->row();
	
		if (!empty($app_info)) {
			return $app_info;
		} else {
			return false; // Return false if no overlapping appointment is found
		}
	}

	public function appointmentSearch($searchQuery, $date = null)
	{
		// Base SQL query
		$sql = "
			SELECT 
				tbl_appointment.appointment_id,
				tbl_appointment.appointment_date,
				tbl_appointment.appointment_time,
				tbl_appointment.appointment_etime,
				tbl_patients.patient_name,
				tbl_appointment_patient_info.now_waiting,
				tbl_patients.patient_id,
				tbl_patients.second_mobile,
				tbl_users.full_name AS doctor_name
			FROM tbl_appointment
			LEFT JOIN tbl_patients ON tbl_patients.patient_id = tbl_appointment.patient_id
			LEFT JOIN tbl_users ON tbl_users.user_id = tbl_appointment.doctor_id
			LEFT JOIN tbl_appointment_patient_info ON tbl_appointment_patient_info.app_patient_id  = tbl_appointment.app_info_id
			WHERE (tbl_patients.patient_name LIKE ? 
				OR tbl_patients.mobile = ? 
				OR tbl_patients.patient_id = ? 
				OR tbl_patients.qatar_id = ?
				OR tbl_appointment_patient_info.app_patient_contact = ?
				OR tbl_appointment_patient_info.app_patient_qatar_id = ?
				
				) 
		";
		
		// If a date is provided, add the condition for appointment_date
		if ($date) {
			$sql .= " AND tbl_appointment.appointment_date = ?";
		}
	
		// Complete query with ordering
		$sql .= " ORDER BY tbl_appointment.appointment_date DESC";
	
		// Binding parameters
		$searchTerm = '%' . $searchQuery . '%';  // Used for LIKE clause
		$params = [$searchTerm, $searchQuery, $searchQuery, $searchQuery,$searchQuery,$searchQuery];
		
		// If date is provided, add it to the parameters
		if ($date) {
			$params[] = $date;
		}
	
		// Execute the query with the parameters
		$result = $this->db->query($sql, $params);
	
		return $result->result();
	}

	
	
}
