<?php

class RetriveProcessModel extends CI_Model {



	public function search_concern_byname($search_data,$type)
	{
		$query = $this->db->query("SELECT * FROM tbl_consent_data LEFT JOIN tbl_patients ON tbl_consent_data.patient_id = tbl_patients.patient_id WHERE tbl_patients.patient_name LIKE'%$search_data%'".($type != 0 ? " AND consent_type = '".$type."'" : ""));
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{
				return FALSE;
			}
	}

	public function search_concern($search_data , $type = 0)
	{
		$query = $this->db->query("SELECT * FROM tbl_consent_data LEFT JOIN tbl_patients ON tbl_consent_data.patient_id = tbl_patients.patient_id WHERE (tbl_patients.qatar_id = '$search_data' OR tbl_patients.mobile = '$search_data' OR tbl_patients.second_mobile = '$search_data' OR tbl_patients.patient_id = '$search_data') ".($type != 0 ? " AND consent_type = '".$type."'" : ""));
			
			if($query->num_rows() > 0)
			{
				return $query->result_array();
				
			} else{

				return FALSE;
			}
	}

	public function getPatients($nameStartsWith, $showAll)
    {
        $this->db->select('*');
        $this->db->from('tbl_patients');
        $this->db->like('patient_id', strtoupper($nameStartsWith), 'both');
        $this->db->or_like('first_name', strtoupper($nameStartsWith), 'both');
        $this->db->or_like('last_name', strtoupper($nameStartsWith), 'both');
        $this->db->or_like('patient_name', strtoupper($nameStartsWith), 'both');
        $this->db->or_like('qatar_id', strtoupper($nameStartsWith), 'both');
        $this->db->order_by('patient_id', 'ASC');

        $query = $this->db->get();
        $data = array();

        if (!empty($showAll)) {
            $data[] = '-1 - All Patients';
        }

        foreach ($query->result_array() as $row) {
            $data[] = $row['patient_id'] . ' - ' . $row['patient_name'] . ' - ' . $row['mobile'];
        }

        return $data;
    }

    public function getInvoices($nameStartsWith, $showAll)
    {

        $subquery = $this->db->select('sum(cash)+sum(card)+sum(insurance_amount)')->from('tbl_patient_payment')->where('tbl_patient_payment.treatment_payment_id=tbl_treatment_payment.treatement_payment_id', NULL, FALSE)->get_compiled_select();

        $subquery_adv = $this->db->select('sum(amount)')->from('tbl_refund')->where('tbl_refund.treatment_payment_id=tbl_treatment_payment.treatement_payment_id', NULL, FALSE)->get_compiled_select();

        $this->db->select("*,IFNULL(({$subquery}),0) - IFNULL(({$subquery_adv}),0) as total_pay", FALSE);
        
        $this->db->from('tbl_treatment_payment');
        $this->db->join('tbl_patients', 'tbl_patients.patient_id = tbl_treatment_payment.patient_id');
        $this->db->where('tbl_treatment_payment.insurance_type', 1);

        $this->db->group_start();
        $this->db->like('tbl_treatment_payment.treatement_payment_id', strtoupper($nameStartsWith), 'both');
        $this->db->or_like('tbl_patients.patient_name', strtoupper($nameStartsWith), 'both'); 
        $this->db->group_end();
        $this->db->order_by('tbl_patients.patient_id', 'ASC');
       

        $query = $this->db->get();
        $data = array();

        if (!empty($showAll)) {
            $data[] = '-1 - All Patients';
        }

        foreach ($query->result_array() as $row) {
            $data[] = $row['treatement_payment_id'] . ' || ' . $row['patient_name'] . ' || ' . $row['total']. ' || ' . $row['total_pay'];
        }

        return $data;
    }

	public function getPatientsDoctor($nameStartsWith)
    {
        $this->db->select('*');
        $this->db->from('tbl_users');
        $this->db->join('tbl_employees', 'tbl_employees.user_id = tbl_users.user_id');
        $this->db->where("tbl_employees.doctor_type in (1,3) AND tbl_users.full_name LIKE '%" . strtoupper($nameStartsWith) . "%'");

        $query = $this->db->get();
        $data = array();

        foreach ($query->result_array() as $row) {
            $data[] = $row['user_id'] . ' - ' . $row['full_name'];
        }

        return $data;
    }

}